<?php

namespace cBuilder\Classes\Analytics;

use cBuilder\Classes\Analytics\CCBAnalyticsHelper;

class CCBAnalytics {
	public static function get_calculators() {
		check_ajax_referer( 'ccb_analytics_get_calculators', 'nonce' );

		$response = array(
			'success' => false,
			'message' => 'You are not authorized to access this page.',
			'data'    => array(),
		);

		if ( ! current_user_can( 'manage_options' ) ) {
			return wp_send_json( $response );
		}

		$response['success'] = true;
		$response['message'] = 'Calculators fetched successfully';

		$response['data']['calculators'] = CCBAnalyticsHelper::get_calculators_list();

		return wp_send_json( $response );
	}

	public static function get_analytics_data() {
		check_ajax_referer( 'ccb_get_analytics_data', 'nonce' );

		$response = array(
			'success' => false,
			'message' => 'You are not authorized to access this page.',
			'data'    => array(),
		);

		if ( ! current_user_can( 'manage_options' ) ) {
			return wp_send_json( $response );
		}

		$response['success'] = true;
		$response['message'] = 'Analytics data fetched successfully';
		$response['data']    = CCBAnalyticsHelper::get_dashboard_data();

		return wp_send_json( $response );
	}

	public static function get_single_calc_analytics_data() {
		check_ajax_referer( 'ccb_single_calc_analytics', 'nonce' );

		$response = array(
			'success' => false,
			'message' => 'You are not authorized to access this page.',
			'data'    => array(),
		);

		if ( ! current_user_can( 'manage_options' ) ) {
			return wp_send_json( $response );
		}

		if ( empty( $_GET['calc_id'] ) ) {
			$response['message'] = 'Calculator ID is required';
			return wp_send_json( $response );
		}

		$response['success'] = true;
		$response['message'] = 'Analytics data fetched successfully';
		$response['data']    = CCBAnalyticsHelper::get_single_calc_data();

		return wp_send_json( $response );
	}

	public static function analytics_page_settings() {
		check_ajax_referer( 'ccb_analytics_page_settings', 'nonce' );

		$response = array(
			'success' => false,
			'message' => 'You are not authorized to access this page.',
		);

		if ( ! current_user_can( 'manage_options' ) ) {
			return wp_send_json( $response );
		}

		try {
			$body = file_get_contents( 'php://input' );
			$data = json_decode( $body, true );

			$data = $data['data'] ?? array();

			$calc_id  = sanitize_text_field( $data['calc_id'] );
			$settings = json_decode( $data['settings'], true ); // phpcs:ignore

			if ( empty( $calc_id ) || empty( $settings ) ) {
				return wp_send_json( $response );
			}

			$analytics_data = get_option( 'ccb_analytics_data', array() );
			if ( empty( $analytics_data[ $calc_id ]['page_settings'] ) ) {
				$analytics_data[ $calc_id ]['page_settings'] = array();
			}

			$analytics_data[ $calc_id ]['page_settings'] = apply_filters( 'ccb_analytics_filter_add_page_settings', $settings );
			update_option( 'ccb_analytics_data', $analytics_data );

			$response['success'] = true;
			$response['message'] = 'Settings saved successfully';
		} catch ( \Exception $e ) {
			$response['message'] = 'Error: ' . $e->getMessage();
		}

		return wp_send_json( $response );
	}

	public static function add_widget() {
		check_ajax_referer( 'ccb_analytics_add_widget', 'nonce' );

		$response = array(
			'success' => false,
			'message' => 'You are not authorized to access this page.',
		);

		if ( ! current_user_can( 'manage_options' ) ) {
			return wp_send_json( $response );
		}

		$body = file_get_contents( 'php://input' );
		$data = json_decode( $body, true );

		$data = $data['data'] ?? array();

		$calc_id = sanitize_text_field( $data['calc_id'] );
		$widgets = json_decode( $data['widgets'], true );

		if ( empty( $calc_id ) || empty( $widgets ) ) {
			$response['message'] = 'Calculator ID or widgets are empty';
			return wp_send_json( $response );
		}

		$analytics_data = get_option( 'ccb_analytics_data', array() );
		if ( empty( $analytics_data[ $calc_id ]['widgets'] ) ) {
			$analytics_data[ $calc_id ]['widgets'] = array();
		}

		$analytics_data[ $calc_id ]['widgets'] = apply_filters( 'ccb_analytics_filter_add_widget', $widgets );
		update_option( 'ccb_analytics_data', $analytics_data );

		$response['success'] = true;
		$response['message'] = 'Widget saved successfully';

		return wp_send_json( $response );
	}
}
