<?php

namespace cBuilder\Classes\Payments;

use cBuilder\Classes\CCBPayments;
use cBuilder\Classes\Database\Payments;

class CCBCashPayment extends CCBPayments {
	public static function render() {
		$paymentData = array(
			'type'     => 'cash_payment',
			'currency' => self::$settings['currency']['currency'],
			'total'    => self::$total,
			'status'   => Payments::$defaultStatus,
		);

		CCBPayments::makePaid( self::$params['orderId'], $paymentData );

		return array(
			'success' => true,
			'reload'  => true,
			'status'  => 'success',
			'orderId' => self::$params['orderId'],
			'message' => esc_html__( 'Your order has been placed', 'cost-calculator-builder-pro' ),
		);
	}
}
