<div class="cbb-edit-field-container">
	<div class="ccb-edit-field-header">
		<div class="ccb-edit-field-header-left" @click="$emit( 'cancel' )">
			<span class="ccb-edit-back-icon"><i class="ccb-icon-Path-3398"></i></span>
			<div class="ccb-edit-header-button">
				<div class="ccb-edit-header-top">
					<button class="ccb-edit-back-button"><?php esc_html_e( 'Back', 'cost-calculator-builder-pro' ); ?></button>
					<span class="ccb-edit-back-separator">/</span>
					<span class="ccb-edit-field-title" v-if="groupField.label && groupField.label.length > 0">{{ groupField.label }}</span>
					<span class="ccb-edit-field-title" v-else><?php esc_html_e( 'Group', 'cost-calculator-builder-pro' ); ?></span>
				</div>
				<span class="ccb-edit-field-alias">[{{ groupField.alias }}]</span>
			</div>
		</div>
		<div class="ccb-edit-field-header-right">
			<div class="ccb-save-wrapper" style="display: flex; justify-content: flex-end;">
				<button class="ccb-button success" @click.prevent="save(groupField, id, index, groupField.alias)"><?php esc_html_e( 'Save', 'cost-calculator-builder-pro' ); ?></button>
			</div>
		</div>
	</div>
	<div class="ccb-grid-box">
		<div class="container">
			<div class="row group-name-input-row">
				<div class="col-8">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( 'Group name', 'cost-calculator-builder-pro' ); ?></span>
						<input type="text" v-model.trim="groupField.label" placeholder="<?php esc_attr_e( 'Enter field name', 'cost-calculator-builder-pro' ); ?>">
					</div>
				</div>
				<div class="col-4" style="margin-top: 25px;">
					<div class="ccb-checkbox">
						<input type="checkbox" id="showTitle" v-model="groupField.showTitle">
						<label for="showTitle"><?php esc_html_e( 'Show Name', 'cost-calculator-builder-pro' ); ?></label>
					</div>
				</div>
				<div class="col-12 ccb-p-t-20">
					<div class="list-header">
						<div class="ccb-switch">
							<input type="checkbox" v-model="groupField.collapsible">
							<label></label>
						</div>
						<h6><?php esc_html_e( 'Make this group collapsible', 'cost-calculator-builder-pro' ); ?></h6>
					</div>
				</div>
				<div class="col-12 ccb-p-t-20" v-if="groupField.collapsible">
					<div class="list-header">
						<div class="ccb-switch">
							<input type="checkbox" v-model="groupField.collapse" @change="() => updateCollapse('collapse')">
							<label></label>
						</div>
						<h6><?php esc_html_e( 'Collapse this group by default', 'cost-calculator-builder-pro' ); ?></h6>
					</div>
					<div class="list-header accordion-mode ccb-p-t-20">
						<div class="ccb-switch">
							<input type="checkbox" v-model="groupField.accordion" @change="updateCollapse">
							<label></label>
						</div>
						<div class="switch-extra-text">
							<h6><?php esc_html_e( 'Accordion mode', 'cost-calculator-builder-pro' ); ?></h6>
							<p><?php esc_html_e( 'This makes that only one Group element is open at a time, and it is applied to all Group fields in the calculator.', 'cost-calculator-builder-pro' ); ?></p>
						</div>
					</div>
				</div>
				<div class="col-12 ccb-p-t-20">
					<div class="list-header group-field-setting">
						<div class="ccb-switch">
							<input type="checkbox" v-model="groupField.hidden">
							<label></label>
						</div>
						<div class="switch-extra-text">
							<h6><?php esc_html_e( 'Show this group based on condition', 'cost-calculator-builder-pro' ); ?></h6>
							<p><?php esc_html_e( 'This makes the group hidden by default. Open "Conditions" tab and create a condition with this field so users can reveal it.', 'cost-calculator-builder-pro' ); ?></p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
