<div class="cbb-edit-field-container">
	<div class="ccb-edit-field-header">
		<div class="ccb-edit-field-header-left" @click="$emit( 'cancel' )">
			<span class="ccb-edit-back-icon"><i class="ccb-icon-Path-3398"></i></span>
			<div class="ccb-edit-header-button">
				<div class="ccb-edit-header-top">
					<button class="ccb-edit-back-button"><?php esc_html_e( 'Back', 'cost-calculator-builder-pro' ); ?></button>
					<span class="ccb-edit-back-separator">/</span>
					<span class="ccb-edit-field-title" v-if="repeaterField.label && repeaterField.label.length > 0">{{ repeaterField.label }}</span>
					<span class="ccb-edit-field-title" v-else><?php esc_html_e( 'Repeater', 'cost-calculator-builder-pro' ); ?></span>
				</div>
				<span class="ccb-edit-field-alias">[{{ repeaterField.alias }}]</span>
			</div>
		</div>
		<div class="ccb-edit-field-header-right">
			<div class="ccb-save-wrapper" style="display: flex; justify-content: flex-end;">
				<button class="ccb-button success" @click.prevent="save(repeaterField, id, index, repeaterField.alias)"><?php esc_html_e( 'Save', 'cost-calculator-builder-pro' ); ?></button>
			</div>
		</div>
	</div>
	<div class="ccb-grid-box">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( 'Name', 'cost-calculator-builder-pro' ); ?></span>
						<input type="text" v-model.trim="repeaterField.label" placeholder="<?php esc_attr_e( 'Enter field name', 'cost-calculator-builder-pro' ); ?>">
					</div>
				</div>
			</div>
			<div class="row ccb-p-t-20">
				<div class="col-6">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( '"Add" Button Label', 'cost-calculator-builder-pro' ); ?></span>
						<input type="text" v-model.trim="repeaterField.addButtonLabel" placeholder="<?php esc_attr_e( 'Enter field name', 'cost-calculator-builder-pro' ); ?>">
					</div>
				</div>
				<div class="col-6">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( '"Remove" Button Label', 'cost-calculator-builder-pro' ); ?></span>
						<input type="text" v-model.trim="repeaterField.removeButtonLabel" placeholder="<?php esc_attr_e( 'Enter field name', 'cost-calculator-builder-pro' ); ?>">
					</div>
				</div>
				<div class="col-6">
					<div class="ccb-input-wrapper number">
						<span class="ccb-input-label"><?php esc_html_e( 'Repeat Limit', 'cost-calculator-builder-pro' ); ?></span>
						<div class="ccb-input-box">
							<input type="text" name="repeatCount" min="0" step="1"  @keypress="repeatMinValue" v-model="repeaterField.repeatCount" placeholder="<?php esc_attr_e( 'Enter field step', 'cost-calculator-builder-pro' ); ?>">
							<span @click="numberCounterAction('repeatCount')" class="input-number-counter up"></span>
							<span @click="numberCounterAction('repeatCount', '-')" class="input-number-counter down"></span>
						</div>
					</div>
				</div>
			</div>
			<div class="row ccb-p-t-20">
				<div class="col-12">
					<div class="list-header">
						<div class="ccb-switch">
							<input type="checkbox" v-model="repeaterField.sumAllAvailable" @change="() => toggleHandler('sumAllAvailable')">
							<label></label>
						</div>
						<h6><?php esc_html_e( 'Sum Up All fields', 'cost-calculator-builder-pro' ); ?></h6>
					</div>
				</div>
			</div>
			<div class="row ccb-p-t-20">
				<div class="col-12">
					<div class="list-header">
						<div class="ccb-switch">
							<input type="checkbox" v-model="repeaterField.enableFormula" @change="() => toggleHandler('enableFormula')">
							<label></label>
						</div>
						<h6><?php esc_html_e( 'Use Formula', 'cost-calculator-builder-pro' ); ?></h6>
					</div>
				</div>
			</div>
			<div class="row ccb-p-t-20" v-if="repeaterField.enableFormula">
				<div class="col-12">
					<div class="list-header">
						<div class="ccb-switch">
							<input type="checkbox" v-model="repeaterField.advancedJsCalculation"/>
							<label></label>
						</div>
						<h6><?php esc_html_e( 'Advanced calculations', 'cost-calculator-builder-pro' ); ?></h6>
						<span class="ccb-options-tooltip">
							<i class="ccb-icon-circle-question"></i>
							<span class="ccb-options-tooltip__text"><?php esc_html_e( 'Enable for advanced calculations using JavaScript-based formulas. With over 9 totals, performance may slow. Disable for faster basic calculations.' ); ?></span>
						</span>
					</div>
				</div>
			</div>
			<div v-if="repeaterField.enableFormula">
				<div class="row ccb-p-t-20" v-if="errorMessage.length > 0">
					<div class="col-12">
						<div class="ccb-formula-message-errors">
							<p class="ccb-formula-error-message" v-for="(item) in errorMessage">
								{{ item.message }}
							</p>
						</div>
					</div>
				</div>
				<div class="row ccb-p-t-20" v-if="openFormula">
					<div class="col-12">
						<formula-field @change="change" @error="setErrors" :id="repeaterField._id" v-model="costCalcLetterFormula" :available_fields="available_fields"/>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
