<div class="cbb-edit-field-container">
	<div class="ccb-edit-field-header">
		<div class="ccb-edit-field-header-left" @click="$emit( 'cancel' )">
			<span class="ccb-edit-back-icon"><i class="ccb-icon-Path-3398"></i></span>
			<div class="ccb-edit-header-button">
				<div class="ccb-edit-header-top">
					<button class="ccb-edit-back-button"><?php esc_html_e( 'Back', 'cost-calculator-builder' ); ?></button>
					<span class="ccb-edit-back-separator">/</span>
					<span class="ccb-edit-field-title" v-if="htmlField.label && htmlField.label.length > 0">{{ htmlField.label }}</span>
					<span class="ccb-edit-field-title" v-else><?php esc_html_e( 'Html element', 'cost-calculator-builder' ); ?></span>
				</div>
				<span class="ccb-edit-field-alias">[{{ htmlField.alias }}]</span>
			</div>
		</div>
		<div class="ccb-edit-field-header-right">
			<div class="ccb-save-wrapper" style="display: flex; justify-content: flex-end;">
				<button class="ccb-button success" @click.prevent="$emit( 'save', htmlField, id, index, htmlField.alias, htmlField.label )"><?php esc_html_e( 'Save', 'cost-calculator-builder' ); ?></button>
			</div>
		</div>
	</div>
	<div class="ccb-grid-box">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<div class="ccb-input-wrapper">
						<span class="ccb-input-label"><?php esc_html_e( 'Name', 'cost-calculator-builder' ); ?></span>
						<input type="text" v-model.trim="htmlField.label" placeholder="<?php esc_attr_e( 'Enter field name', 'cost-calculator-builder' ); ?>">
					</div>
					<div class="calc-html-textarea ccb-p-t-15">
						<span class="ccb-input-label"><?php esc_html_e( 'HTML5 Code', 'cost-calculator-builder' ); ?></span>
						<textarea rows="14" v-model="htmlField.htmlContent" placeholder="<?php esc_attr_e( 'Put HTML code here', 'cost-calculator-builder' ); ?>"></textarea>
					</div>
				</div>
			</div>
			<div class="row ccb-p-t-15" v-if="!disableFieldHiddenByDefault(htmlField)">
				<div class="col-6">
					<div class="list-header">
						<div class="ccb-switch">
							<input type="checkbox" v-model="htmlField.hidden"/>
							<label></label>
						</div>
						<h6><?php esc_html_e( 'Hidden by Default', 'cost-calculator-builder' ); ?></h6>
					</div>
				</div>
			</div>
			<div class="row ccb-p-t-15">
				<div class="col-12">
					<div class="ccb-builder-radio-wrapper">
						<span class="ccb-radio-label"><?php esc_html_e( 'Width', 'cost-calculator-builder' ); ?></span>
						<div class="ccb-radio-box">
							<input class="ccb-builder-radio__radio" :id="'ccb-width-25-' + htmlField.alias" type="radio" :name="'width-' + htmlField.alias" value="25" v-model="htmlField.width" @change="document.dispatchEvent(new CustomEvent('ccb_field_width_change', { detail: { alias: id.alias, width: 25 } }))">
							<label class="ccb-builder-radio__option" :for="'ccb-width-25-' + htmlField.alias"><?php esc_html_e( '25%', 'cost-calculator-builder' ); ?></label>

							<input class="ccb-builder-radio__radio" :id="'ccb-width-50-' + htmlField.alias" type="radio" :name="'width-' + htmlField.alias" value="50" v-model="htmlField.width" @change="document.dispatchEvent(new CustomEvent('ccb_field_width_change', { detail: { alias: id.alias, width: 50 } }))">
							<label class="ccb-builder-radio__option" :for="'ccb-width-50-' + htmlField.alias"><?php esc_html_e( '50%', 'cost-calculator-builder' ); ?></label>

							<input class="ccb-builder-radio__radio" :id="'ccb-width-75-' + htmlField.alias" type="radio" :name="'width-' + htmlField.alias" value="75" v-model="htmlField.width" @change="document.dispatchEvent(new CustomEvent('ccb_field_width_change', { detail: { alias: id.alias, width: 75 } }))">
							<label class="ccb-builder-radio__option" :for="'ccb-width-75-' + htmlField.alias"><?php esc_html_e( '75%', 'cost-calculator-builder' ); ?></label>

							<input class="ccb-builder-radio__radio" :id="'ccb-width-100-' + htmlField.alias" type="radio" :name="'width-' + htmlField.alias" value="100" v-model="htmlField.width" @change="document.dispatchEvent(new CustomEvent('ccb_field_width_change', { detail: { alias: id.alias, width: 100 } }))">
							<label class="ccb-builder-radio__option" :for="'ccb-width-100-' + htmlField.alias"><?php esc_html_e( '100%', 'cost-calculator-builder' ); ?></label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
