<?php

namespace RT\FinwaveCore\Controllers;

use RT\Finwave\Helpers\Fns;
use \RT_Postmeta;
use RT\FinwaveCore\Traits\SingletonTraits;
use RT\FinwaveCore\Builder\Builder;
use RT\FinwaveCore\Helper\FnsBuilder;
use RT\FinwaveCore\Modules\IconList;

class PostMetaController {
	use SingletonTraits;

	public $postmeta;

	public function __construct() {
		$this->postmeta = RT_Postmeta::getInstance();
//		$this->add_meta_box();
		add_action( 'init', [ $this, 'add_meta_box' ] );
	}

	/**
	 * Add all metabox
	 * @return void
	 */
	function add_meta_box() {

		$this->postmeta->add_meta_box(
			"rt_page_settings",
			__( 'Layout Settings', 'finwave-core' ),
			[ 'page', 'post', 'rt-team', 'rt-service', 'rt-project' ],
			'',
			'',
			'high',
			[
				'fields' => [
					"rt_layout_meta_data" => [
						'label' => __( 'Layouts', 'finwave-core' ),
						'type'  => 'group',
						'value' => $this->get_post_page_meta_args(),
					],
				],
			]
		);

		//Post Info
		$this->postmeta->add_meta_box(
			"rt_post_info",
			__( 'Post Info', 'finwave-core' ),
			[ 'post' ],
			'',
			'',
			'high',
			[
				'fields' => $this->get_post_info_meta(),
			]
		);

		//Team meta
		$this->postmeta->add_meta_box(
			"rt_team_info",
			__( 'Team Info', 'finwave-core' ),
			[ 'rt-team' ],
			'',
			'',
			'high',
			[
				'fields' => $this->get_team_info_meta(),
			]
		);
		$this->postmeta->add_meta_box(
			"rt_team_social",
			__( 'Team Social', 'finwave-core' ),
			[ 'rt-team' ],
			'',
			'',
			'high',
			[
				'fields' => $this->get_team_social_meta(),
			]
		);

		$this->postmeta->add_meta_box(
			"rt_team_skill",
			__( 'Team Skill', 'finwave-core' ),
			[ 'rt-team' ],
			'',
			'',
			'high',
			[
				'fields' => $this->get_team_skill_meta(),
			]
		);

		$this->postmeta->add_meta_box(
			"rt_team_contact",
			__( 'Team Contact', 'finwave-core' ),
			[ 'rt-team' ],
			'',
			'',
			'high',
			[
				'fields' => $this->get_team_contact_meta(),
			]
		);

        //service meta
        $this->postmeta->add_meta_box(
            "rt_service_icon",
            __( 'Service Icon', 'finwave-core' ),
            [ 'rt-service' ],
            '',
            '',
            'high',
            [
                'fields' => $this->get_service_icon_meta(),
            ]
        );

		//Project meta
		$this->postmeta->add_meta_box(
			"rt_project_info",
			__( 'Project Info', 'finwave-core' ),
			[ 'rt-project' ],
			'',
			'',
			'high',
			[
				'fields' => $this->get_project_info_meta(),
			]
		);

        //header footer build
		$this->postmeta->add_meta_box(
			"rt_el_builder_settings",
			__( 'Header - Footer Builder Settings', 'finwave-core' ),
			[ 'elementor-finwave' ],
			'',
			'',
			'high',
			[
				'fields' => $this->get_el_builder_meta_args(),
			]
		);
	}

	function get_el_builder_meta_args() {
		return apply_filters( 'finwave_layout_meta_field', [
			'template_type' => [
				'label'   => __( 'Template Type', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default' => __( 'Choose Options', 'finwave-core' ),
					'header'  => __( 'Header', 'finwave-core' ),
					'footer'  => __( 'Footer', 'finwave-core' ),
				],
				'default' => 'default',
			],

			'show_on' => [
				'label'   => __( 'Show On', 'finwave-core' ),
				'type'    => 'multi_select2',
				'options' => FnsBuilder::get_builder_type(),
				'default' => [],
				'class'   => 'rt-header-footer-select'
			],

			'choose_post' => [
				'label'       => __( 'Choose posts or pages', 'finwave-core' ),
				'type'        => 'ajax_select',
				'data_source' => 'post',
				'default'     => [],
			],

		] );
	}

	function get_post_page_meta_args() {
		$sidebars = [ 'default' => __( 'Default from customizer', 'finwave-core' ) ] + Fns::sidebar_lists();

		return apply_filters( 'finwave_layout_meta_field', [
			'layout'            => [
				'label'   => __( 'Layout', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default'       => __( 'Default from customizer', 'finwave-core' ),
					'full-width'    => __( 'Full Width', 'finwave-core' ),
					'left-sidebar'  => __( 'Left Sidebar', 'finwave-core' ),
					'right-sidebar' => __( 'Right Sidebar', 'finwave-core' ),
				],
				'default' => 'default',
			],
			'single_post_style' => [
				'label'   => __( 'Post View Style', 'finwave-core' ),
				'type'    => 'select',
				'options' => [ 'default' => __( 'Default from customizer', 'finwave-core' ) ] + Fns::single_post_style(),
				'default' => 'default',
			],
			'header_style'      => [
				'label'   => __( 'Header Style', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default' => __( 'Default from customizer', 'finwave-core' ),
					'1'       => __( 'Layout 1', 'finwave-core' ),
					'2'       => __( 'Layout 2', 'finwave-core' ),
				],
				'default' => 'default',
			],
			'sidebar'           => [
				'label'   => __( 'Custom Sidebar', 'finwave-core' ),
				'type'    => 'select',
				'options' => $sidebars,
				'default' => 'default',
			],
			'top_bar'           => [
				'label'   => __( 'Top Bar Visibility', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default' => __( 'Default from customizer', 'finwave-core' ),
					'on'      => __( 'ON', 'finwave-core' ),
					'off'     => __( 'OFF', 'finwave-core' ),
				],
				'default' => 'default',
			],
			'topbar_style'      => [
				'label'   => __( 'Top Bar Style', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default' => __( 'Default from customizer', 'finwave-core' ),
					'1'       => __( 'Layout 1', 'finwave-core' ),
				],
				'default' => 'default',
			],
			'header_width'      => [
				'label'   => __( 'Header Width', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default' => __( 'Default from customizer', 'finwave-core' ),
					'box'     => __( 'Box Width', 'finwave-core' ),
					'full'    => __( 'Full Width', 'finwave-core' ),
				],
				'default' => 'default',
			],
			'menu_alignment'    => [
				'label'   => __( 'Menu Alignment', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default'     => __( 'Default from customizer', 'finwave-core' ),
					'menu-left'   => __( 'Left Alignment', 'finwave-core' ),
					'menu-center' => __( 'Center Alignment', 'finwave-core' ),
					'menu-right'  => __( 'Right Alignment', 'finwave-core' ),
				],
				'default' => 'default',
			],

			'tr_header'        => [
				'label'   => __( 'Transparent Header', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default' => __( 'Default from customizer', 'finwave-core' ),
					'on'      => __( 'ON', 'finwave-core' ),
					'off'     => __( 'OFF', 'finwave-core' ),
				],
				'default' => 'default',
			],

			'tr_header_color' => [
				'label'   => __( 'Transparent color', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default'   => __( 'Default from customizer', 'finwave-core' ),
					'tr-header-light'   => __( 'Light Color', 'finwave-core' ),
					'tr-header-dark'    => __( 'Dark Color', 'finwave-core' ),
				],
				'default' => 'default',
			],

			'banner'           => [
				'label'   => __( 'Banner Visibility', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default' => __( 'Default from customizer', 'finwave-core' ),
					'on'      => __( 'ON', 'finwave-core' ),
					'off'     => __( 'OFF', 'finwave-core' ),
				],
				'default' => 'default',
			],
			'breadcrumb_title' => [
				'label'   => __( 'Banner Title', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default' => __( 'Default from customizer', 'finwave-core' ),
					'on'      => __( 'ON', 'finwave-core' ),
					'off'     => __( 'OFF', 'finwave-core' ),
				],
				'default' => 'default',
			],
			'breadcrumb'       => [
				'label'   => __( 'Banner Breadcrumb', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default' => __( 'Default from customizer', 'finwave-core' ),
					'on'      => __( 'ON', 'finwave-core' ),
					'off'     => __( 'OFF', 'finwave-core' ),
				],
				'default' => 'default',
			],

			'banner_image'    => [
				'type'  => 'image',
				'label' => __( 'Banner Background Image', 'finwave-core' ),
			],
			'banner_color'    => [
				'type'  => 'color_picker',
				'label' => __( 'Banner Background Color', 'finwave-core' ),
			],


			'footer_style'     => [
				'label'   => __( 'Footer Layout', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default' => __( 'Default from customizer', 'finwave-core' ),
					'1'       => __( 'Layout 1', 'finwave-core' ),
					'2'       => __( 'Layout 2', 'finwave-core' ),
				],
				'default' => 'default',
			],
			'footer_schema'    => [
				'label'   => __( 'Footer Schema', 'finwave-core' ),
				'type'    => 'select',
				'options' => [
					'default'      => __( 'Default from customizer', 'finwave-core' ),
					'footer-light' => __( 'Light Footer', 'finwave' ),
					'footer-dark'  => __( 'Dark Footer', 'finwave' ),
				],
				'default' => 'default',
			],
			'padding_top'    => [
				'label' => __( 'Padding Top (Page Content)', 'finwave-core' ),
				'type'  => 'number',
			],
			'padding_bottom'   => [
				'label' => __( 'Padding Bottom (Page Content)', 'finwave-core' ),
				'type'  => 'number',
			],
			'page_bg_image'    => [
				'type'  => 'image',
				'label' => __( 'Background Image', 'finwave-core' ),
			],
			'page_bg_color'    => [
				'type'  => 'color_picker',
				'label' => __( 'Background Color', 'finwave-core' ),
			],

		] );
	}

	function get_post_info_meta() {
		return apply_filters( 'rt_post_info', [
			'rt_youtube_link' => [
				'label'   => __( 'Youtube Link', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],
			'rt_post_gallery' => [
				'label' => __( 'Post Gallery', 'finwave-core' ),
				'type'  => 'gallery',
				'desc'  => __( 'Only work for the gallery post format', 'finwave-core' ),
			],
		] );
	}

	//Team meta info
	function get_team_info_meta() {
		return apply_filters( 'rt_team_meta_field', [
			'rt_team_info_title' => array(
				'label' => __( 'Information Title', 'finwave-core' ),
				'type'  => 'text',
			),

			'rt_team_designation' => [
				'label'   => __( 'Team Designation', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],

			'rt_team_phone' => [
				'label'   => __( 'Team Phone', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],

			'rt_team_website' => [
				'label'   => __( 'Team Website', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],

			'rt_team_email' => [
				'label'   => __( 'Team Email', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],

			'rt_team_address' => [
				'label'   => __( 'Team Address', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],

		] );
	}
	function get_team_social_meta() {
		return apply_filters( 'rt_team_meta_social', [
			'rt_team_socials' => array(
				'type'  => 'group',
				'value' => Fns::get_team_socials(),
			),
		] );
	}

	function get_team_skill_meta() {
		return apply_filters( 'rt_team_meta_skill', [

			'rt_team_skill_title' => array(
				'label' => __( 'Skill Title', 'finwave-core' ),
				'type'  => 'text',
			),

			'rt_team_skill_info' => [
				'label'   => __( 'Team Skill Info', 'finwave-core' ),
				'type'    => 'textarea',
			],

			'rt_team_skill' => [
				'type'  => 'repeater',
				'button' => __( 'Add New Skill', 'finwave-core' ),
				'value'  => [
					'skill_name' => [
						'label' => __( 'Skill Name', 'finwave-core' ),
						'type'  => 'text',
						'desc'  => __( 'eg. Marketing', 'finwave-core' ),
					],
					'skill_value' => [
						'label' => __( 'Skill Percentage (%)', 'finwave-core' ),
						'type'  => 'text',
						'desc'  => __( 'eg. 75', 'finwave-core' ),
					],
					'skill_color' => [
						'label' => __( 'Skill Color', 'finwave-core' ),
						'type'  => 'color_picker',
						'desc'  => __( 'If not selected, primary color will be used', 'finwave-core' ),
					],
				]
			],
		] );
	}

	function get_team_contact_meta() {
		return apply_filters( 'rt_team_meta_contact', [
			'rt_team_contact_form' => array(
				'label' => __( 'Contact Form Shortcode', 'finwave-core' ),
				'type'  => 'text',
			),
		] );
	}

    // Service meta info

    function get_service_icon_meta() {
        return apply_filters( 'rt_service_meta_icon', [
            'rt_service_icon'    => [
                'label'   => __( 'Service Icon', 'finwave-core' ),
                'type'    => 'select',
                'options' => IconList::fontello_service(),
            ],
            'rt_service_color'    => [
	            'label'   => __( 'Service Color', 'finwave-core' ),
	            'type'  => 'color_picker',
            ],
        ] );
    }


	//Project meta info
	function get_project_info_meta() {
		return apply_filters( 'rt_project_meta_field', [
			'rt_project_title' => [
				'label'   => __( 'Info Title', 'finwave-core' ),
				'type'    => 'text',
				'default' => __( 'Project Info', 'finwave-core' ),
			],

			'rt_project_text' => [
				'label'   => __( 'Info Text', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],

			'rt_project_client' => [
				'label'   => __( 'Client', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],

			'rt_project_start' => [
				'label'   => __( 'Starts On', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],

			'rt_project_end' => [
				'label'   => __( 'End On', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],

			'rt_project_weblink' => [
				'label'   => __( 'Weblink', 'finwave-core' ),
				'type'    => 'text',
				'default' => '',
			],

			'rt_project_rating' => [
				'label' => __( 'Select the Rating', 'finwave-core' ),
				'type'  => 'select',
				'options' => array(
					'-1' => __( 'Default', 'finwave-core' ),
					'1'    => '1',
					'2'    => '2',
					'3'    => '3',
					'4'    => '4',
					'5'    => '5'
				),
				'default'  => '-1',
			],

		] );
	}
}

