<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace RT\FinwaveCore\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use RT\FinwaveCore\Helper\Fns;
use RT\FinwaveCore\Abstracts\ElementorBase;

if (!defined('ABSPATH')) {
	exit;
}

class OpeningHour extends ElementorBase {

	public function __construct($data = [], $args = null) {
		$this->rt_name = esc_html__('RT Opening Hour', 'finwave-core');
		$this->rt_base = 'rt-opening-hour';
		parent::__construct($data, $args);
	}

	protected function register_controls() {
		$this->start_controls_section(
			'rt_opening_hour',
			[
				'label' => esc_html__('Opening Hour', 'finwave-core'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		// Features
		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'day', [
				'label' => __('Opening Day', 'finwave-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Saturday', 'finwave-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'hour', [
				'label' => __('Opening Hour', 'finwave-core'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('09.00 AM - 21.00 PM', 'finwave-core'),
				'label_block' => true,
			]
		);


		$repeater->add_control(
			'day_color',
			[
				'label' => __('Day Color', 'finwave-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .rt-opening-hour .opening-items {{CURRENT_ITEM}} .opening-day' => 'color: {{VALUE}}',
				],
			]
		);

		$repeater->add_control(
			'hour_color',
			[
				'label' => __('Hour Color', 'finwave-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .rt-opening-hour .opening-items {{CURRENT_ITEM}} .opening-hour' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'list',
			[
				'label' => __('Opening List', 'finwave-core'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'day' => __('Friday', 'finwave-core'),
						'hour' => __('09.00 AM - 21.00 PM', 'finwave-core'),
					],
					[
						'day' => __('Saturday', 'finwave-core'),
						'hour' => __('09.00 AM - 21.00 PM', 'finwave-core'),
					],
					[
						'day' => __('Sunday', 'finwave-core'),
						'hour' => __('Closed', 'finwave-core'),
					],
				],
				'title_field' => '{{{ day }}}',
			]
		);

		$this->end_controls_section();

		// Day Settings
		$this->start_controls_section(
			'opening_settings',
			[
				'label' => esc_html__('Opening Hour Settings', 'finwave-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'opening_style_tabs'
		);

		$this->start_controls_tab(
			'day_tab',
			[
				'label' => __('Day', 'finwave-core'),
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'day_typo',
				'label' => esc_html__('Typo', 'finwave-core'),
				'selector' => '{{WRAPPER}} .rt-opening-hour .opening-items .opening-day',
			]
		);
		$this->add_control(
			'day_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__('Color', 'finwave-core'),
				'selectors' => [
					'{{WRAPPER}} .rt-opening-hour .opening-items .opening-day' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'hour_tab',
			[
				'label' => __('Hour', 'finwave-core'),
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'hour_typo',
				'label' => esc_html__('Typo', 'finwave-core'),
				'selector' => '{{WRAPPER}} .rt-opening-hour .opening-items .opening-hour',
			]
		);
		$this->add_control(
			'hour_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__('Color', 'finwave-core'),
				'selectors' => [
					'{{WRAPPER}} .rt-opening-hour .opening-items .opening-hour' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		// Opening List setting
		$this->start_controls_section(
			'opening_list_style',
			[
				'label' => esc_html__( 'Opening List Style', 'finwave-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'opening_list_color',
			[
				'type' => Controls_Manager::COLOR,
				'label' => esc_html__('Background Color', 'finwave-core'),
				'selectors' => [
					'{{WRAPPER}} .rt-opening-hour li.opening-list' => 'background-color: {{VALUE}}',

				],
			]
		);
		$this->add_responsive_control(
			'opening_list_margin',
			[
				'label' => __('Margin', 'finwave-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rt-opening-hour li.opening-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
				'separator' =>'before',
			]
		);
		$this->add_responsive_control(
			'opening_list_padding',
			[
				'label' => __('Padding', 'finwave-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rt-opening-hour li.opening-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
				'separator' =>'before',
			]
		);
		$this->add_responsive_control(
			'opening_list_radius',
			[
				'label' => __('Radius', 'finwave-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rt-opening-hour li.opening-list' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
				'separator' =>'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'opening_list_border',
				'label' => __('Border', 'finwave-core'),
				'selector' => '{{WRAPPER}} .rt-opening-hour li.opening-list',
			]
		);

		$this->end_controls_section();

		//Animation setting
		$this->start_controls_section(
			'animation_style',
			[
				'label' => esc_html__( 'Animation Style', 'finwave-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'animation',
			[
				'type'      => Controls_Manager::SELECT,
				'label'     => esc_html__( 'Animation', 'finwave-core' ),
				'options' => [
					'wow' => esc_html__( 'On', 'finwave-core' ),
					'wow-off'         => esc_html__( 'Off', 'finwave-core' ),
				],
				'default' => 'wow-off',
			]
		);

		$this->add_control(
			'animation_effect',
			[
				'type'    => Controls_Manager::SELECT,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'finwave-core' ),
				'options' => [
					'bounce' => esc_html__( 'bounce', 'finwave-core' ),
					'flash' => esc_html__( 'flash', 'finwave-core' ),
					'pulse' => esc_html__( 'pulse', 'finwave-core' ),
					'headShake' => esc_html__( 'headShake', 'finwave-core' ),
					'swing' => esc_html__( 'swing', 'finwave-core' ),
					'fadeIn' => esc_html__( 'fadeIn', 'finwave-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'finwave-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'finwave-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'finwave-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'finwave-core' ),
					'bounceIn' => esc_html__( 'bounceIn', 'finwave-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'finwave-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'finwave-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'finwave-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'finwave-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'finwave-core' ),
					'slideInDown' => esc_html__( 'slideInDown', 'finwave-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'finwave-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'finwave-core' ),
					'zoomIn' => esc_html__( 'zoomIn', 'finwave-core' ),
					'zoomInDown' => esc_html__( 'zoomInDown', 'finwave-core' ),
					'zoomInUp' => esc_html__( 'zoomInUp', 'finwave-core' ),
					'zoomInLeft' => esc_html__( 'zoomInLeft', 'finwave-core' ),
					'zoomInRight' => esc_html__( 'zoomInRight', 'finwave-core' ),
					'zoomOut' => esc_html__( 'zoomOut', 'finwave-core' ),
				],
				'default' => 'fadeInUp',
				'condition'   => [
					'animation' => [ 'wow' ]
				],
			]
		);

		$this->add_control(
			'delay',
			[
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Delay', 'finwave-core' ),
				'default' => '200',
				'condition'   => [
					'animation' => [ 'wow' ]
				],
			],
		);

		$this->add_control(
			'duration',
			[
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'Duration', 'finwave-core' ),
				'default' => '1200',
				'condition'   => [
					'animation' => [ 'wow' ]
				],
			],
		);

		$this->end_controls_section();

	}

	protected function render() {
		$data = $this->get_settings();
		$template = 'view-1';
		Fns::get_template( "elementor/opening-hour/$template", $data );
	}
}