<?php
/**
 * Theme Customizer - Header
 *
 * @package finwave
 */

namespace RT\Finwave\Api\Customizer\Sections;

use RT\Finwave\Api\Customizer;
use RTFramework\Customize;

/**
 * Customizer class
 */
class SiteIdentity extends Customizer {

	/**
	 * Register controls
	 * @return void
	 */
	public function register() {
		Customize::add_controls( 'title_tagline', $this->get_controls() );
	}

	/**
	 * Get controls
	 * @return array
	 */
	public function get_controls() {

		return apply_filters( 'rt_title_tagline_controls', [

			'rt_logo' => [
				'type'         => 'image',
				'label'        => __( 'Main Logo', 'finwave' ),
				'description'  => __( 'Upload main logo for your site.', 'finwave' ),
				'button_label' => __( 'Logo', 'finwave' ),
			],

			'rt_logo_light' => [
				'type'         => 'image',
				'label'        => __( 'Light Logo', 'finwave' ),
				'description'  => __( 'Upload light logo for transparent header. It should a white logo', 'finwave' ),
				'button_label' => __( 'Light Logo', 'finwave' ),
			],

			'rt_logo_mobile' => [
				'type'         => 'image',
				'label'        => __( 'Mobile Logo', 'finwave' ),
				'description'  => __( 'Upload, if you need a different logo for mobile device..', 'finwave' ),
				'button_label' => __( 'Mobile Logo', 'finwave' ),
			],

			'rt_logo_width_height' => [
				'type'      => 'text',
				'label'     => __( 'Main Logo Dimension', 'finwave' ),
				'description'     => __( 'Enter the width and height value separate by comma (,). Eg. 120px,45px', 'finwave' ),
				'transport' => '',
			],

			'rt_mobile_logo_width_height' => [
				'type'      => 'text',
				'label'     => __( 'Mobile Logo Dimension', 'finwave' ),
				'description'     => __( 'Enter the width and height value separate by comma (,). Eg. 120px,45px', 'finwave' ),
				'transport' => '',
			],

		] );

	}

}
