<?php
/**
 * @author  RadiusTheme
 * @since   1.0.0
 * @version 1.1.0
 */

namespace RT\Finwave\Modules;
use RT\Finwave\Traits\SingletonTraits;

require_once get_template_directory() . '/inc/Lib/class-tgm-plugin-activation.php';
class TgmConfig {

	use SingletonTraits;

	public $base;
	public $path;

	public function __construct() {
		$this->base = 'finwave';
		$this->path = get_template_directory() . '/plugin-bundle/';

		add_action( 'tgmpa_register', [ $this, 'register_required_plugins' ] );
	}

	public function register_required_plugins() {
		$plugins = [
			// Bundled
			[
				'name'     => 'Finwave Core',
				'slug'     => 'finwave-core',
				'source'   => 'finwave-core.zip',
				'required' => true,
				'version'  => '1.1.3'
			],
			[
				'name'     => 'RT Framework',
				'slug'     => 'rt-framework',
				'source'   => 'rt-framework.zip',
				'required' => true,
				'version'  => '3.0.3'
			],
			[
				'name'     => esc_html__('ShopBuilder - Elementor WooCommerce Builder Addons','finwave'),
				'slug'     => 'shopbuilder',
				'required' => false,
			],
			[
				'name'         => 'ShopBuilder Pro',
				'slug'         => 'shopbuilder-pro',
				'source'       => 'shopbuilder-pro.zip',
				'required'     => true,
				'version'      => '2.0.1'
			],

			// Repository
			[
				'name'     => esc_html__('WooCommerce','finwave'),
				'slug'     => 'woocommerce',
				'required' => false,
			],
			[
				'name'     => esc_html__('Elementor Page Builder','finwave'),
				'slug'     => 'elementor',
				'required' => false,
			],
			[
				'name'     => esc_html__('Breadcrumb NavXT','finwave'),
				'slug'     => 'breadcrumb-navxt',
				'required' => false,
			],
			[
				'name'     => esc_html__('WP Fluent Forms','finwave'),
				'slug'     => 'fluentform',
				'required' => false,
			],
			[
				'name'     => esc_html__('One Click Demo Import','finwave'),
				'slug'     => 'one-click-demo-import',
				'required' => false,
			],
		];

		$config = [
			'id'           => $this->base,
			'default_path' => $this->path,
			'menu'         => $this->base . '-install-plugins',
			'has_notices'  => true,
			'dismissable'  => true,
			'dismiss_msg'  => '',
			'is_automatic' => false,
			'message'      => '',
		];

		tgmpa( $plugins, $config );
	}
}
