<?php
/**
 * LayoutControls
 */

namespace RT\Finwave\Traits;

// Do not allow directly accessing this file.
use RT\Finwave\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

trait LayoutControlsTraits {
	public function get_layout_controls( $prefix = '' ) {

		$_left_text  = __( 'Left Sidebar', 'finwave' );
		$_right_text = __( 'Right Sidebar', 'finwave' );
		$left_text   = $_left_text;
		$right_text  = $_right_text;
		$image_left  = 'sidebar-left.png';
		$image_right = 'sidebar-right.png';

		if ( is_rtl() ) {
			$left_text   = $_right_text;
			$right_text  = $_left_text;
			$image_left  = 'sidebar-right.png';
			$image_right = 'sidebar-left.png';
		}

		return apply_filters( "finwave_{$prefix}_layout_controls", [

			$prefix . '_layout' => [
				'type'    => 'image_select',
				'label'   => __( 'Choose Layout', 'finwave' ),
				'default' => 'right-sidebar',
				'choices' => [
					'left-sidebar'  => [
						'image' => finwave_get_img( $image_left ),
						'name'  => $left_text,
					],
					'full-width'    => [
						'image' => finwave_get_img( 'sidebar-full.png' ),
						'name'  => __( 'Full Width', 'finwave' ),
					],
					'right-sidebar' => [
						'image' => finwave_get_img( $image_right ),
						'name'  => $right_text,
					],
				]
			],

			$prefix . '_sidebar' => [
				'type'    => 'select',
				'label'   => __( 'Choose a Sidebar', 'finwave' ),
				'default' => 'default',
				'choices' => Fns::sidebar_lists()
			],

			$prefix . '_page_bg_image' => [
				'type'         => 'image',
				'label'        => __( 'Page Background Image', 'finwave' ),
				'description'  => __( 'Upload Background Image', 'finwave' ),
				'button_label' => __( 'Background Image', 'finwave' ),
			],

			$prefix . '_page_bg_color' => [
				'type'         => 'color',
				'label'        => __( 'Page Background Color', 'finwave' ),
				'description'  => __( 'Inter Background Color', 'finwave' ),
			],

			$prefix . '_header_heading' => [
				'type'  => 'heading',
				'label' => __( 'Header Settings', 'finwave' ),
			],

			$prefix . '_header_style' => [
				'type'    => 'select',
				'default' => 'default',
				'label'   => __( 'Header Layout', 'finwave' ),
				'choices' => [
					'default' => __( '--Default--', 'finwave' ),
					'1'       => __( 'Layout 1', 'finwave' ),
					'2'       => __( 'Layout 2', 'finwave' ),
				],
			],

			$prefix . '_top_bar' => [
				'type'    => 'select',
				'label'   => __( 'Top Bar', 'finwave' ),
				'default' => 'default',
				'choices' => [
					'default' => __( '--Default--', 'finwave' ),
					'on'      => __( 'On', 'finwave' ),
					'off'     => __( 'Off', 'finwave' ),
				]
			],

			$prefix . '_banner_heading' => [
				'type'  => 'heading',
				'label' => __( 'Banner Settings', 'finwave' ),
			],

			$prefix . '_banner' => [
				'type'    => 'select',
				'default' => 'default',
				'label'   => __( 'Banner Visibility', 'finwave' ),
				'choices' => [
					'default' => __( '--Default--', 'finwave' ),
					'on'      => __( 'On', 'finwave' ),
					'off'     => __( 'Off', 'finwave' ),
				],
			],

			$prefix . '_breadcrumb_title' => [
				'type'    => 'select',
				'default' => 'default',
				'label'   => __( 'Banner Title', 'finwave' ),
				'choices' => [
					'default' => __( '--Default--', 'finwave' ),
					'on'      => __( 'On', 'finwave' ),
					'off'     => __( 'Off', 'finwave' ),
				],
			],

			$prefix . '_breadcrumb' => [
				'type'    => 'select',
				'default' => 'default',
				'label'   => __( 'Banner Breadcrumb', 'finwave' ),
				'choices' => [
					'default' => __( '--Default--', 'finwave' ),
					'on'      => __( 'On', 'finwave' ),
					'off'     => __( 'Off', 'finwave' ),
				],
			],

			$prefix . '_banner_image' => [
				'type'         => 'image',
				'label'        => __( 'Banner Image', 'finwave' ),
				'description'  => __( 'Upload Banner Image', 'finwave' ),
				'button_label' => __( 'Banner Image', 'finwave' ),
			],

			$prefix . '_banner_color' => [
				'type'         => 'color',
				'label'        => __( 'Banner Background Color', 'finwave' ),
				'description'  => __( 'Inter Background Color', 'finwave' ),
			],

			$prefix . '_footer_heading' => [
				'type'  => 'heading',
				'label' => __( 'Footer Settings', 'finwave' ),
			],

			$prefix . '_footer_style'  => [
				'type'    => 'select',
				'default' => 'default',
				'label'   => __( 'Footer Layout', 'finwave' ),
				'choices' => [
					'default' => __( '--Default--', 'finwave' ),
					'1'       => __( 'Layout 1', 'finwave' ),
					'2'       => __( 'Layout 2', 'finwave' ),
				],
			],

		] );


	}


}
