<?php

namespace RadiusTheme\SBPRO\Controllers\Admin;

defined( 'ABSPATH' ) || exit();

use RadiusTheme\SBPRO\Traits\SingletonTrait;

class AdminInitPro {
	/**
	 * Parent Menu Page Slug
	 */
	const MENU_PAGE_SLUG = 'rtsb';

	/**
	 * Menu capability
	 */
	const MENU_CAPABILITY = 'manage_options';

	/**
	 * Parent Menu Hook
	 *
	 * @var string
	 */
	static $parent_menu_hook = '';

	// private $menu_link_part;

	use SingletonTrait;

	private function __construct() {
		add_action( 'rtsb/add/more/submenu', [ $this, 'add_menu' ], 10, 2 );
	}

	/**
	 * @return void
	 */
	public function add_menu( $menu_page_slug, $menu_capability ) {
		add_submenu_page(
			$menu_page_slug,
			esc_html__( 'License', 'shopbuilder-pro' ),
			'<span style="color: #6BBE66;">' . esc_html__( 'License', 'shopbuilder-pro' ) . '</span>',
			$menu_capability,
			'rtsb-license',
			[ $this, 'license_page' ]
		);
	}

	public function license_page() {
		wp_enqueue_style( 'rtsb-admin-app' );
		$license_key    = rtsbpro()->get_license( 'license_key' );
		$license_status = rtsbpro()->get_license( 'license_status' );
		?>
		<div class="wrap rtsb-license-wrap">
			<div id="rtsb-license-key-wrapper" class="rtsb-settings-page-wrapper">
				<div class="rtsb-header-area">
					<div class="rtsb-header-logo-wrap">
						<img src="<?php echo esc_url( rtsb()->get_assets_uri( 'images/icon/ShopBuilder-Logo.svg' ) ); ?>" alt="ShopBuilder" loading="lazy">
					</div>
					<div class="rtsb-header-title-wrap">
						<h2 class="rtsb-title">ShopBuilder Settings</h2>
					</div>
				</div>
				<div class="rtsbpro-wrapper">
					<div class="rtsb-ss-wrap">
						<div class="rtsb-ss-header">
							<h2 class="rtsb-title">Licence </h2>
							<p class="rtsb-description">
								It helps ensure authorized usage and enables us to support and update your plugin effectively with auto-updates, and premium support.
							</p>
						</div>
					</div>
					<div id="mainform">
						<div class="rtsbpro-field-label">
							<h3>Licence key</h3>
							<p class="description"> Please provide a valid license key.</p>
						</div>

                        <?php

                            $license_status_class = '';
                            switch ( $license_status ){
                                case 'valid':
	                                $license_status_class = 'rtsb-success';
                                    break;
                                    //case 'valid':
                                    //    $license_status_class = 'rtsb-failure';
                                    //    break;
                                default:
                            }

                        ?>

						<div class="rtsbpro-field <?php echo esc_attr( $license_status_class );?>">
							<input type="text" class="regular-text" id="license_key_field" name="rtsbpro_license_key" value="<?php echo esc_attr( $license_key ); ?>" placeholder="Enter your licence key here">
                            <span class="license-status"> <span class="dashicons dashicons-yes-alt"></span> Valid </span>
						</div>
						<div class="rtsbpro-field-submit-button <?php echo esc_attr( 'valid' === $license_status ? 'rtsb-danger' : '' ); ?>">
							<?php
							$button_class = 'primary ' . ( 'valid' === $license_status ? 'rtsb-license-deactivate' : 'rtsb-license-activate' );
                            $text  = 'valid' === $license_status ? esc_attr__( 'Deactivate License', 'shopbuilder-pro' ) : esc_attr__( 'Activate License', 'shopbuilder-pro' );
							submit_button( $text, esc_attr( $button_class ), 'rtsb_license_action' );
							?>
						</div>
					</div>
                    <div id="mainform-status">
                        <div class="rtsbpro-field-label"></div>
                        <div class="rtsbpro-field"></div>
                    </div>
				</div>
			</div>
		</div>
		<?php
	}

}
