<?php
/**
 * Main Licensing class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Controllers\Admin;

use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Models\RtLicense;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

class Licensing {

	/**
	 * Single ton
	 */
	use SingletonTrait;

	// Licensing variable
	public static $store_url = 'https://www.radiustheme.com';
	/**
	 * @var int
	 */
	public static $product_id = 222610; // Original Id Added

	/**
	 *
	 */
	private function __construct() {
		add_action( 'admin_init', [ $this, 'license' ] );
		add_action( 'wp_ajax_rtsbpro_manage_licensing', [ $this, 'rtsbpro_manage_licensing' ] );
	}

	/**
	 * @return void
	 */
	public function license() {
		if ( FnsPro::check_license() ) {
			$license_key    = trim( rtsbpro()->get_license( 'license_key' ) ?? '' );
			$license_status = rtsbpro()->get_license( 'license_status' );
			$status         = ( ! empty( $license_status ) && $license_status === 'valid' ) ? true : false;
			new RtLicense(
				static::$store_url,
				RTSBPRO_FILE,
				[
					'version' => RTSBPRO_VERSION,
					'license' => $license_key,
					'item_id' => self::$product_id,
					'author'  => 'RadiusTheme',
					'url'     => home_url(),
					'beta'    => false,
					'status'  => $status,
				]
			);

		}
	}

	/**
	 * @return void
	 */
	public function rtsbpro_manage_licensing() {
		$error       = true;
		$type        = $value = $data = $message = null;
		$license_key = sanitize_text_field( $_REQUEST['license_key'] ?? '' );// trim( rtsbpro()->get_license( 'license_key' ) );
		$status = '';
		// Check if anything passed on a message constituting a failure
		if ( ! empty( $_REQUEST['type'] ) && $_REQUEST['type'] == 'license_activate' ) {
			$api_params = [
				'edd_action' => 'activate_license',
				'license'    => $license_key,
				'item_id'    => self::$product_id,
				'url'        => home_url(),
			];
			$response   = wp_remote_post(
				self::$store_url,
				[
					'timeout'   => 15,
					'sslverify' => false,
					'body'      => $api_params,
				]
			);
			if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {
				$err     = $response->get_error_message();
				$message = ( is_wp_error( $response ) && ! empty( $err ) ) ? $err : __( 'An error occurred, please try again.', 'shopbuilder-pro' );
			} else {
				$license_data = json_decode( wp_remote_retrieve_body( $response ) );
				if ( false === $license_data->success ) {
					switch ( $license_data->error ) {
						case 'expired':
							$message = sprintf(
								__( 'Your license key expired on %s.', 'shopbuilder-pro' ),
								date_i18n(
									get_option( 'date_format' ),
									strtotime( $license_data->expires, current_time( 'timestamp' ) )
								)
							);
							break;
						case 'revoked':
							$message = __( 'Your license key has been disabled.', 'shopbuilder-pro' );
							break;
						case 'missing':
							$message = __( 'Invalid license. Please provide a valid license key.', 'shopbuilder-pro' );
							break;
						case 'invalid':
						case 'site_inactive':
							$message = __( 'Your license is not active for this URL.', 'shopbuilder-pro' );
							break;
						case 'item_name_mismatch':
							$message = __( 'This appears to be an invalid license key for Shopbuilder Pro.', 'shopbuilder-pro' );
							break;
						case 'no_activations_left':
							$message = __( 'Your license key has reached its activation limit.', 'shopbuilder-pro' );
							break;
						case 'license_not_activable':
							$message = __( 'Your license is invalid.', 'shopbuilder-pro' );
							break;
						default:
							$message = __( 'An error occurred, please try again.', 'shopbuilder-pro' );
							break;
					}
				}
				if ( empty( $message ) ) {
					$status = $license_data->license;
					$error = false;
					$type  = 'license_deactivate';
					$value = __( 'Deactivate License', 'shopbuilder-pro' );
				}

			}
		}
		if ( ! empty( $_REQUEST['type'] ) && $_REQUEST['type'] == 'license_deactivate' ) {
			$api_params = [
				'edd_action' => 'deactivate_license',
				'license'    => $license_key,
				'item_id'    => self::$product_id,
				'url'        => home_url(),
			];
			$response   = wp_remote_post(
				self::$store_url,
				[
					'timeout'   => 15,
					'sslverify' => false,
					'body'      => $api_params,
				]
			);

			// Make sure there are no errors
			if ( is_wp_error( $response ) || 200 !== wp_remote_retrieve_response_code( $response ) ) {
				$err     = $response->get_error_message();
				$message = ( is_wp_error( $response ) && ! empty( $err ) ) ? $err : __( 'An error occurred, please try again.', 'shopbuilder-pro' );
			} else {
				$status = '';
				$error = false;
				$type  = 'license_activate';
				$value = __( 'Activate License', 'shopbuilder-pro' );
			}
		}
		rtsbpro()->update_license( [
			'license_key' => $license_key,
			'license_status' => $status
		] );
		$response = [
			'error' => $error,
			'msg'   => $message,
			'type'  => $type,
			'value' => $value,
			'data'  => $data,
		];
		wp_send_json( $response );
	}

}
