<?php
/**
 * Main ActionHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Controllers\Hooks;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SB\Helpers\BuilderFns;
use RadiusTheme\SB\Models\TemplateSettings;
use RadiusTheme\SBPRO\Elementor\Render\RenderPro;

defined( 'ABSPATH' ) || exit();

/**
 * Main ActionHooks class.
 */
class ActionHooksPro {

	/**
	 * Init Hooks.
	 *
	 * @return void
	 */
	public static function init_hooks() {

		add_action( 'rtsb/builder/after/header', [ __CLASS__, 'builder_after_header' ] );
		add_action( 'rtsb/builder/before/footer', [ __CLASS__, 'builder_before_footer' ], 1 );

		add_action( 'rtsb/set/default/column/extra/field', [ __CLASS__, 'product_column_extra_field' ], 15, 2 );
		add_action( 'rtsb/set/default/column/extra/field', [ __CLASS__, 'archive_column_extra_field' ], 15, 2 );
		add_action( 'rtsb/after/create/and/edit/builder/template', [ __CLASS__, 'edit_product_builder_template' ], 15, 2 );
		add_action( 'rtsb/after/create/and/edit/builder/template', [ __CLASS__, 'edit_archive_builder_template' ], 15, 2 );
		add_action( 'rtsb/set/builder/default/template', [ __CLASS__, 'set_product_builder_default_template' ], 15, 2 );
		add_action( 'rtsb/set/builder/default/template', [ __CLASS__, 'set_archive_builder_default_template' ], 15, 2 );

		add_action( 'rtsb/after/saved/settings/success', [ __CLASS__, 'after_saved_settings_success' ], 15, 3 );

		// WC Query modifier.
		add_action( 'woocommerce_product_query', [ __CLASS__, 'query_modifier' ], 15 );

		// Cart Table Column Data.
		add_action( 'rtsb/cart/table/products/column', [ __CLASS__, 'cart_table_products_column' ], 15, 5 );

		// Ajax Filters.
		add_action( 'rtsb/before/archive/filter/items', [ RenderPro::class, 'filter_header' ], 10 );
		add_action( 'rtsb/before/archive/filter/items', [ RenderPro::class, 'filter_search' ], 15 );

		// Recently viewed.
		add_action( 'template_redirect', [ __CLASS__, 'track_product_view' ], 20 );

		// Disabling features for Guest Users.
		add_action( 'the_post', [ __CLASS__, 'disable_add_to_cart' ], 12 );
		add_action( 'wp_enqueue_scripts', [ __CLASS__, 'disable_guest_css' ], 99 );
		add_action( 'woocommerce_before_shop_loop_item_title', [ __CLASS__, 'disable_badges' ], 10 );
		add_action( 'template_redirect', [ __CLASS__, 'disable_cart' ] );

		// Product stock count for widget.
		add_action( 'rtsb/after/shop/product/content', [ __CLASS__, 'render_product_stock_count' ], 10 );
	}
	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function builder_after_header() {
		$type = apply_filters( 'rtsb/builder/set/current/page/type', '' );
		if ( 'quick-view' !== $type ) {
			return;
		}
		?>
		<div class="single-product">
		<div <?php post_class( '', Fns::get_prepared_product_id() ); ?> >
		<?php
	}
	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function builder_before_footer() {
		$type = apply_filters( 'rtsb/builder/set/current/page/type', '' );
		if ( 'quick-view' !== $type ) {
			return;
		}
		?>
		</div>
		</div>
		<?php
	}
	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function cart_table_products_column( $cart_item_key, $_product, $cart_item, $table, $controllers ) {
		$product_permalink    = $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '';
		$thumbnail_size       = isset( $table['cart_table_thumbnail_size'] ) ? $table['cart_table_thumbnail_size'] : 'thumbnail';
		$thumbnail            = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image( $thumbnail_size ), $cart_item, $cart_item_key );
		$link                 = sprintf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() );
		$show_image_on_mobile = $controllers['show_image_on_mobile'] ? ' show-on-mobile' : ' hide-on-mobile';
		?>
			<div class="rtsb-product-image <?php echo esc_attr( $show_image_on_mobile ); ?>">
				<?php Fns::print_html( $thumbnail, true ); //  phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
			</div>
			<div class="rtsb-product-content" data-title="<?php echo esc_attr( $table['cart_table_heading_title'] ); ?>" >
				<?php
				echo FnsPro::woocommerce_cart_item_name( $link, $cart_item, $cart_item_key, $table );

				do_action( 'woocommerce_after_cart_item_name', $cart_item, $cart_item_key );
				?>
			</div>
		<?php
	}
	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function after_saved_settings_success( $section_id, $block_id, $rawOptions ) {
		// Remove Cache.
		if ( 'sales_notification' === $block_id ) {
			// $cache_id   = 'rtsb_get_notifications_data';
			delete_transient( 'rtsb_get_notifications_data' );
		}
	}

	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function archive_column_extra_field( $post_id, $template_type ) {
		if ( ! in_array( $template_type, [ 'archive' , 'product' ], true ) ) {
			return;
		}
		$categories = apply_filters( 'rtsb/template/builder/selected/categories', [], $post_id, $template_type );
		if ( empty( $categories ) ) {
			return;
		}
		$class = '';
		if ( 'product' === $template_type ) {
			$class = 'product-page-';
		}
		?>
		<div class="<?php echo esc_attr( $class ); ?>specific-category" data-specific_category="<?php echo esc_attr( wp_json_encode( $categories ) ); ?>"
			 style=""></div>
		<?php
	}

	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function product_column_extra_field( $post_id, $type ) {
		if ( 'product' !== $type ) {
			return;
		}

		$product_page_for = get_post_meta( $post_id, '_is_product_page_template_for', true );
		if ( 'specific_products' === $product_page_for ) {
			$the_option  = BuilderFns::option_name_by_template_id( $post_id );
			$product_ids = TemplateSettings::instance()->get_option( $the_option );
			?>
		<div class="specific-product" data-specific_product="<?php echo esc_attr( wp_json_encode( $product_ids ) ); ?>"
			 style=""></div>
			<?php
		} elseif ( 'product_tags' === $product_page_for ) {
			$tag_options_name = BuilderFns::option_name_product_page_selected_tag( $post_id );
			$tags_id          = TemplateSettings::instance()->get_option( $tag_options_name );
			?>
			<div class="specific-tags" data-specific_tags="<?php echo esc_attr( wp_json_encode( $tags_id ) ); ?>"
				 style=""></div>
			<?php
		}
	}

	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function edit_product_builder_template( $action, $post_id ) {
		if ( empty( $action['page_type'] ) || 'product' !== $action['page_type'] ) {
			return;
		}
		$category_list            = array_unique( isset( $action['selected_category'] ) && is_array( $action['selected_category'] ) ? array_map( 'sanitize_text_field', $action['selected_category'] ) : [] );
		$selected_tags            = array_unique( isset( $action['selected_tags'] ) && is_array( $action['selected_tags'] ) ? array_map( 'sanitize_text_field', $action['selected_tags'] ) : [] );
		$is_for_category          = 'product_cats' === ( $action['product_page_for'] ?? '' );
		$is_for_tags              = 'product_tags' === ( $action['product_page_for'] ?? '' );
		$is_for_selected_products = 'specific_products' === ( $action['product_page_for'] ?? '' );
		$set_default              = false;
		if ( ! empty( $action['default_template'] ) && 'default_template' === $action['default_template'] ) {
			$set_default = true;
		}
		$cat_options_name       = BuilderFns::option_name_product_page_selected_cat( $post_id );
		$cat_set_default_option = BuilderFns::option_name_product_page_specific_cat_set_default( $post_id );

		$tag_options_name       = BuilderFns::option_name_product_page_selected_tag( $post_id );
		$tag_set_default_option = BuilderFns::option_name_product_page_specific_tag_set_default( $post_id );

		if ( $is_for_category && is_array( $category_list ) ) {
			$old_cat_list     = TemplateSettings::instance()->get_option( $cat_options_name );
			$old_cat_list     = is_array( $old_cat_list ) ? $old_cat_list : [];
			$old_removed_cats = array_diff( $old_cat_list, $category_list );
			if ( ! empty( $old_removed_cats ) ) {
				foreach ( $old_removed_cats as $old_slug ) {
					$OldcatList = get_term_by( 'slug', $old_slug, 'product_cat' );
					if ( ! empty( $OldcatList ) && ! is_wp_error( $OldcatList ) ) {
						delete_term_meta( $OldcatList->term_id, BuilderFns::$categories_product_page_template, $post_id );
					}
				}
			}

			TemplateSettings::instance()->set_option( $cat_set_default_option, $set_default );
			TemplateSettings::instance()->set_option( $cat_options_name, $category_list );
            foreach ( $category_list as $slug ) {
				$catList = get_term_by( 'slug', $slug, 'product_cat' );
                if ( ! empty( $catList ) && ! is_wp_error( $catList ) ) {
                    update_term_meta( $catList->term_id, BuilderFns::$categories_product_page_template, absint( $post_id ) );
				}
			}
		} elseif ( $is_for_tags && is_array( $selected_tags ) ) {
			$old_tag_list     = TemplateSettings::instance()->get_option( $tag_options_name );
			$old_tag_list     = is_array( $old_tag_list ) ? $old_tag_list : [];
			$old_removed_tags = array_diff( $old_tag_list, $selected_tags );
			if ( ! empty( $old_removed_tags ) ) {
				foreach ( $old_removed_tags as $old_slug ) {
					$OldTagList = get_term_by( 'slug', $old_slug, 'product_tag' );
					if ( ! empty( $OldTagList ) && ! is_wp_error( $OldTagList ) ) {
						delete_term_meta( $OldTagList->term_id, BuilderFns::$tags_product_page_template, $post_id );
					}
				}
			}

			TemplateSettings::instance()->set_option( $tag_set_default_option, $set_default );
			TemplateSettings::instance()->set_option( $tag_options_name, $selected_tags );

			foreach ( $selected_tags as $slug ) {
				$tagList = get_term_by( 'slug', $slug, 'product_tag' );
				if ( ! empty( $tagList ) && ! is_wp_error( $tagList ) ) {
					update_term_meta( $tagList->term_id, BuilderFns::$tags_product_page_template, absint( $post_id ) );
				}
			}
		}
		if ( ! $is_for_category ) {
			if ( TemplateSettings::instance()->get_option( $cat_options_name ) ) {
				TemplateSettings::instance()->delete_option( $cat_options_name );
			}
			if ( TemplateSettings::instance()->get_option( $cat_set_default_option ) ) {
				TemplateSettings::instance()->delete_option( $cat_set_default_option );
			}
		}
		if ( ! $is_for_tags ) {
			if ( TemplateSettings::instance()->get_option( $tag_options_name ) ) {
				TemplateSettings::instance()->delete_option( $tag_options_name );
			}
			if ( TemplateSettings::instance()->get_option( $tag_set_default_option ) ) {
				TemplateSettings::instance()->delete_option( $tag_set_default_option );
			}
		}

		// Product Page For Selected Product.
		if ( $is_for_selected_products ) {
			$the_products       = array_unique( isset( $action['the_products'] ) && is_array( $action['the_products'] ) ? array_map( 'absint', $action['the_products'] ) : [] );
			$the_option         = BuilderFns::option_name_by_template_id( $post_id );
			$set_default_option = BuilderFns::option_name_for_specific_product_set_default( $post_id );
			// Remove Old Data.
			$old_products        = TemplateSettings::instance()->get_option( $the_option );
			$old_products        = is_array( $old_products ) ? $old_products : [];
			$old_removed_product = array_diff( $old_products, $the_products );
			foreach ( $old_removed_product as $old_id ) {
				delete_post_meta( $old_id, BuilderFns::$view_template_for_products_meta, $post_id );
			}
			// Add new data.
			TemplateSettings::instance()->set_option( $set_default_option, $set_default );
			TemplateSettings::instance()->set_option( $the_option, $the_products );
			foreach ( $the_products as $id ) {
				update_post_meta( $id, BuilderFns::$view_template_for_products_meta, $post_id );
			}
		}
	}

	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function edit_archive_builder_template( $action, $post_id ) {

		if ( empty( $action['page_type'] ) || 'archive' !== $action['page_type'] ) {
			return;
		}
		$selected_category  = array_unique( isset( $action['selected_category'] ) && is_array( $action['selected_category'] ) ? array_map( 'sanitize_text_field', $action['selected_category'] ) : [] );
		$the_option         = BuilderFns::archive_option_name_by_template_id( $post_id );
		$set_default_option = BuilderFns::option_name_for_specific_category_set_default( $post_id );
		$set_default        = false;
		if ( ! empty( $action['default_template'] ) && 'default_template' === $action['default_template'] ) {
			$set_default = true;
		}

		// Remove Old Data.
		$old_categories  = TemplateSettings::instance()->get_option( $the_option );
		$old_categories  = is_array( $old_categories ) ? $old_categories : [];
		$old_removed_cat = array_diff( $old_categories, $selected_category );
		foreach ( $old_removed_cat as $old_slug ) {
			$old_cat = get_term_by( 'slug', $old_slug, 'product_cat' );
			delete_term_meta( $old_cat->term_id, BuilderFns::$view_template_for_archive_meta, $post_id );
		}
		// Add New Data.
		TemplateSettings::instance()->set_option( $set_default_option, $set_default );
		TemplateSettings::instance()->set_option( $the_option, $selected_category );
		foreach ( $selected_category as $slug ) {
			$cat = get_term_by( 'slug', $slug, 'product_cat' );
			update_term_meta( $cat->term_id, BuilderFns::$view_template_for_archive_meta, $post_id );
		}
	}

	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function set_product_builder_default_template( $action, $post_id ) {
		if ( 'product' !== ( $action['template_type'] ?? '' ) ) {
			return;
		}
		$set_default_option_name = '';
		$product_page_for        = get_post_meta( $post_id, '_is_product_page_template_for', true );

		switch ( $product_page_for ) {
			case 'specific_products':
				$set_default_option_name = BuilderFns::option_name_for_specific_product_set_default( $action['page_id'] );
				break;
			case 'product_cats':
				$set_default_option_name = BuilderFns::option_name_product_page_specific_cat_set_default( $action['page_id'] );
				break;
			case 'product_tags':
				$set_default_option_name = BuilderFns::option_name_product_page_specific_tag_set_default( $action['page_id'] );
				break;
			default:
		}
		if ( empty( $set_default_option_name ) ) {
			return;
		}
		$set_default = false;
		if ( absint( $action['set_default_page_id'] ) ) {
			$set_default = true;
		}
		TemplateSettings::instance()->set_option( $set_default_option_name, $set_default );
	}

	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function set_archive_builder_default_template( $action, $post_id ) {

		if ( empty( $action['template_type'] ) || 'archive' !== $action['template_type'] ) {
			return;
		}

		$set_default_option_name = BuilderFns::option_name_for_specific_category_set_default( $action['page_id'] );
		$set_default             = false;
		if ( absint( $action['set_default_page_id'] ) ) {
			$set_default = true;
		}

		// update_option( $set_default_option_name, $set_default );
		TemplateSettings::instance()->set_option( $set_default_option_name, $set_default );
	}

	/**
	 * Query modifier.
	 *
	 * @param object $query Query.
	 * @return object
	 */
	public static function query_modifier( $query ) {
		$onsale_filter    = isset( $_GET['sale_filter'] ) ? sanitize_text_field( wp_unslash( $_GET['sale_filter'] ) ) : ''; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$on_sale_products = wc_get_product_ids_on_sale();

		if ( 'onsale' === $onsale_filter ) {
			$query->set( 'post__in', ! empty( $on_sale_products ) ? $on_sale_products : [ 0 ] );
		} elseif ( 'regular' === $onsale_filter ) {
			$query->set( 'post__not_in', $on_sale_products );
		}

		return $query;
	}

	/**
	 * Track the view of a product and update the recently viewed products list.
	 *
	 * @return void
	 */
	public static function track_product_view() {
		if ( ! is_product() ) {
			return;
		}

		global $post;

		if ( empty( $_COOKIE['rtsb_recently_viewed'] ) ) {
			$viewed_products = [];
		} else {
			$viewed_products = wp_parse_id_list( (array) explode( '|', wp_unslash( $_COOKIE['rtsb_recently_viewed'] ) ) ); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
		}

		// Unset if already in viewed products list.
		$keys = array_flip( $viewed_products );

		if ( isset( $keys[ $post->ID ] ) ) {
			unset( $viewed_products[ $keys[ $post->ID ] ] );
		}

		$viewed_products[] = $post->ID;

		if ( count( $viewed_products ) > 15 ) {
			array_shift( $viewed_products );
		}

		// Store for session only.
		wc_setcookie( 'rtsb_recently_viewed', implode( '|', $viewed_products ) );
	}

	/**
	 * Disable certain features for non-logged-in users.
	 *
	 * @return void
	 */
	public static function disable_add_to_cart() {
		$add_to_cart_disabled = Fns::is_guest_feature_disabled( 'hide_add_to_cart', '' );

		if ( $add_to_cart_disabled ) {
			remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
			remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
			remove_action( 'woocommerce_external_add_to_cart', 'woocommerce_external_add_to_cart', 30 );
			remove_action( 'woocommerce_grouped_add_to_cart', 'woocommerce_grouped_add_to_cart', 30 );
			add_filter( 'woocommerce_is_purchasable', '__return_false' );
		}
	}

	/**
	 * Disable certain features for non-logged-in users.
	 *
	 * @return void
	 */
	public static function disable_cart() {
		$cart_page_disabled = Fns::is_guest_feature_disabled( 'hide_cart_page', '' );

		if ( $cart_page_disabled && is_cart() ) {
			wp_safe_redirect( wc_get_account_endpoint_url( 'my-account' ) );

			exit();
		}
	}

	/**
	 * Disable certain features for non-logged-in users.
	 *
	 * @return void
	 */
	public static function disable_badges() {
		$badges_disabled = Fns::is_guest_feature_disabled( 'hide_badges', '' );

		if ( $badges_disabled ) {
			remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash' );
			remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash' );
		}
	}

	/**
	 * Disable certain features for non-logged-in users.
	 *
	 * @return void
	 */
	public static function disable_guest_css() {
		$dynamic_css          = '';
		$add_to_cart_disabled = Fns::is_guest_feature_disabled( 'hide_add_to_cart', '' );
		$badges_disabled      = Fns::is_guest_feature_disabled( 'hide_badges', '' );

		if ( $add_to_cart_disabled ) {
			$dynamic_css .= '
                a.ast-on-card-button,
                .rtsb-checkout-and-add-to-cart {
                    display: none !important;
                }
            ';

			if ( is_product() ) {
				$dynamic_css .= '
                    form.variations_form {
                        display: none !important;
                    }
                ';
			}
		}

		if ( $badges_disabled ) {
			$dynamic_css .= '
			    .ast-on-card-button.ast-onsale-card,
                .woocommerce span.onsale,
                .woocommerce span.outofstock,
                .woocommerce span.wc-new-badge {
                    display: none !important;
                }
            ';
		}

		wp_add_inline_style( 'rtsb-frontend', $dynamic_css );
	}

	/**
	 * Renders the product stock count.
	 *
	 * @param array $settings The settings for rendering the product stock count.
	 *
	 * @return void
	 */
	public static function render_product_stock_count( $settings ) {
		if ( ! self::exclude_product_stock_count_layout( $settings ) && ! empty( $settings['show_product_stock_count'] ) ) {
			$show_stock_text     = $settings['show_stock_text'] ?: 'no';
			$show_stock_progress = $settings['show_stock_progress'] ?: 'no';
			$stock_text          = $settings['stock_text'] ?: '';
			$stock_text_position = 'bottom' === $settings['stock_text_position'] ? 'bottom-position' : 'top-position';
			$shortcode           = '[product_stock_count wrapper_class="' . $stock_text_position . '" stock_text="' . $stock_text . '" show_stock_text="' . $show_stock_text . '" show_stock_progress="' . $show_stock_progress . '"/]';

			Fns::print_html( do_shortcode( $shortcode ) );
		}
	}

	/**
	 * Exclude product stock count layout.
	 *
	 * @param array $settings The settings array.
	 *
	 * @return bool
	 */
	public static function exclude_product_stock_count_layout( $settings ) {
		$exclude_layout = [
			'grid-layout3',
			'list-layout6',
			'slider-layout3',
			'slider-layout8',
		];

		return in_array( $settings['layout'], $exclude_layout, true );
	}
}
