<?php
/**
 * Main initialization class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Controllers\Hooks;

defined( 'ABSPATH' ) || exit();

use RadiusTheme\SB\Helpers\BuilderFns;
use RadiusTheme\SBPRO\Helpers\BuilderFunPro;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

/**
 * Builder Frontend.
 */
class BuilderHooksPro {
	/**
	 * Singleton.
	 */
	use SingletonTrait;

	/**
	 * Final constructor.
	 */
	private function __construct() {
		add_filter( 'body_class', [ $this, 'product_page_body_class' ] );
		add_filter( 'rtsb/builder/register/page/types', [ $this, 'register_builder_page_types' ], 15 );
		add_filter( 'rtsb/element/list/init/widgets', [ $this, 'element_list_init_widgets' ], 15, 2 );
		add_filter( 'rtsb/builder/set/current/page/type/external', [ $this, 'builder_page_type' ], 15 );
	}

	/**
	 * Page builder types.
	 *
	 * @return array
	 */
	public function register_builder_page_types( $types ) {
		$page_type = [
			'order-thank-you'                 => esc_html__( 'Thank You / Order Received', 'shopbuilder-pro' ),
			'myaccount-dashboard'             => esc_html__( 'My Account - Dashboard', 'shopbuilder-pro' ),
			'myaccount-order'                 => esc_html__( 'My Account - Orders', 'shopbuilder-pro' ),
			'myaccount-downloads'             => esc_html__( 'My Account - Downloads', 'shopbuilder-pro' ),
			'myaccount-address'               => esc_html__( 'My Account - Address', 'shopbuilder-pro' ),
			'myaccount-edit-billing-address'  => esc_html__( 'My Account - Edit Billing Address', 'shopbuilder-pro' ),
			'myaccount-edit-shipping-address' => esc_html__( 'My Account - Edit Shipping Address', 'shopbuilder-pro' ),
			'myaccount-edit-details'          => esc_html__( 'My Account - Edit/Details', 'shopbuilder-pro' ),
			'myaccount-order-details'         => esc_html__( 'My Account - Order Details', 'shopbuilder-pro' ),
			'order-pay'                       => esc_html__( 'My Account - Order Pay', 'shopbuilder-pro' ),
			'myaccount-auth'                  => esc_html__( 'Login / Register', 'shopbuilder-pro' ),
			'myaccount-lost-password'         => esc_html__( 'Lost Password', 'shopbuilder-pro' ),
			'quick-view'                      => esc_html__( 'Quick View', 'shopbuilder-pro' ),
			// 'myaccount-wishlist'              => esc_html__( 'Wishlist', 'shopbuilder-pro' ), // TODO:: Remove After Testing
		];
		$page_type = apply_filters( 'rtsb/builder/register/page/types/pro', $page_type );

		return array_merge( $types, $page_type );
	}

	/**
	 * @param string $type Builder Type.
	 *
	 * @return mixed|string
	 * TODO: Need speed optimization
	 */
	public function builder_page_type( $type ) {
		// if ( 'product' !== get_post_type() || 'rtsb_builder' !== get_post_type() ) {
		// return $type;
		// }

		if ( BuilderFunPro::is_thank_you() ) {
			$type = 'order-thank-you';
		} elseif ( BuilderFunPro::is_order_pay() ) {
			$type = 'order-pay';
		} elseif ( BuilderFunPro::is_account_dashboard() ) {
			$current_url_path   = wp_parse_url( esc_url_raw( add_query_arg( null, null ) ), PHP_URL_PATH );
			$dashboard_url_path = wp_parse_url( wc_get_account_endpoint_url( 'dashboard' ), PHP_URL_PATH );
			if ( $dashboard_url_path === $current_url_path && is_user_logged_in() ) {
				$type = 'myaccount-dashboard';
			} else {
				$type = 'myaccount-auth';
			}
		} elseif ( BuilderFunPro::is_orders_page() ) {
			$type = ! is_user_logged_in() ? 'myaccount-auth' : 'myaccount-order';
		} elseif ( BuilderFunPro::is_orders_details_page() ) {
			$type = ! is_user_logged_in() ? 'myaccount-auth' : 'myaccount-order-details';
		} elseif ( BuilderFunPro::is_downloads_page() ) {
			$type = ! is_user_logged_in() ? 'myaccount-auth' : 'myaccount-downloads';
		} elseif ( BuilderFunPro::is_account_edit_billing_address() ) {
			$type = ! is_user_logged_in() ? 'myaccount-auth' : 'myaccount-edit-billing-address';
		} elseif ( BuilderFunPro::is_account_edit_shipping_address() ) {
			$type = ! is_user_logged_in() ? 'myaccount-auth' : 'myaccount-edit-shipping-address';
		} elseif ( BuilderFunPro::is_address_page() ) {
			$type = ! is_user_logged_in() ? 'myaccount-auth' : 'myaccount-address';
		} elseif ( BuilderFunPro::is_account_details() ) {
			$type = ! is_user_logged_in() ? 'myaccount-auth' : 'myaccount-edit-details';
			// } elseif ( BuilderFunPro::is_account_wishlist() ) {
			// $type = 'myaccount-wishlist';
		} elseif ( BuilderFunPro::is_account_login_register() ) {
			$type = 'myaccount-auth';
		} elseif ( BuilderFunPro::is_lost_password_page() ) {
			$type = 'myaccount-lost-password';
		} elseif ( BuilderFns::is_quick_views_page() ) {
			$type = 'quick-view';
		}

		return $type;
	}

	/**
	 * Builder page Body class.
	 *
	 * @param array $classes class list.
	 *
	 * @return array.
	 */
	public function product_page_body_class( $classes ) {
		$type            = apply_filters( 'rtsb/builder/set/current/page/type', '' );
		$custom_endpoint = apply_filters( 'rtsb/editor/enable/custom_endpoint', false );

		if ( $custom_endpoint ) {
			$classes[] = 'woocommerce-account';
		}

		switch ( $type ) {
			case 'order-thank-you':
				$classes[] = 'woocommerce-checkout woocommerce-order-received';
				break;
			case 'order-pay':
				$classes[] = 'woocommerce-checkout woocommerce-order-pay';
				break;
			case 'myaccount-order-details':
				$classes[] = 'woocommerce-view-order woocommerce-account';
				break;
			case 'myaccount-edit-details':
				$classes[] = 'woocommerce-edit-account woocommerce-account';
				break;
			case 'myaccount-dashboard':
			case 'myaccount-address':
			case 'myaccount-auth':
			case 'myaccount-edit-shipping-address':
			case 'myaccount-edit-billing-address':
			case 'myaccount-downloads':
			case 'myaccount-order':
				$classes[] = 'woocommerce-account';
				break;
			case 'myaccount-lost-password':
				$classes[] = 'woocommerce-lost-password';
				break;

		}

		return $classes;
	}


	/**
	 * @param $widget
	 * @param $element
	 *
	 * @return mixed
	 */
	public function element_list_init_widgets( $widget, $element ) {
		if ( $widget ) {
			return $widget;
		}
		$widget  = apply_filters( 'rtsb/builder/element/list/widgets', $widget );
		$isfront = ! empty( $element['is_front_page'] ) ? $element['is_front_page'] : 'none';
		$import  = apply_filters( 'rtsb_import_status', false );
		switch ( $isfront ) {
			case 'thank_you':
				if ( BuilderFunPro::is_thank_you() || $import ) {
					$widget = new $element['base_class']();
				}
				break;
			case 'quick_view':
				// is quick view: Required for Modal View.
				if ( BuilderFns::is_quick_views_page( true ) || $import ) {
					$widget = new $element['base_class']();
				}
				break;

			case 'all_myaccount_dashboard_inner':
				$custom_endpoint = apply_filters( 'rtsb/editor/enable/custom_endpoint', false );

				if (
					BuilderFunPro::is_account_dashboard() ||
					BuilderFunPro::is_orders_page() ||
					BuilderFunPro::is_downloads_page() ||
					BuilderFunPro::is_address_page() ||
					BuilderFunPro::is_account_edit_billing_address() ||
					BuilderFunPro::is_account_edit_shipping_address() ||
					BuilderFunPro::is_account_details() ||
					BuilderFunPro::is_account_wishlist() ||
					BuilderFunPro::is_orders_details_page() ||
					BuilderFunPro::is_order_pay() ||
					$custom_endpoint ||
					$import
				) {
					$widget = new $element['base_class']();
				}
				break;

			case 'myaccount_auth':
				$widget = new $element['base_class']();
				break;

			default:
		}

		return apply_filters( 'rtsb/builder/editor/widgets', $widget );
	}
}
