<?php
/**
 * Elementor Widget Hooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Controllers\Hooks;

use RadiusTheme\SB\Elementor\Helper\ControlSelectors;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Controllers\Frontend\Shortcodes\CouponList;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\ProductStockCountSettings;
use RadiusTheme\SBPRO\Elementor\Widgets\General\ProductLookBook\Selectors;
use RadiusTheme\SBPRO\Elementor\Widgets\General\ImageHotspots\Selectors as ImageHotspotsSelectors;
use RadiusTheme\SBPRO\Elementor\Widgets\General\CouponList\Selectors as CouponListSelectors;
use RadiusTheme\SBPRO\Elementor\Widgets\General\HeroSlider\Selectors as HeroSliderSelectors;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SB\Controllers\Hooks\ActionHooks;
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SBPRO\Elementor\Render\RenderPro;
use RadiusTheme\SBPRO\Elementor\Helpers\ControlSelectorPro;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\LayoutFields;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\StyleFields;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\SettingsFields;
use RadiusTheme\SB\Elementor\Widgets\Controls\StyleFields as StyleFieldsFree;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\FlashSaleCountdownSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\SettingsFields as FreeSettingsFields;

use WC_Product;

defined( 'ABSPATH' ) || exit();

/**
 * Elementor Widget Hooks class.
 */
class ElementorHooks {
	/**
	 * Controller;
	 *
	 * @var array
	 */
	private static $controller = [];

	/**
	 * Widget.
	 *
	 * @var object
	 */
	private static $widget;

	/**
	 * Init Hooks.
	 *
	 * @return void
	 */
	public static function init_hooks() {
		// phpcs:disable
		// Ignore for readable array values on a single line.

		/**
		 * Actions.
		 */
		add_action( 'rtsb/elementor/render/before_row', [ RenderPro::class, 'render_tax_filter' ], 10, 4 );
		add_action( 'rtsb/elementor/render/pagination', [ RenderPro::class, 'render_pro_pagination' ], 10, 3 );
		add_action( 'rtsb/after/shop/product/image', [ RenderPro::class, 'render_flash_sale' ], 10, 1 );
		add_action( 'rtsb/before/social/share/item', [ RenderPro::class, 'render_social_share_pro' ], 10, 1 );
		add_action( 'rtsb/elements/elementor/additional_action_buttons', [ RenderPro::class, 'render_action_buttons' ] );
		add_action( 'rtsb/elementor/render/cat_arg_dataset', [ RenderPro::class, 'cat_arg_dataset_pro' ], 10, 6 );
		add_action( 'rtsb/custom/products/before/template/load', [ __CLASS__, 'archive_custom_layout_rendering' ] );
		add_action(' rtsb/custom/products/after/template/load', [ __CLASS__, 'archive_custom_layout_reset_rendering' ] );

		// Cart Table.
		add_action( 'rtsb/before/product/cart/table', [ __CLASS__, 'before_product_cart_table_widgets' ], 10, 2 );
		add_action( 'rtsb/after/product/cart/table', [ __CLASS__, 'after_product_cart_table_widgets' ] );

		// Count Down.
		add_action( 'rtsb/before/product/flash/sale/countdown/widget', [ __CLASS__, 'before_product_flash_sale_countdown_widget' ], 10, 2 );
		add_action( 'rtsb/after/product/flash/sale/countdown/widget', [ __CLASS__, 'after_product_flash_sale_countdown_widget' ], 10, 2 );

        // Custom category image.
		add_action( 'rtsb/categories/category_image_override', [ __CLASS__, 'cat_custom_image_id' ], 99, 2 );

		/**
		 * Filters.
		 */
		add_filter( 'rtsb/elements/tax_list', [ __CLASS__, 'tax_list' ] );
		add_filter( 'rtsb/elementor/pagination_options', [ __CLASS__, 'pagination_pro_options' ] );
		add_filter( 'rtsb/elementor/pagination_control', [ LayoutFields::class, 'pagination_pro_controls' ] );
		add_filter( 'rtsb/elements/elementor/cat_layout_control', [ LayoutFields::class, 'category_pro_controls' ], 10, 2 );
		add_filter( 'rtsb/elementor/filter_control', [ SettingsFields::class, 'filter_controls' ], 10, 2 );
		add_filter( 'rtsb/elementor/ordering_control', [ SettingsFields::class, 'ordering_control' ], 10, 2 );
		add_filter( 'rtsb/elementor/render/meta_dataset', [ __CLASS__, 'meta_dataset_pro' ], 10, 2 );
		add_filter( 'rtsb/elementor/render/slider_dataset', [ __CLASS__, 'slider_dataset_pro' ], 10, 2 );
//		add_filter( 'rtsb/elements/product_query_args', [ __CLASS__, 'query_args' ], 10, 2 );
		add_filter( 'rtsb/elements/product_query_args', [ __CLASS__, 'wc_query_args' ], 10, 2 );
		add_filter( 'rtsb/elementor/args_before_loop', [ __CLASS__, 'filter_query_args' ], 10, 2 );
		add_filter( 'rtsb/elementor/row/start', [ __CLASS__, 'row_attributes' ], 10, 2 );
		add_filter( 'rtsb/elementor/grid_style_tab/rtsb-cross-sell-product-custom', [ __CLASS__, 'style_controls' ], 10, 2 );
		add_filter( 'rtsb/elementor/grid_style_tab', [ __CLASS__, 'style_controls' ], 10, 2 );
		add_filter( 'rtsb/elementor/list_style_tab', [ __CLASS__, 'style_controls' ], 10, 2 );
		add_filter( 'rtsb/elementor/slider_style_tab', [ __CLASS__, 'style_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/archive_styles_tab', [ __CLASS__, 'quick_checkout_controls' ], 10, 2 );
		add_filter( 'rtsb/elementor/common_selectors', [ ControlSelectorPro::class, 'pro_common_selectors' ], 10, 2 );
		add_filter( 'rtsb/elementor/general_product_selectors', [ ControlSelectorPro::class, 'pro_product_selectors' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/social_share_selectors', [ ControlSelectorPro::class, 'pro_social_selectors' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/product_loop_default_selectors', [ ControlSelectorPro::class, 'product_loop_default_selectors' ], 15 );
		add_filter( 'rtsb/elements/elementor/visibility_control', [ __CLASS__, 'pro_visibility_control' ], 10, 2 );
		add_filter( 'rtsb/elementor/render/arg_dataset', [ __CLASS__, 'pro_arg_dataset' ], 10, 4 );
		add_filter( 'rtsb/elements/elementor/formatted_action_buttons', [ __CLASS__, 'pro_formatted_buttons' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/share_style_tab', [ __CLASS__, 'pro_share_styles' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/action_buttons', [ __CLASS__, 'action_buttons' ], 11, 2 );
		add_filter( 'rtsb/elements/elementor/grid_layout_control', [ __CLASS__, 'layout_fields' ], 11, 2 );

		// Product Default Widget Hook.
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-archive', [ __CLASS__, 'products_default_widgets_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product', [ __CLASS__, 'products_default_widgets_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-product', [ __CLASS__, 'products_default_widgets_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-cross-sells', [ __CLASS__, 'products_default_widgets_controls' ], 10, 2 );

		// Product Grid Widget Hook.
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-grid', [ __CLASS__, 'product_grid_widget_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-slider', [ __CLASS__, 'product_grid_widget_controls' ], 10, 2
		);
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-archive-custom', [ __CLASS__, 'product_grid_widget_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-custom', [ __CLASS__, 'product_grid_widget_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-slider', [ __CLASS__, 'product_grid_widget_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-product-custom', [ __CLASS__, 'product_grid_widget_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-products-slider', [ __CLASS__, 'product_grid_widget_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-cross-sell-product-custom', [ __CLASS__, 'product_grid_widget_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-crosssell-product-slider', [ __CLASS__, 'product_grid_widget_controls' ], 10, 2 );

		// Product List Widget Hook.
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-list', [ __CLASS__, 'product_list_widget_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-slider', [ __CLASS__, 'product_list_widget_controls' ], 10, 2 );

		// Product Inner Gallery Support.
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-grid', [ __CLASS__, 'added_rtsb_product_slider_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-list', [ __CLASS__, 'added_rtsb_product_slider_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-slider', [ __CLASS__, 'added_rtsb_product_slider_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-archive-custom', [ __CLASS__, 'added_rtsb_product_slider_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-custom', [ __CLASS__, 'added_rtsb_product_slider_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-slider', [ __CLASS__, 'added_rtsb_product_slider_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-product-custom', [ __CLASS__, 'added_rtsb_product_slider_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-products-slider', [ __CLASS__, 'added_rtsb_product_slider_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-cross-sell-product-custom', [ __CLASS__, 'added_rtsb_product_slider_controls' ], 10, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-crosssell-product-slider', [ __CLASS__, 'added_rtsb_product_slider_controls' ], 10, 2 );

		// General Product CountDownSettings.
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-grid', [ __CLASS__, 'elementor_general_products_countdown_controls' ], 11, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-list', [ __CLASS__, 'elementor_general_products_countdown_controls' ], 11, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-slider', [ __CLASS__, 'elementor_general_products_countdown_controls' ], 11, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-archive-custom', [ __CLASS__, 'elementor_general_products_countdown_controls' ], 11, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-custom', [ __CLASS__, 'elementor_general_products_countdown_controls' ], 11, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-slider', [ __CLASS__, 'elementor_general_products_countdown_controls' ], 11, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-product-custom', [ __CLASS__, 'elementor_general_products_countdown_controls' ], 11, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-products-slider', [ __CLASS__, 'elementor_general_products_countdown_controls' ], 11, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-cross-sell-product-custom', [ __CLASS__, 'elementor_general_products_countdown_controls' ], 11, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-crosssell-product-slider', [ __CLASS__, 'elementor_general_products_countdown_controls' ], 11, 2 );


		// General Product Stock Count Settings.
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-grid', [ __CLASS__, 'elementor_general_products_stock_count_controls' ], 12, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-list', [ __CLASS__, 'elementor_general_products_stock_count_controls' ], 12, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-slider', [ __CLASS__, 'elementor_general_products_stock_count_controls' ], 12, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-archive-custom', [ __CLASS__, 'elementor_general_products_stock_count_controls' ], 12, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-custom', [ __CLASS__, 'elementor_general_products_stock_count_controls' ], 12, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-slider', [ __CLASS__, 'elementor_general_products_stock_count_controls' ], 12, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-product-custom', [ __CLASS__, 'elementor_general_products_stock_count_controls' ], 12, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-products-slider', [ __CLASS__, 'elementor_general_products_stock_count_controls' ], 12, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-cross-sell-product-custom', [ __CLASS__, 'elementor_general_products_stock_count_controls' ], 12, 2 );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-crosssell-product-slider', [ __CLASS__, 'elementor_general_products_stock_count_controls' ], 12, 2 );

		// Cart.
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-product-carttable', [ __CLASS__, 'elementor_product_carttable_controls' ], 11, 2 );

		// Product Inner Gallery Selector.
		add_filter( 'rtsb/elements/elementor/widget/general/selectors', [ __CLASS__, 'general_widget_control_selectors' ] );
		add_filter( 'rtsb/elements/elementor/widget/archive/selectors', [ __CLASS__, 'product_archive_widget_control_selectors' ] );
		add_filter( 'rtsb/elements/elementor/widget/product/selectors', [ __CLASS__, 'product_single_widget_control_selectors' ] );
		add_filter( 'rtsb/elements/elementor/widget/cart/selectors', [ __CLASS__, 'cart_widget_control_selectors' ] );
		add_filter( 'rtsb/elementor/common_selectors', [ __CLASS__, 'general_layout_common_selectors' ], 11 );

		// Single Product Tab Widget.
		add_filter( 'rtsb/elements/elementor/render/rtsb-product-tabs', [ __CLASS__, 'rtsb_product_tabs_render' ] );
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-product-tabs',  [ __CLASS__,  'rtsb_product_tabs_widget_controls', ],  10,  2
		);

		// General rating settings.
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-grid', [ __CLASS__, 'rating_settings' ], 10, 2
		);
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-list', [ __CLASS__, 'rating_settings' ], 10, 2
		);
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-slider', [ __CLASS__, 'rating_settings' ], 10, 2
		);
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-archive-custom', [ __CLASS__, 'rating_settings' ], 10, 2
		);
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-custom', [ __CLASS__, 'rating_settings' ], 10, 2
		);
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-upsells-product-slider', [ __CLASS__, 'rating_settings' ], 10, 2
		);
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-related-product-custom', [ __CLASS__, 'rating_settings' ], 10, 2
		);
		add_filter(
			'rtsb/elements/elementor/widgets/controls/rtsb-related-products-slider', [ __CLASS__, 'rating_settings' ], 10, 2
		);
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-cross-sell-product-custom', [ __CLASS__, 'rating_settings' ], 10, 2
		);
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-crosssell-product-slider', [ __CLASS__, 'rating_settings' ], 10, 2
		);

		// Product Category Widget Control
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-product-categories-general', [ __CLASS__, 'elementor_product_category_controls' ], 11, 2 );

		// Product Single Category Widget Control
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-products-single-category', [ __CLASS__, 'elementor_product_category_controls' ], 11, 2 );

        /*
        * Product Badges.
        * TODO:: Remove After Final Test
        * add_filter( 'rtsb/elementor/badges', [ __CLASS__, 'badges_module_controls' ], 10, 2 );
        */

        // Single add to cart.
		add_filter( 'rtsb/elements/elementor/widgets/controls/rtsb-product-add-to-cart', [ __CLASS__, 'single_ajax_add_to_cart' ] );

		// phpcs:enable
	}

	/**
	 * Product Tab settings
	 *
	 * @param array $fields widget controls.
	 *
	 * @return array
	 */
	public static function products_default_widgets_controls( $fields, $obj ) {
		if ( FnsPro::is_module_active( 'flash_sale_countdown' ) ) {
			$Countdown_control['show_flash_sale_countdown'] = [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Flash Sale Countdown?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show flash sale countdown.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			];
			$fields = Fns::insert_controls( 'show_rating', $fields, $Countdown_control );
		}

		if ( FnsPro::is_module_active( 'quick_checkout' ) ) {
			$extra_control['show_quick_checkout'] = [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Quick Checkout?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show quick checkout button.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			];
			$fields                               = Fns::insert_controls( 'show_rating', $fields, $extra_control );

			// Quick Checkout.
			$css_selectors = $obj->selectors['show_qc_btn_selector'] ?? [];
			$title         = esc_html__( 'Quick Checkout Button', 'shopbuilder-pro' );
			$condition     = [
				'show_quick_checkout' => [ 'yes' ],
			];
			$selectors     = StyleFieldsFree::title_selectors( $css_selectors );

			$qc_btn_style = ControlHelper::general_elementor_style( 'show_qc_btn', $title, $obj, $condition, $selectors );

			unset(
				$qc_btn_style['show_qc_btn_alignment']
			);

			$fields = Fns::insert_controls( 'cart_button_style_section_end', $fields, $qc_btn_style, true );

			$extra_style_control['qc_btn_height'] = [
				'label'     => esc_html__( 'Button Height', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'default'   => [
					'size' => '',
				],
				'selectors' => [
					$css_selectors['qc_btn_height'] => 'height: {{SIZE}}{{UNIT}};',
				],
			];

			$fields = Fns::insert_controls( 'show_qc_btn_style_section', $fields, $extra_style_control, true );

		}
		return $fields;
	}


	/**
	 * Product Tab settings
	 *
	 * @param array $fields widget controls.
	 *
	 * @return array
	 */
	public static function action_buttons( $fields, $obj ) {
		if ( FnsPro::is_module_active( 'quick_checkout' ) ) {
			$extra_control['quick_checkout_note'] = $obj->el_heading(
				esc_html__( 'Quick Checkout', 'shopbuilder-pro' ),
				'before',
				[],
				[ 'show_quick_checkout' => [ 'yes' ] ]
			);

			$extra_control['show_quick_checkout_text'] = [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Button Text?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show quick checkout text.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
				'default'     => 'yes',
				'condition'   => [ 'show_quick_checkout' => [ 'yes' ] ],
			];
			$extra_control['show_quick_checkout_icon'] = [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Button Icon?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show quick checkout icon.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
				'default'     => 'yes',
				'condition'   => [ 'show_quick_checkout' => [ 'yes' ] ],
			];
			$extra_control['quick_checkout_icon']      = [
				'type'      => 'icons',
				'label'     => esc_html__( 'Button Icon', 'shopbuilder-pro' ),
				'condition' => [
					'show_quick_checkout'      => [ 'yes' ],
					'show_quick_checkout_icon' => [ 'yes' ],
				],
				'default'   => [
					'value'   => 'rtsb-icon rtsb-icon-pay',
					'library' => 'rtsb-fonts',
				],
			];

			$fields = Fns::insert_controls( 'comparison_icon_added', $fields, $extra_control, true );
		}

		return $fields;
	}

	/**
	 * Grid layout settings
	 *
	 * @param array  $fields widget controls.
	 * @param object $widget Widget object.
	 *
	 * @return array
	 */
	public static function layout_fields( $fields, $widget ) {
		$new_fields['full_product_col'] = [
			'type'        => 'select2',
			'label'       => esc_html__( 'Full Height Product Column Position', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please select the full height product column position.', 'shopbuilder-pro' ),
			'options'     => [
				'left'   => esc_html__( 'Left', 'shopbuilder-pro' ),
				'center' => esc_html__( 'Center', 'shopbuilder-pro' ),
				'right'  => esc_html__( 'Right', 'shopbuilder-pro' ),
			],
			'default'     => 'left',
			'label_block' => true,
			'condition'   => [
				'layout' => [ 'grid-layout9' ],
				'cols'   => [ '3', '5' ],
			],
		];

		$new_fields['products_per_col'] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Products Per Column', 'shopbuilder-pro' ),
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 2,
					'max'  => 3,
					'step' => 1,
				],
			],
			'default'     => [
				'unit' => 'px',
				'size' => 3,
			],
			'description' => esc_html__( 'Please select the number of products per column (except full height product column).', 'shopbuilder-pro' ),
			'condition'   => [ 'layout' => [ 'grid-layout9' ] ],
		];

		$new_fields['full_product_height'] = [
			'type'        => 'slider',
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Full Height Product Image Height', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please select the full height product image height.', 'shopbuilder-pro' ),
			'size_units'  => [ 'px', '%' ],
			'range'       => [
				'px' => [
					'min'  => 1,
					'max'  => 1000,
					'step' => 1,
				],
			],
			'condition'   => [ 'layout' => [ 'grid-layout9' ] ],
			'selectors'   => [
				$widget->selectors['full_product_height'] => 'height: {{SIZE}}{{UNIT}};',
			],
		];

		return Fns::insert_controls( 'cols', $fields, $new_fields, true );
	}

	/**
	 * @param $controller
	 * @param $widget
	 *
	 * @return void
	 */
	public static function before_product_flash_sale_countdown_widget( $controller, $widget ) {
		add_filter(
			'rtsb/countdown/campaign/parent/class',
			function ( $classes ) {
				if ( ! is_array( $classes ) ) {
					return $classes;
				}
				if ( in_array( 'rtsb-vertical-position-top-left', $classes ) ) {
					$index = array_search( 'rtsb-vertical-position-top-left', $classes );
					unset( $classes[ $index ] );
				}
				if ( in_array( 'rtsb-vertical-position-top-right', $classes ) ) {
					$index = array_search( 'rtsb-vertical-position-top-right', $classes );
					unset( $classes[ $index ] );
				}
				if ( in_array( 'rtsb-countdown-vertical', $classes ) ) {
					$index = array_search( 'rtsb-countdown-vertical', $classes );
					unset( $classes[ $index ] );
				}
				$classes[] = 'rtsb-countdown-horizontal';

				return $classes;
			},
			15
		);
	}

	/**
	 * @param $controller
	 * @param $widget
	 *
	 * @return void
	 */
	public static function after_product_flash_sale_countdown_widget( $controller, $widget ) {
		remove_action(
			'rtsb/before/product/flash/sale/countdown/widget',
			[
				__CLASS__,
				'before_product_flash_sale_countdown_widget',
			],
			10
		);
	}

	/**
	 * @param $controller
	 * @param $widget
	 *
	 * @return void
	 */
	public static function before_product_cart_table_widgets( $controller, $widget ) {
		self::$controller = $controller;
		if ( ! empty( $controller['show_clear_cart_button'] ) ) {
			add_action( 'rtsb/cart/table/before/update/cart', [ __CLASS__, 'cart_table_before_update_cart' ] );
			add_action( 'woocommerce_cart_actions', [ __CLASS__, 'woocommerce_cart_actions' ] );
		}
		add_filter( 'woocommerce_cart_item_name', [ FnsPro::class, 'woocommerce_cart_item_name' ], 11, 4 );
		add_filter( 'woocommerce_cart_item_subtotal', [ __CLASS__, 'cart_table_after_subtotal' ], 15, 4 );
		add_filter( 'rtsb/module/wishlist/icon_html', [ __CLASS__, 'module_wishlist_icon_html' ], 20, 2 );
	}

	/**
	 * @param $icon_html
	 * @param $atts
	 *
	 * @return string
	 */
	public static function module_wishlist_icon_html( $icon_html, $atts ) {
		$icon_html = esc_html__( 'Save for Later', 'shopbuilder-pro' );

		return $icon_html;
	}

	/**
	 * @param $table_content
	 * @param $cart_item
	 * @param $cart_item_key
	 * @param $table
	 *
	 * @return mixed|string\
	 */
	public static function cart_table_after_subtotal( $table_content, $cart_item, $cart_item_key, $table ) {

		$product    = $cart_item['data'] ?? '';
		$product_id = $cart_item['product_id'] ?? '';
		if ( ! $product || ! $product_id ) {
			return $product;
		}
		$table_content .= '<div class="subtotal-action-button-wrapper">';
		if ( ! empty( $table['show_remove_button'] ) ) {
			$table_content .= apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				'woocommerce_cart_item_remove_link',
				sprintf(
					'<span class="product-remove rtsb-tipsy-position" data-tooltip-position="right"><a href="%s" class="tipsy" aria-label="%s" title="%s" data-product_id="%s" data-product_sku="%s">%s</a></span>',
					esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
					esc_attr__( 'Remove this item', 'shopbuilder-pro' ),
					esc_attr__( 'Remove this item', 'shopbuilder-pro' ),
					esc_attr( $product_id ),
					esc_attr( $product->get_sku() ),
					esc_attr( $table['remove_button_text'] ?? '' )
				),
				$cart_item_key
			);
		}
		if ( ! empty( $table['show_wishlist_button'] ) ) {
			ob_start();
			echo "<div class='cart-to-wishlist rtsb-tipsy-position rtsb-action-buttons' data-tooltip-position='right'>";
			do_action( 'rtsb/modules/wishlist/print_button', $product_id );
			echo '</div>';
			$table_content .= ob_get_clean();
		}
		$table_content .= '</div>';

		return $table_content;
	}

	/**
	 * @return void
	 */
	public static function cart_table_before_update_cart() {
		$button_text = ! empty( self::$controller['cart_table_clear_cart_button_text'] ) ? self::$controller['cart_table_clear_cart_button_text'] : __( 'Clear All', 'shopbuilder-pro' );
		?>
		<div class="rtsb-button-wrapper">
		<button type="button" class="button rtsb-clear-cart-items"> <?php echo esc_html( $button_text ); ?> </button>
		<?php
	}

	/**
	 * @return void
	 */
	public static function after_product_cart_table_widgets() {
		remove_action( 'rtsb/before/product/cart/table', [ __CLASS__, 'before_product_cart_table_widgets' ] );
		remove_filter( 'rtsb/module/wishlist/icon_html', [ __CLASS__, 'module_wishlist_icon_html' ], 20 );
	}

	/**
	 * Meta tags for social sharing.
	 *
	 * @return void
	 */
	public static function woocommerce_cart_actions() {

		?>
		</div> <!-- button-wrapper-->
		<?php
	}

	/**
	 * Adds additional Taxonomies to the list of available Taxonomies.
	 *
	 * @param array $tax The list of existing Taxonomies.
	 *
	 * @return array
	 */
	public static function general_layout_common_selectors( $selectors ) {
		$countdown = [
			'countdown_vertical_gap'     => '{{WRAPPER}} .rtsb-vertical-position-top-right, {{WRAPPER}} .rtsb-vertical-position-top-left,{{WRAPPER}} .rtsb-countdown-vertical.rtsb-countdown-campaign',
			'countdown_vertical_gap_top' => '{{WRAPPER}} .rtsb-vertical-position-top-right, {{WRAPPER}} .rtsb-vertical-position-top-left',
		];

		return $selectors + $countdown + ControlSelectorPro::countdown_common_selectors() + ControlSelectorPro::categories_sale_count() + ControlSelectorPro::product_stock_count_common_selectors() + ControlSelectorPro::categories_cat_link_button();
	}

	/**
	 * @param $fields
	 * @param $obj
	 *
	 * @return void
	 */
	public static function elementor_product_carttable_controls( $fields, $obj ) {
		$new_options = [
			'products' => esc_html__( 'Products', 'shopbuilder-pro' ),
		];
		$fields['cart_table']['fields']['cart_table_items']['options'] = $new_options + $fields['cart_table']['fields']['cart_table_items']['options'];

		return $fields;
	}

	/**
	 * Badge section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function elementor_general_products_countdown_controls( $fields, $obj ) {
		$condition = [
			'show_flash_sale_countdown' => 'yes',
		];

		$countdown_fields['countdown_section'] = $obj->start_section(
			esc_html__( 'Flash Sale Countdown', 'shopbuilder-pro' ),
			'settings',
			[],
			$condition
		);

		$countdown_fields['countdown_preset'] = [
			'type'        => 'rtsb-image-selector',
			'label'       => esc_html__( 'Flash Sale Countdown Appearance', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the countdown appearance.', 'shopbuilder-pro' ),
			'default'     => 'preset1',
			'separator'   => 'default',
			'options'     => [
				'preset1' => [
					'title' => esc_html__( 'Dark', 'shopbuilder-pro' ),
					'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/flash-sale-preset-1.png' ) ),
				],
				'preset2' => [
					'title' => esc_html__( 'Light', 'shopbuilder-pro' ),
					'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/flash-sale-preset-2.png' ) ),
				],
			],
		];

		$countdown_fields['countdown_layout'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Layout', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please Select Countdown Layout.', 'shopbuilder-pro' ),
			'options'     => [
				'horizontal' => esc_html__( 'Horizontal', 'shopbuilder-pro' ),
				'vertical'   => esc_html__( 'Vertical', 'shopbuilder-pro' ),
			],
			'default'     => 'horizontal',
			'label_block' => true,
		];

		$countdown_fields['countdown_vertical_position'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Vertical position', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please Select Countdown Layout.', 'shopbuilder-pro' ),
			'options'     => [
				'left'  => esc_html__( 'Top Left', 'shopbuilder-pro' ),
				'right' => esc_html__( 'Top Right', 'shopbuilder-pro' ),
			],
			'default'     => 'left',
			'label_block' => true,
			'condition'   => [
				'countdown_layout' => 'vertical',
			],
		];

		$countdown_fields['countdown_vertical_center'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Center Mode', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch In Center.', 'shopbuilder-pro' ),
			'default'     => 'yes',
			'condition'   => [
				'countdown_layout' => 'vertical',
			],
		];

		$countdown_fields['countdown_vertical_gap'] = [
			'type'        => 'slider',
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Vertical Gap / Spacing (px)', 'shopbuilder-pro' ),
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'description' => esc_html__( 'Please select the grid gap in px.', 'shopbuilder-pro' ),
			'selectors'   => [
				$obj->selectors['countdown_vertical_gap'] => '{{countdown_vertical_position.value}}: {{SIZE}}{{UNIT}}',
			],
			'condition'   => [
				'countdown_layout' => 'vertical',
			],
		];

		$countdown_fields['countdown_vertical_gap_top'] = [
			'type'        => 'slider',
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Top Gap / Spacing (px)', 'shopbuilder-pro' ),
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'description' => esc_html__( 'Please select the grid gap in px.', 'shopbuilder-pro' ),
			'selectors'   => [
				$obj->selectors['countdown_vertical_gap_top'] => 'top: {{SIZE}}{{UNIT}}',
			],
			'condition'   => [
				'countdown_layout'           => 'vertical',
				'countdown_vertical_center!' => 'yes',
			],
		];

		$countdown_fields['countdown_section_end'] = $obj->end_section();

		// Badges Sections.
		$fields = Fns::insert_controls( 'badges_section_end', $fields, $countdown_fields, true );

		$countdown_style                                       = FlashSaleCountdownSettings::settings( $obj );
		$countdown_style['counter_section_start']['tab']       = 'style';
		$countdown_style['counter_section_start']['label']     = esc_html__( 'Flash Sale Countdown', 'shopbuilder-pro' );
		$countdown_style['counter_section_start']['condition'] = [ 'show_flash_sale_countdown' => 'yes' ];

		return Fns::insert_controls( 'badges_style_section', $fields, $countdown_style, false );
	}

	/**
	 * Adds additional Taxonomies to the list of available Taxonomies.
	 *
	 * @param array $tax The list of existing Taxonomies.
	 *
	 * @return array
	 */
	public static function tax_list( $tax ) {
		return array_merge(
			$tax,
			[
				'product_brand' => esc_html__( 'Product Brand', 'shopbuilder-pro' ),
				'product_tag'   => esc_html__( 'Product Tag', 'shopbuilder-pro' ),
				'product_attr'  => esc_html__( 'Product Attributes', 'shopbuilder-pro' ),
			]
		);
	}

	/**
	 * Pagination option list
	 *
	 * @param array $options Pagination option list.
	 *
	 * @return array
	 */
	public static function pagination_pro_options( $options ) {
		return array_merge(
			$options,
			[
				'pagination_ajax' => esc_html__( 'Ajax Pagination', 'shopbuilder-pro' ),
				'load_more'       => esc_html__( 'Ajax Load More Button', 'shopbuilder-pro' ),
				'load_on_scroll'  => esc_html__( 'Ajax Load Products on Scroll', 'shopbuilder-pro' ),
			]
		);
	}

	/**
	 * Action buttons.
	 *
	 * @param string $html HTML.
	 * @param array  $args Args array.
	 *
	 * @return string
	 */
	public static function pro_formatted_buttons( $html, $args ) {

		list( $items, $ajax_cart, $preset, $position, $placement ) = $args;

		if ( 'preset5' === $preset && 'top' === $placement ) {
			$html .= '<div class="rtsb-action-buttons rtsb-action-buttons-vertical vertical-delay-effect ' . esc_attr( $preset . ' ' . $position ) . '">';
			$html .= '<ul class="rtsb-action-button-list">';
			$html .= Fns::get_action_button_by_type( $items, 'wishlist' );

			if ( 'above' === $position ) {
				$html .= Fns::get_action_button_by_type( $items, 'add_to_cart', $ajax_cart );
				$html .= Fns::get_action_button_by_type( $items, 'quick_checkout' );
				$html .= Fns::get_action_button_by_type( $items, 'compare' );
				$html .= Fns::get_action_button_by_type( $items, 'quick_view' );
			}

			$html .= '</ul>';
			$html .= '</div>';
		}

		if ( 'preset5' === $preset && 'after' === $position && 'bottom' === $placement ) {
			$html .= '<div class="rtsb-action-buttons rtsb-action-buttons-cart-box-width-auto horizontal-floating-btn after-content ' . esc_attr( $preset ) . '">';
			$html .= '<ul class="rtsb-action-button-list">';
			$html .= Fns::get_action_button_by_type( $items, 'add_to_cart', $ajax_cart );
			$html .= Fns::get_action_button_by_type( $items, 'quick_checkout' );
			$html .= Fns::get_action_button_by_type( $items, 'compare' );
			$html .= Fns::get_action_button_by_type( $items, 'quick_view' );

			$html .= '</ul>';
			$html .= '</div>';
		}

		if ( 'preset6' === $preset && 'top' === $placement ) {
			$html .= '<div class="rtsb-action-buttons top-part ' . esc_attr( $preset ) . '">';
			$html .= '<ul class="rtsb-action-button-list">';
			$html .= Fns::get_action_button_by_type( $items, 'wishlist' );
			$html .= Fns::get_action_button_by_type( $items, 'compare' );
			$html .= Fns::get_action_button_by_type( $items, 'quick_view' );
			$html .= '</ul>';
			$html .= '</div>';

			$html .= '<div class="rtsb-action-buttons bottom-part ' . esc_attr( $preset ) . '">';
			$html .= '<ul class="rtsb-action-button-list">';
			$html .= Fns::get_action_button_by_type( $items, 'add_to_cart', $ajax_cart );
			$html .= Fns::get_action_button_by_type( $items, 'quick_checkout' );
			$html .= '</ul>';
			$html .= '</div>';
		}

		return $html;
	}

	/**
	 * Meta Dataset Pro.
	 *
	 * @param array $metas Metas array.
	 * @param array $settings Settings array.
	 *
	 * @return array
	 */
	public static function meta_dataset_pro( $metas, $settings ) {
		$metas['load_more_text']      = ! empty( $settings['load_more_text'] ) ? esc_html( $settings['load_more_text'] ) : esc_html__( 'Load More', 'shopbuilder-pro' );
		$metas['show_filter']         = ! empty( $settings['tax_filter'] );
		$metas['filters']             = ! empty( self::selected_filters( $settings ) ) ? self::selected_filters( $settings ) : [];
		$metas['tax_filter']          = ! empty( $settings['filter_taxonomy'] ) ? esc_html( $settings['filter_taxonomy'] ) : '';
		$metas['ajax_filter_type']    = ! empty( $settings['ajax_filter_type'] ) ? esc_html( $settings['ajax_filter_type'] ) : 'taxonomy';
		$metas['action_term']         = ! empty( self::selected_term( $settings ) ) ? self::selected_term( $settings ) : 0;
		$metas['custom_tabs']         = ! empty( $settings['custom_tabs'] ) ? $settings['custom_tabs'] : [];
		$metas['filter_type']         = ! empty( $settings['tax_filter_type'] ) ? esc_html( $settings['tax_filter_type'] ) : '';
		$metas['term_count']          = ! empty( $settings['tax_show_count'] );
		$metas['tag_term']            = ! empty( $settings['select_tag'] ) ? $settings['select_tag'] : null;
		$metas['brand_term']          = ! empty( $settings['select_brand'] ) ? $settings['select_brand'] : null;
		$metas['quick_checkout_text'] = ! empty( $settings['show_quick_checkout_text'] );
		$metas['quick_checkout_icon'] = ! empty( $settings['quick_checkout_icon'] ) ? $settings['quick_checkout_icon'] : [];
		$metas['full_product_col']    = ! empty( $settings['full_product_col'] ) ? $settings['full_product_col'] : 'left';
		$metas['products_per_col']    = ! empty( $settings['products_per_col'] ) ? $settings['products_per_col'] : 3;

		if ( ! empty( $settings['show_quick_checkout'] ) ) {
			$metas['visibility'][] = 'quick_checkout';
		}

		// Gallery slider.
		$metas['product_slide_speed']             = ! empty( $settings['product_slide_speed'] ) ? absint( $settings['product_slide_speed'] ) : 2000;
		$metas['slider_animation']                = ! empty( $settings['slider_animation'] ) ? esc_html( $settings['slider_animation'] ) : 'slide';
		$metas['product_autoplay_timeout']        = ! empty( $settings['product_autoplay_timeout'] ) ? absint( $settings['product_autoplay_timeout'] ) : 5000;
		$metas['product_slider_left_arrow_icon']  = ! empty( $settings['product_slider_left_arrow_icon'] ) ? $settings['product_slider_left_arrow_icon'] : [];
		$metas['product_slider_right_arrow_icon'] = ! empty( $settings['product_slider_right_arrow_icon'] ) ? $settings['product_slider_right_arrow_icon'] : [];
		$metas['product_slider_loop']             = ! empty( $settings['product_slider_loop'] );
		$metas['product_slide_autoplay']          = ! empty( $settings['product_slide_autoplay'] );
		$metas['product_pause_hover']             = ! empty( $settings['product_pause_hover'] );
		$metas['show_product_nav_arrows']         = ! empty( $settings['show_product_nav_arrows'] );
		$metas['show_product_dots']               = ! empty( $settings['show_product_dots'] );

		// Raw settings.
		$metas['raw_settings']['show_product_gallery']        = ! empty( $settings['show_product_gallery'] );
		$metas['raw_settings']['show_product_gallery_thumb']  = ! empty( $settings['show_product_gallery_thumb'] );
		$metas['raw_settings']['gallery_thumb_column_number'] = ! empty( $settings['gallery_thumb_column_number']['size'] ) ? $settings['gallery_thumb_column_number']['size'] : 3;
		$metas['raw_settings']['gallery_thumb_column_gap']    = ! empty( $settings['gallery_thumb_column_gap']['size'] ) ? $settings['gallery_thumb_column_gap']['size'] : 10;
		$metas['raw_settings']['show_cart_text']              = ! empty( $metas['show_cart_text'] );
		$metas['raw_settings']['show_featured_image']         = ! empty( $settings['show_featured_image'] );
		$metas['raw_settings']['show_product_stock_count']    = ! empty( $settings['show_product_stock_count'] );
		$metas['raw_settings']['show_stock_text']             = ! empty( $settings['show_stock_text'] ) ? $settings['show_stock_text'] : 'no';
		$metas['raw_settings']['show_stock_progress']         = ! empty( $settings['show_stock_progress'] ) ? $settings['show_stock_progress'] : 'no';
		$metas['raw_settings']['product_stock_layout']        = ! empty( $settings['product_stock_layout'] ) ? $settings['product_stock_layout'] : 'layout1';
		$metas['raw_settings']['stock_text_position']         = ! empty( $settings['stock_text_position'] ) && 'bottom' === $settings['stock_text_position'] ? 'bottom' : 'top';
		$metas['raw_settings']['stock_text']                  = ! empty( $settings['stock_text'] ) ? $settings['stock_text'] : '';
		$metas['raw_settings']['layout']                      = ! empty( $settings['layout'] ) ? $settings['layout'] : '';

		// Rating settings.
		$metas['rating_preset']       = ! empty( $settings['rating_preset'] ) ? esc_html( $settings['rating_preset'] ) : 'preset1';
		$metas['show_empty_rating']   = ! empty( $settings['show_empty_rating'] );
		$metas['show_average_rating'] = ! empty( $settings['show_average_rating'] );
		$metas['show_rating_count']   = ! empty( $settings['show_rating_count'] );

		$metas['show_product_dynamic_dots']   = ! empty( $settings['show_product_dynamic_dots'] );
		$metas['gallery_thumb_column_number'] = ! empty( $settings['gallery_thumb_column_number']['size'] ) ? $settings['gallery_thumb_column_number']['size'] : 3;
		$metas['gallery_thumb_column_gap']    = ! empty( $settings['gallery_thumb_column_gap']['size'] ) ? $settings['gallery_thumb_column_gap']['size'] : 10;

		return $metas;
	}

	/**
	 * Slider Dataset Pro.
	 *
	 * @param array $options Slider options array.
	 * @param array $metas Metadata array.
	 *
	 * @return array
	 */
	public static function slider_dataset_pro( $options, $metas ) {
		if ( ! empty( $metas['raw_settings']['rows'] ) ) {
			$options['grid'] = [
				'rows' => absint( $metas['raw_settings']['rows'] ),
				'fill' => 'row',
			];
		}

		return $options;
	}

	/**
	 * Selected filters.
	 *
	 * @param array $settings Elementor settings.
	 *
	 * @return array
	 */
	private static function selected_filters( $settings ) {
		$selected = [];

		if ( ! empty( $settings['tax_filter'] ) ) {
			$selected[] = '_taxonomy_filter';
		}

		if ( ! empty( $settings['tax_search'] ) ) {
			$selected[] = '_search';
		}

		return array_map( 'sanitize_text_field', $selected );
	}

	/**
	 * Modifies the query arguments for products.
	 *
	 * @param array $args The query arguments to be modified.
	 * @param array $metas Metas array.
	 *
	 * @return array
	 */
	public static function query_args( $args, $metas ) {
		$display_by = ! empty( $metas['display_by'] ) ? $metas['display_by'] : null;
		$post_in    = ! empty( $metas['post_in'] ) ? $metas['post_in'] : [ 0 ];
		$taxQ       = [];

		if ( 'featured' === $display_by ) {
			$taxQ[] = [
				'taxonomy' => 'product_visibility',
				'field'    => 'name',
				'terms'    => 'featured',
				'operator' => 'IN',
			];
		} elseif ( 'recent' === $display_by ) {
			$args['orderby'] = 'date';
		} elseif ( 'best-selling' === $display_by ) {
			$args['meta_key'] = 'total_sales';
			$args['orderby']  = 'meta_value_num';
		} elseif ( 'sale' === $display_by ) {
			$args['post__in'] = array_merge( $post_in, wc_get_product_ids_on_sale() );
		} elseif ( 'top-rated' === $display_by ) {
			$args['meta_key'] = '_wc_average_rating';
			$args['orderby']  = 'meta_value_num';
		}

		if ( ! empty( $taxQ ) ) {
			$args['tax_query'] = ! empty( $args['tax_query'] ) ? array_merge( $args['tax_query'], $taxQ ) : $taxQ;
		}

		return $args;
	}

	/**
	 * Modifies the query arguments for products.
	 *
	 * @param array $args The query arguments to be modified.
	 * @param array $metas Metas array.
	 *
	 * @return array
	 */
	public static function wc_query_args( $args, $metas ) {
		$display_by = ! empty( $metas['display_by'] ) ? $metas['display_by'] : null;
		$post_in    = ! empty( $metas['post_in'] ) ? $metas['post_in'] : [ 0 ];

		switch ( $display_by ) {
			case 'featured':
				$args['featured'] = true;
				break;

			case 'best-selling':
				$args['meta_key'] = 'total_sales'; // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
				$args['orderby']  = 'meta_value_num';
				break;

			case 'sale':
				$args['include'] = array_merge( $post_in, wc_get_product_ids_on_sale() );
				$args['orderby'] = 'title';
				break;

			case 'top-rated':
				$args['meta_key'] = '_wc_average_rating'; // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
				$args['orderby']  = 'meta_value_num';
				break;

			case 'recently-viewed':
				$viewed_products = ! empty( $_COOKIE['rtsb_recently_viewed'] ) ? (array) explode( '|', wp_unslash( $_COOKIE['rtsb_recently_viewed'] ) ) : []; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
				$viewed_products = array_reverse( array_filter( array_map( 'absint', $viewed_products ) ) );

				$args['include'] = ! empty( $viewed_products ) ? $viewed_products : [ 0 ];
				$args['orderby'] = 'post__in';

				break;

			default:
				break;
		}

		return $args;
	}

	/**
	 * Selected term.
	 *
	 * @param array $settings Elementor settings.
	 *
	 * @return int
	 */
	private static function selected_term( $settings ) {
		$selected = 0;

		if ( ! empty( $settings['product_cat_default'] ) ) {
			$selected = $settings['product_cat_default'][0];
		}
		if ( ! empty( $settings['product_brand_default'] ) ) {
			$selected = $settings['product_brand_default'][0];
		}

		if ( ! empty( $settings['product_tag_default'] ) ) {
			$selected = $settings['product_tag_default'][0];
		}

		return absint( $selected );
	}

	/**
	 * Modifies the query arguments before loop.
	 *
	 * @param array $args The query arguments to be modified.
	 * @param array $metas Metas array.
	 *
	 * @return array
	 */
	public static function filter_query_args( $args, $metas ) {
		$taxonomy_filter  = '_taxonomy_filter';
		$tax_filter       = $metas['tax_filter'];
		$action_term      = $metas['action_term'];
		$ajax_filter_type = $metas['ajax_filter_type'];
		$custom_tabs      = $metas['custom_tabs'];
		$show_all         = ! empty( $metas['raw_settings']['tax_show_all'] );
		if ( 'special' === $ajax_filter_type && ! empty( $custom_tabs ) && ! $show_all ) {
			$display_by = $custom_tabs[0]['tab_query'] ?? '';

			switch ( $display_by ) {
				case 'featured':
					$args['featured'] = true;
					break;

				case 'best-selling':
					$args['meta_key'] = 'total_sales'; // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
					$args['orderby']  = 'meta_value_num';
					break;

				case 'sale':
					$post_in         = ! empty( $metas['post_in'] ) ? $metas['post_in'] : [ 0 ];
					$args['include'] = array_merge( $post_in, wc_get_product_ids_on_sale() );
					$args['orderby'] = 'title';
					break;

				case 'top-rated':
					$args['meta_key'] = '_wc_average_rating'; // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
					$args['orderby']  = 'meta_value_num';
					break;

				default:
					$args['orderby'] = 'date';
					break;
			}
		} else {
			if ( in_array( $taxonomy_filter, $metas['filters'], true ) && $tax_filter && $action_term ) {
				$args['product_category_id'] = null;
				$args['product_brand_id']    = null;
				$args['product_tag_id']      = null;

				if ( 'product_cat' === $tax_filter ) {
					$args['product_category_id'] = [ $action_term ];
				} elseif ( 'product_tag' === $tax_filter ) {
					$args['product_tag_id'] = [ $action_term ];
				} elseif ( 'product_brand' === $tax_filter ) {
					$args['product_brand_id'] = [ $action_term ];
				} elseif ( 'product_attr' === $tax_filter ) {
					$args['product_attribute_id'] = [ $action_term ];
				}
			}

			if ( empty( $action_term ) && ! $show_all ) {
				$taxonomy_id_key = 'product_category_id';
				$first_term_id   = $args[ $taxonomy_id_key ][0] ?? null;

				if ( 'product_tag' === $tax_filter ) {
					$taxonomy_id_key = 'product_tag_id';
				}
				if ( 'product_brand' === $tax_filter ) {
					$taxonomy_id_key = 'product_brand_id';
					$first_term_id   = $args[ $taxonomy_id_key ][0] ?? null;
				}
				if ( null !== $first_term_id ) {
					$args[ $taxonomy_id_key ] = [ $first_term_id ];
				}
			}
			if ( 'product_attr' === $tax_filter && ! $show_all ) {
				$taxonomy_id_key = 'product_attribute_id';
				$first_term_id   = $args[ $taxonomy_id_key ][0] ?? null;
				if ( null !== $first_term_id ) {
					$args[ $taxonomy_id_key ] = [ $first_term_id ];
				}
			}
		}
		return $args;
	}

	/**
	 * Modify the attributes of a row wrapper with custom ordering.
	 *
	 * @param string $row_wrapper The original HTML string of the row wrapper.
	 * @param array  $settings    The Elementor settings.
	 *
	 * @return string
	 */
	public static function row_attributes( $row_wrapper, $settings ) {
		if ( empty( $settings['content_ordering'] ) ) {
			return $row_wrapper;
		}

		$custom_ordering = $settings['content_ordering'];
		$order           = FnsPro::generate_custom_order( $custom_ordering );

		return preg_replace( '/<div(.*?)>/i', '<div$1 style="' . esc_attr( $order ) . '">', $row_wrapper );
	}

	/**
	 * Pro Style Controls.
	 *
	 * @param array  $fields Control fields.
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function style_controls( $fields, $obj ) {
		$ajax_filter_styles = StyleFields::ajax_filter_controls( $obj );
		$fields             = Fns::insert_controls( 'badges_style_section', $fields, $ajax_filter_styles, false );
		$fields             = self::quick_checkout_controls( $fields, $obj );

		return apply_filters( 'rtsb/elements/elementor/style_controls_pro', $fields, $obj );
	}

	/**
	 * Pro Share Style Controls.
	 *
	 * @param array  $fields Control fields.
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function pro_share_styles( $fields, $obj ) {
		$share_toggle = StyleFields::share_toggle( $obj );

		return Fns::insert_controls( 'share_text_style_section', $fields, $share_toggle );
	}

	/**
	 * Checkout Controls.
	 *
	 * @param array  $fields Control fields.
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function quick_checkout_controls( $fields, $obj ) {
		$quick_checkout = StyleFields::quick_checkout_styles( $obj );

		return Fns::insert_controls( 'badges_style_section', $fields, $quick_checkout );
	}

	/**
	 * Pro Visibility Controls.
	 *
	 * @param array  $fields Control fields.
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function pro_visibility_control( $fields, $obj ) {
		if ( FnsPro::is_module_active( 'flash_sale_countdown' ) ) {
			$extra_control['show_flash_sale_countdown'] = [
				'type'        => 'switch',
				'label'       => esc_html__( 'Show Sale Countdown?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show flash sale countdown.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			];

		}

		$extra_control['show_product_stock_count'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Product Stock Count', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show product stock count.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'condition'   => [
				'layout!' => [ 'grid-layout3', 'list-layout6', 'slider-layout3', 'slider-layout8' ],
			],
		];

		$fields = Fns::insert_controls( 'single_category', $fields, $extra_control, true );

		if ( FnsPro::is_module_active( 'quick_checkout' ) ) {
			$qc_control['show_quick_checkout'] = [
				'type'        => 'switch',
				'value'       => 'on',
				'label'       => esc_html__( 'Show Quick Checkout?', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Switch on to show quick checkout button.', 'shopbuilder-pro' ),
				'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
				'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			];

			$fields = FnsPro::is_module_active( 'compare' ) ? Fns::insert_controls( 'show_compare', $fields, $qc_control, true ) : Fns::insert_controls( 'show_add_to_cart', $fields, $qc_control, true );
		}

		return $fields;
	}

	/**
	 * Arg Dataset Pro.
	 *
	 * @param array $arg Product args.
	 * @param int   $post_id Product ID.
	 * @param array $meta Meta array.
	 * @param bool  $lazy_load Lazy load.
	 *
	 * @return array
	 */
	public static function pro_arg_dataset( $arg, $post_id, $meta, $lazy_load ) {
		global $product;

		if ( ! $product instanceof WC_Product && $post_id ) {
			$product = wc_get_product( $post_id );
		}

		if ( ! empty( $arg['raw_settings']['show_product_gallery'] ) ) {
			$arg['hover_img_html']             = '';
			$arg['img_args']['hover_img_html'] = '';
			$gallery_ids                       = $product->get_gallery_image_ids();

			foreach ( $gallery_ids as $gallery_id ) {
				$arg['img_html'] .= Fns::get_product_image_html(
					'product',
					$gallery_id,
					$meta['f_img_size'],
					null,
					$meta['custom_img_size'],
					$lazy_load,
					false,
					true
				);
			}

			$arg['img_args']['img_html'] = $arg['img_html'];
		}

		if ( FnsPro::is_module_active( 'quick_checkout' ) && ( ! empty( $meta['raw_settings']['show_quick_checkout'] ) ) ) {
			$arg['items'][] = 'quick_checkout';
		}

		$arg['class'] .= $meta['quick_checkout_text'] ? ' has-qc-title ' : ' no-qc-title ';

		/**
		 * Product Rating.
		 */
		$arg['rating_args'] = [
			'preset'              => $meta['rating_preset'],
			'show_empty_rating'   => $meta['show_empty_rating'],
			'show_average_rating' => $meta['show_average_rating'],
			'show_rating_count'   => $meta['show_rating_count'],
		];

		$product_has_gallery = method_exists( Fns::class, 'get_cached_gallery_ids' )
								? Fns::get_cached_gallery_ids( $product )
								: $product->get_gallery_image_ids();

		if ( $product_has_gallery ) {
			$arg['class'] .= ! empty( ( $arg['raw_settings']['show_product_gallery_thumb'] ?? '' ) ) ? ' has-product-gallery-thumb ' : '';
		}

		return $arg;
	}

	/**
	 * @return void
	 */
	public static function archive_custom_layout_rendering( $obj ) {
		self::$widget = $obj;

		remove_action( 'rtsb/shop/product/image', [ ActionHooks::CLASS, 'render_image' ] );
		add_action( 'rtsb/shop/product/image', [ __CLASS__, 'render_image' ], 10, 2 );

		add_action( 'rtsb/quick_checkout/parent/class', [ __CLASS__, 'quick_checkout_parent_classes' ], 15 );
		add_action( 'rtsb/quick_checkout/button/text', [ __CLASS__, 'quick_checkout_btn_txt' ], 15 );
		add_action( 'rtsb/quick_checkout/button/icon', [ __CLASS__, 'quick_checkout_btn_icon' ], 15 );
	}

	/**
	 * Quick Checkout Parent Classes.
	 *
	 * @param array $classes Parent Classes.
	 *
	 * @return array
	 */
	public static function quick_checkout_parent_classes( $classes ) {
		$settings = self::$widget->get_settings_for_display();
		$has_text = $settings['show_quick_checkout_text'] ?? false;
		$key      = array_search( 'button', $classes, true );

		if ( false !== $key ) {
			unset( $classes[ $key ] );
		}

		$classes[] = $has_text ? 'has-text' : 'no-text';

		return $classes;
	}

	/**
	 * Quick Checkout Button Text.
	 *
	 * @param string $button_text Button text.
	 *
	 * @return string
	 */
	public static function quick_checkout_btn_txt( $button_text ) {
		$settings = self::$widget->get_settings_for_display();
		$text     = $settings['show_quick_checkout_text'] ?? false;

		if ( ! $text ) {
			$button_text = '';
		}

		return $button_text;
	}

	/**
	 * Quick Checkout Button Icon.
	 *
	 * @return string
	 */
	public static function quick_checkout_btn_icon() {
		$settings = self::$widget->get_settings_for_display();

		return Fns::icons_manager( $settings['quick_checkout_icon'], 'icon-default' );
	}

	/**
	 * Archive Custom Layout Widget Rendering.
	 *
	 * @return void
	 */
	public static function archive_custom_layout_reset_rendering() {
		remove_action( 'rtsb/shop/product/image', [ __CLASS__, 'render_image' ], 10 );
		add_action( 'rtsb/shop/product/image', [ ActionHooks::CLASS, 'render_image' ], 10, 2 );

		remove_action( 'rtsb/quick_checkout/parent/class', [ __CLASS__, 'quick_checkout_parent_classes' ], 15 );
		remove_action( 'rtsb/quick_checkout/button/text', [ __CLASS__, 'quick_checkout_btn_txt' ], 15 );
		remove_action( 'rtsb/quick_checkout/button/icon', [ __CLASS__, 'quick_checkout_btn_icon' ], 15 );
	}

	/**
	 * Render image.
	 *
	 * @param array $args Image args.
	 * @param array $settings Settings array.
	 *
	 * @return void
	 */
	public static function render_image( $args, $settings ) {
		global $product;

		if ( ! $product instanceof WC_Product && $args['p_id'] ) {
			$product = wc_get_product( $args['p_id'] );
		}

		$gallery_ids = method_exists( Fns::class, 'get_cached_gallery_ids' )
						? Fns::get_cached_gallery_ids( $product )
						: $product->get_gallery_image_ids();

		if ( ! empty( $gallery_ids ) ) {
			array_unshift( $gallery_ids, get_post_thumbnail_id( $args['p_id'] ) );
		}

		$data = [
			'gallery_ids' => $gallery_ids,
			'settings'    => $settings,
			'args'        => $args,
		];

		if ( $gallery_ids && $settings['show_product_gallery'] ) {
			Fns::load_template( 'elementor/general/product-gallery', $data );
			if ( ! empty( $settings['show_product_gallery_thumb'] ) ) {
				Fns::load_template( 'elementor/general/product-gallery-thumb', $data );
			}
		} else {
			if ( $args['image_link'] ) {
				$aria_label = esc_attr(
				/* translators: Product Name */
					sprintf( __( 'Image link for Product: %s', 'shopbuilder-pro' ), $args['title'] )
				);
				?>
				<figure>
					<a class="woocommerce-LoopProduct-link rtsb-img-link"
					   href="<?php echo esc_url( $args['p_link'] ); ?>"
					   aria-label="<?php echo esc_attr( $aria_label ); ?>">
						<?php
						Fns::get_product_image( $args['img_html'], $args['hover_img_html'] );
						?>
					</a>
				</figure>

				<?php
			} else {
				echo '<figure class="rtsb-img-link">';
				Fns::get_product_image( $args['img_html'], $args['hover_img_html'] );
				echo '</figure>';
			}
		}
	}

	/**
	 * Gallery slider settings
	 *
	 * @param array  $fields widget controls.
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function added_rtsb_product_slider_controls( $fields, $obj ) {
		$condition = [
			'show_product_gallery' => [ 'yes' ],
			'show_featured_image'  => [ 'yes' ],
			'grid_style!'          => [ 'masonry' ],
		];

		$extra_controls['slider_settings_title'] = $obj->el_heading(
			esc_html__( 'Gallery Slider Settings', 'shopbuilder-pro' ),
			'before',
			[],
			$condition
		);

		$extra_controls['slider_animation'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Select Slide Animation', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please select the slide animation.', 'shopbuilder-pro' ),
			'options'     => [
				'slide' => esc_html__( 'Slide', 'shopbuilder-pro' ),
				'fade'  => esc_html__( 'Fade', 'shopbuilder-pro' ),
			],
			'default'     => 'slide',
			'separator'   => 'default',
			'label_block' => true,
			'condition'   => $condition,
		];

		$extra_controls['show_product_nav_arrows']        = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Navigation Arrows', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider navigation arrows.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'condition'   => $condition,
		];
		$extra_controls['inner_slider_always_show_nav']   = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Always Show Arrows', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable always showing navigation arrows.', 'shopbuilder-pro' ),
			'condition'   => [
				'show_product_gallery'    => [ 'yes' ],
				'show_featured_image'     => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
		];
		$extra_controls['product_slider_left_arrow_icon'] = [
			'label'       => esc_html__( 'Left Arrow Icon', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the slider left arrow icon.', 'shopbuilder-pro' ),
			'type'        => 'icons',
			'default'     => [
				'value'   => 'fas fa-chevron-left',
				'library' => 'fa-solid',
			],
			'condition'   => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => 'yes',
				'grid_style!'             => [ 'masonry' ],
			],
		];

		$extra_controls['product_slider_right_arrow_icon'] = [
			'label'       => esc_html__( 'Right Arrow Icon', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the slider right arrow icon.', 'shopbuilder-pro' ),
			'type'        => 'icons',
			'default'     => [
				'value'   => 'fas fa-chevron-right',
				'library' => 'fa-solid',
			],
			'condition'   => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => 'yes',
				'grid_style!'             => [ 'masonry' ],
			],
		];

		$extra_controls['show_product_dots']         = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Pagination Dots', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider pagination dots.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'condition'   => $condition,
		];
		$extra_controls['show_product_dynamic_dots'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Dynamic Pagination Dots', 'shopbuilder-pro' ),
			'description' => esc_html__( 'It will keep only few bullets visible at the same time.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'condition'   => [
				'show_product_gallery' => [ 'yes' ],
				'show_featured_image'  => [ 'yes' ],
				'show_product_dots'    => [ 'yes' ],
				'grid_style!'          => [ 'masonry' ],
			],
		];

		$extra_controls['product_slider_loop'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Infinite Loop', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider infinite loop.', 'shopbuilder-pro' ),
			'condition'   => $condition,
		];

		$extra_controls['product_slide_speed'] = [
			'type'        => 'number',
			'label'       => esc_html__( 'Slide Speed (in ms)', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please enter the duration of transition between slides (in ms).', 'shopbuilder-pro' ),
			'default'     => 2000,
			'condition'   => $condition,
		];

		$extra_controls['product_slide_autoplay'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Autoplay?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider autoplay.', 'shopbuilder-pro' ),
			'condition'   => $condition,
		];

		$extra_controls['product_pause_hover'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Pause on Mouse Hover?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable slider autoplay pause on mouse hover.', 'shopbuilder-pro' ),
			'default'     => 'yes',
			'condition'   => [
				'show_product_gallery'   => [ 'yes' ],
				'show_featured_image'    => [ 'yes' ],
				'product_slide_autoplay' => 'yes',
				'grid_style!'            => [ 'masonry' ],
			],
		];

		$extra_controls['product_autoplay_timeout'] = [
			'type'        => 'number',
			'label'       => esc_html__( 'Autoplay Delay (in ms)', 'shopbuilder-pro' ),
			'default'     => 2000,
			'description' => esc_html__( 'Please select autoplay interval delay (in ms).', 'shopbuilder-pro' ),
			'condition'   => [
				'show_product_gallery'   => [ 'yes' ],
				'show_featured_image'    => [ 'yes' ],
				'product_slide_autoplay' => 'yes',
				'grid_style!'            => [ 'masonry' ],
			],
		];

		$fields = Fns::insert_controls( 'show_product_gallery_thumb', $fields, $extra_controls, true );

		$style_controls['slider_style_title'] = $obj->el_heading(
			esc_html__( 'Slider Buttons', 'shopbuilder-pro' ),
			'before',
			[
				'relation' => 'and',
				'terms'    => [
					[
						'name'     => 'show_product_gallery',
						'operator' => '==',
						'value'    => 'yes',
					],
					[
						'relation' => 'or',
						'terms'    => [
							[
								'name'     => 'show_product_nav_arrows',
								'operator' => '==',
								'value'    => 'yes',
							],
							[
								'name'     => 'show_product_dots',
								'operator' => '==',
								'value'    => 'yes',
							],
						],
					],
				],
			],
		);

		$style_controls['nav_arrow_size'] = [
			'type'      => 'slider',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Arrow Size', 'shopbuilder-pro' ),
			'range'     => [
				'px' => [
					'min'  => 1,
					'max'  => 100,
					'step' => 1,
				],
			],
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['nav_arrow_size']['icon'] => 'font-size: {{SIZE}}{{UNIT}};',
				$obj->selectors['image']['slider_buttons']['nav_arrow_size']['svg'] => 'width: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
		];

		$style_controls['nav_arrow_width'] = [
			'type'      => 'slider',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Arrow Width', 'shopbuilder-pro' ),
			'range'     => [
				'px' => [
					'min'  => 1,
					'max'  => 100,
					'step' => 1,
				],
			],
			'condition' => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['nav_arrow_width'] => 'width: {{SIZE}}{{UNIT}};',
			],
		];

		$style_controls['nav_arrow_height'] = [
			'type'      => 'slider',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Arrow Height', 'shopbuilder-pro' ),
			'range'     => [
				'px' => [
					'min'  => 1,
					'max'  => 100,
					'step' => 1,
				],
			],
			'condition' => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['nav_arrow_height'] => 'height: {{SIZE}}{{UNIT}};',
			],
		];

		$style_controls['nav_arrow_line_height'] = [
			'type'      => 'slider',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Arrow Line Height', 'shopbuilder-pro' ),
			'range'     => [
				'px' => [
					'min'  => 1,
					'max'  => 100,
					'step' => 1,
				],
			],
			'condition' => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['nav_arrow_line_height'] => 'line-height: {{SIZE}}{{UNIT}};',
			],
		];

		$style_controls['nav_border'] = [
			'mode'       => 'group',
			'type'       => 'border',
			'selector'   => $obj->selectors['image']['slider_buttons']['nav_border'],
			'size_units' => [ 'px' ],
			'condition'  => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
		];

		$style_controls['nav_border_radius'] = [
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'size_units' => [ 'px', '%', 'em' ],
			'condition'  => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
			'selectors'  => [
				$obj->selectors['image']['slider_buttons']['nav_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];

		$style_controls['nav_color']      = [
			'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'condition' => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['nav_color'] => 'background-color: {{VALUE}}',
			],
		];
		$style_controls['nav_icon_color'] = [
			'label'     => esc_html__( 'Nav Icon Color', 'shopbuilder-pro' ),
			'type'      => 'color',
			'condition' => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['nav_icon_color'] => 'color: {{VALUE}}',
			],
		];

		$style_controls['nav_hover_color']      = [
			'label'     => esc_html__( 'Hover Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'condition' => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['nav_hover_color'] => 'background-color: {{VALUE}}',
			],
		];
		$style_controls['nav_icon_hover_color'] = [
			'label'     => esc_html__( 'Nav Icon Hover', 'shopbuilder-pro' ),
			'type'      => 'color',
			'condition' => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['nav_icon_hover_color'] => 'color: {{VALUE}}',
			],
		];

		$style_controls['nav_icon_hover_border_color'] = [
			'label'     => esc_html__( 'Nav Border Hover ', 'shopbuilder-pro' ),
			'type'      => 'color',
			'condition' => [
				'show_product_gallery'    => [ 'yes' ],
				'show_product_nav_arrows' => [ 'yes' ],
				'grid_style!'             => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['nav_border_hover_color'] => 'border-color: {{VALUE}}',
			],
		];

		$style_controls['pagi_dot_width'] = [
			'type'      => 'slider',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Dot Width', 'shopbuilder-pro' ),
			'range'     => [
				'px' => [
					'min'  => 1,
					'max'  => 100,
					'step' => 1,
				],
			],
			'separator' => 'default',
			'condition' => [
				'show_product_gallery' => [ 'yes' ],
				'show_product_dots'    => [ 'yes' ],
				'grid_style!'          => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['pagi_dot_width'] => 'width: {{SIZE}}{{UNIT}};',
			],
		];

		$style_controls['pagi_dot_height'] = [
			'type'      => 'slider',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Dot Height', 'shopbuilder-pro' ),
			'range'     => [
				'px' => [
					'min'  => 1,
					'max'  => 100,
					'step' => 1,
				],
			],
			'separator' => 'default',
			'condition' => [
				'show_product_gallery' => [ 'yes' ],
				'show_product_dots'    => [ 'yes' ],
				'grid_style!'          => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['pagi_dot_height'] => 'height: {{SIZE}}{{UNIT}};',
			],
		];

		$style_controls['pagi_dot_spacing'] = [
			'type'      => 'slider',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Dot Spacing', 'shopbuilder-pro' ),
			'range'     => [
				'px' => [
					'min'  => 1,
					'max'  => 100,
					'step' => 1,
				],
			],
			'condition' => [
				'show_product_gallery' => [ 'yes' ],
				'show_product_dots'    => [ 'yes' ],
				'grid_style!'          => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['pagi_dot_spacing'] => 'margin-left: calc({{SIZE}}{{UNIT}} / 2); margin-right: calc({{SIZE}}{{UNIT}} / 2);',
			],
		];

		$style_controls['pagi_dot_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Dot Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'condition' => [
				'show_product_gallery' => [ 'yes' ],
				'show_product_dots'    => [ 'yes' ],
				'grid_style!'          => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['pagi_dot_color'] => 'background-color: {{VALUE}};',
			],
		];

		$style_controls['pagi_dot_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Dot Active Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'condition' => [
				'show_product_gallery' => [ 'yes' ],
				'show_product_dots'    => [ 'yes' ],
				'grid_style!'          => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['slider_buttons']['pagi_dot_active_color'] => 'background-color: {{VALUE}};',
			],
		];

		$style_controls['pagi_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Dot Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'separator'  => 'default',
			'condition'  => [
				'show_product_gallery' => [ 'yes' ],
				'show_product_dots'    => [ 'yes' ],
				'grid_style!'          => [ 'masonry' ],
			],
			'selectors'  => [
				$obj->selectors['image']['slider_buttons']['pagi_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
			],
		];

		$style_controls['thumb_slider_style_title'] = $obj->el_heading(
			esc_html__( 'Thumb Slider Styles', 'shopbuilder-pro' ),
			'before',
			[],
			[
				'show_product_gallery'       => [ 'yes' ],
				'show_product_gallery_thumb' => [ 'yes' ],
				'grid_style!'                => [ 'masonry' ],
			],
		);

		$style_controls['thumb_slider_image_border']              = [
			'mode'       => 'group',
			'type'       => 'border',
			'size_units' => [ 'px' ],
			'condition'  => [
				'show_product_gallery'       => [ 'yes' ],
				'show_product_gallery_thumb' => [ 'yes' ],
				'grid_style!'                => [ 'masonry' ],
			],
			'selector'   => $obj->selectors['image']['thumbnail_images']['thumb_slider_image_border'],
		];
		$style_controls['thumb_slider_image_border_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Border Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'condition' => [
				'show_product_gallery'       => [ 'yes' ],
				'show_product_gallery_thumb' => [ 'yes' ],
				'grid_style!'                => [ 'masonry' ],
			],
			'selectors' => [
				$obj->selectors['image']['thumbnail_images']['thumb_slider_image_border_active_color'] => 'border-color: {{VALUE}};',
			],
		];

		$style_controls['thumb_slider_image_border_radius'] = [
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px' ],
			'condition'  => [
				'show_product_gallery'       => [ 'yes' ],
				'show_product_gallery_thumb' => [ 'yes' ],
				'grid_style!'                => [ 'masonry' ],
			],
			'selectors'  => [
				$obj->selectors['image']['thumbnail_images']['thumb_slider_image_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];

		$style_controls['thumb_slider_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'separator'  => 'default',
			'condition'  => [
				'show_product_gallery'       => [ 'yes' ],
				'show_product_gallery_thumb' => [ 'yes' ],
				'grid_style!'                => [ 'masonry' ],
			],
			'selectors'  => [
				$obj->selectors['image']['thumbnail_images']['thumb_slider_margin']['thumb']   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				$obj->selectors['image']['thumbnail_images']['thumb_slider_margin']['wrapper'] => '--rtsb-gallery-thumb-gap: {{TOP}}{{UNIT}};',
			],
		];
		return Fns::insert_controls( 'image_styles_margin', $fields, $style_controls, true );
	}
	/**
	 *
	 *
	 * @return array
	 */
	public static function slider_thumbnail_selectors() {
		return [
			'thumbnail_images' => [
				'thumb_slider_margin'                    => [
					'thumb'   => '{{WRAPPER}} .product-gallery-thumb',
					'wrapper' => '{{WRAPPER}} .rtsb-product',
				],
				'thumb_slider_image_border'              => '{{WRAPPER}} .product-gallery-thumb figure',
				'thumb_slider_image_border_active_color' => '{{WRAPPER}} .product-gallery-thumb .swiper-slide-thumb-active figure',
				'thumb_slider_image_border_radius'       => '{{WRAPPER}} .product-gallery-thumb .swiper-slide figure',
			],
		];
	}

	/**
	 *
	 *
	 * @return array
	 */
	public static function slider_buttons_selectors() {
		return [
			'slider_buttons' => [
				'nav_arrow_size'        => [
					'icon' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.product-gallery .swiper-arrow i',
					'svg'  => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.product-gallery .swiper-arrow svg',
				],
				'nav_arrow_width'       => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.product-gallery .swiper-arrow',
				'nav_arrow_height'      => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.product-gallery .swiper-arrow',
				'nav_arrow_line_height' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.product-gallery .swiper-arrow i',
				'pagi_dot_width'        => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.product-gallery .swiper-gallery-pagination .swiper-pagination-bullet',
				'pagi_dot_height'       => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.product-gallery .swiper-gallery-pagination .swiper-pagination-bullet',
				'pagi_dot_spacing'      => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.product-gallery .swiper-gallery-pagination .swiper-pagination-bullet',
				'pagi_dot_color'        => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.product-gallery .swiper-gallery-pagination .swiper-pagination-bullet',
				'pagi_dot_active_color' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.product-gallery .swiper-gallery-pagination .swiper-pagination-bullet-active',
				'pagi_margin'           => '{{WRAPPER}} .rtsb-elementor-container .rtsb-product-img .rtsb-gallery-slider.rtsb-gallery-slider .swiper-gallery-pagination',
			],
		];
	}

	/**
	 * @param array $selectors widget controls selectors.
	 *
	 * @return array
	 */
	public static function general_widget_control_selectors( $selectors ) {
		$selectors['rtsb-products-grid']['image']                                        = array_merge(
			$selectors['rtsb-products-grid']['image'],
			self::slider_buttons_selectors(),
			self::slider_thumbnail_selectors()
		);
		$selectors['rtsb-products-grid']['image']['border']                              = $selectors['rtsb-products-grid']['image']['border'] . ',.rtsb-elementor-container .product-gallery .image-wrapper figure';
		$selectors['rtsb-products-grid']['image']['slider_buttons']['nav_border']        = '{{WRAPPER}} .rtsb-elementor-container .rtsb-product .product-gallery .swiper-arrow';
		$selectors['rtsb-products-grid']['image']['slider_buttons']['nav_border_radius'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-grid']['image']['slider_buttons']['nav_color']         = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-grid']['image']['slider_buttons']['nav_icon_color']    = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-grid']['image']['slider_buttons']['nav_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-products-grid']['image']['slider_buttons']['nav_icon_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover i';
		$selectors['rtsb-products-grid']['image']['slider_buttons']['nav_border_hover_color'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery.rtsb-gallery-slider .swiper-arrow:hover';

		$selectors['rtsb-products-grid']['product_categories']['wrapper_margin'] .= ',{{WRAPPER}} .rtsb-elementor-container .rtsb-category-with-rating';

		$selectors['rtsb-products-grid']['advanced']['rtsb_el_element_shadow'] .= ',{{WRAPPER}} .rtsb-elementor-container .rtsb-grid-layout8 .rtsb-product';

		/*Product List Widget */
		$selectors['rtsb-products-list']['image']                                        = array_merge(
			$selectors['rtsb-products-list']['image'],
			self::slider_buttons_selectors(),
			self::slider_thumbnail_selectors()
		);
		$selectors['rtsb-products-list']['image']['border']                              = $selectors['rtsb-products-list']['image']['border'] . ',.rtsb-elementor-container .product-gallery .image-wrapper figure';
		$selectors['rtsb-products-list']['image']['slider_buttons']['nav_border']        = '{{WRAPPER}} .rtsb-elementor-container .rtsb-product .product-gallery .swiper-arrow';
		$selectors['rtsb-products-list']['image']['slider_buttons']['nav_border_radius'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-list']['image']['slider_buttons']['nav_color']         = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-list']['image']['slider_buttons']['nav_icon_color']    = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-list']['image']['slider_buttons']['nav_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-products-list']['image']['slider_buttons']['nav_icon_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-products-list']['image']['slider_buttons']['nav_border_hover_color'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery.rtsb-gallery-slider .swiper-arrow:hover';

		/*Product Slider Widget */
		$selectors['rtsb-products-slider']['image']                                        = array_merge(
			$selectors['rtsb-products-slider']['image'],
			self::slider_buttons_selectors(),
			self::slider_thumbnail_selectors()
		);
		$selectors['rtsb-products-slider']['image']['border']                              = $selectors['rtsb-products-slider']['image']['border'] . ',.rtsb-elementor-container .product-gallery .image-wrapper figure';
		$selectors['rtsb-products-slider']['image']['slider_buttons']['nav_border']        = '{{WRAPPER}} .rtsb-elementor-container .rtsb-product .product-gallery .swiper-arrow';
		$selectors['rtsb-products-slider']['image']['slider_buttons']['nav_border_radius'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-slider']['image']['slider_buttons']['nav_color']         = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-slider']['image']['slider_buttons']['nav_icon_color']    = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-slider']['image']['slider_buttons']['nav_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-products-slider']['image']['slider_buttons']['nav_icon_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-products-slider']['image']['slider_buttons']['nav_border_hover_color'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery.rtsb-gallery-slider .swiper-arrow:hover';

		$selectors['rtsb-products-slider']['advanced']['rtsb_el_element_border'] = $selectors['rtsb-products-slider']['advanced']['rtsb_el_element_border'] . ',{{WRAPPER}} .rtsb-elementor-container .rtsb-col-grid .rtsb-grid-item .product-fade-content';

		$selectors['rtsb-products-slider']['advanced']['element_border_hover_color'] .= ',{{WRAPPER}} .rtsb-elementor-container .rtsb-col-grid:hover .rtsb-grid-item .product-fade-content';

		$selectors['rtsb-products-slider']['advanced']['element_hover_bg_color'] .= ',{{WRAPPER}} .rtsb-elementor-container .rtsb-col-grid .rtsb-grid-item .product-fade-content';

		/*Product Categories Widget */

		$selectors['rtsb-product-categories-general']['category_multi_layout']['cat_height'] .= ',{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout3 .rtsb-product-img .rtsb-product-image,{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout4 .rtsb-product-img img';

		$selectors['rtsb-product-categories-general']['image']['hover_overlay'] .= ',{{WRAPPER}} .rtsb-elementor-container .rtsb-category-layout3 .category-wrapper .rtsb-product-img figure a:after';

		$selectors['rtsb-product-categories-general'] = array_merge(
			$selectors['rtsb-product-categories-general'],
			ControlSelectors::general_slider_selectors()
		);

		$selectors['rtsb-product-lookbook'] = Selectors::get_selectors();
		$selectors['rtsb-image-hotspots']   = ImageHotspotsSelectors::get_selectors();
		$selectors['rtsb-coupon-list']      = CouponListSelectors::get_selectors();
		$selectors['rtsb-hero-slider']      = HeroSliderSelectors::get_selectors();

		return $selectors;
	}

	/**
	 * @param array $selectors widget controls selectors.
	 *
	 * @return mixed
	 */
	public static function product_archive_widget_control_selectors( $selectors ) {
		/*Product Archive Custom Layout Widget */
		$selectors['rtsb-products-archive-custom']['image']                                        = array_merge(
			$selectors['rtsb-products-archive-custom']['image'],
			self::slider_buttons_selectors(),
			self::slider_thumbnail_selectors()
		);
		$selectors['rtsb-products-archive-custom']['image']['border']                              = $selectors['rtsb-products-archive-custom']['image']['border'] . ',.rtsb-elementor-container .product-gallery .image-wrapper figure';
		$selectors['rtsb-products-archive-custom']['image']['slider_buttons']['nav_border']        = '{{WRAPPER}} .rtsb-elementor-container .rtsb-product .product-gallery .swiper-arrow';
		$selectors['rtsb-products-archive-custom']['image']['slider_buttons']['nav_border_radius'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-archive-custom']['image']['slider_buttons']['nav_color']         = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-archive-custom']['image']['slider_buttons']['nav_icon_color']    = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-products-archive-custom']['image']['slider_buttons']['nav_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-products-archive-custom']['image']['slider_buttons']['nav_icon_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-products-archive-custom']['image']['slider_buttons']['nav_border_hover_color'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery.rtsb-gallery-slider .swiper-arrow:hover';

		return $selectors;
	}

	/**
	 * @param array $selectors widget controls selectors.
	 *
	 * @return mixed
	 */
	public static function product_single_widget_control_selectors( $selectors ) {
		/*Upsell Custom Layout Widget */
		$selectors['rtsb-upsells-product-custom']['image']                                        = array_merge(
			$selectors['rtsb-upsells-product-custom']['image'],
			self::slider_buttons_selectors(),
			self::slider_thumbnail_selectors()
		);
		$selectors['rtsb-upsells-product-custom']['image']['border']                              = $selectors['rtsb-upsells-product-custom']['image']['border'] . ',.rtsb-elementor-container .product-gallery .image-wrapper figure';
		$selectors['rtsb-upsells-product-custom']['image']['slider_buttons']['nav_border']        = '{{WRAPPER}} .rtsb-elementor-container .rtsb-product .product-gallery .swiper-arrow';
		$selectors['rtsb-upsells-product-custom']['image']['slider_buttons']['nav_border_radius'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-upsells-product-custom']['image']['slider_buttons']['nav_color']         = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-upsells-product-custom']['image']['slider_buttons']['nav_icon_color']    = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-upsells-product-custom']['image']['slider_buttons']['nav_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-upsells-product-custom']['image']['slider_buttons']['nav_icon_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover i';
		$selectors['rtsb-upsells-product-custom']['image']['slider_buttons']['nav_border_hover_color'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery.rtsb-gallery-slider .swiper-arrow:hover';

		/*Upsell Custom Slider Layout Widget */
		$selectors['rtsb-upsells-product-slider']['image']                                        = array_merge(
			$selectors['rtsb-upsells-product-slider']['image'],
			self::slider_buttons_selectors(),
			self::slider_thumbnail_selectors()
		);
		$selectors['rtsb-upsells-product-slider']['image']['border']                              = $selectors['rtsb-upsells-product-slider']['image']['border'] . ',.rtsb-elementor-container .product-gallery .image-wrapper figure';
		$selectors['rtsb-upsells-product-slider']['image']['slider_buttons']['nav_border']        = '{{WRAPPER}} .rtsb-elementor-container .rtsb-product .product-gallery .swiper-arrow';
		$selectors['rtsb-upsells-product-slider']['image']['slider_buttons']['nav_border_radius'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-upsells-product-slider']['image']['slider_buttons']['nav_color']         = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-upsells-product-slider']['image']['slider_buttons']['nav_icon_color']    = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-upsells-product-slider']['image']['slider_buttons']['nav_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-upsells-product-slider']['image']['slider_buttons']['nav_icon_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-upsells-product-slider']['image']['slider_buttons']['nav_border_hover_color'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery.rtsb-gallery-slider .swiper-arrow:hover';

		/*Related Custom  Layout Widget */
		$selectors['rtsb-related-product-custom']['image']                                        = array_merge(
			$selectors['rtsb-related-product-custom']['image'],
			self::slider_buttons_selectors(),
			self::slider_thumbnail_selectors()
		);
		$selectors['rtsb-related-product-custom']['image']['border']                              = $selectors['rtsb-related-product-custom']['image']['border'] . ',.rtsb-elementor-container .product-gallery .image-wrapper figure';
		$selectors['rtsb-related-product-custom']['image']['slider_buttons']['nav_border']        = '{{WRAPPER}} .rtsb-elementor-container .rtsb-product .product-gallery .swiper-arrow';
		$selectors['rtsb-related-product-custom']['image']['slider_buttons']['nav_border_radius'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-related-product-custom']['image']['slider_buttons']['nav_color']         = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-related-product-custom']['image']['slider_buttons']['nav_icon_color']    = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-related-product-custom']['image']['slider_buttons']['nav_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-related-product-custom']['image']['slider_buttons']['nav_icon_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover i';
		$selectors['rtsb-related-product-custom']['image']['slider_buttons']['nav_border_hover_color'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery.rtsb-gallery-slider .swiper-arrow:hover';

		/*Related Custom Slider Layout Widget */
		$selectors['rtsb-related-products-slider']['image']                                        = array_merge(
			$selectors['rtsb-related-products-slider']['image'],
			self::slider_buttons_selectors(),
			self::slider_thumbnail_selectors()
		);
		$selectors['rtsb-related-products-slider']['image']['border']                              = $selectors['rtsb-related-products-slider']['image']['border'] . ',.rtsb-elementor-container .product-gallery .image-wrapper figure';
		$selectors['rtsb-related-products-slider']['image']['slider_buttons']['nav_border']        = '{{WRAPPER}} .rtsb-elementor-container .rtsb-product .product-gallery .swiper-arrow';
		$selectors['rtsb-related-products-slider']['image']['slider_buttons']['nav_border_radius'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-related-products-slider']['image']['slider_buttons']['nav_color']         = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-related-products-slider']['image']['slider_buttons']['nav_icon_color']    = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-related-products-slider']['image']['slider_buttons']['nav_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-related-products-slider']['image']['slider_buttons']['nav_icon_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-related-products-slider']['image']['slider_buttons']['nav_border_hover_color'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery.rtsb-gallery-slider .swiper-arrow:hover';

		/*Product Tab Widget */
		$selectors['rtsb-product-tabs']['accordion_title_typography']        = '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title';
		$selectors['rtsb-product-tabs']['accordion_title_color']             = '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title';
		$selectors['rtsb-product-tabs']['accordion_title_icon_color']        = '#rtsb-builder-content {{WRAPPER}} .rtsb-tab-accordion-item .rtsb-accordion-title:after';
		$selectors['rtsb-product-tabs']['accordion_title_bg_color']          = '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title';
		$selectors['rtsb-product-tabs']['accordion_title_active_color']      = '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title.active';
		$selectors['rtsb-product-tabs']['accordion_title_icon_active_color'] = '#rtsb-builder-content {{WRAPPER}} .rtsb-tab-accordion-item .rtsb-accordion-title.active:after';
		$selectors['rtsb-product-tabs']['accordion_title_active_bg_color']   = '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title.active';
		$selectors['rtsb-product-tabs']['accordion_title_padding']           = '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title';
		$selectors['rtsb-product-tabs']['accordion_title_border_radius']     = '#rtsb-builder-content {{WRAPPER}} .rtsb-accordion-title';
		$selectors['rtsb-product-tabs']['show_title']                        = $selectors['rtsb-product-tabs']['show_title'] . ',#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content > h2';
		$selectors['rtsb-product-tabs']['content_padding']                  .= ',#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content';
		$selectors['rtsb-product-tabs']['tab_title_typography']              = $selectors['rtsb-product-tabs']['tab_title_typography'] . ',#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content > h2';
		$selectors['rtsb-product-tabs']['additional_info_typography']        = $selectors['rtsb-product-tabs']['additional_info_typography'] . ',#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content .shop_attributes';
		$selectors['rtsb-product-tabs']['tab_title_gap']                    .= ',#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content > h2';
		$selectors['rtsb-product-tabs']['tab_content_title_color']          .= ',#rtsb-builder-content {{WRAPPER}} .rtsb-product-accordion-content > h2';
		$selectors['rtsb-product-tabs']['accordion_border_radius']           = '#rtsb-builder-content {{WRAPPER}} .rtsb-tab-accordion-item,#rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs.tabs-custom-layout2 .wc-tabs-wrapper';
		$selectors['rtsb-product-tabs']['nav_border']                        = $selectors['rtsb-product-tabs']['nav_border'] . ',#rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs.tabs-custom-layout2 ul.wc-tabs li a';
		$selectors['rtsb-product-tabs']['nav_border_radius']                 = '#rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs.tabs-custom-layout2 ul.wc-tabs li a';
		$selectors['rtsb-product-tabs']['nav_active_border_color']          .= ',#rtsb-builder-content {{WRAPPER}} .rtsb-product-tabs.tabs-custom-layout2 ul.wc-tabs li.active a';

		// Badges.
		/*
		 * TODO:: Remove After Final Test.
		 $selectors['rtsb-product-onsale']['badges_module'] = [
			 'direction' => '{{WRAPPER}} .rtsb-promotion .rtsb-badge-group-style',
			 'alignment' => '{{WRAPPER}} .rtsb-promotion .rtsb-badge-group-style',
		 ];
		 */

		return $selectors;
	}

	/**
	 * @param array $selectors widget controls selectors.
	 *
	 * @return mixed
	 */
	public static function cart_widget_control_selectors( $selectors ) {
		/*Crossell Custom Layout Widget */
		$selectors['rtsb-cross-sell-product-custom']['image']                                        = array_merge(
			$selectors['rtsb-cross-sell-product-custom']['image'],
			self::slider_buttons_selectors(),
			self::slider_thumbnail_selectors()
		);
		$selectors['rtsb-cross-sell-product-custom']['image']['border']                              = $selectors['rtsb-cross-sell-product-custom']['image']['border'] . ',.rtsb-elementor-container .product-gallery .image-wrapper figure';
		$selectors['rtsb-cross-sell-product-custom']['image']['slider_buttons']['nav_border']        = '{{WRAPPER}} .rtsb-elementor-container .rtsb-product .product-gallery .swiper-arrow';
		$selectors['rtsb-cross-sell-product-custom']['image']['slider_buttons']['nav_border_radius'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-cross-sell-product-custom']['image']['slider_buttons']['nav_color']         = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-cross-sell-product-custom']['image']['slider_buttons']['nav_icon_color']    = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-cross-sell-product-custom']['image']['slider_buttons']['nav_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-cross-sell-product-custom']['image']['slider_buttons']['nav_icon_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover i';
		$selectors['rtsb-cross-sell-product-custom']['image']['slider_buttons']['nav_border_hover_color'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery.rtsb-gallery-slider .swiper-arrow:hover';

		/*Crossell Custom Slider Layout Widget */
		$selectors['rtsb-crosssell-product-slider']['image']                                        = array_merge(
			$selectors['rtsb-crosssell-product-slider']['image'],
			self::slider_buttons_selectors(),
			self::slider_thumbnail_selectors()
		);
		$selectors['rtsb-crosssell-product-slider']['image']['border']                              = $selectors['rtsb-crosssell-product-slider']['image']['border'] . ',.rtsb-elementor-container .product-gallery .image-wrapper figure';
		$selectors['rtsb-crosssell-product-slider']['image']['slider_buttons']['nav_border']        = '{{WRAPPER}} .rtsb-elementor-container .rtsb-product .product-gallery .swiper-arrow';
		$selectors['rtsb-crosssell-product-slider']['image']['slider_buttons']['nav_border_radius'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-crosssell-product-slider']['image']['slider_buttons']['nav_color']         = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-crosssell-product-slider']['image']['slider_buttons']['nav_icon_color']    = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow';
		$selectors['rtsb-crosssell-product-slider']['image']['slider_buttons']['nav_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-crosssell-product-slider']['image']['slider_buttons']['nav_icon_hover_color']   = '{{WRAPPER}} .rtsb-elementor-container .product-gallery .swiper-arrow:hover';
		$selectors['rtsb-crosssell-product-slider']['image']['slider_buttons']['nav_border_hover_color'] = '{{WRAPPER}} .rtsb-elementor-container .product-gallery.rtsb-gallery-slider .swiper-arrow:hover';

		return $selectors;
	}

	/**
	 * Product Grid settings
	 *
	 * @param array $fields widget controls.
	 *
	 * @return array
	 */
	public static function product_grid_widget_controls( $fields ) {
		$fields['action_btn_preset']['condition']['layout!']            = [
			'slider-layout3',
			'slider-layout4',
			'slider-layout5',
			'slider-layout6',
			'slider-layout7',
			'slider-layout8',
			'slider-layout9',
			'grid-layout3',
			'grid-layout4',
			'grid-layout5',
			'grid-layout6',
			'grid-layout7',
			'grid-layout8',
			'grid-layout9',
		];
		$fields['action_btn_position']['condition']['layout!']          = [
			'slider-layout3',
			'slider-layout4',
			'slider-layout5',
			'slider-layout6',
			'slider-layout7',
			'slider-layout8',
			'slider-layout9',
			'grid-layout2',
			'grid-layout3',
			'slider-layout2',
			'grid-layout4',
			'grid-layout5',
			'grid-layout6',
			'grid-layout7',
			'grid-layout8',
		];
		$fields['product_categories_alignment']['condition']['layout!'] = [
			'grid-layout8',
			'slider-layout9',
		];
		$fields['product_rating_alignment']['condition']['layout!']     = [
			'grid-layout8',
			'slider-layout9',
		];

		return $fields;
	}

	/**
	 * Product List settings
	 *
	 * @param array $fields widget controls.
	 *
	 * @return array
	 */
	public static function product_list_widget_controls( $fields, $obj ) {

		$fields['product_categories_alignment']['condition'] = [
			'layout!' => [ 'list-layout6', 'slider-layout8' ],
		];

		return $fields;
	}

	/**
	 * Product Tab settings
	 *
	 * @param array $settings widget controls.
	 *
	 * @return array
	 */
	public static function rtsb_product_tabs_render( $settings ) {
		if ( 'custom-layout1' === $settings['controllers']['layout_style'] ) {
			$settings['template'] = 'elementor/single-product/product-tabs-custom';
		}
		// elseif ( 'custom-layout2' === $settings['controllers']['layout_style'] ) {
		// $settings['template'] = 'elementor/single-product/product-tabs/custom-layout-2';
		// }
		return $settings;
	}

	/**
	 * Product Tab settings
	 *
	 * @param array $fields widget controls.
	 *
	 * @return array
	 */
	public static function rtsb_product_tabs_widget_controls( $fields, $obj ) {
		$extra_controls['accordion_title_style']      = [
			'mode'      => 'section_start',
			'tab'       => 'style',
			'label'     => esc_html__( 'Accordion Title', 'shopbuilder-pro' ),
			'condition' => [
				'layout_style' => [ 'custom-layout1' ],
			],
		];
		$extra_controls['accordion_title_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
			'selector' => $obj->selectors['accordion_title_typography'],
		];
		$extra_controls['accordion_title_tabs_start'] = [
			'mode' => 'tabs_start',
		];
		// Accordion For normal view.
		$extra_controls['title_normal']               = [
			'mode'  => 'tab_start',
			'label' => esc_html__( 'Normal', 'shopbuilder-pro' ),
		];
		$extra_controls['accordion_title_color']      = [
			'label'     => esc_html__( 'Title', 'shopbuilder-pro' ),
			'type'      => 'color',
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['accordion_title_color'] => 'color: {{VALUE}}',
			],
		];
		$extra_controls['accordion_title_icon_color'] = [
			'label'     => esc_html__( 'Icon', 'shopbuilder-pro' ),
			'type'      => 'color',
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['accordion_title_icon_color'] => 'background-color: {{VALUE}}',
			],
		];
		$extra_controls['accordion_title_bg_color']   = [
			'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['accordion_title_bg_color'] => 'background-color: {{VALUE}}',
			],
		];
		$extra_controls['title_normal_end']           = [
			'mode' => 'tab_end',
		];
		// Accordion For Active view.
		$extra_controls['accordion_title_active']            = [
			'mode'  => 'tab_start',
			'label' => esc_html__( 'Active', 'shopbuilder-pro' ),
		];
		$extra_controls['accordion_title_active_color']      = [
			'label'     => esc_html__( 'Title', 'shopbuilder-pro' ),
			'type'      => 'color',
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['accordion_title_active_color'] => 'color: {{VALUE}}',
			],
		];
		$extra_controls['accordion_title_icon_active_color'] = [
			'label'     => esc_html__( 'Icon', 'shopbuilder-pro' ),
			'type'      => 'color',
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['accordion_title_icon_active_color'] => 'background-color: {{VALUE}}',
			],
		];
		$extra_controls['accordion_title_active_bg_color']   = [
			'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['accordion_title_active_bg_color'] => 'background-color: {{VALUE}}',
			],
		];
		$extra_controls['accordion_title_active_end']        = [
			'mode' => 'tab_end',
		];
		$extra_controls['accordion_title_tabs_end']          = [
			'mode' => 'tabs_end',
		];
		$extra_controls['accordion_title_padding']           = [
			'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px' ],
			'selectors'  => [
				$obj->selectors['accordion_title_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];
		$extra_controls['accordion_title_border_radius']     = [
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px' ],
			'selectors'  => [
				$obj->selectors['accordion_title_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];
		$extra_controls['accordion_title_style_end']         = [
			'mode' => 'section_end',
		];
		$fields = Fns::insert_controls( 'tab_content_style', $fields, $extra_controls, false );

		$extra_controls2['accordion_border_radius'] = [
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px' ],
			'selectors'  => [
				$obj->selectors['accordion_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
			'condition'  => [
				'layout_style!' => [ 'default' ],
			],
		];

		$fields = Fns::insert_controls( 'tab_content_title_color', $fields, $extra_controls2, true );

		$extra_controls3['nav_border_radius'] = [
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px' ],
			'selectors'  => [
				$obj->selectors['nav_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
			'condition'  => [
				'layout_style' => [ 'custom-layout2' ],
			],
		];

		return Fns::insert_controls( 'nav_border', $fields, $extra_controls3, true );
	}

	/**
	 * Product rating settings
	 *
	 * @param array  $fields widget controls.
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function rating_settings( $fields, $obj ) {
		$condition = [
			'show_rating' => 'yes',
		];

		$rating_fields['rating_section'] = $obj->start_section(
			esc_html__( 'Product Rating', 'shopbuilder-pro' ),
			'settings',
			[],
			$condition
		);

		$rating_fields['rating_preset'] = [
			'type'        => 'rtsb-image-selector',
			'label'       => esc_html__( 'Rating Appearance', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the rating appearance.', 'shopbuilder-pro' ),
			'default'     => 'preset1',
			'separator'   => 'default',
			'options'     => [
				'preset1' => [
					'title' => esc_html__( 'Preset 1', 'shopbuilder-pro' ),
					'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/rating-preset-1.png' ) ),
				],
				'preset2' => [
					'title' => esc_html__( 'Preset 2', 'shopbuilder-pro' ),
					'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/rating-preset-2.png' ) ),
				],
			],
		];

		$rating_fields['show_empty_rating'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Empty Rating?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show empty rating.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
		];

		$rating_fields['show_average_rating'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Average Rating?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show average rating.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$rating_fields['show_rating_count'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Review Count?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show review count.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
		];

		$rating_fields['rating_section_end'] = $obj->end_section();

		$fields = Fns::insert_controls( 'product_excerpt_section_end', $fields, $rating_fields, true );

		$rating_fields['rating_style_bg'] = [
			'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
			'type'      => 'color',
			'condition' => [ 'rating_preset' => [ 'preset2' ] ],
			'selectors' => [
				$obj->selectors['product_rating']['rating_bg'] => 'background-color: {{VALUE}}',
			],
		];

		$fields = Fns::insert_controls( 'product_rating_color', $fields, $rating_fields, true );

		$rating_fields['rating_border_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Star Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'condition'  => [ 'rating_preset' => [ 'preset2' ] ],
			'selectors'  => [
				$obj->selectors['product_rating']['star_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];

		$fields = Fns::insert_controls( 'product_rating_bg_color', $fields, $rating_fields, true );

		$rating_fields['product_rating_star_padding'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Star Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'condition'  => [ 'rating_preset' => [ 'preset2' ] ],
			'selectors'  => [
				$obj->selectors['product_rating']['star_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];

		return Fns::insert_controls( 'product_rating_padding', $fields, $rating_fields, true );
	}

	/**
	 * Product Category settings
	 *
	 * @param array  $fields widget controls.
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function elementor_product_category_controls( $fields, $obj ) {

		$new_fields['show_sale_items_count'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Sale Items Count?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show sale items count.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'default'     => 'yes',
			'condition'   => [
				'layout' => [ 'category-layout3', 'category-single-layout2' ],
			],
		];

		$fields = Fns::insert_controls( 'show_count', $fields, $new_fields, true );

		$slider_fields                                        = FreeSettingsFields::slider_settings( $obj );
		$slider_fields['slider_control_section']['condition'] = [
			'active_cat_slider' => 'yes',
		];
		$fields = Fns::insert_controls( 'category_title_section', $fields, $slider_fields );

		$fields['before_count']['condition']['layout!']         = [ 'category-layout3', 'category-single-layout2' ];
		$fields['count_display_type']['condition']['layout!'][] = 'category-layout3';
		$fields['count_display_type']['condition']['layout!'][] = 'category-layout4';
		$fields['count_display_type']['condition']['layout!'][] = 'category-single-layout2';

		$fields['excerpt_position']['condition']['layout!'][] = 'category-layout3';
		$fields['excerpt_position']['condition']['layout!'][] = 'category-layout4';
		$fields['excerpt_position']['condition']['layout!'][] = 'category-single-layout2';

		if ( 'rtsb-product-categories-general' === $obj->rtsb_base ) {
			$fields['grid_alignment']['condition']['layout!'][] = 'category-layout3';
		}
		if ( 'rtsb-products-single-category' === $obj->rtsb_base ) {
			$fields['cat_alignment']['condition']['layout!'][] = 'category-single-layout2';
		}
		$fields['product_count_alignment']['condition']['layout!'][]    = 'category-layout3';
		$fields['product_count_alignment']['condition']['layout!'][]    = 'category-layout4';
		$fields['product_count_alignment']['condition']['layout!'][]    = 'category-single-layout2';
		$fields['show_overlay']['condition']['layout'][]                = 'category-layout3';
		$fields['show_overlay']['condition']['layout'][]                = 'category-layout4';
		$fields['show_overlay']['condition']['layout'][]                = 'category-single-layout2';
		$fields['rtsb_el_image_styles_overlay']['condition']['layout!'] = [ 'category-layout3', 'category-single-layout2', 'category-layout4' ];
		$condition = [
			'show_sale_items_count' => 'yes',
			'layout'                => [ 'category-layout3', 'category-single-layout2' ],
		];

		$sale_count_fields['sale_count_section'] = $obj->start_section(
			esc_html__( 'Product Sale Count', 'shopbuilder-pro' ),
			'settings',
			[],
			$condition
		);

		$sale_count_fields['sale_count_text'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Sale Count Text', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please enter the text to show sale count text.', 'shopbuilder-pro' ),
			'default'     => esc_html__( 'Sale Items', 'shopbuilder-pro' ),
			'condition'   => $condition,
		];

		$sale_count_fields['sale_count_section_end'] = $obj->end_section();

		$fields = Fns::insert_controls( 'count_section_end', $fields, $sale_count_fields, true );

		$fields['count_text_style_section'] = [
			'mode'      => 'section_start',
			'tab'       => 'style',
			'label'     => esc_html__( 'Count Text', 'shopbuilder-pro' ),
			'condition' => [
				'layout' => [ 'category-layout3', 'category-single-layout2' ],
			],
		];
		$fields['count_text_typography']    = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
			'selector' => $obj->selectors['category_sale_count_text']['count_text_typography'],
		];
		$fields['count_text_tabs_start']    = [
			'mode' => 'tabs_start',
		];
		// Count Text For normal view.
		$fields['title_normal']     = [
			'mode'  => 'tab_start',
			'label' => esc_html__( 'Normal', 'shopbuilder-pro' ),
		];
		$fields['count_text_color'] = [
			'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
			'type'      => 'color',
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['category_sale_count_text']['count_text_color'] => 'color: {{VALUE}}',
			],
		];

		$fields['count_text_bg_color'] = [
			'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['category_sale_count_text']['count_text_bg_color'] => 'background-color: {{VALUE}}',
			],
		];
		$fields['title_normal_end']    = [
			'mode' => 'tab_end',
		];
		// Count For Active view.
		$fields['count_text_hover']       = [
			'mode'  => 'tab_start',
			'label' => esc_html__( 'Hover', 'shopbuilder-pro' ),
		];
		$fields['count_text_hover_color'] = [
			'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
			'type'      => 'color',
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['category_sale_count_text']['count_text_hover_color'] => 'color: {{VALUE}}',
			],
		];

		$fields['count_text_hover_bg_color']    = [
			'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'separator' => 'default',
			'selectors' => [
				$obj->selectors['category_sale_count_text']['count_text_hover_bg_color'] => 'background-color: {{VALUE}}',
			],
		];
		$fields['count_text_hover_end']         = [
			'mode' => 'tab_end',
		];
		$fields['count_text_tabs_end']          = [
			'mode' => 'tabs_end',
		];
		$fields['count_text_style_section_end'] = [
			'mode' => 'section_end',
		];
		if ( 'rtsb-product-categories-general' === $obj->rtsb_base ) {
			$slider_btn_settings = StyleFieldsFree::slider_buttons( $obj );

			$slider_btn_settings['slider_buttons_style_section']['condition'] = [
				'active_cat_slider' => 'yes',
			];

			$fields = Fns::insert_controls( 'count_text_style_section', $fields, $slider_btn_settings );

			$button_fields['cat_link_btn_style_section']     = [
				'mode'      => 'section_start',
				'tab'       => 'style',
				'label'     => esc_html__( 'Category Link Button', 'shopbuilder-pro' ),
				'condition' => [
					'layout' => [ 'category-layout4' ],
				],
			];
			$button_fields['cat_link_icon_color']            = [
				'label'     => esc_html__( 'Icon Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$obj->selectors['category_cat_link_button']['cat_link_icon_color'] => 'fill: {{VALUE}}',
				],
			];
			$button_fields['cat_link_bg_color']              = [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$obj->selectors['category_cat_link_button']['cat_link_bg_color']['bg']     => 'background: {{VALUE}}',
					$obj->selectors['category_cat_link_button']['cat_link_bg_color']['shadow'] => '--rtsb-category-layout4-shadow: {{VALUE}}',
				],
			];
			$button_fields['cat_link_icon_hover_color']      = [
				'label'     => esc_html__( 'Hover Icon Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$obj->selectors['category_cat_link_button']['cat_link_icon_hover_color'] => 'fill: {{VALUE}}',
				],
			];
			$button_fields['cat_link_bg_hover_color']        = [
				'label'     => esc_html__( 'Hover Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$obj->selectors['category_cat_link_button']['cat_link_bg_hover_color']['bg'] => 'background: {{VALUE}}',
					$obj->selectors['category_cat_link_button']['cat_link_bg_hover_color']['shadow'] => '--rtsb-category-layout4-shadow: {{VALUE}}',
				],
			];
			$button_fields['cat_link_btn_style_section_end'] = [
				'mode' => 'section_end',
			];
			$fields = Fns::insert_controls( 'category_description_style_section_end', $fields, $button_fields, true );
		}

		$repeater_fields['repeater_fields_note'] = [
			'type'            => 'html',
			'raw'             => '<h3 class="rtsb-elementor-group-heading">' . esc_html__( 'Add Custom Image', 'shopbuilder-pro' ) . '</h3>',
			'separator'       => 'before',
			'content_classes' => 'elementor-panel-heading-title',
			'condition'       => [
				'show_custom_image' => 'yes',
				'layout!'           => [ 'category-single-layout1', 'category-single-layout2' ],
			],
		];

		$repeater_fields['category_custom_images_fields'] = [
			'type'      => 'repeater',
			'label'     => esc_html__( 'Select categories and add custom image.', 'shopbuilder-pro' ),
			'mode'      => 'repeater',
			'separator' => 'after',
			'fields'    => [
				'category_item_id'      => [
					'label'       => esc_html__( 'Category Name', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Please choose the category name.', 'shopbuilder-pro' ),
					'type'        => 'rt-select2',
					'separator'   => 'default',
					'source_name' => 'taxonomy',
					'source_type' => 'product_cat',
					'multiple'    => false,
				],
				'category_custom_image' => [
					'type'        => 'media',
					'label'       => esc_html__( 'Upload Custom Image', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Please choose the custom category image. It will override the default image.', 'shopbuilder-pro' ),
					'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
					'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
					'default'     => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
				],
			],
			'condition' => [
				'show_custom_image' => 'yes',
				'layout!'           => [ 'category-single-layout1', 'category-single-layout2' ],
			],
		];

		return Fns::insert_controls( 'show_custom_image', $fields, $repeater_fields, true );
	}

	/**
	 * Category Custom Image
	 *
	 * @param array $meta Meta data array.
	 * @param int   $id Category ID.
	 *
	 * @return void
	 */
	public static function cat_custom_image_id( $meta, $id ) {
		$category_data = ! empty( $meta['raw_settings']['category_custom_images_fields'] ) ? $meta['raw_settings']['category_custom_images_fields'] : [];

		if ( empty( $category_data ) ) {
			return;
		}

		foreach ( $category_data as $data ) {
			if ( absint( $data['category_item_id'] ) === $id ) {
				echo ! empty( $data['category_custom_image']['id'] ) ? $data['category_custom_image']['id'] : null;
			}
		}
	}

	/**
	 * Badges Module Controls.
	 *
	 * @param array  $fields Control fields.
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	/*
	 * TODO:: Remove After final Text Later.
	public static function badges_module_controls( $fields, $obj ) {
		$extra_control['enable_badges_module'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Badges Module?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to integrate Badge module.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'condition'   => [ 'layout!' => [ 'category-single-layout1', 'category-single-layout2', 'category-layout1', 'category-layout2', 'category-layout3' ] ],
		];

		$extra_control['badges_module_notice'] = [
			'type'      => 'html',
			'raw'       => sprintf(
				'<span style="display: block; background: #fffbf1; padding: 10px; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a30;">%s</span>',
				__( '<b>Note:</b> Badges Module needs to be enabled in the <a href="' . esc_url( admin_url() ) . 'admin.php?page=rtsb-settings' . '" target="_blank">ShopBuilder Modules Settings</a>. From there you can create and customize diferrent badges.', 'shopbuilder-pro' )
			),
			'separator' => 'default',
			'condition' => [ 'enable_badges_module' => [ 'yes' ] ],
		];

		$extra_control['badges_module_direction'] = [
			'type'        => 'select',
			'options'     => [
				'row'    => esc_html__( 'Horizontal', 'shopbuilder-pro' ),
				'column' => esc_html__( 'Vertical', 'shopbuilder-pro' ),
			],
			'label'       => esc_html__( 'Group Badge Direction', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the group badge direction.', 'shopbuilder-pro' ),
			'condition'   => [ 'enable_badges_module' => [ 'yes' ] ],
			'default'     => 'row',
			'label_block' => true,
			'selectors'   => [
				$obj->selectors['badges_module']['direction'] => 'flex-direction: {{VALUE}} !important;',
			],
		];

		$extra_control['badges_module_alignment'] = [
			'type'        => 'choose',
			'options'     => [
				'start'  => [
					'title' => esc_html__( 'Left', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-center',
				],
				'end'    => [
					'title' => esc_html__( 'Right', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-right',
				],
			],
			'label'       => esc_html__( 'Group Badge Alignment', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the group badge alignment.', 'shopbuilder-pro' ),
			'condition'   => [ 'enable_badges_module' => [ 'yes' ] ],
			'default'     => 'start',
			'label_block' => true,
			'selectors'   => [
				$obj->selectors['badges_module']['alignment'] => 'align-items: {{VALUE}} !important;',
			],
		];

		 $fields['custom_badge_preset']['condition']                        = [ 'enable_badges_module!' => [ 'yes' ] ];
		$fields['sale_badges_type']['condition']['enable_badges_module!']  = [ 'yes' ];
		$fields['sale_badges_text']['condition']['enable_badges_module!']  = [ 'yes' ];
		$fields['stock_badges_text']['condition']['enable_badges_module!'] = [ 'yes' ];
		$fields['custom_badge_text']['condition']['enable_badges_module!'] = [ 'yes' ];

		return Fns::insert_controls( 'custom_badge_preset', $fields, $extra_control );

	}
	*/
	public static function elementor_general_products_stock_count_controls( $fields, $obj ) {
		$condition = [
			'show_product_stock_count' => 'yes',
		];

		$stock_count_fields['product_stock_section'] = $obj->start_section(
			esc_html__( 'Product Stock Count', 'shopbuilder-pro' ),
			'settings',
			[],
			$condition
		);
		$stock_count_fields['product_stock_layout']  = [
			'label'     => esc_html__( 'Layout', 'shopbuilder-pro' ),
			'type'      => 'rtsb-image-selector',
			'options'   => FnsPro::product_stock_count_layouts(),
			'default'   => 'layout1',
			'separator' => 'default',
		];
		$stock_count_fields['show_stock_text']       = [
			'label'       => esc_html__( 'Show Stock Text?', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'description' => esc_html__( 'Switch on to show stock count text.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'default'     => 'yes',
		];
		$stock_count_fields['show_stock_progress']   = [
			'label'       => esc_html__( 'Show Stock Progress?', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'description' => esc_html__( 'Switch on to show stock progress bar.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'default'     => 'yes',
		];
		$stock_count_fields['stock_text_position']   = [
			'type'        => 'select2',
			'label'       => esc_html__( 'Stock Text Position', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please select the stock text position.', 'shopbuilder-pro' ),
			'options'     => [
				'top'    => esc_html__( 'Top', 'shopbuilder-pro' ),
				'bottom' => esc_html__( 'Bottom', 'shopbuilder-pro' ),
			],
			'default'     => 'top',
			'label_block' => true,
			'condition'   => [
				'show_stock_text' => 'yes',
			],

		];
		$stock_count_fields['stock_text'] = [
			'label'       => esc_html__( 'Stock Text', 'shopbuilder-pro' ),
			'type'        => 'textarea',
			'label_block' => true,
			'default'     => __( 'Only {count} item(s) left in stock.', 'shopbuilder-pro' ),
			'description' => __( 'Please use the {count} placeholder to dynamically show the stock count. <br />Example: Available Stock: {count} pcs.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'condition'   => [
				'show_stock_text' => 'yes',
			],
		];

		$stock_count_fields['product_stock_section_end'] = $obj->end_section();

		// Badges Sections.
		$fields = Fns::insert_controls( 'badges_section_end', $fields, $stock_count_fields, true );

		$stock_count_style                                       = ProductStockCountSettings::stock_count_style_settings( $obj );
		$stock_count_style['general_section_start']['label']     = esc_html__( 'Product Stock Count', 'shopbuilder-pro' );
		$stock_count_style['general_section_start']['condition'] = [ 'show_product_stock_count' => 'yes' ];

		$fields = Fns::insert_controls( 'badges_style_section', $fields, $stock_count_style, false );

		$extra_fields['product_stock_wrapper_style'] = [
			'type'            => 'html',
			'raw'             => sprintf(
				'<h3 class="rtsb-elementor-group-heading">%s</h3>',
				esc_html__( 'Wrapper', 'shopbuilder-pro' )
			),
			'content_classes' => 'elementor-panel-heading-title',
			'separator'       => 'default',
		];
		$extra_fields['stock_wrapper_bg']            = [
			'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
			'type'      => 'color',
			'alpha'     => true,
			'selectors' => [
				$obj->selectors['stock_wrapper_bg'] => 'background-color: {{VALUE}};',
			],

		];
		$extra_fields['stock_wrapper_border']        = [
			'mode'       => 'group',
			'type'       => 'border',
			'selector'   => $obj->selectors['stock_wrapper_border'],
			'size_units' => [ 'px' ],
		];
		$extra_fields['stock_wrapper_shadow']        = [
			'mode'     => 'group',
			'type'     => 'text-shadow',
			'selector' => $obj->selectors['stock_wrapper_shadow'],
		];
		$extra_fields['stock_wrapper_border_radius'] = [
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px', 'em', '%' ],
			'selectors'  => [
				$obj->selectors['stock_wrapper_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];
		$extra_fields['stock_wrapper_padding']       = [
			'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px', 'em', '%' ],
			'selectors'  => [
				$obj->selectors['stock_wrapper_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];
		$extra_fields['stock_wrapper_margin']        = [
			'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
			'type'       => 'dimensions',
			'mode'       => 'responsive',
			'size_units' => [ 'px', 'em', '%' ],
			'selectors'  => [
				$obj->selectors['stock_wrapper_padding'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		];
		return Fns::insert_controls( 'product_stock_margin', $fields, $extra_fields, true );
	}

	/**
	 * Single product ajax add to cart.
	 *
	 * @param array $fields widget controls.
	 *
	 * @return array
	 */
	public static function single_ajax_add_to_cart( $fields ) {
		$new_fields['enable_single_ajax_add_to_cart'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Ajax Add to Cart?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable Ajax add to cart.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
		];

		return Fns::insert_controls( 'cart_icon', $fields, $new_fields );
	}
}
