<?php
/**
 * Main ProductDescription class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Cart;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\CartCouponFormSettings;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Product Description class
 */
class CouponForm extends ElementorWidgetBase {
	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Coupon Form ', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-cart-coupon-form';
		parent::__construct( $data, $args );

	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public function widget_fields() {
		return CartCouponFormSettings::widget_fields( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'Coupon' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();
		$this->theme_support();
		$data = [
			'template'    => 'elementor/cart/coupon-form',
			'controllers' => $controllers
		];

		if ( $this->is_builder_mode() ) {
			wc_load_cart();
		}

		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );
		$this->theme_support( 'render_reset' );
	}


}
