<?php
/**
 * AccountNavigationSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SBPRO\Modules\CustomizeMyAccount\CustomizeMyAccountFns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigationSettings class.
 */
class AccountNavigationSettings {
	/**
	 * Widget Field
	 *
	 * @param object $widget Widget object.
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		return self::navigation_visibility_settings() + self::icon_settings() + self::general_style( $widget ) + self::icon_style( $widget );
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function navigation_visibility_settings() {
		return [
			'navigation_visibility_section_start' => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Visibility', 'shopbuilder-pro' ),
				'tab'   => 'content',
			],
			'dashboard_show'                      => [
				'label'       => esc_html__( 'Dashboard Menu', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show dashboard menu.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',
			],
			'orders_show'                         => [
				'label'       => esc_html__( 'Orders Menu', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show orders menu.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',
			],
			'downloads_show'                      => [
				'label'       => esc_html__( 'Downloads Menu', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show downloads menu.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',
			],
			'edit-address_show'                   => [
				'label'       => esc_html__( 'Address Menu', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show address menu.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',
			],
			'edit-account_show'                   => [
				'label'       => esc_html__( 'Account Details Menu', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show account details menu.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',
			],
			'navigation_visibility_section_end'   => [
				'mode' => 'section_end',
			],
		];
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function icon_settings() {
		$fields    = [];
		$endpoints = CustomizeMyAccountFns::get_endpoints_options();

		$fields['icon_section_start'] = [
			'mode'  => 'section_start',
			'label' => esc_html__( 'Menu Icons', 'shopbuilder-pro' ),
			'tab'   => 'content',
		];

		$fields['dashboard_heading_label'] = [
			'type'            => 'html',
			'raw'             => sprintf(
				'<h3 class="rtsb-elementor-group-heading">%s</h3>',
				esc_html__( 'Dashboard', 'shopbuilder-pro' )
			),
			'content_classes' => 'elementor-panel-heading-title',
		];

		$fields['dashboard_icon'] = [
			'label' => esc_html__( 'Dashboard Icon', 'shopbuilder-pro' ),
			'type'  => 'icons',
		];

		if ( ! empty( $endpoints['dashboard'] ) ) {
			$fields['dashboard_icon']['default'] = self::get_endpoint_icon( 'dashboard', $endpoints );
		}

		$fields['order_heading_label'] = [
			'type'            => 'html',
			'raw'             => sprintf(
				'<h3 class="rtsb-elementor-group-heading">%s</h3>',
				esc_html__( 'Orders', 'shopbuilder-pro' )
			),
			'content_classes' => 'elementor-panel-heading-title',
			'separator'       => 'before',
		];

		$fields['orders_icon'] = [
			'label'     => esc_html__( 'Orders Icon', 'shopbuilder-pro' ),
			'type'      => 'icons',
			'separator' => 'default',
		];

		if ( ! empty( $endpoints['orders'] ) ) {
			$fields['orders_icon']['default'] = self::get_endpoint_icon( 'orders', $endpoints );
		}

		$fields['download_heading_label'] = [
			'type'            => 'html',
			'raw'             => sprintf(
				'<h3 class="rtsb-elementor-group-heading">%s</h3>',
				esc_html__( 'Download', 'shopbuilder-pro' )
			),
			'content_classes' => 'elementor-panel-heading-title',
			'separator'       => 'before',
		];

		$fields['downloads_icon'] = [
			'label'     => esc_html__( 'Download Icon', 'shopbuilder-pro' ),
			'type'      => 'icons',
			'separator' => 'default',
		];

		if ( ! empty( $endpoints['downloads'] ) ) {
			$fields['downloads_icon']['default'] = self::get_endpoint_icon( 'downloads', $endpoints );
		}

		$fields['address_heading_label'] = [
			'type'            => 'html',
			'raw'             => sprintf(
				'<h3 class="rtsb-elementor-group-heading">%s</h3>',
				esc_html__( 'Address', 'shopbuilder-pro' )
			),
			'content_classes' => 'elementor-panel-heading-title',
			'separator'       => 'before',
		];

		$fields['edit-address_icon'] = [
			'label'     => esc_html__( 'Address Icon', 'shopbuilder-pro' ),
			'type'      => 'icons',
			'separator' => 'default',
		];

		if ( ! empty( $endpoints['edit-address'] ) ) {
			$fields['edit-address_icon']['default'] = self::get_endpoint_icon( 'edit-address', $endpoints );
		}

		$fields['account_heading_label'] = [
			'type'            => 'html',
			'raw'             => sprintf(
				'<h3 class="rtsb-elementor-group-heading">%s</h3>',
				esc_html__( 'Account Details', 'shopbuilder-pro' )
			),
			'content_classes' => 'elementor-panel-heading-title',
			'separator'       => 'before',
		];

		$fields['edit-account_icon'] = [
			'label'     => esc_html__( 'Account Details Icon', 'shopbuilder-pro' ),
			'type'      => 'icons',
			'separator' => 'default',
		];

		if ( ! empty( $endpoints['edit-account'] ) ) {
			$fields['edit-account_icon']['default'] = self::get_endpoint_icon( 'edit-account', $endpoints );
		}

		if ( CustomizeMyAccountFns::is_custom_endpoint_enabled() ) {
			$endpoints_data = CustomizeMyAccountFns::custom_endpoints()['endpoints_data'] ?? [];

			foreach ( $endpoints_data as $endpoint => $endpoint_data ) {
				$fields[ $endpoint . '_custom_heading_label' ] = [
					'type'            => 'html',
					'raw'             => sprintf(
						'<h3 class="rtsb-elementor-group-heading">%s</h3>',
						esc_html__( 'Endpoint: ', 'shopbuilder-pro' ) . esc_html( $endpoint_data['title'] )
					),
					'content_classes' => 'elementor-panel-heading-title',
					'separator'       => 'before',
				];

				$fields[ $endpoint . '_icon' ] = [
					'label'     => esc_html( $endpoint_data['title'] ) . esc_html__( ' Icon', 'shopbuilder-pro' ),
					'type'      => 'icons',
					'separator' => 'default',
					'default'   => [
						'value'   => 'rtsb-icon rtsb-icon-check-alt',
						'library' => 'rtsb-fonts',
					],
				];

				if ( ! empty( $endpoints[ $endpoint ] ) ) {
					$fields[ $endpoint . '_icon' ]['default'] = self::get_endpoint_icon( $endpoint, $endpoints );
				}
			}
		}

		$fields['logout_heading_label'] = [
			'type'            => 'html',
			'raw'             => sprintf(
				'<h3 class="rtsb-elementor-group-heading">%s</h3>',
				esc_html__( 'Logout', 'shopbuilder-pro' )
			),
			'content_classes' => 'elementor-panel-heading-title',
			'separator'       => 'before',
		];

		$fields['customer-logout_icon'] = [
			'label'     => esc_html__( 'Logout Icon', 'shopbuilder-pro' ),
			'type'      => 'icons',
			'separator' => 'default',
		];

		if ( ! empty( $endpoints['customer-logout'] ) ) {
			$fields['customer-logout_icon']['default'] = self::get_endpoint_icon( 'customer-logout', $endpoints );
		}

		$fields['icon_section_end'] = [
			'mode' => 'section_end',
		];

		return $fields;
	}

	/**
	 * Widget Field
	 *
	 * @param object $widget Widget object.
	 *
	 * @return array
	 */
	public static function general_style( $widget ) {
		return [
			'general_section_start'     => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
				'tab'   => 'style',
			],
			'view_mode'                 => [
				'label'     => esc_html__( 'Default View', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => [
					'block' => [
						'title' => esc_html__( 'New Line', 'shopbuilder-pro' ),
						'icon'  => 'eicon-post-list',
					],
					'flex'  => [
						'title' => esc_html__( 'Inline', 'shopbuilder-pro' ),
						'icon'  => 'eicon-posts-grid',
					],
				],
				'default'   => 'block',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['view_mode'] => 'display: {{VALUE}}',
				],
			],
			'typography'                => [
				'mode'      => 'group',
				'type'      => 'typography',
				'separator' => 'before',
				'label'     => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['typography'],
			],
			'navigation_border'         => [
				'mode'      => 'group',
				'type'      => 'border',
				'label'     => esc_html__( 'Border', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['navigation_border'],
				'separator' => 'before',
			],
			'active_text_decoration'    => [
				'label'       => esc_html__( 'Active Nav Text Decoration?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to active text decoration.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => false,
				'selectors'   => [
					$widget->selectors['active_text_decoration'] => 'text-decoration:underline',
				],
			],
			'fields_tabs_start'         => [
				'mode' => 'tabs_start',
			],
			// Tab For normal view.
			'fields_normal'             => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Normal', 'shopbuilder-pro' ),
			],
			'fields_text_color'         => [
				'label'     => esc_html__( 'Text', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$widget->selectors['fields_text_color'] => 'color: {{VALUE}};',
				],
			],
			'fields_bg_color'           => [
				'label'     => esc_html__( 'Label Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['fields_bg_color'] => 'background-color: {{VALUE}};',
				],
			],
			'fields_border_color'       => [
				'label'     => esc_html__( 'Border', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['fields_border_color'] => 'border-color: {{VALUE}};',
				],
			],
			'fields_normal_end'         => [
				'mode' => 'tab_end',
			],
			'fields_hover'              => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Hover & Active', 'shopbuilder-pro' ),
			],
			'fields_hover_text_color'   => [
				'label'     => esc_html__( 'Text', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['fields_hover_text_color'] => 'color: {{VALUE}};',
				],
			],
			'fields_hover_bg_color'     => [
				'label'     => esc_html__( 'Label Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['fields_hover_bg_color'] => 'background-color: {{VALUE}};',
				],
			],
			'fields_border_hover_color' => [
				'label'     => esc_html__( 'Border', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['fields_border_hover_color'] => 'border-color: {{VALUE}};',
				],
			],
			'fields_hover_end'          => [
				'mode' => 'tab_end',
			],
			'fields_tabs_end'           => [
				'mode' => 'tabs_end',
			],
			'gap'                       => [
				'label'      => esc_html__( 'Gap (px)', 'shopbuilder-pro' ),
				'mode'       => 'responsive',
				'type'       => 'slider',
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'condition'  => [
					'view_mode' => 'flex',
				],
				'selectors'  => [
					$widget->selectors['gap'] => 'gap: {{SIZE}}{{UNIT}};',
				],
			],
			'border_radius'             => [
				'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					$widget->selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'content_padding'           => [
				'label'      => esc_html__( 'Label Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					$widget->selectors['content_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'general_section_end'       => [
				'mode' => 'section_end',
			],
		];
	}
	/**
	 * Widget Field
	 *
	 * @param object $widget Widget object.
	 *
	 * @return array
	 */
	public static function icon_style( $widget ) {
		return [
			'icon_start_section_start' => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Icon Style', 'shopbuilder-pro' ),
				'tab'   => 'style',
			],
			'icon_alignment'           => [
				'type'      => 'choose',
				'label'     => esc_html__( 'Icon Alignment', 'shopbuilder-pro' ),
				'options'   => [
					'left'  => [
						'title' => esc_html__( 'Left', 'shopbuilder-pro' ),
						'icon'  => 'eicon-arrow-left',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'shopbuilder-pro' ),
						'icon'  => 'eicon-arrow-right',
					],
				],
				'separator' => 'default',
				'default'   => 'left',
				'toggle'    => true,
			],
			'icon_size'                => [
				'label'      => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
				'size_units' => [ 'px', '%' ],
				'type'       => 'slider',
				'range'      => [
					'px' => [
						'min' => 10,
						'max' => 100,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					$widget->selectors['icon_size']['svg'] => 'width: {{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};',
					$widget->selectors['icon_size']['icon'] => 'font-size: {{SIZE}}{{UNIT}};',
				],
			],
			'icon_color'               => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['icon_color'] => 'color: {{VALUE}};',
				],
			],
			'icon_active_color'        => [
				'label'     => esc_html__( 'Active Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['icon_active_color'] => 'color: {{VALUE}};',
				],
			],
			'icon_style_section_end'   => [
				'mode' => 'section_end',
			],
		];
	}

	/**
	 * Retrieve the icon for a given endpoint.
	 *
	 * @param string $endpoint The endpoint ID.
	 * @param array  $endpoints_data Data for all endpoints.
	 *
	 * @return array
	 */
	private static function get_endpoint_icon( $endpoint, $endpoints_data ) {
		if ( 'custom' === $endpoints_data[ $endpoint ]['icon'] && ! empty( $endpoints_data[ $endpoint ]['custom_icon'] ) ) {
			return [
				'value'   => 'rtsb-icon rtsb-icon-' . $endpoints_data[ $endpoint ]['custom_icon'],
				'library' => 'rtsb-fonts',
			];
		} else {
			return [];
		}
	}
}
