<?php
/**
 * AccountOrderStatusSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountOrderStatusSettings class.
 */
class AccountOrderStatusSettings {
	/**
	 * Widget Field
	 *
	 * @param object $widget Reference widget.
	 * @return array
	 */
	public static function settings( $widget ) {
		return self::text_style( $widget ) +
			   self::order_mark_style( $widget );
	}

	/**
	 * Widget Field
	 *
	 * @param object $widget Reference widget.
	 * @return array
	 */
	public static function text_style( $widget ) {
		$fields                           = TextStyleSettings::widget_fields( $widget );
		$fields['section_style']['label'] = esc_html__( 'Text Style', 'shopbuilder-pro' );
		return $fields;
	}

	/**
	 * Widget Field
	 *
	 * @param object $widget Reference widget.
	 * @return array
	 */
	public static function order_mark_style( $widget ) {
		$fields = [
			'mark_section_style'     => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Order Mark Style', 'shopbuilder-pro' ),
			],
			'mark_typo'              => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['mark_typo'],
			],
			'mark_color'             => [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'default'   => '',
				'selectors' => [
					$widget->selectors['mark_color'] => 'color: {{VALUE}};',
				],
			],
			'mark_bg_color'          => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'default'   => '',
				'selectors' => [
					$widget->selectors['mark_bg_color'] => 'background-color: {{VALUE}};',
				],
			],
			'mark_padding'           => [
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					$widget->selectors['mark_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'mark_section_style_end' => [
				'mode' => 'section_end',
			],
		];
		return apply_filters( 'rtsb/elements/elementor/order_status_mark_selector', $fields );
	}
}
