<?php
/**
 * AccountRegistrationFormSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.


use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class AccountRegistrationFormSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		$fields = AccountLoginSettings::settings( $widget );
		unset( $fields['login_note'] );
		unset( $fields['register_note'] );
		unset( $fields['show_remember_me'] );
		unset( $fields['remember_me_lab_text'] );
		unset( $fields['show_lost_password'] );
		unset( $fields['lost_password_text'] );
		unset( $fields['login_btn_text'] );
		unset( $fields['form_border_between_color'] );
		unset( $fields['lost_pass_section_start'] );
		unset( $fields['lost_pass_typography'] );
		unset( $fields['lost_pass_color'] );
		unset( $fields['lost_pass_hover_color'] );
		unset( $fields['lost_pass_margin'] );
		unset( $fields['lost_pass_section_end'] );
		$extra_controls['registration_title_text'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Registration Title', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Enter custom Registration Title. Leave empty for default label.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'label_block' => true,
			'condition'   => [
				'show_title' => 'yes',
			],
		];
		$fields                                 = Fns::insert_controls( 'show_title', $fields, $extra_controls, true );
		return $fields;

	}

}
