<?php
/**
 * Main AdvanceProductTabsSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ProductTabsSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\ReviewsSettings;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AdvanceProductTabsSettings class
 */
class AdvancedProductTabSettings {
	/**
	 * Settings fields.
	 *
	 * @param object $widget Reference widget.
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		return self::general_settings()
			+ self::accordion_style_settings( $widget )
			+ ProductTabsSettings::nav_style( $widget )
			+ self::tab_content_settings( $widget )
			+ self::additional_info_settings( $widget )
			+ ReviewsSettings::widget_fields( $widget );
	}

	/**
	 * General Settings fields.
	 *
	 * @return array
	 */
	public static function general_settings() {
		return [
			'general_section_start' => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'layout_note'           => [
				'type'            => 'html',
				'raw'             => '<h3 class="rtsb-elementor-group-heading">' . esc_html__( 'Layout', 'shopbuilder-pro' ) . '</h3>',
				'separator'       => 'default',
				'content_classes' => 'elementor-panel-heading-title',
			],
			'layout_style'          => [
				'type'      => 'rtsb-image-selector',
				'options'   => ControlHelper::single_product_tab_layouts(),
				'default'   => 'default',
				'separator' => 'default',
			],
			'first_item_collapse'   => [
				'type'      => 'switch',
				'label'     => esc_html__( 'First Item Collapse', 'shopbuilder-pro' ),
				'condition' => [
					'layout_style' => [ 'custom-layout1' ],
				],
			],
			'tabs_note'             => [
				'type'            => 'html',
				'raw'             => '<h3 class="rtsb-elementor-group-heading">' . esc_html__( 'Add Product Tabs', 'shopbuilder-pro' ) . '</h3>',
				'separator'       => 'before',
				'content_classes' => 'elementor-panel-heading-title',
			],
			'advance_tabs'          => [
				'type'        => 'repeater',
				'label'       => esc_html__( 'Please add your product tabs below', 'shopbuilder-pro' ),
				'mode'        => 'repeater',
				'fields'      => [
					'advance_tab_items'          => [
						'label'       => esc_html__( 'Tab Item Type', 'shopbuilder-pro' ),
						'description' => esc_html__( 'Please choose the tab item type.', 'shopbuilder-pro' ),
						'type'        => 'select',
						'separator'   => 'default',
						'default'     => 'description',
						'label_block' => true,
						'options'     => [
							'description'            => esc_html__( 'Description', 'shopbuilder-pro' ),
							'reviews'                => esc_html__( 'Review', 'shopbuilder-pro' ),
							'additional_information' => esc_html__( 'Additional Information', 'shopbuilder-pro' ),
							'custom_tab'             => esc_html__( 'Custom Tab', 'shopbuilder-pro' ),
						],
					],
					'advanced_tab_heading_title' => [
						'label'       => esc_html__( 'Tab Nav Title', 'shopbuilder-pro' ),
						'description' => esc_html__( 'Enter tab navigation title.', 'shopbuilder-pro' ),
						'type'        => 'text',
						'label_block' => true,
						'default'     => esc_html__( 'Custom Title', 'shopbuilder-pro' ),
						'separator'   => 'before-short',
					],
					'enable_tab_content_title'   => [
						'type'        => 'switch',
						'label'       => esc_html__( 'Display Tab Heading?', 'shopbuilder-pro' ),
						'description' => esc_html__( 'Switch on to display tab heading.', 'shopbuilder-pro' ),
						'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
						'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
						'separator'   => 'before-short',
					],
					'advanced_tab_content_title' => [
						'label'       => esc_html__( 'Tab Content Heading', 'shopbuilder-pro' ),
						'description' => esc_html__( 'Enter tab content heading.', 'shopbuilder-pro' ),
						'type'        => 'text',
						'label_block' => true,
						'default'     => esc_html__( 'Tab Custom Heading', 'shopbuilder-pro' ),
						'separator'   => 'before-short',
						'condition'   => [
							'enable_tab_content_title' => 'yes',
						],
					],
					'custom_field_description'   => [
						'label'       => esc_html__( 'Tab Content', 'shopbuilder-pro' ),
						'description' => esc_html__( 'Enter tab content in the above editor. Please note that you can use this editor to display any ShortCodes.', 'shopbuilder-pro' ),
						'type'        => 'wysiwyg',
						'separator'   => 'before-short',
						'condition'   => [
							'advance_tab_items' => 'custom_tab',
						],
					],
				],
				'default'     => [
					[
						'advance_tab_items'          => 'description',
						'advanced_tab_heading_title' => esc_html__( 'Description', 'shopbuilder-pro' ),
						'advanced_tab_content_title' => esc_html__( 'Description', 'shopbuilder-pro' ),
					],
					[
						'advance_tab_items'          => 'additional_information',
						'advanced_tab_heading_title' => esc_html__( 'Additional Information', 'shopbuilder-pro' ),
						'advanced_tab_content_title' => esc_html__( 'Additional Information', 'shopbuilder-pro' ),
					],
					[
						'advance_tab_items'          => 'reviews',
						'advanced_tab_heading_title' => esc_html__( 'Reviews', 'shopbuilder-pro' ),
						'advanced_tab_content_title' => esc_html__( 'Reviews', 'shopbuilder-pro' ),
					],
				],
				'title_field' => '{{{ advanced_tab_heading_title }}}',
			],

			'general_section_end'   => [
				'mode' => 'section_end',
			],
		];
	}
	/**
	 * Additional info Style fields.
	 *
	 * @param object $widget Reference widget.
	 *
	 * @return array
	 */
	public static function additional_info_settings( $widget ) {
		$fields = ProductTabsSettings::additional_info( $widget );
		unset( $fields['additional_info_style']['condition'] );
		return $fields;
	}

	/**
	 * Accordion style fields.
	 *
	 * @param object $widget Reference widget.
	 *
	 * @return array
	 */
	public static function accordion_style_settings( $widget ) {
		return [
			'accordion_title_style'             => [
				'mode'      => 'section_start',
				'tab'       => 'style',
				'label'     => esc_html__( 'Accordion Title', 'shopbuilder-pro' ),
				'condition' => [
					'layout_style' => [ 'custom-layout1' ],
				],
			],
			'accordion_title_typography'        => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['accordion_title_typography'],
			],
			'accordion_title_tabs_start'        => [
				'mode' => 'tabs_start',
			],
			'title_normal'                      => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Normal', 'shopbuilder-pro' ),
			],
			'accordion_title_color'             => [
				'label'     => esc_html__( 'Title', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['accordion_title_color'] => 'color: {{VALUE}}',
				],
			],
			'accordion_title_icon_color'        => [
				'label'     => esc_html__( 'Icon', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['accordion_title_icon_color'] => 'background-color: {{VALUE}}',
				],
			],
			'accordion_title_bg_color'          => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['accordion_title_bg_color'] => 'background-color: {{VALUE}}',
				],
			],
			'title_normal_end'                  => [
				'mode' => 'tab_end',
			],
			// Accordion For Active view.
			'accordion_title_active'            => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Active', 'shopbuilder-pro' ),
			],
			'accordion_title_active_color'      => [
				'label'     => esc_html__( 'Title', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['accordion_title_active_color'] => 'color: {{VALUE}}',
				],
			],
			'accordion_title_icon_active_color' => [
				'label'     => esc_html__( 'Icon', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['accordion_title_icon_active_color'] => 'background-color: {{VALUE}}',
				],
			],
			'accordion_title_active_bg_color'   => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['accordion_title_active_bg_color'] => 'background-color: {{VALUE}}',
				],
			],
			'accordion_title_active_end'        => [
				'mode' => 'tab_end',
			],
			'accordion_title_tabs_end'          => [
				'mode' => 'tabs_end',
			],
			'accordion_title_style_end'         => [
				'mode' => 'section_end',
			],
		];
	}

	/**
	 * Tab content style fields.
	 *
	 * @param object $widget Reference widget.
	 *
	 * @return array
	 */
	public static function tab_content_settings( $widget ) {
		$fields = ProductTabsSettings::tab_content( $widget );
		unset( $fields['show_title'] );
		unset( $fields['tab_title_typography']['condition'] );
		unset( $fields['tab_title_gap']['condition'] );
		unset( $fields['tab_content_title_color']['condition'] );
		return $fields;
	}
}
