<?php
/**
 * Main ProductDescription class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SB\Elementor\Helper\ControlHelper;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Product Description class
 */
class ArchiveFiltersSettings {

	/**
	 * Widget Field
	 *
	 * @param object $widget Widget object.
	 *
	 * @return array
	 */
	public static function widget_fields( $widget ) {
		return self::layout( $widget )
			+ self::filters( $widget )
			+ self::filter_settings( $widget )
			+ self::search_settings( $widget )
			+ self::accordion_settings( $widget )
			+ self::toggle_btn_settings( $widget )
			+ self::apply_filters_btn_settings( $widget )
			+ self::more_less_btn( $widget )
			+ self::filter_scrolling( $widget )
			+ self::reset_btn_settings( $widget )
			+ self::filter_styles( $widget );
	}

	/**
	 * Filters Layout section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function layout( $obj ) {
		$fields['layout_section'] = $obj->start_section(
			esc_html__( 'Layouts', 'shopbuilder-pro' ),
			'layout'
		);

		$fields['layout'] = [
			'type'      => 'rtsb-image-selector',
			'options'   => FnsPro::filter_layouts(),
			'default'   => 'vertical',
			'separator' => 'default',
		];

		$fields['columns'] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Number of Columns', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please specify the number of columns.', 'shopbuilder-pro' ),
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 10,
					'step' => 1,
				],
			],
			'default'     => [
				'unit' => 'px',
				'size' => 5,
			],
			'condition'   => [ 'layout' => [ 'horizontal' ] ],
			'selectors'   => [ $obj->selectors['layout']['columns'] => 'grid-template-columns: repeat({{SIZE}}, minmax(0, 1fr));' ],
		];

		$fields['columns_gap'] = [
			'type'        => 'slider',
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Columns Gap', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please specify the columns gap.', 'shopbuilder-pro' ),
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'default'     => [
				'unit' => 'px',
				'size' => 15,
			],
			'condition'   => [ 'layout' => [ 'horizontal' ] ],
			'selectors'   => [ $obj->selectors['layout']['columns_gap'] => 'grid-gap: {{SIZE}}{{UNIT}};' ],
		];

		$fields['columns_alignment'] = [
			'type'      => 'choose',
			'label'     => esc_html__( 'Columns Alignment', 'shopbuilder-pro' ),
			'options'   => [
				'flex-start' => [
					'title' => esc_html__( 'Left', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-left',
				],
				'center'     => [
					'title' => esc_html__( 'Center', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-center',
				],
				'flex-end'   => [
					'title' => esc_html__( 'Right', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-right',
				],
			],
			'condition' => [ 'layout' => [ 'horizontal' ] ],
			'selectors' => [ $obj->selectors['layout']['columns_alignment'] => 'justify-content: {{VALUE}};' ],
		];

		$fields['canvas_width'] = [
			'type'        => 'slider',
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Off-Canvas Width', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please specify the off-canvas width.', 'shopbuilder-pro' ),
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 1500,
					'step' => 1,
				],
			],
			'condition'   => [ 'layout' => 'off-canvas' ],
			'selectors'   => [ $obj->selectors['layout']['canvas_width'] => 'width: {{SIZE}}{{UNIT}};' ],
		];

		$fields['canvas_alignment'] = [
			'type'      => 'choose',
			'label'     => esc_html__( 'Off-Canvas Alignment', 'shopbuilder-pro' ),
			'options'   => [
				'flex-start' => [
					'title' => esc_html__( 'Left', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-left',
				],
				'flex-end'   => [
					'title' => esc_html__( 'Right', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-right',
				],
			],
			'condition' => [ 'layout' => [ 'off-canvas' ] ],
			'selectors' => [ $obj->selectors['layout']['canvas_alignment'] => 'justify-content: {{VALUE}};' ],
		];

		$fields['layout_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Filters repeater section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function filters( $obj ) {
		$fields['filters_section'] = $obj->start_section(
			esc_html__( 'Add Filters', 'shopbuilder-pro' ),
			'layout'
		);

		$fields['add_filter_note'] = $obj->el_heading(
			esc_html__( 'Filters', 'shopbuilder-pro' ),
			'default'
		);

		$filter_options = [
			'product_cat'   => esc_html__( 'Categories', 'shopbuilder-pro' ),
			'product_brand' => esc_html__( 'Brands', 'shopbuilder-pro' ),
			'product_tag'   => esc_html__( 'Tags', 'shopbuilder-pro' ),
			'product_attr'  => esc_html__( 'Attributes', 'shopbuilder-pro' ),
			'rating_filter' => esc_html__( 'Rating', 'shopbuilder-pro' ),
			'price_filter'  => esc_html__( 'Price', 'shopbuilder-pro' ),
			'sale_filter'   => esc_html__( 'On Sale', 'shopbuilder-pro' ),
		];

		$input_options = [
			'checkbox' => esc_html__( 'Checkbox', 'shopbuilder-pro' ),
			'radio'    => esc_html__( 'Radio', 'shopbuilder-pro' ),
		];

		if ( function_exists( 'rtwpvs' ) ) {
			$input_options['color']  = esc_html__( 'Color', 'shopbuilder-pro' );
			$input_options['button'] = esc_html__( 'Button', 'shopbuilder-pro' );
			$input_options['image']  = esc_html__( 'Image', 'shopbuilder-pro' );
		}

		$attributes = Fns::get_all_attributes_name();

		if ( empty( $attributes ) ) {
			$attributes = [
				'nothing' => esc_html__( 'No attributes found', 'shopbuilder-pro' ),
			];
		}

		$fields['filter_types'] = [
			'type'        => 'repeater',
			'mode'        => 'repeater',
			'label'       => esc_html__( 'Please add your product filters below', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'title_field' => '{{{ filter_title }}}',
			'fields'      => [
				'filter_title'       => [
					'label'       => esc_html__( 'Filter Title', 'shopbuilder-pro' ),
					'type'        => 'text',
					'description' => esc_html__( 'Enter the filter title.', 'shopbuilder-pro' ),
					'label_block' => true,
					'default'     => esc_html__( 'Filter by Categories', 'shopbuilder-pro' ),
				],
				'show_title_icon'    => [
					'label'       => esc_html__( 'Show Filter Title Icon?', 'shopbuilder-pro' ),
					'type'        => 'switch',
					'description' => esc_html__( 'Switch on to show filter title icon.', 'shopbuilder-pro' ),
					'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
					'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
				],
				'filter_title_icon'  => [
					'type'        => 'icons',
					'label'       => esc_html__( 'Choose Title Icon', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Please choose the title icon.', 'shopbuilder-pro' ),
					'default'     => [
						'value'   => 'fas fa-star',
						'library' => 'fa-solid',
					],
					'condition'   => [ 'show_title_icon' => [ 'yes' ] ],
				],
				'filter_items'       => [
					'label'       => esc_html__( 'Select Filter Query', 'shopbuilder-pro' ),
					'type'        => 'select',
					'description' => esc_html__( 'Select the query you want to display.', 'shopbuilder-pro' ),
					'options'     => $filter_options,
					'default'     => 'product_cat',
					'label_block' => true,
					'separator'   => 'before-short',
				],
				'filter_attr'        => [
					'label'       => esc_html__( 'Select Attribute', 'shopbuilder-pro' ),
					'type'        => 'select',
					'description' => esc_html__( 'Select the product attribute.', 'shopbuilder-pro' ),
					'options'     => $attributes,
					'default'     => array_key_first( $attributes ),
					'label_block' => true,
					'condition'   => [ 'filter_items' => 'product_attr' ],
				],
				'input_type'         => [
					'label'       => esc_html__( 'Input Type', 'shopbuilder-pro' ),
					'type'        => 'select',
					'description' => esc_html__( 'Select the filter input type.', 'shopbuilder-pro' ),
					'label_block' => true,
					'options'     => [
						'checkbox' => esc_html__( 'Checkbox', 'shopbuilder-pro' ),
						'radio'    => esc_html__( 'Radio', 'shopbuilder-pro' ),
					],
					'default'     => 'checkbox',
					'condition'   => [
						'filter_items!' => [ 'product_attr', 'rating_filter', 'price_filter' ],
					],
				],
				'input_type_all'     => [
					'label'       => esc_html__( 'Input Type', 'shopbuilder-pro' ),
					'type'        => 'select',
					'description' => esc_html__( 'Select the filter input type.', 'shopbuilder-pro' ),
					'label_block' => true,
					'options'     => $input_options,
					'default'     => 'checkbox',
					'condition'   => [ 'filter_items' => 'product_attr' ],
				],
				'rating_icon'        => [
					'type'        => 'icons',
					'label'       => esc_html__( 'Choose Rating Icon', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Please choose the rating icon.', 'shopbuilder-pro' ),
					'default'     => [
						'value'   => 'fas fa-star',
						'library' => 'fa-solid',
					],
					'condition'   => [ 'filter_items' => [ 'rating_filter' ] ],
				],
				'exclude_terms'      => [
					'type'        => 'text',
					'label'       => esc_html__( 'Exclude Terms by ID', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Please enter the term IDs\' separated by comma to exclude.', 'shopbuilder-pro' ),
					'multiple'    => true,
					'label_block' => true,
					'placeholder' => esc_html__( 'Ex: 1,2,3', 'shopbuilder-pro' ),
					'condition'   => [ 'filter_items' => [ 'product_cat','product_brand', 'product_tag', 'product_attr' ] ],
				],
				'onsale_title'       => [
					'label'       => esc_html__( 'On Sale Input Label', 'shopbuilder-pro' ),
					'type'        => 'text',
					'description' => esc_html__( 'Enter the on sale filter input title.', 'shopbuilder-pro' ),
					'label_block' => true,
					'default'     => esc_html__( 'On Sale', 'shopbuilder-pro' ),
					'condition'   => [ 'filter_items' => 'sale_filter' ],
					'separator'   => 'before-short',
				],
				'regular_title'      => [
					'label'       => esc_html__( 'Regular Input Label', 'shopbuilder-pro' ),
					'type'        => 'text',
					'description' => esc_html__( 'Enter the on regular filter input title.', 'shopbuilder-pro' ),
					'label_block' => true,
					'default'     => esc_html__( 'Regular', 'shopbuilder-pro' ),
					'condition'   => [ 'filter_items' => 'sale_filter' ],
				],
				'filter_display'     => [
					'label'       => esc_html__( 'Filter Layout Columns', 'shopbuilder-pro' ),
					'type'        => 'select',
					'description' => esc_html__( 'Please select filter layout columns.', 'shopbuilder-pro' ),
					'options'     => [
						'default' => esc_html__( 'Default', 'shopbuilder-pro' ),
						'c1'      => esc_html__( '1 Column', 'shopbuilder-pro' ),
						'c2'      => esc_html__( '2 Columns', 'shopbuilder-pro' ),
						'c3'      => esc_html__( '3 Columns', 'shopbuilder-pro' ),
						'auto'    => esc_html__( 'Inline / Auto', 'shopbuilder-pro' ),
					],
					'label_block' => true,
					'default'     => 'default',
					'separator'   => 'before-short',
					'condition'   => [ 'filter_items!' => [ 'price_filter' ] ],
				],
				'column_gap'         => [
					'type'        => 'slider',
					'label'       => esc_html__( 'Column Gap', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Please select the column gap.', 'shopbuilder-pro' ),
					'size_units'  => [ 'px' ],
					'range'       => [
						'px' => [
							'min'  => 0,
							'max'  => 100,
							'step' => 1,
						],
					],
					'selectors'   => [ $obj->selectors['filter_types']['column_gap'] => 'column-gap: {{SIZE}}{{UNIT}};' ],
					'condition'   => [
						'filter_display' => [ 'c2', 'auto' ],
						'filter_items!'  => [ 'rating_filter', 'price_filter' ],
					],
				],
				'show_label'         => [
					'type'        => 'switch',
					'label'       => esc_html__( 'Show Term Label?', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Switch on to display term label.', 'shopbuilder-pro' ),
					'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
					'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
					'separator'   => 'before-short',
					'condition'   => [
						'filter_items'   => [ 'product_attr' ],
						'input_type_all' => [ 'color' ],
					],
				],
				'show_empty'         => [
					'type'        => 'switch',
					'label'       => esc_html__( 'Show Empty Terms?', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Switch on to display empty terms.', 'shopbuilder-pro' ),
					'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
					'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
					'separator'   => 'before-short',
					'condition'   => [ 'filter_items' => [ 'product_cat', 'product_brand','product_tag', 'product_attr' ] ],
				],
				'include_child_cats' => [
					'label'       => esc_html__( 'Show Child?', 'shopbuilder-pro' ),
					'type'        => 'switch',
					'description' => esc_html__( 'Switch on to include child.', 'shopbuilder-pro' ),
					'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
					'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
					'default'     => 'yes',
					'condition'   => [ 'filter_items' => [ 'product_cat','product_brand' ] ],
				],
				'show_tooltips'      => [
					'label'       => esc_html__( 'Show Tooltips?', 'shopbuilder-pro' ),
					'type'        => 'switch',
					'description' => esc_html__( 'Switch on to enable tooltips.', 'shopbuilder-pro' ),
					'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
					'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
					'default'     => 'yes',
					'condition'   => [
						'filter_items'   => [ 'product_attr' ],
						'input_type_all' => [ 'color', 'button', 'image' ],
					],
				],
				'price_label'        => [
					'type'        => 'text',
					'label'       => esc_html__( 'Price Label', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Please enter the price label.', 'shopbuilder-pro' ),
					'multiple'    => true,
					'label_block' => true,
					'default'     => esc_html__( 'Price:', 'shopbuilder-pro' ),
					'condition'   => [ 'filter_items' => [ 'price_filter' ] ],
				],
				'multiple_selection' => [
					'label'       => esc_html__( 'Select Multiple Terms?', 'shopbuilder-pro' ),
					'type'        => 'switch',
					'description' => esc_html__( 'Switch on to enable selection of multiple terms.', 'shopbuilder-pro' ),
					'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
					'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
					'conditions'  => [
						'relation' => 'and',
						'terms'    => [
							[
								'relation' => 'or',
								'terms'    => [
									[
										'name'     => 'input_type',
										'operator' => '!=',
										'value'    => 'radio',
									],
									[
										'name'     => 'input_type_all',
										'operator' => '!=',
										'value'    => 'radio',
									],
								],
							],
							[
								'relation' => 'or',
								'terms'    => [
									[
										'name'     => 'filter_items',
										'operator' => '!=',
										'value'    => 'price_filter',
									],
								],
							],
						],
					],
				],
				'multiple_relation'  => [
					'label'       => esc_html__( 'Multiple Terms Relation', 'shopbuilder-pro' ),
					'type'        => 'select',
					'description' => esc_html__( 'Please select the multiple terms relation.', 'shopbuilder-pro' ),
					'options'     => [
						'AND' => esc_html__( 'Show Common Products (AND)', 'shopbuilder-pro' ),
						'OR'  => esc_html__( 'Show All Products (OR)', 'shopbuilder-pro' ),
					],
					'label_block' => true,
					'default'     => 'AND',
					'conditions'  => [
						'relation' => 'and',
						'terms'    => [
							[
								'relation' => 'or',
								'terms'    => [
									[
										'name'     => 'input_type',
										'operator' => '!=',
										'value'    => 'radio',
									],
									[
										'name'     => 'input_type_all',
										'operator' => '!=',
										'value'    => 'radio',
									],
								],
							],
							[
								'relation' => 'or',
								'terms'    => [
									[
										'name'     => 'filter_items',
										'operator' => '==',
										'value'    => 'product_attr',
									],
								],
							],
							[
								'relation' => 'or',
								'terms'    => [
									[
										'name'     => 'multiple_selection',
										'operator' => '==',
										'value'    => 'yes',
									],
								],
							],
						],
					],
				],
				'show_input'         => [
					'type'        => 'switch',
					'label'       => esc_html__( 'Show Input Icons?', 'shopbuilder-pro' ),
					'description' => esc_html__( 'Switch on to display input icons.', 'shopbuilder-pro' ),
					'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
					'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
					'default'     => 'yes',
					'separator'   => 'before-short',
					'conditions'  => [
						'relation' => 'and',
						'terms'    => [
							[
								'relation' => 'or',
								'terms'    => [
									[
										'name'     => 'input_type',
										'operator' => 'in',
										'value'    => [ 'checkbox', 'radio' ],
									],
									[
										'name'     => 'input_type_all',
										'operator' => 'in',
										'value'    => [ 'checkbox', 'radio' ],
									],
								],
							],
							[
								'relation' => 'and',
								'terms'    => [
									[
										'name'     => 'filter_items',
										'operator' => '!=',
										'value'    => 'price_filter',
									],
								],
							],
						],
					],
				],
			],
			'default'     => [
				[
					'filter_title'       => esc_html__( 'Filter by Categories', 'shopbuilder-pro' ),
					'filter_items'       => 'product_cat',
					'input_type'         => 'checkbox',
					'multiple_selection' => 'yes',
					'include_child_cats' => 'yes',
				],
				[
					'filter_title' => esc_html__( 'Filter by Tags', 'shopbuilder-pro' ),
					'filter_items' => 'product_tag',
					'input_type'   => 'radio',
				],
				[
					'filter_title' => esc_html__( 'Filter by Prices', 'shopbuilder-pro' ),
					'filter_items' => 'price_filter',
					'price_label'  => esc_html__( 'Price', 'shopbuilder-pro' ),
				],
				[
					'filter_title'       => esc_html__( 'Filter by Ratings', 'shopbuilder-pro' ),
					'filter_items'       => 'rating_filter',
					'rating_icon'        => [
						'value'   => 'fas fa-star',
						'library' => 'fa-solid',
					],
					'multiple_selection' => 'yes',
				],
				[
					'filter_title'  => esc_html__( 'Filter by Sale', 'shopbuilder-pro' ),
					'filter_items'  => 'sale_filter',
					'onsale_title'  => esc_html__( 'On Sale', 'shopbuilder-pro' ),
					'regular_title' => esc_html__( 'Regular', 'shopbuilder-pro' ),
				],
			],
		];

		$fields['filters_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Filters Layout section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function filter_settings( $obj ) {
		$fields['filter_settings_section'] = $obj->start_section(
			esc_html__( 'Filter Settings', 'shopbuilder-pro' ),
			'settings'
		);

		$fields['filter_target'] = [
			'label'       => esc_html__( 'Specify Filter Target Widget:', 'shopbuilder-pro' ),
			'type'        => 'select',
			'description' => esc_html__( 'Please select the product filter target widget for filter connectivity.', 'shopbuilder-pro' ),
			'label_block' => true,
			'options'     => [
				'default' => esc_html__( 'ShopBuilder Archive: Default Layout', 'shopbuilder-pro' ),
				'custom'  => esc_html__( 'ShopBuilder Archive: Custom Layouts', 'shopbuilder-pro' ),
			],
			'default'     => 'custom',
			'separator'   => 'default',
		];

		$fields['filter_target_notice'] = [
			'type'      => 'html',
			'raw'       => sprintf(
				'<span style="display: block; background: #fffbf1; padding: 10px; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a30;">%s</span>',
				esc_html__( 'Please note that, the widget you select above should be added to the page for the target mentioned. If the widget is not added to the page, the filter will not work as intended.', 'shopbuilder-pro' )
			),
			'separator' => 'default',
		];

		$fields['custom_class'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Product Wrapper Selector', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please specify the archive product wrapper Selector for default theme layout (Example: ul.products).', 'shopbuilder-pro' ),
			'default'     => 'ul.products',
			'label_block' => true,
			'condition'   => [ 'filter_target' => 'default' ],
		];

		$fields['ajax_mode'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Filter Ajax Mode?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable filter ajax mode.', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields['ajax_mode_notice'] = [
			'type'      => 'html',
			'raw'       => sprintf(
				'<span style="display: block; background: #fffbf1; padding: 10px; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a30;">%s</span>',
				esc_html__( 'Please note that disabling the Ajax mode will reload the page and display the filtered result.', 'shopbuilder-pro' )
			),
			'separator' => 'default',
		];

		$fields['active_filter'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Active Filter Items?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to show active filter terms on top of products.', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields['scroll_to_top'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Scroll to Top?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable scroll to top of products when filter applies.', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields['scroll_offset'] = [
			'type'        => 'number',
			'label'       => esc_html__( 'Scroll Vertical Offset (px)', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please specify the scroll vertical offset in px.', 'shopbuilder-pro' ),
			'default'     => 200,
			'condition'   => [ 'scroll_to_top' => 'yes' ],
		];

		$fields['show_filter_header'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Filter Header Text?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to filter header text at the beginning.', 'shopbuilder-pro' ),
		];

		$fields['filter_header_text'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Filter Header Text', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Enter the filter header text.', 'shopbuilder-pro' ),
			'label_block' => true,
			'condition'   => [ 'show_filter_header' => 'yes' ],
		];

		$fields['toggle_btn_mobile'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Toggle Button in Mobile?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable filter toggle button in mobile.', 'shopbuilder-pro' ),
			'separator'   => 'before',
			'default'     => 'yes',
			'condition'   => [ 'toggle_btn!' => 'yes' ],
		];

		$fields['toggle_btn_mobile_text'] = [
			'label'       => esc_html__( 'Mobile Filter Button Text', 'shopbuilder-pro' ),
			'type'        => 'text',
			'description' => esc_html__( 'Enter the modile toggle filter button text.', 'shopbuilder-pro' ),
			'label_block' => true,
			'default'     => esc_html__( 'Click to Filter', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'condition'   => [
				'toggle_btn_mobile' => [ 'yes' ],
				'toggle_btn!'       => 'yes',
			],
		];

		$fields['filter_settings_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Search section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function search_settings( $obj ) {
		$fields['search_settings_section'] = $obj->start_section(
			esc_html__( 'Search Form Settings', 'shopbuilder-pro' ),
			'settings'
		);

		$fields['search_form'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Top Search Form?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable search form at the top.', 'shopbuilder-pro' ),
		];

		$fields['search_title'] = [
			'label'       => esc_html__( 'Search Title', 'shopbuilder-pro' ),
			'type'        => 'text',
			'description' => esc_html__( 'Enter the search title.', 'shopbuilder-pro' ),
			'label_block' => true,
			'condition'   => [ 'search_form' => [ 'yes' ] ],
			'separator'   => 'before-short',
		];

		$fields['show_search_title_icon'] = [
			'label'       => esc_html__( 'Show Search Title Icon?', 'shopbuilder-pro' ),
			'type'        => 'switch',
			'description' => esc_html__( 'Switch on to show search title icon.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'condition'   => [
				'search_form' => [ 'yes' ],
			],
		];

		$fields['filter_search_title_icon'] = [
			'type'        => 'icons',
			'label'       => esc_html__( 'Choose Search Title Icon', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the search title icon.', 'shopbuilder-pro' ),
			'default'     => [
				'value'   => 'fas fa-star',
				'library' => 'fa-solid',
			],
			'condition'   => [
				'search_form'            => [ 'yes' ],
				'show_search_title_icon' => [ 'yes' ],
			],
		];

		$fields['search_placeholder'] = [
			'label'       => esc_html__( 'Search Form Placeholder', 'shopbuilder-pro' ),
			'type'        => 'text',
			'description' => esc_html__( 'Enter the search form placeholder text.', 'shopbuilder-pro' ),
			'label_block' => true,
			'default'     => esc_html__( 'Search Products...', 'shopbuilder-pro' ),
			'condition'   => [ 'search_form' => [ 'yes' ] ],
			'separator'   => 'before-short',
		];

		$fields['search_submit'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Search Form Button Type', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Specify the search form submit button type.', 'shopbuilder-pro' ),
			'options'     => [
				'text' => esc_html__( 'Text Button', 'shopbuilder-pro' ),
				'icon' => esc_html__( 'Icon Button', 'shopbuilder-pro' ),
			],
			'default'     => 'icon',
			'label_block' => true,
			'condition'   => [
				'search_form' => 'yes',
			],
		];

		$fields['submit_button_title'] = [
			'label'       => esc_html__( 'Search Form Button Text', 'shopbuilder-pro' ),
			'type'        => 'text',
			'description' => esc_html__( 'Enter the search form button text.', 'shopbuilder-pro' ),
			'label_block' => true,
			'default'     => esc_html__( 'Search', 'shopbuilder-pro' ),
			'condition'   => [
				'search_submit' => [ 'text' ],
				'search_form'   => [ 'yes' ],
			],
		];

		$fields['search_title_icon'] = [
			'type'        => 'icons',
			'label'       => esc_html__( 'Choose Search Button Icon', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the search button icon.', 'shopbuilder-pro' ),
			'default'     => [
				'value'   => 'rtsb-icon rtsb-icon-search',
				'library' => 'rtsb-fonts',
			],
			'condition'   => [
				'search_submit' => [ 'icon' ],
				'search_form'   => [ 'yes' ],
			],
		];

		$fields['search_settings_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Accordion section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function accordion_settings( $obj ) {
		$fields['accordion_settings_section'] = $obj->start_section(
			esc_html__( 'Accordion Settings', 'shopbuilder-pro' ),
			'settings'
		);

		$fields['collapse_mode'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Filter Accordion Mode?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable filter title accordion mode.', 'shopbuilder-pro' ),
			'separator'   => 'default',
		];

		$fields['collapse_mode_mobile'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Filter Accordion Mode on Mobile?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable filter title accordion mode on mobile.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'default'     => 'yes',
			'conditions'  => [
				'relation' => 'or',
				'terms'    => [
					[
						'name'     => 'toggle_btn_mobile',
						'operator' => '!=',
						'value'    => 'yes',
					],
					[
						'name'     => 'toggle_btn',
						'operator' => '==',
						'value'    => 'yes',
					],
				],
			],
		];

		$fields['collapse_open_mode'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Accordion Default Behavior', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Specify the accordion default open behavior.', 'shopbuilder-pro' ),
			'options'     => [
				'all'   => esc_html__( 'All Expand', 'shopbuilder-pro' ),
				'one'   => esc_html__( 'All Collapse except First Filter', 'shopbuilder-pro' ),
				'close' => esc_html__( 'All Collapse', 'shopbuilder-pro' ),
			],
			'default'     => 'one',
			'label_block' => true,
			'condition'   => [ 'collapse_mode' => 'yes' ],
		];

		$fields['close_collapsed'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Close Accordion When Filtered?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable closing accordion when filtered.', 'shopbuilder-pro' ),
			'condition'   => [ 'collapse_mode' => 'yes' ],
		];

		$fields['collapse_behavior'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Accordion Mode', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Specify the accordion mode when clicked.', 'shopbuilder-pro' ),
			'options'     => [
				'all' => esc_html__( 'Multi-Expand Mode', 'shopbuilder-pro' ),
				'one' => esc_html__( 'Single-Expand / Auto-Collapse Mode', 'shopbuilder-pro' ),
			],
			'default'     => 'all',
			'label_block' => true,
			'condition'   => [
				'collapse_mode'       => 'yes',
				'collapse_open_mode!' => 'all',
			],
		];

		$fields['floating_mode'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Floating Mode?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable floating mode.', 'shopbuilder-pro' ),
			'condition'   => [
				'collapse_mode' => 'yes',
				'layout'        => 'horizontal',
			],
		];

		$fields['container_mode'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Activate Container Mode?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to activate mode.', 'shopbuilder-pro' ),
			'condition'   => [
				'collapse_mode' => 'yes',
				'layout'        => 'horizontal',
				'floating_mode' => 'yes',
			],
		];

		$fields['container'] = [
			'type'        => 'slider',
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Filter Container Width', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please specify the filter container width.', 'shopbuilder-pro' ),
			'size_units'  => [ 'px', '%' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 1500,
					'step' => 1,
				],
				'%'  => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'condition'   => [
				'collapse_mode'  => 'yes',
				'floating_mode'  => 'yes',
				'container_mode' => 'yes',
				'layout'         => 'horizontal',
			],
			'selectors'   => [ $obj->selectors['layout']['container'] => 'width: {{SIZE}}{{UNIT}};' ],
		];

		$fields['inner_container'] = [
			'type'        => 'slider',
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Inner Container Width', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please specify the inner container width.', 'shopbuilder-pro' ),
			'size_units'  => [ '%', 'px' ],
			'range'       => [
				'%'  => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
				'px' => [
					'min'  => 0,
					'max'  => 1500,
					'step' => 1,
				],
			],
			'condition'   => [
				'collapse_mode'  => 'yes',
				'floating_mode'  => 'yes',
				'container_mode' => 'yes',
				'layout'         => 'horizontal',
			],
			'selectors'   => [ $obj->selectors['layout']['inner_container'] => 'max-width: {{SIZE}}{{UNIT}} !important;' ],
		];

		$fields['accordion_settings_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Toggle button section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function toggle_btn_settings( $obj ) {
		$fields['toggle_btn_settings_section'] = $obj->start_section(
			esc_html__( 'Toggle Filter Button', 'shopbuilder-pro' ),
			'settings',
			[],
			[ 'layout' => [ 'horizontal' ] ]
		);

		$fields['toggle_btn'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Filter Toggle Button?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable filter toggle button.', 'shopbuilder-pro' ),
			'separator'   => 'default',
		];

		$fields['toggle_btn_text'] = [
			'label'       => esc_html__( 'Toggle Filter Button Text', 'shopbuilder-pro' ),
			'type'        => 'text',
			'description' => esc_html__( 'Enter the toggle filter button text.', 'shopbuilder-pro' ),
			'label_block' => true,
			'default'     => esc_html__( 'Filter', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'condition'   => [ 'toggle_btn' => [ 'yes' ] ],
		];

		$fields['toggle_btn_icon'] = [
			'type'        => 'icons',
			'label'       => esc_html__( 'Choose Toggle Button Icon', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the filter icon.', 'shopbuilder-pro' ),
			'default'     => [
				'value'   => 'rtsb-icon rtsb-icon-filter',
				'library' => 'rtsb-fonts',
			],
			'separator'   => 'default',
			'condition'   => [ 'toggle_btn' => [ 'yes' ] ],
		];

		$fields['toggle_btn_settings_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Toggle button section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function apply_filters_btn_settings( $obj ) {
		$fields['apply_filters_btn_settings_section'] = $obj->start_section(
			esc_html__( 'Apply Filters Button', 'shopbuilder-pro' ),
			'settings'
		);

		$fields['apply_filters_btn'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Apply Filters Button?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable apply filters button.', 'shopbuilder-pro' ),
			'separator'   => 'default',
		];

		$fields['apply_filters_btn_text'] = [
			'label'       => esc_html__( 'Apply Filters Button Text', 'shopbuilder-pro' ),
			'type'        => 'text',
			'description' => esc_html__( 'Enter the apply filters button text.', 'shopbuilder-pro' ),
			'label_block' => true,
			'default'     => esc_html__( 'Apply Filters', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'condition'   => [ 'apply_filters_btn' => [ 'yes' ] ],
		];

		$fields['apply_filters_btn_icon'] = [
			'type'        => 'icons',
			'label'       => esc_html__( 'Choose Button Icon', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the button icon.', 'shopbuilder-pro' ),
			'default'     => [
				'value'   => 'fas fa-filter',
				'library' => 'fa-solid',
			],
			'separator'   => 'default',
			'condition'   => [ 'apply_filters_btn' => [ 'yes' ] ],
		];

		$fields['apply_filters_btn_settings_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * More/less button section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function more_less_btn( $obj ) {
		$fields['more_less_btn_section'] = $obj->start_section(
			esc_html__( 'More / Less Button', 'shopbuilder-pro' ),
			'settings',
			[],
			[ 'enable_scroll!' => [ 'yes' ] ]
		);

		$fields['more_less_btn'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show More / Less Button?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable more / less button (Only works with checkbox and radio).', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'condition'   => [ 'enable_scroll!' => [ 'yes' ] ],
		];

		$fields['more_less_items'] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Default Item Lines Count', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please specify default item lines count.', 'shopbuilder-pro' ),
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'default'     => [
				'unit' => 'px',
				'size' => 5,
			],
			'separator'   => 'default',
			'condition'   => [
				'more_less_btn'  => [ 'yes' ],
				'enable_scroll!' => [ 'yes' ],
			],
		];

		$fields['more_text'] = [
			'type'        => 'text',
			'label'       => esc_html__( '\'More\' Text', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please enter the \'More\' text.', 'shopbuilder-pro' ),
			'default'     => esc_html__( '+ More', 'shopbuilder-pro' ),
			'label_block' => true,
			'separator'   => 'default',
			'condition'   => [
				'more_less_btn'  => [ 'yes' ],
				'enable_scroll!' => [ 'yes' ],
			],
		];

		$fields['less_text'] = [
			'type'        => 'text',
			'label'       => esc_html__( '\'Less\' Text', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please enter the \'Less\' text.', 'shopbuilder-pro' ),
			'default'     => esc_html__( '- Less', 'shopbuilder-pro' ),
			'label_block' => true,
			'separator'   => 'default',
			'condition'   => [
				'more_less_btn'  => [ 'yes' ],
				'enable_scroll!' => [ 'yes' ],
			],
		];

		$fields['more_less_btn_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Filters scrolling section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function filter_scrolling( $obj ) {
		$fields['filter_scrolling_section'] = $obj->start_section(
			esc_html__( 'Filter Scrolling', 'shopbuilder-pro' ),
			'settings',
			[],
			[ 'more_less_btn!' => [ 'yes' ] ]
		);

		$fields['enable_scroll'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Items Scrolling?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable filter items scrolling (Only works with checkbox and radio).', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'condition'   => [ 'more_less_btn!' => [ 'yes' ] ],
		];

		$fields['scroll_height'] = [
			'type'        => 'slider',
			'label'       => esc_html__( 'Scroll Height', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please specify the filter height for scrolling.', 'shopbuilder-pro' ),
			'size_units'  => [ 'px' ],
			'range'       => [
				'px' => [
					'min'  => 0,
					'max'  => 600,
					'step' => 1,
				],
			],
			'default'     => [
				'unit' => 'px',
				'size' => 300,
			],
			'separator'   => 'default',
			'condition'   => [
				'enable_scroll'  => [ 'yes' ],
				'more_less_btn!' => [ 'yes' ],
			],
		];

		$fields['filter_scrolling_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Reset button section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function reset_btn_settings( $obj ) {
		$fields['reset_btn_settings_section'] = $obj->start_section(
			esc_html__( 'Reset Button', 'shopbuilder-pro' ),
			'settings'
		);

		$fields['reset_btn'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Show Reset Filter Button?', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable reset filter button.', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'default'     => 'yes',
		];

		$fields['reset_btn_behavior'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Reset Button Behavior', 'shopbuilder-pro' ),
			'options'     => [
				'show' => esc_html__( 'Always Show', 'shopbuilder-pro' ),
				'hide' => esc_html__( 'Only When Filter Applied', 'shopbuilder-pro' ),
			],
			'label_block' => true,
			'description' => esc_html__( 'Specify the reset button behavior.', 'shopbuilder-pro' ),
			'default'     => 'hide',
			'separator'   => 'default',
			'condition'   => [ 'reset_btn' => [ 'yes' ] ],
		];

		$fields['reset_btn_text'] = [
			'label'       => esc_html__( 'Reset Filter Button Text', 'shopbuilder-pro' ),
			'type'        => 'text',
			'description' => esc_html__( 'Enter the reset filter button text.', 'shopbuilder-pro' ),
			'label_block' => true,
			'default'     => esc_html__( 'Reset Filter', 'shopbuilder-pro' ),
			'separator'   => 'default',
			'condition'   => [ 'reset_btn' => [ 'yes' ] ],
		];

		$fields['reset_btn_settings_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Filters styles section
	 *
	 * @param object $obj Reference object.
	 * @return array
	 */
	public static function filter_styles( $obj ) {
		return self::color( $obj )
			+ self::filter_header( $obj )
			+ self::filter_title( $obj )
			+ self::filter_items( $obj )
			+ self::search_form( $obj )
			+ self::checkbox( $obj )
			+ self::radio( $obj )
			+ self::other_inputs( $obj )
			+ self::price_slider( $obj )
			+ self::rating( $obj )
			+ self::toggle_btn( $obj )
			+ self::apply_btn( $obj )
			+ self::reset_btn( $obj )
			+ self::active_filters( $obj )
			+ self::filter_groups( $obj );
	}

	/**
	 * Filters colors section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function color( $obj ) {
		$css_selectors = $obj->selectors['color_scheme'];

		$fields['color_section'] = $obj->start_section(
			esc_html__( 'Color Scheme', 'shopbuilder-pro' ),
			'style'
		);

		$fields['primary_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Primary Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'default'   => '#0066ff',
			'selectors' => [
				$css_selectors['primary_color'] => '--rtsb-color-primary: {{VALUE}}',
			],
		];

		$fields['secondary_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Secondary Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'default'   => '#111',
			'selectors' => [
				$css_selectors['secondary_color'] => '--rtsb-color-secondary: {{VALUE}}',
			],
		];

		$fields['color_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Filter Title Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function filter_header( $obj ) {
		$css_selectors = $obj->selectors['filter_header'];
		$title         = esc_html__( 'Filter Header', 'shopbuilder-pro' );
		$condition     = [
			'show_filter_header' => [ 'yes' ],
		];
		$selectors     = [
			'typography' => $css_selectors['typography'],
			'alignment'  => [ $css_selectors['alignment'] => 'text-align: {{VALUE}};' ],
			'color'      => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'bg_color'   => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}};' ],
			'border'     => $css_selectors['border'],
			'padding'    => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
			'margin'     => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
		];

		$fields = ControlHelper::general_elementor_style( 'filter_header', $title, $obj, $condition, $selectors );

		unset(
			$fields['filter_header_color_tabs'],
			$fields['filter_header_color_tab'],
			$fields['filter_header_color_tab_end'],
			$fields['filter_header_hover_color_tab'],
			$fields['filter_header_hover_color'],
			$fields['filter_header_hover_bg_color'],
			$fields['filter_header_hover_color_tab_end'],
			$fields['filter_header_color_tabs_end'],
			$fields['filter_header_border_hover_color']
		);

		return $fields;
	}

	/**
	 * Filter Title Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function filter_title( $obj ) {
		$css_selectors = $obj->selectors['filter_title'];
		$title         = esc_html__( 'Filter Title', 'shopbuilder-pro' );
		$selectors     = [
			'typography'            => $css_selectors['typography'],
			'icon_size'             => [ $css_selectors['icon_size'] => 'font-size: {{SIZE}}{{UNIT}};' ],
			'alignment'             => [ $css_selectors['alignment'] => 'justify-content: {{VALUE}};' ],
			'color'                 => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'bg_color'              => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}};' ],
			'hover_color'           => [ $css_selectors['hover_color'] => 'color: {{VALUE}};' ],
			'hover_bg_color'        => [ $css_selectors['hover_bg_color'] => 'background-color: {{VALUE}};' ],
			'title_active_color'    => [ $css_selectors['title_active_color'] => 'color: {{VALUE}}; border-color: {{VALUE}};' ],
			'title_active_bg_color' => [ $css_selectors['title_active_bg_color'] => 'background-color: {{VALUE}};' ],
			'border'                => $css_selectors['border'],
			'border_hover_color'    => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}};' ],
			'padding'               => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'active_padding'        => [ $css_selectors['active_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
			'margin'                => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'icon_margin'           => [ $css_selectors['icon_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'border_radius'         => [ $css_selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields = ControlHelper::general_elementor_style( 'filter_title', $title, $obj, [], $selectors );

		$fields['filter_title_alignment']['separator'] = 'default';

		$extra_controls = [];

		$extra_controls['title_icon_size'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Title Icon Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['icon_size'],
		];

		$extra_controls['collapse_icon_size'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Collapse Icon Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => [ $css_selectors['collapse_icon_size'] => 'width: {{SIZE}}{{UNIT}};' ],
			'condition'  => [ 'collapse_mode' => 'yes' ],
		];

		$extra_controls['collapse_icon_position'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Collapse Icon Position Offset', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => [ $css_selectors['collapse_icon_position'] => 'right: {{SIZE}}{{UNIT}};' ],
			'condition'  => [
				'collapse_mode'        => 'yes',
				'title_icon_alignment' => 'right',
			],
		];

		$extra_controls['title_icon_preset'] = [
			'type'      => 'choose',
			'label'     => esc_html__( 'Collapse Icon Preset', 'shopbuilder-pro' ),
			'options'   => [
				'plus'  => [
					'title' => esc_html__( 'Plus/Minus', 'shopbuilder-pro' ),
					'icon'  => 'eicon-plus',
				],
				'arrow' => [
					'title' => esc_html__( 'Arrow', 'shopbuilder-pro' ),
					'icon'  => 'eicon-arrow-down',
				],
			],
			'default'   => 'plus',
			'condition' => [ 'collapse_mode' => 'yes' ],
		];

		$extra_controls['title_icon_alignment'] = [
			'type'      => 'choose',
			'label'     => esc_html__( 'Collapse Icon Alignment', 'shopbuilder-pro' ),
			'options'   => [
				'left'  => [
					'title' => esc_html__( 'Left', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-left',
				],
				'right' => [
					'title' => esc_html__( 'Right', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-right',
				],
			],
			'condition' => [ 'collapse_mode' => 'yes' ],
		];

		$fields = Fns::insert_controls( 'filter_title_alignment', $fields, $extra_controls, false );

		$active_condition = [
			'collapse_mode' => 'yes',
		];

		$extra_controls['filter_title_active_color_tab'] = $obj->start_tab( esc_html__( 'Active', 'shopbuilder-pro' ), [], $active_condition );

		$extra_controls['title_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'condition' => $active_condition,
			'selectors' => $selectors['title_active_color'],
		];

		$extra_controls['title_active_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'condition' => $active_condition,
			'selectors' => $selectors['title_active_bg_color'],
		];

		$fields['filter_title_active_color_tab_end'] = $obj->end_tab();

		$fields = Fns::insert_controls( 'filter_title_color_tabs_end', $fields, $extra_controls );

		$extra_controls['title_border_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['border_radius'],
		];

		$extra_controls['active_padding'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Active Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'condition'  => $active_condition,
			'selectors'  => $selectors['active_padding'],
		];

		$extra_controls['icon_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Icon Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['icon_margin'],
		];

		return Fns::insert_controls( 'filter_title_margin', $fields, $extra_controls, true );
	}

	/**
	 * Filter Items Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function filter_items( $obj ) {
		$css_selectors = $obj->selectors['filter_items'];
		$title         = esc_html__( 'Filter Items', 'shopbuilder-pro' );
		$selectors     = [
			'typography'          => $css_selectors['typography'],
			'count_display'       => [ $css_selectors['count_display'] => 'display: {{VALUE}};' ],
			'count_alignment'     => [ $css_selectors['count_alignment'] => 'justify-content: {{VALUE}};' ],
			'color'               => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'bg_color'            => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}};' ],
			'count_color'         => [ $css_selectors['count_color'] => 'color: {{VALUE}};' ],
			'hover_color'         => [ $css_selectors['hover_color'] => 'color: {{VALUE}};' ],
			'hover_bg_color'      => [ $css_selectors['hover_bg_color'] => 'background-color: {{VALUE}};' ],
			'hover_count_color'   => [ $css_selectors['hover_count_color'] => 'color: {{VALUE}};' ],
			'active_color'        => [ $css_selectors['active_color'] => 'color: {{VALUE}};' ],
			'active_bg_color'     => [ $css_selectors['active_bg_color'] => 'background-color: {{VALUE}};' ],
			'active_count_color'  => [ $css_selectors['active_count_color'] => 'color: {{VALUE}};' ],
			'border'              => $css_selectors['border'],
			'border_hover_color'  => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}};' ],
			'border_active_color' => [ $css_selectors['border_active_color'] => 'border-color: {{VALUE}} !important;' ],
			'padding'             => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'margin'              => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'wrapper_padding'     => [ $css_selectors['wrapper_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'wrapper_margin'      => [ $css_selectors['wrapper_margin'] => 'margin-top: {{TOP}}{{UNIT}} !important; margin-bottom: {{BOTTOM}}{{UNIT}} !important;' ],
			'subcat_margin'       => [ $css_selectors['subcat_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields = ControlHelper::general_elementor_style( 'filter_items', $title, $obj, [], $selectors );

		unset( $fields['filter_items_alignment'] );

		$fields['filter_items_typo_note']['raw']    = '<h3 class="rtsb-elementor-group-heading">' . esc_html__( 'Label Typography', 'shopbuilder-pro' ) . '</h3>';
		$fields['filter_items_color_note']['raw']   = '<h3 class="rtsb-elementor-group-heading">' . esc_html__( 'Label Colors', 'shopbuilder-pro' ) . '</h3>';
		$fields['filter_items_border_note']['raw']  = '<h3 class="rtsb-elementor-group-heading">' . esc_html__( 'Item Border', 'shopbuilder-pro' ) . '</h3>';
		$fields['filter_items_spacing_note']['raw'] = '<h3 class="rtsb-elementor-group-heading">' . esc_html__( 'Item Spacing', 'shopbuilder-pro' ) . '</h3>';

		$extra_controls = [];

		$extra_controls['count_note'] = $obj->el_heading( esc_html__( 'Product Count', 'shopbuilder-pro' ), 'before' );

		$extra_controls['count_display'] = [
			'mode'      => 'responsive',
			'type'      => 'choose',
			'label'     => esc_html__( 'Display', 'shopbuilder-pro' ),
			'options'   => [
				'block' => [
					'title' => esc_html__( 'Show', 'shopbuilder-pro' ),
					'icon'  => 'eicon-check',
				],
				'none'  => [
					'title' => esc_html__( 'Hide', 'shopbuilder-pro' ),
					'icon'  => 'eicon-close',
				],
			],
			'separator' => 'default',
			'default'   => 'block',
			'selectors' => ! empty( $selectors['count_display'] ) ? $selectors['count_display'] : [],
		];

		$extra_controls['count_alignment'] = [
			'type'      => 'choose',
			'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
			'options'   => [
				'flex-start'    => [
					'title' => esc_html__( 'Left', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-left',
				],
				'space-between' => [
					'title' => esc_html__( 'Right', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-right',
				],
			],
			'selectors' => ! empty( $selectors['count_alignment'] ) ? $selectors['count_alignment'] : [],
		];

		$fields = Fns::insert_controls( 'filter_items_color_note', $fields, $extra_controls );

		$extra_controls['count_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Count Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['count_color'],
		];

		$fields = Fns::insert_controls( 'filter_items_bg_color', $fields, $extra_controls, true );

		$extra_controls['count_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Count Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['hover_count_color'],
		];

		$fields = Fns::insert_controls( 'filter_items_hover_bg_color', $fields, $extra_controls, true );

		$extra_controls['product_filters_active_color_tab'] = $obj->start_tab( esc_html__( 'Active', 'shopbuilder-pro' ) );

		$extra_controls['active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['active_color'],
			'separator' => 'default',
		];

		$extra_controls['active_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Background Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['active_bg_color'],
			'separator' => 'default',
		];

		$extra_controls['active_count_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Count Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['active_count_color'],
			'separator' => 'default',
		];

		$extra_controls['product_filters_active_color_tab_end'] = $obj->end_tab();

		$fields = Fns::insert_controls( 'filter_items_hover_color_tab_end', $fields, $extra_controls, true );

		$extra_controls['active_border_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Border Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['border_active_color'],
			'separator' => 'default',
			'condition' => [ 'rtsb_el_filter_items_border_border!' => [ '' ] ],
		];

		$fields = Fns::insert_controls( 'filter_items_border_hover_color', $fields, $extra_controls, true );

		$extra_controls['wrapper_padding'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Wrapper Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['wrapper_padding'],
		];

		$extra_controls['wrapper_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Wrapper Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['wrapper_margin'],
		];

		$extra_controls['subcat_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Sub-Categories Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['subcat_margin'],
		];

		$fields = Fns::insert_controls( 'filter_items_margin', $fields, $extra_controls, true );

		return $fields;
	}

	/**
	 * Search Form Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function search_form( $obj ) {
		$css_selectors = $obj->selectors['search_styles'];
		$title         = esc_html__( 'Search Form', 'shopbuilder-pro' );
		$condition     = [ 'search_form' => 'yes' ];
		$selectors     = [
			'typography'                => $css_selectors['typography'],
			'button_typography'         => $css_selectors['button_typography'],
			'icon_typography'           => $css_selectors['icon_typography'],
			'placeholder_typography'    => $css_selectors['placeholder_typography'],
			'search_input_height'       => [ $css_selectors['search_input_height'] => 'height: {{SIZE}}{{UNIT}};' ],
			'search_button_width'       => [ $css_selectors['search_button_width'] => 'width: {{SIZE}}{{UNIT}};' ],
			'search_button_height'      => [ $css_selectors['search_button_height'] => 'height: {{SIZE}}{{UNIT}};' ],
			'search_icon_width'         => [ $css_selectors['search_icon_width'] => 'width: {{SIZE}}{{UNIT}};' ],
			'search_icon_height'        => [ $css_selectors['search_icon_height'] => 'height: {{SIZE}}{{UNIT}};' ],
			'color'                     => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'bg_color'                  => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}};' ],
			'button_color'              => [ $css_selectors['button_color'] => 'color: {{VALUE}};' ],
			'button_bg_color'           => [ $css_selectors['button_bg_color'] => 'background-color: {{VALUE}};' ],
			'placeholder_color'         => [ $css_selectors['placeholder_color'] => 'color: {{VALUE}};' ],
			'hover_color'               => [ $css_selectors['hover_color'] => 'color: {{VALUE}};' ],
			'hover_bg_color'            => [ $css_selectors['hover_bg_color'] => 'background-color: {{VALUE}};' ],
			'hover_button_color'        => [ $css_selectors['hover_button_color'] => 'color: {{VALUE}};' ],
			'hover_button_bg_color'     => [ $css_selectors['hover_button_bg_color'] => 'background-color: {{VALUE}};' ],
			'border'                    => $css_selectors['border'],
			'button_border'             => $css_selectors['button_border'],
			'border_hover_color'        => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}};' ],
			'active_border_color'       => [ $css_selectors['active_border_color'] => 'border-color: {{VALUE}};' ],
			'button_border_hover_color' => [ $css_selectors['button_border_hover_color'] => 'border-color: {{VALUE}};' ],
			'input_border_radius'       => [ $css_selectors['input_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'button_border_radius'      => [ $css_selectors['button_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'search_clear_offset'       => [ $css_selectors['search_clear_offset'] => '--rtsb-search-padding-right: {{SIZE}}{{UNIT}};' ],
			'padding'                   => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'margin'                    => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'button_padding'            => [ $css_selectors['button_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'button_margin'             => [ $css_selectors['button_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'title_padding'             => [ $css_selectors['title_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'title_margin'              => [ $css_selectors['title_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'wrapper_margin'            => [ $css_selectors['wrapper_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields = ControlHelper::general_elementor_style( 'search_styles', $title, $obj, $condition, $selectors );

		unset(
			$fields['search_styles_alignment']
		);

		$fields['rtsb_el_search_styles_typography']['label'] = esc_html__( 'Input Typography', 'shopbuilder-pro' );
		$fields['search_styles_color']['label']              = esc_html__( 'Input Color', 'shopbuilder-pro' );
		$fields['search_styles_bg_color']['label']           = esc_html__( 'Input Background Color', 'shopbuilder-pro' );
		$fields['search_styles_hover_color']['label']        = esc_html__( 'Input Hover Color', 'shopbuilder-pro' );
		$fields['search_styles_hover_bg_color']['label']     = esc_html__( 'Input Hover Background Color', 'shopbuilder-pro' );
		$fields['search_styles_border_hover_color']['label'] = esc_html__( 'Input Hover Border Color', 'shopbuilder-pro' );
		$fields['search_styles_padding']['label']            = esc_html__( 'Input Padding', 'shopbuilder-pro' );
		$fields['search_styles_margin']['label']             = esc_html__( 'Input Margin', 'shopbuilder-pro' );

		$fields['rtsb_el_search_styles_border']['fields_options'] = [
			'border' => [
				'label'       => esc_html__( 'Input Border Type', 'shopbuilder-pro' ),
				'label_block' => true,
			],
			'width'  => [
				'label' => esc_html__( 'Input Border Width', 'shopbuilder-pro' ),
			],
			'color'  => [
				'label' => esc_html__( 'Input Border Color', 'shopbuilder-pro' ),
			],
		];

		$extra_controls = [];

		$extra_controls['rtsb_el_search_button_typography'] = [
			'mode'      => 'group',
			'label'     => esc_html__( 'Button Typography', 'shopbuilder-pro' ),
			'type'      => 'typography',
			'selector'  => ! empty( $selectors['button_typography'] ) ? $selectors['button_typography'] : [],
			'condition' => [ 'search_submit' => 'text' ],
		];

		$extra_controls['rtsb_el_search_icon_typography'] = [
			'mode'      => 'group',
			'label'     => esc_html__( 'Icon Typography', 'shopbuilder-pro' ),
			'type'      => 'typography',
			'selector'  => ! empty( $selectors['icon_typography'] ) ? $selectors['icon_typography'] : [],
			'condition' => [ 'search_submit' => 'icon' ],
		];

		$extra_controls['rtsb_el_search_placeholder_typography'] = [
			'mode'     => 'group',
			'label'    => esc_html__( 'Placeholder Typography', 'shopbuilder-pro' ),
			'type'     => 'typography',
			'selector' => ! empty( $selectors['placeholder_typography'] ) ? $selectors['placeholder_typography'] : [],
		];

		$extra_controls['search_dimension_note'] = $obj->el_heading(
			esc_html__( 'Dimensions', 'shopbuilder-pro' ),
			'before-short'
		);

		$extra_controls['search_input_height'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Input Height', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'selectors'  => $selectors['search_input_height'],
		];

		$extra_controls['search_button_width'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Button Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 300,
					'step' => 1,
				],
			],
			'selectors'  => $selectors['search_button_width'],
		];

		$extra_controls['search_button_height'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Button Height', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'selectors'  => $selectors['search_button_height'],
		];

		$extra_controls['search_icon_width'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Icon Width (for SVG Icons)', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 300,
					'step' => 1,
				],
			],
			'selectors'  => $selectors['search_icon_width'],
			'condition'  => [ 'search_submit' => 'icon' ],
		];

		$extra_controls['search_icon_height'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Icon Height (for SVG Icons)', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'selectors'  => $selectors['search_icon_height'],
			'condition'  => [ 'search_submit' => 'icon' ],
		];

		$fields = Fns::insert_controls( 'rtsb_el_search_styles_typography', $fields, $extra_controls, true );

		$extra_controls['search_styles_button_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Button/Icon Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['button_color'],
		];

		$extra_controls['search_styles_button_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Button/Icon Background Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['button_bg_color'],
		];

		$extra_controls['search_styles_placeholder_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Placeholder Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['placeholder_color'],
		];

		$fields = Fns::insert_controls( 'search_styles_bg_color', $fields, $extra_controls, true );

		$extra_controls['search_styles_hover_button_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Button/Icon Hover Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['hover_button_color'],
		];

		$extra_controls['search_styles_hover_button_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Button/Icon Hover Background Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['hover_button_bg_color'],
		];

		$fields = Fns::insert_controls( 'search_styles_hover_bg_color', $fields, $extra_controls, true );

		$extra_controls['search_styles_border_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Border Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['active_border_color'],
		];

		$fields = Fns::insert_controls( 'search_styles_border_hover_color', $fields, $extra_controls, true );

		$extra_controls['search_input_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Input Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['input_border_radius'],
		];

		$extra_controls['rtsb_el_search_styles_button_border'] = [
			'mode'           => 'group',
			'type'           => 'border',
			'label'          => esc_html__( 'Border', 'shopbuilder-pro' ),
			'selector'       => $selectors['button_border'],
			'fields_options' => [
				'border' => [
					'label'       => esc_html__( 'Button Border Type', 'shopbuilder-pro' ),
					'label_block' => true,
				],
				'width'  => [
					'label' => esc_html__( 'Button Border Width', 'shopbuilder-pro' ),
				],
				'color'  => [
					'label' => esc_html__( 'Button Border Color', 'shopbuilder-pro' ),
				],
			],
			'separator'      => 'before-short',
		];

		$extra_controls['search_styles_button_border_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Button Hover Border Color', 'shopbuilder-pro' ),
			'condition' => [ 'rtsb_el_search_styles_button_border_border!' => [ '' ] ],
			'selectors' => $selectors['button_border_hover_color'],
		];

		$extra_controls['search_button_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Button Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['button_border_radius'],
		];

		$fields = Fns::insert_controls( 'search_styles_spacing_note', $fields, $extra_controls );

		$extra_controls['search_clear_offset'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Clear Icon Right Spacing', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'selectors'  => $selectors['search_clear_offset'],
		];

		$fields = Fns::insert_controls( 'search_styles_spacing_note', $fields, $extra_controls, true );

		$extra_controls['search_styles_button_padding'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Button Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['button_padding'],
			'separator'  => 'before-short',
		];

		$extra_controls['search_styles_button_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Button Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['button_margin'],
		];

		$extra_controls['search_styles_title_padding'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Title Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['title_padding'],
			'separator'  => 'before-short',
		];

		$extra_controls['search_styles_title_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Title Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['title_margin'],
		];

		$extra_controls['search_styles_wrapper_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Wrapper Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['wrapper_margin'],
		];

		return Fns::insert_controls( 'search_styles_margin', $fields, $extra_controls, true );
	}

	/**
	 * Checkbox Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function checkbox( $obj ) {
		$css_selectors = $obj->selectors['checkbox'];
		$selectors     = [
			'checkbox_size'             => [ $css_selectors['checkbox_size'] => 'padding: {{SIZE}}{{UNIT}};' ],
			'check_width'               => [ $css_selectors['check_width'] => 'width: {{SIZE}}{{UNIT}};' ],
			'check_height'              => [ $css_selectors['check_height'] => 'height: {{SIZE}}{{UNIT}};' ],
			'check_border'              => [ $css_selectors['check_border'] => 'border-width: {{SIZE}}{{UNIT}};' ],
			'checkmark_border'          => [ $css_selectors['checkmark_border'] => 'border-right-width: {{SIZE}}{{UNIT}}; border-bottom-width: {{SIZE}}{{UNIT}};' ],
			'check_h_alignment'         => [ $css_selectors['check_h_alignment'] => 'left: {{SIZE}}{{UNIT}};' ],
			'check_v_alignment'         => [ $css_selectors['check_v_alignment'] => 'top: {{SIZE}}{{UNIT}};' ],
			'border_color'              => [ $css_selectors['border_color'] => 'border-color: {{VALUE}};' ],
			'border_bg_color'           => [ $css_selectors['border_bg_color'] => 'background-color: {{VALUE}};' ],
			'check_border_color'        => [ $css_selectors['check_border_color'] => 'border-color: {{VALUE}};' ],
			'check_bg_color'            => [ $css_selectors['check_bg_color'] => 'background-color: {{VALUE}};' ],
			'outline_color'             => [ $css_selectors['outline_color'] => 'outline: 1px solid {{VALUE}};' ],
			'border_hover_color'        => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}} !important;' ],
			'border_hover_bg_color'     => [ $css_selectors['border_hover_bg_color'] => 'background-color: {{VALUE}} !important;' ],
			'check_border_hover_color'  => [ $css_selectors['check_border_hover_color'] => 'border-color: {{VALUE}} !important;' ],
			'check_hover_bg_color'      => [ $css_selectors['check_hover_bg_color'] => 'background-color: {{VALUE}} !important;' ],
			'border_active_color'       => [ $css_selectors['border_active_color'] => 'border-color: {{VALUE}};' ],
			'border_active_bg_color'    => [ $css_selectors['border_active_bg_color'] => 'background-color: {{VALUE}};' ],
			'check_border_active_color' => [ $css_selectors['check_border_active_color'] => 'border-color: {{VALUE}};' ],
			'check_active_bg_color'     => [ $css_selectors['check_active_bg_color'] => 'background-color: {{VALUE}} !important;' ],
			'border_radius'             => [ $css_selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'checkbox_margin'           => [ $css_selectors['checkbox_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields['checkbox_section'] = $obj->start_section(
			esc_html__( 'Checkbox Styles', 'shopbuilder-pro' ),
			'style'
		);

		$fields['checkbox_size_note'] = $obj->el_heading(
			esc_html__( 'Size', 'shopbuilder-pro' ),
			'default'
		);

		$fields['checkbox_size'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Checkbox Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['checkbox_size'],
		];

		$fields['check_width'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Check Mark Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['check_width'],
		];

		$fields['check_height'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Check Mark Height', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['check_height'],
		];

		$fields['check_border'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Checkbox Border Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['check_border'],
		];

		$fields['checkmark_border'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Check Mark Border Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['checkmark_border'],
		];

		$fields['checkbox_alignment_note'] = $obj->el_heading(
			esc_html__( 'Alignment', 'shopbuilder-pro' ),
			'default'
		);

		$fields['check_h_alignment'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Check Mark Horizontal Alignment', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['check_h_alignment'],
		];

		$fields['check_v_alignment'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Check Mark Vertical Alignment', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['check_v_alignment'],
		];

		$fields['checkbox_color_note'] = $obj->el_heading(
			esc_html__( 'Color', 'shopbuilder-pro' ),
			'default'
		);

		$fields['checkbox_color_tabs'] = $obj->start_tab_group();
		$fields['checkbox_color_tab']  = $obj->start_tab( esc_html__( 'Normal', 'shopbuilder-pro' ) );

		$fields['border_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Border Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['border_color'],
		];

		$fields['border_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['border_bg_color'],
		];

		$fields['check_border_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Check Mark Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['check_border_color'],
		];

		$fields['check_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Check Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['check_bg_color'],
		];

		$fields['outline_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Outline Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['outline_color'],
		];

		$fields['checkbox_color_tab_end']   = $obj->end_tab();
		$fields['checkbox_hover_color_tab'] = $obj->start_tab( esc_html__( 'Hover', 'shopbuilder-pro' ) );

		$fields['border_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Border Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['border_hover_color'],
		];

		$fields['border_hover_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['border_hover_bg_color'],
		];

		$fields['check_border_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Check Mark Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['check_border_hover_color'],
		];

		$fields['check_hover_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Check Hover Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['check_hover_bg_color'],
		];

		$fields['checkbox_hover_color_tab_end'] = $obj->end_tab();
		$fields['checkbox_active_color_tab']    = $obj->start_tab( esc_html__( 'Active', 'shopbuilder-pro' ) );

		$fields['border_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Border Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['border_active_color'],
		];

		$fields['border_active_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['border_active_bg_color'],
		];

		$fields['check_border_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Check Mark Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['check_border_active_color'],
		];

		$fields['check_active_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Check Active Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['check_active_bg_color'],
		];

		$fields['checkbox_active_color_tab_end'] = $obj->end_tab();
		$fields['checkbox_color_tabs_end']       = $obj->end_tab_group();

		$fields['checkbox_spacing_note'] = $obj->el_heading( esc_html__( 'Spacing', 'shopbuilder-pro' ), 'before' );

		$fields['checkbox_border_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['border_radius'],
		];

		$fields['checkbox_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'separator'  => 'default',
			'selectors'  => $selectors['checkbox_margin'],
		];

		$fields['checkbox_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Radio Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function radio( $obj ) {
		$css_selectors = $obj->selectors['radio'];
		$selectors     = [
			'radio_size'                   => [ $css_selectors['radio_size'] => 'padding: {{SIZE}}{{UNIT}};' ],
			'dot_size'                     => [ $css_selectors['dot_size'] => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};' ],
			'radio_border'                 => [ $css_selectors['radio_border'] => 'border-width: {{SIZE}}{{UNIT}};' ],
			'dot_h_alignment'              => [ $css_selectors['dot_h_alignment'] => 'left: {{SIZE}}{{UNIT}};' ],
			'dot_v_alignment'              => [ $css_selectors['dot_v_alignment'] => 'top: {{SIZE}}{{UNIT}};' ],
			'radio_border_color'           => [ $css_selectors['radio_border_color'] => 'border-color: {{VALUE}};' ],
			'radio_border_bg_color'        => [ $css_selectors['radio_border_bg_color'] => 'background-color: {{VALUE}};' ],
			'dot_border_color'             => [ $css_selectors['dot_border_color'] => 'background-color: {{VALUE}};' ],
			'radio_border_hover_color'     => [ $css_selectors['radio_border_hover_color'] => 'border-color: {{VALUE}} !important;' ],
			'radio_border_hover_bg_color'  => [ $css_selectors['radio_border_hover_bg_color'] => 'background-color: {{VALUE}} !important;' ],
			'dot_border_hover_color'       => [ $css_selectors['dot_border_hover_color'] => 'background-color: {{VALUE}} !important;' ],
			'radio_border_active_color'    => [ $css_selectors['radio_border_active_color'] => 'border-color: {{VALUE}};' ],
			'radio_border_active_bg_color' => [ $css_selectors['radio_border_active_bg_color'] => 'background-color: {{VALUE}};' ],
			'dot_border_active_color'      => [ $css_selectors['dot_border_active_color'] => 'background-color: {{VALUE}};' ],
			'radio_margin'                 => [ $css_selectors['radio_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields['radio_section'] = $obj->start_section(
			esc_html__( 'Radio Styles', 'shopbuilder-pro' ),
			'style'
		);

		$fields['radio_size_note'] = $obj->el_heading(
			esc_html__( 'Size', 'shopbuilder-pro' ),
			'default'
		);

		$fields['radio_size'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Radio Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['radio_size'],
		];

		$fields['dot_size'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Dot Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['dot_size'],
		];

		$fields['radio_border'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Radio Border Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['radio_border'],
		];

		$fields['radio_alignment_note'] = $obj->el_heading(
			esc_html__( 'Alignment', 'shopbuilder-pro' ),
			'default'
		);

		$fields['dot_h_alignment'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Dot Horizontal Alignment', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['dot_h_alignment'],
		];

		$fields['dot_v_alignment'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Dot Vertical Alignment', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 50,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['dot_v_alignment'],
		];

		$fields['dot_color_note'] = $obj->el_heading(
			esc_html__( 'Color', 'shopbuilder-pro' ),
			'default'
		);

		$fields['radio_color_tabs'] = $obj->start_tab_group();
		$fields['radio_color_tab']  = $obj->start_tab( esc_html__( 'Normal', 'shopbuilder-pro' ) );

		$fields['radio_border_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Border Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['radio_border_color'],
		];

		$fields['radio_border_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['radio_border_bg_color'],
		];

		$fields['dot_border_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Dot Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['dot_border_color'],
		];

		$fields['radio_color_tab_end']   = $obj->end_tab();
		$fields['radio_hover_color_tab'] = $obj->start_tab( esc_html__( 'Hover', 'shopbuilder-pro' ) );

		$fields['radio_border_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Border Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['radio_border_hover_color'],
		];

		$fields['radio_border_hover_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['radio_border_hover_bg_color'],
		];

		$fields['dot_border_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Dot Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['dot_border_hover_color'],
		];

		$fields['radio_hover_color_tab_end'] = $obj->end_tab();
		$fields['radio_active_color_tab']    = $obj->start_tab( esc_html__( 'Active', 'shopbuilder-pro' ) );

		$fields['radio_border_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Border Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['radio_border_active_color'],
		];

		$fields['radio_border_active_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['radio_border_active_bg_color'],
		];

		$fields['dot_border_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Dot Mark Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['dot_border_active_color'],
		];

		$fields['radio_active_color_tab_end'] = $obj->end_tab();
		$fields['radio_color_tabs_end']       = $obj->end_tab_group();

		$fields['radio_spacing_note'] = $obj->el_heading( esc_html__( 'Spacing', 'shopbuilder-pro' ), 'before' );

		$fields['radio_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'separator'  => 'default',
			'selectors'  => $selectors['radio_margin'],
		];

		$fields['radio_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Other Input Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function other_inputs( $obj ) {
		$css_selectors = $obj->selectors['other_inputs'];
		$inputs        = [ 'color', 'button', 'image' ];
		$fields        = [];

		$fields['other_inputs_section'] = $obj->start_section(
			esc_html__( 'Color/Button/Image Input Styles', 'shopbuilder-pro' ),
			'style'
		);

		foreach ( $inputs as $key => $input ) {
			$selectors = [
				$input . '_input_hover_border_color'  => [ $css_selectors[ $input . '_input_hover_border_color' ] => 'border-color: {{VALUE}};' ],
				$input . '_input_active_border_color' => [ $css_selectors[ $input . '_input_active_border_color' ] => 'border-color: {{VALUE}};' ],
			];

			$fields[ $input . '_input_note' ] = $obj->el_heading(
				ucfirst( $input ) . esc_html__( ' Input', 'shopbuilder-pro' ),
				array_keys( $inputs )[0] === $key ? 'default' : 'before-short'
			);

			if ( 'color' === $input || 'button' === $input ) {
				$fields[ $input . '_input_count_display' ] = [
					'mode'      => 'responsive',
					'type'      => 'choose',
					'label'     => esc_html__( 'Count Display', 'shopbuilder-pro' ),
					'options'   => [
						'block' => [
							'title' => esc_html__( 'Show', 'shopbuilder-pro' ),
							'icon'  => 'eicon-check',
						],
						'none'  => [
							'title' => esc_html__( 'Hide', 'shopbuilder-pro' ),
							'icon'  => 'eicon-close',
						],
					],
					'separator' => 'default',
					'default'   => 'none',
					'selectors' => [ $css_selectors[ $input . '_input_count_display' ] => 'display: {{VALUE}} !important;' ],
				];
			}

			if ( 'color' === $input ) {
				$fields[ $input . '_input_preset' ] = [
					'type'      => 'choose',
					'label'     => esc_html__( 'Appearance', 'shopbuilder-pro' ),
					'options'   => [
						'preset-1' => [
							'title' => esc_html__( 'Preset 1', 'shopbuilder-pro' ),
							'icon'  => 'preset-1',
						],
						'preset-2' => [
							'title' => esc_html__( 'Preset 2', 'shopbuilder-pro' ),
							'icon'  => 'preset-2',
						],
					],
					'separator' => 'default',
					'default'   => 'preset-1',
				];

				$fields[ $input . '_input_outline' ] = [
					'type'      => 'color',
					'label'     => esc_html__( 'Outline Color Color', 'shopbuilder-pro' ),
					'separator' => 'default',
					'default'   => '#B6B6B6',
					'condition' => [ $input . '_input_preset' => 'preset-2' ],
					'selectors' => [ $css_selectors[ $input . '_input_outline' ] => 'outline: 1px solid {{VALUE}} !important;' ],
				];
			}

			$fields[ $input . '_input_border_tabs' ] = $obj->start_tab_group();
			$fields[ $input . '_input_border_tab' ]  = $obj->start_tab( esc_html__( 'Normal', 'shopbuilder-pro' ) );

			if ( 'button' === $input ) {
				$fields[ $input . '_input_color' ] = [
					'type'      => 'color',
					'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
					'separator' => 'default',
					'selectors' => [ $css_selectors[ $input . '_input_color' ] => 'color: {{VALUE}} !important;' ],
				];
			}

			if ( 'image' === $input || 'button' === $input ) {
				$fields[ $input . '_input_bg_color' ] = [
					'type'      => 'color',
					'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
					'separator' => 'default',
					'selectors' => [ $css_selectors[ $input . '_input_bg_color' ] => 'background-color: {{VALUE}} !important;' ],
				];
			}

			$fields[ 'rtsb_el_' . $input . '_input_border' ] = [
				'mode'           => 'group',
				'type'           => 'border',
				'label'          => esc_html__( 'Border', 'shopbuilder-pro' ),
				'selector'       => $css_selectors[ $input . '_input_border' ],
				'separator'      => 'default',
				'fields_options' => [
					'color' => [
						'label' => esc_html__( 'Border Color', 'shopbuilder-pro' ),
					],
				],
			];

			$fields[ $input . '_input_border_tab_end' ]  = $obj->end_tab();
			$fields[ $input . '_input_hover_color_tab' ] = $obj->start_tab( esc_html__( 'Hover', 'shopbuilder-pro' ) );

			if ( 'button' === $input ) {
				$fields[ $input . '_input_hover_color' ] = [
					'type'      => 'color',
					'label'     => esc_html__( 'Hover Color', 'shopbuilder-pro' ),
					'separator' => 'default',
					'selectors' => [ $css_selectors[ $input . '_input_hover_color' ] => 'color: {{VALUE}} !important;' ],
				];
			}

			if ( 'image' === $input || 'button' === $input ) {
				$fields[ $input . '_input_hover_bg_color' ] = [
					'type'      => 'color',
					'label'     => esc_html__( 'Hover Background Color', 'shopbuilder-pro' ),
					'separator' => 'default',
					'selectors' => [ $css_selectors[ $input . '_input_hover_bg_color' ] => 'background-color: {{VALUE}} !important;' ],
				];
			}

			$fields[ $input . '_input_hover_border_color' ] = [
				'type'      => 'color',
				'label'     => esc_html__( 'Hover Border Color', 'shopbuilder-pro' ),
				'separator' => 'default',
				'selectors' => $selectors[ $input . '_input_hover_border_color' ],
			];

			$fields[ $input . '_input_hover_color_tab_end' ] = $obj->end_tab();
			$fields[ $input . '_input_active_color_tab' ]    = $obj->start_tab( esc_html__( 'Active', 'shopbuilder-pro' ) );

			if ( 'button' === $input ) {
				$fields[ $input . '_input_active_color' ] = [
					'type'      => 'color',
					'label'     => esc_html__( 'Active Color', 'shopbuilder-pro' ),
					'separator' => 'default',
					'selectors' => [ $css_selectors[ $input . '_input_active_color' ] => 'color: {{VALUE}} !important;' ],
				];
			}

			if ( 'image' === $input || 'button' === $input ) {
				$fields[ $input . '_input_active_bg_color' ] = [
					'type'      => 'color',
					'label'     => esc_html__( 'Active Background Color', 'shopbuilder-pro' ),
					'separator' => 'default',
					'selectors' => [ $css_selectors[ $input . '_input_active_bg_color' ] => 'background-color: {{VALUE}} !important;' ],
				];
			}

			$fields[ $input . '_input_active_border_color' ] = [
				'type'      => 'color',
				'label'     => esc_html__( 'Active Border Color', 'shopbuilder-pro' ),
				'separator' => 'default',
				'selectors' => $selectors[ $input . '_input_active_border_color' ],
			];

			$fields[ $input . '_input_active_color_tab_end' ] = $obj->end_tab();
			$fields[ $input . '_input_border_tabs_end' ]      = $obj->end_tab_group();

			$fields[ $input . '_input_radius' ] = [
				'mode'       => 'responsive',
				'type'       => 'dimensions',
				'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [ $css_selectors[ $input . '_input_radius' ] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
			];

			$fields[ $input . '_input_padding' ] = [
				'mode'       => 'responsive',
				'type'       => 'dimensions',
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'size_units' => [ 'px', '%', 'em' ],
				'separator'  => 'default',
				'selectors'  => [ $css_selectors[ $input . '_input_padding' ] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
			];

			if ( array_keys( $inputs )[0] === $key ) {
				unset( $fields[ $input . '_input_padding' ] );
			}

			$fields[ $input . '_input_margin' ] = [
				'mode'       => 'responsive',
				'type'       => 'dimensions',
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'size_units' => [ 'px', '%', 'em' ],
				'separator'  => 'default',
				'selectors'  => [ $css_selectors[ $input . '_input_margin' ] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
			];
		}

		$fields['other_inputs_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Price Slider Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function price_slider( $obj ) {
		$css_selectors = $obj->selectors['price_slider'];
		$selectors     = [
			'label_typography'               => $css_selectors['label_typography'],
			'text_typography'                => $css_selectors['text_typography'],
			'alignment'                      => [ $css_selectors['alignment'] => 'justify-content: {{VALUE}};' ],
			'handle_border'                  => $css_selectors['handle_border'],
			'price_slider_label_color'       => [
				$css_selectors['price_slider_label_color']['color'] => 'color: {{VALUE}};',
				$css_selectors['price_slider_label_color']['bg_color'] => 'background-color: {{VALUE}};',
			],
			'price_slider_line_color'        => [ $css_selectors['price_slider_line_color'] => 'background: {{VALUE}};' ],
			'price_slider_active_line_color' => [ $css_selectors['price_slider_active_line_color'] => 'background-color: {{VALUE}};' ],
			'price_slider_handle_color'      => [ $css_selectors['price_slider_handle_color'] => 'border-color: {{VALUE}};' ],
			'price_slider_handle_bg_color'   => [ $css_selectors['price_slider_handle_bg_color'] => 'background-color: {{VALUE}};' ],
			'price_slider_label_margin'      => [ $css_selectors['price_slider_label_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'price_slider_wrapper_margin'    => [ $css_selectors['price_slider_wrapper_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields['price_slider_section'] = $obj->start_section(
			esc_html__( 'Price Slider Styles', 'shopbuilder-pro' ),
			'style'
		);

		$fields['price_slider_typo_note'] = $obj->el_heading(
			esc_html__( 'Price Label', 'shopbuilder-pro' ),
			'default'
		);

		$fields['rtsb_el_price_label_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Price Label Typography', 'shopbuilder-pro' ),
			'selector' => $selectors['label_typography'],
		];

		$fields['rtsb_el_price_text_typography'] = [
			'mode'     => 'group',
			'type'     => 'typography',
			'label'    => esc_html__( 'Price Text Typography', 'shopbuilder-pro' ),
			'selector' => $selectors['text_typography'],
		];

		$fields['price_slider_alignment'] = [
			'mode'      => 'responsive',
			'type'      => 'choose',
			'label'     => esc_html__( 'Label Alignment', 'shopbuilder-pro' ),
			'options'   => [
				'left'   => [
					'title' => esc_html__( 'Left', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-center',
				],
				'right'  => [
					'title' => esc_html__( 'Right', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-right',
				],
			],
			'separator' => 'default',
			'selectors' => $selectors['alignment'],
		];

		$fields['price_slider_border_note'] = $obj->el_heading(
			esc_html__( 'Handle Border', 'shopbuilder-pro' ),
		);

		$fields['rtsb_el_price_slider_border'] = [
			'mode'      => 'group',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'shopbuilder-pro' ),
			'selector'  => $selectors['handle_border'],
			'separator' => 'default',
		];

		$fields['price_slider_color_note'] = $obj->el_heading(
			esc_html__( 'Colors', 'shopbuilder-pro' ),
		);

		$fields['price_slider_label_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Label Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['price_slider_label_color'],
		];

		$fields['price_slider_line_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Default Line Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['price_slider_line_color'],
		];

		$fields['price_slider_active_line_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Line Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['price_slider_active_line_color'],
		];

		$fields['price_slider_handle_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Handle Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['price_slider_handle_color'],
		];

		$fields['price_slider_handle_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Handle Background Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['price_slider_handle_bg_color'],
		];

		$fields['price_slider_spacing_note'] = $obj->el_heading(
			esc_html__( 'Spacing', 'shopbuilder-pro' ),
		);

		$fields['price_slider_label_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Label Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'separator'  => 'default',
			'selectors'  => $selectors['price_slider_label_margin'],
		];

		$fields['price_slider_wrapper_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Wrapper Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['price_slider_wrapper_margin'],
		];

		$fields['price_slider_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Rating Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function rating( $obj ) {
		$css_selectors = $obj->selectors['rating'];
		$selectors     = [
			'typography'            => $css_selectors['typography'],
			'count_display'         => [ $css_selectors['count_display'] => 'display: {{VALUE}};' ],
			'count_position'        => [ $css_selectors['count_position'] => 'padding-left: {{SIZE}}{{UNIT}};' ],
			'rating_color'          => [ $css_selectors['rating_color'] => 'color: {{VALUE}};' ],
			'rating_active_color'   => [ $css_selectors['rating_active_color'] => 'color: {{VALUE}};' ],
			'rating_selected_color' => [ $css_selectors['rating_selected_color'] => 'color: {{VALUE}};' ],
			'rating_margin'         => [ $css_selectors['rating_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'rating_padding'        => [ $css_selectors['rating_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields['rating_section'] = $obj->start_section(
			esc_html__( 'Rating Styles', 'shopbuilder-pro' ),
			'style'
		);

		$fields['rtsb_el_rating_typography'] = [
			'mode'     => 'group',
			'label'    => esc_html__( 'Icon Typography', 'shopbuilder-pro' ),
			'type'     => 'typography',
			'exclude'  => [ 'font_family', 'font_weight', 'text_transform', 'text_decoration', 'font_style', 'word_spacing', 'line_height' ],
			'selector' => $selectors['typography'],
		];

		$fields['start_count_display'] = [
			'mode'      => 'responsive',
			'type'      => 'choose',
			'label'     => esc_html__( 'Count Text Display', 'shopbuilder-pro' ),
			'options'   => [
				'block' => [
					'title' => esc_html__( 'Show', 'shopbuilder-pro' ),
					'icon'  => 'eicon-check',
				],
				'none'  => [
					'title' => esc_html__( 'Hide', 'shopbuilder-pro' ),
					'icon'  => 'eicon-close',
				],
			],
			'default'   => 'block',
			'separator' => 'default',
			'selectors' => ! empty( $selectors['count_display'] ) ? $selectors['count_display'] : [],
		];

		$fields['rating_count_position'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Count Text Alignment', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 500,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['count_position'],
		];

		$fields['rating_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Star Inactive Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['rating_color'],
		];

		$fields['rating_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Star Active Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['rating_active_color'],
		];

		$fields['rating_selected_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Star Selected Color', 'shopbuilder-pro' ),
			'separator' => 'default',
			'selectors' => $selectors['rating_selected_color'],
		];

		$fields['rating_spacing_note'] = $obj->el_heading( esc_html__( 'Spacing', 'shopbuilder-pro' ), 'before' );

		$fields['rating_padding'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'separator'  => 'default',
			'selectors'  => $selectors['rating_padding'],
		];

		$fields['rating_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['rating_margin'],
		];

		$fields['rating_section_end'] = $obj->end_section();

		return $fields;
	}

	/**
	 * Toggle Button Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function toggle_btn( $obj ) {
		$css_selectors = $obj->selectors['toggle_btn'];
		$title         = esc_html__( 'Toggle Button Styles', 'shopbuilder-pro' );
		$selectors     = [
			'typography'         => $css_selectors['typography'],
			'alignment'          => [ $css_selectors['toggle_btn_alignment'] => 'text-align: {{VALUE}};' ],
			'icon_display'       => [ $css_selectors['icon_display'] => 'display: {{VALUE}};' ],
			'toggle_icon_size'   => [ $css_selectors['toggle_icon_size'] => 'font-size: {{SIZE}}{{UNIT}};' ],
			'color'              => [ $css_selectors['color'] => 'color: {{VALUE}} !important;' ],
			'icon_color'         => [ $css_selectors['icon_color'] => 'color: {{VALUE}} !important;' ],
			'bg_color'           => [
				$css_selectors['bg_color']['bg_color']     => 'background-color: {{VALUE}} !important;',
				$css_selectors['bg_color']['border_color'] => 'border-top-color: {{VALUE}} !important;',
			],
			'hover_color'        => [ $css_selectors['hover_color'] => 'color: {{VALUE}} !important;' ],
			'hover_icon_color'   => [ $css_selectors['hover_icon_color'] => 'color: {{VALUE}} !important;' ],
			'hover_bg_color'     => [
				$css_selectors['hover_bg_color']['hover_bg_color']     => 'background-color: {{VALUE}} !important;',
				$css_selectors['hover_bg_color']['hover_border_color'] => 'border-top-color: {{VALUE}} !important;',
			],
			'border'             => $css_selectors['border'],
			'border_hover_color' => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}};' ],
			'border_radius'      => [ $css_selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'padding'            => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'margin'             => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields = ControlHelper::general_elementor_style(
			'toggle_btn',
			$title,
			$obj,
			[
				'toggle_btn' => 'yes',
				'layout'     => 'horizontal',
			],
			$selectors
		);

		unset( $fields['toggle_btn_alignment'] );

		$extra_controls = [];

		$extra_controls['toggle_btn_alignment'] = [
			'type'      => 'choose',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Buttons Vertical Alignment', 'shopbuilder-pro' ),
			'options'   => [
				'left'   => [
					'title' => esc_html__( 'Left', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__( 'Center', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-center',
				],
				'right'  => [
					'title' => esc_html__( 'Right', 'shopbuilder-pro' ),
					'icon'  => 'eicon-text-align-right',
				],
			],
			'selectors' => $selectors['alignment'],
		];

		$extra_controls['toggle_icon_display'] = [
			'type'      => 'choose',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Icon Display', 'shopbuilder-pro' ),
			'options'   => [
				'block' => [
					'title' => esc_html__( 'Show', 'shopbuilder-pro' ),
					'icon'  => 'eicon-check',
				],
				'none'  => [
					'title' => esc_html__( 'Hide', 'shopbuilder-pro' ),
					'icon'  => 'eicon-close',
				],
			],
			'selectors' => $selectors['icon_display'],
			'separator' => 'default',
		];

		$extra_controls['toggle_icon_size'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'selectors'  => $selectors['toggle_icon_size'],
			'separator'  => 'default',
		];

		$fields = Fns::insert_controls( 'toggle_btn_color_note', $fields, $extra_controls );

		$extra_controls['icon_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Icon Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['icon_color'],
			'separator' => 'default',
		];

		$fields = Fns::insert_controls( 'toggle_btn_color', $fields, $extra_controls, true );

		$extra_controls['hover_icon_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Icon Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['hover_icon_color'],
			'separator' => 'default',
		];

		$fields = Fns::insert_controls( 'toggle_btn_hover_color', $fields, $extra_controls, true );

		$extra_controls['toggle_btn_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['border_radius'],
		];

		return Fns::insert_controls( 'toggle_btn_border_hover_color', $fields, $extra_controls, true );
	}

	/**
	 * Apply Filters Button Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function apply_btn( $obj ) {
		$css_selectors = $obj->selectors['apply_btn'];
		$title         = esc_html__( 'Apply Filters Button Styles', 'shopbuilder-pro' );
		$selectors     = [
			'typography'         => $css_selectors['typography'],
			'apply_btn_width'    => [ $css_selectors['apply_btn_width'] => 'width: {{SIZE}}{{UNIT}};' ],
			'icon_display'       => [ $css_selectors['icon_display'] => 'display: {{VALUE}};' ],
			'apply_icon_size'    => [ $css_selectors['apply_icon_size'] => 'font-size: {{SIZE}}{{UNIT}};' ],
			'color'              => [ $css_selectors['color'] => 'color: {{VALUE}} !important;' ],
			'icon_color'         => [ $css_selectors['icon_color'] => 'color: {{VALUE}} !important;' ],
			'bg_color'           => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}} !important;' ],
			'hover_color'        => [ $css_selectors['hover_color'] => 'color: {{VALUE}} !important;' ],
			'hover_icon_color'   => [ $css_selectors['hover_icon_color'] => 'color: {{VALUE}} !important;' ],
			'hover_bg_color'     => [ $css_selectors['hover_bg_color'] => 'background-color: {{VALUE}} !important;' ],
			'border'             => $css_selectors['border'],
			'border_hover_color' => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}};' ],
			'border_radius'      => [ $css_selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'padding'            => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'margin'             => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields = ControlHelper::general_elementor_style(
			'apply_btn',
			$title,
			$obj,
			[ 'apply_filters_btn' => 'yes' ],
			$selectors
		);

		unset( $fields['apply_btn_alignment'] );

		$extra_controls = [];

		$extra_controls['apply_btn_width'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Button Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 1500,
					'step' => 1,
				],
				'%'  => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['apply_btn_width'],
		];

		$extra_controls['apply_icon_display'] = [
			'type'      => 'choose',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Icon Display', 'shopbuilder-pro' ),
			'options'   => [
				'block' => [
					'title' => esc_html__( 'Show', 'shopbuilder-pro' ),
					'icon'  => 'eicon-check',
				],
				'none'  => [
					'title' => esc_html__( 'Hide', 'shopbuilder-pro' ),
					'icon'  => 'eicon-close',
				],
			],
			'selectors' => $selectors['icon_display'],
			'separator' => 'default',
		];

		$extra_controls['apply_icon_size'] = [
			'type'       => 'slider',
			'label'      => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'selectors'  => $selectors['apply_icon_size'],
			'separator'  => 'default',
		];

		$fields = Fns::insert_controls( 'apply_btn_color_note', $fields, $extra_controls );

		$extra_controls['apply_icon_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Icon Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['icon_color'],
			'separator' => 'default',
		];

		$fields = Fns::insert_controls( 'apply_btn_color', $fields, $extra_controls, true );

		$extra_controls['apply_hover_icon_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Icon Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['hover_icon_color'],
			'separator' => 'default',
		];

		$fields = Fns::insert_controls( 'apply_btn_hover_color', $fields, $extra_controls, true );

		$extra_controls['apply_btn_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['border_radius'],
		];

		return Fns::insert_controls( 'apply_btn_border_hover_color', $fields, $extra_controls, true );
	}

	/**
	 * Reset Button Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function reset_btn( $obj ) {
		$css_selectors = $obj->selectors['reset_btn'];
		$title         = esc_html__( 'Reset Button Styles', 'shopbuilder-pro' );
		$selectors     = [
			'typography'         => $css_selectors['typography'],
			'alignment'          => [ $css_selectors['alignment'] => 'text-align: {{VALUE}}; justify-content: {{VALUE}}' ],
			'btn_width'          => [ $css_selectors['btn_width'] => 'width: {{SIZE}}{{UNIT}};' ],
			'color'              => [ $css_selectors['color'] => 'color: {{VALUE}} !important;' ],
			'bg_color'           => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}};' ],
			'hover_color'        => [ $css_selectors['hover_color'] => 'color: {{VALUE}} !important;' ],
			'hover_bg_color'     => [ $css_selectors['hover_bg_color'] => 'background-color: {{VALUE}};' ],
			'border'             => $css_selectors['border'],
			'border_hover_color' => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}};' ],
			'border_radius'      => [ $css_selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'padding'            => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'margin'             => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields = ControlHelper::general_elementor_style( 'reset_btn', $title, $obj, [ 'reset_btn' => 'yes' ], $selectors );

		$extra_controls = [];

		$extra_controls['btn_width'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Button Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%' ],
			'range'      => [
				'px' => [
					'min'  => 0,
					'max'  => 1500,
					'step' => 1,
				],
				'%'  => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'separator'  => 'default',
			'selectors'  => $selectors['btn_width'],
		];

		$fields = Fns::insert_controls( 'reset_btn_alignment', $fields, $extra_controls, true );

		$extra_controls['reset_btn_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['border_radius'],
		];

		return Fns::insert_controls( 'reset_btn_border_hover_color', $fields, $extra_controls, true );
	}

	/**
	 * Active Filters Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function active_filters( $obj ) {
		$css_selectors = $obj->selectors['active_filters'];
		$title         = esc_html__( 'Active Filters Styles', 'shopbuilder-pro' );
		$condition     = [ 'active_filter' => 'yes' ];
		$selectors     = [
			'wrapper_bg_color'   => [ $css_selectors['wrapper_bg_color'] => 'background-color: {{VALUE}} !important;' ],
			'color'              => [ $css_selectors['color'] => 'color: {{VALUE}} !important;' ],
			'bg_color'           => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}};' ],
			'icon_color'         => [ $css_selectors['icon_bg_color'] => 'color: {{VALUE}};' ],
			'icon_bg_color'      => [ $css_selectors['icon_bg_color'] => 'background-color: {{VALUE}}; -webkit-text-stroke: 1px {{VALUE}};' ],
			'border_color'       => [ $css_selectors['border_color'] => 'border-color: {{VALUE}};' ],
			'hover_color'        => [ $css_selectors['hover_color'] => 'color: {{VALUE}} !important;' ],
			'hover_bg_color'     => [ $css_selectors['hover_bg_color'] => 'background-color: {{VALUE}} !important;' ],
			'border_hover_color' => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}};' ],
			'border_radius'      => [ $css_selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'padding'            => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'margin'             => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields = ControlHelper::general_elementor_style( 'active_filters', $title, $obj, $condition, $selectors );

		$fields['active_filters_color_note']['separator'] = 'default';
		$fields['active_filters_padding']['separator']    = 'before-short';
		$fields['active_filters_color']['label']          = esc_html__( 'Text Color', 'shopbuilder-pro' );
		$fields['active_filters_bg_color']['label']       = esc_html__( 'Item Background Color', 'shopbuilder-pro' );
		$fields['active_filters_hover_color']['label']    = esc_html__( 'Hover Text Color', 'shopbuilder-pro' );
		$fields['active_filters_hover_bg_color']['label'] = esc_html__( 'Item Hover Background Color', 'shopbuilder-pro' );
		$fields['active_filters_padding']['label']        = esc_html__( 'Wrapper Padding', 'shopbuilder-pro' );
		$fields['active_filters_margin']['label']         = esc_html__( 'Wrapper Margin', 'shopbuilder-pro' );

		unset(
			$fields['active_filters_typo_note'],
			$fields['rtsb_el_active_filters_typography'],
			$fields['active_filters_alignment'],
			$fields['active_filters_border_note'],
			$fields['rtsb_el_active_filters_border'],
			$fields['active_filters_border_hover_color'],
		);

		$extra_controls = [];

		$extra_controls['close_icon_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Icon Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['icon_color'],
			'separator' => 'default',
		];

		$extra_controls['close_icon_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Icon Background Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['icon_bg_color'],
			'separator' => 'default',
		];

		$extra_controls['bordr_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Item Border Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['border_color'],
			'separator' => 'default',
		];

		$extra_controls['wrapper_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Wrapper Background Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['wrapper_bg_color'],
			'separator' => 'default',
		];

		$fields = Fns::insert_controls( 'active_filters_bg_color', $fields, $extra_controls, true );

		$extra_controls['bordr_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Item Hover Border Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['border_hover_color'],
			'separator' => 'default',
		];

		$fields = Fns::insert_controls( 'active_filters_hover_bg_color', $fields, $extra_controls, true );

		$extra_controls['active_filters_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Wrapper Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['border_radius'],
			'separator'  => 'default',
		];

		return Fns::insert_controls( 'active_filters_spacing_note', $fields, $extra_controls, true );
	}

	/**
	 * Advanced Style Section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function filter_groups( $obj ) {
		$css_selectors = $obj->selectors['filter_group'];

		$fields['filter_groups_style_section'] = $obj->start_section(
			esc_html__( 'Filter Groups', 'shopbuilder-pro' ),
			'style',
		);

		$fields['filter_group_alignment_note'] = $obj->el_heading( esc_html__( 'Alignment', 'shopbuilder-pro' ), 'default', [], [ 'layout' => [ 'horizontal' ] ] );

		$fields['btn_v_alignment'] = [
			'type'      => 'choose',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Buttons Vertical Alignment', 'shopbuilder-pro' ),
			'options'   => [
				'flex-start' => [
					'title' => esc_html__( 'Top', 'shopbuilder-pro' ),
					'icon'  => 'eicon-v-align-top',
				],
				'center'     => [
					'title' => esc_html__( 'Middle', 'shopbuilder-pro' ),
					'icon'  => 'eicon-v-align-middle',
				],
				'flex-end'   => [
					'title' => esc_html__( 'Bottom', 'shopbuilder-pro' ),
					'icon'  => 'eicon-v-align-bottom',
				],
			],
			'condition' => [ 'layout' => [ 'horizontal' ] ],
			'selectors' => [ $css_selectors['btn_v_alignment'] => 'justify-content: {{VALUE}}' ],
		];

		$fields['filter_group_border_note'] = $obj->el_heading( esc_html__( 'Border', 'shopbuilder-pro' ), 'default' );

		$fields['rtsb_el_filter_group_border'] = [
			'mode'      => 'group',
			'type'      => 'border',
			'label'     => esc_html__( 'Border', 'shopbuilder-pro' ),
			'selector'  => $css_selectors['border'],
			'separator' => 'default',
		];

		$fields['filter_wrapper_border_note'] = $obj->el_heading( esc_html__( 'Wrapper Border', 'shopbuilder-pro' ), 'default' );

		$fields['rtsb_el_filter_wrapper_border'] = [
			'mode'      => 'group',
			'type'      => 'border',
			'label'     => esc_html__( 'Wrapper Border', 'shopbuilder-pro' ),
			'selector'  => $css_selectors['wrapper_border'],
			'separator' => 'default',
		];

		$fields['rtsb_el_wrapper_border_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Wrapper Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => [ $css_selectors['wrapper_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'separator'  => 'default',
			'condition'  => [ 'rtsb_el_filter_wrapper_border_border!' => '' ],
		];

		$fields['filter_group_spacing_note'] = $obj->el_heading( esc_html__( 'Spacing', 'shopbuilder-pro' ) );

		$fields['filter_group_padding'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};' ],
			'separator'  => 'default',
		];

		$fields['active_wrapper_padding'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Active Group Padding', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'condition'  => [
				'collapse_mode' => 'yes',
			],
			'selectors'  => [ $css_selectors['active_wrapper_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;' ],
		];

		$fields['filter_group_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields['filter_wrapper_padding'] = [
			'mode'               => 'responsive',
			'type'               => 'dimensions',
			'label'              => esc_html__( 'Wrapper Padding', 'shopbuilder-pro' ),
			'size_units'         => [ 'px', '%', 'em' ],
			'allowed_dimensions' => [
				'top',
				'right',
				'left',
			],
			'selectors'          => [ $css_selectors['wrapper_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};' ],
		];

		$fields['filter_wrapper_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Wrapper Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => [ $css_selectors['wrapper_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields['filter_groups_style_section_end'] = $obj->end_section();

		return $fields;
	}
}
