<?php
/**
 * BillingShippingSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\OrderReviewTableSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class BillingShippingSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		$fields                            =
					TitleSettings::general_settings() +
					self::title_settings( $widget ) +
					self::general_style( $widget );
		$fields['show_title']['selectors'] = [
			$widget->selectors['show_title'] => 'display:block;',
		];

		return $fields;

	}


	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function title_settings( $widget ) {
		$title_settings = TitleSettings::title_settings( $widget );
		if ( 'rtsb-order-shipping-address' === $widget->rtsb_base || 'rtsb-order-billing-address' === $widget->rtsb_base || 'rtsb-account-order-billing' === $widget->rtsb_base || 'rtsb-account-order-shipping' === $widget->rtsb_base ) {
			$insert_array   = [
				'title_border' => [
					'mode'      => 'group',
					'type'      => 'border',
					'label'     => esc_html__( 'Border', 'shopbuilder-pro' ),
					'selector'  => $widget->selectors['title_border'],
					'separator' => 'before',
				],
			];
			$title_settings = Fns::insert_controls( 'title_text_shadow', $title_settings, $insert_array, true );
		}
		return $title_settings;

	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function general_style( $widget ) {
		return [
			'general_section_start' => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
				'tab'   => 'style',
			],
			'content_heading'       => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Content Heading', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'content_align'         => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => ControlHelper::alignment(),
				'selectors' => [
					$widget->selectors['content_align'] => 'text-align: {{VALUE}};',
				],
			],
			'content_bg_color'      => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['content_bg_color'] => 'background-color: {{VALUE}};',
				],
			],
			'content_border'        => [
				'mode'      => 'group',
				'type'      => 'border',
				'label'     => esc_html__( 'Border', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['content_border'],
				'separator' => 'before',
			],
			'content_padding'       => [
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					$widget->selectors['content_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'address_heading'       => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Address Heading', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'address_typography'    => [
				'mode'      => 'group',
				'type'      => 'typography',
				'seperator' => 'before',
				'label'     => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['address_typography'],
			],
			'address_color'         => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['address_color'] => 'color: {{VALUE}};',
				],
			],
			'general_section_end'   => [
				'mode' => 'section_end',
			],
		];
	}

}
