<?php
/**
 * Elementor Content Fields Class.
 *
 * This class contains all the pro fields for Content tab.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use Elementor\Utils;
use RadiusTheme\SB\Helpers\Fns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Elementor layout Fields Class.
 */
class ContentFields {
	/**
	 * Image section
	 *
	 * @param object $obj Reference object.
	 * @param string $prefix Prefix.
	 *
	 * @return array
	 */
	public static function image( $obj, $prefix = 'lookbook' ) {
		$fields[ $prefix . '_image_section' ] = $obj->start_section(
			esc_html__( 'Image', 'shopbuilder-pro' ),
			'content'
		);

		$fields[ $prefix . '_custom_image' ] = [
			'type'        => 'media',
			'label'       => esc_html__( 'Upload Background Image', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the background image.', 'shopbuilder-pro' ),
			'default'     => [
				'url' => Utils::get_placeholder_image_src(),
			],
		];

		$fields[ $prefix . '_image_hover_animation' ] = [
			'type'        => 'select2',
			'label'       => esc_html__( 'Image Hover Animation', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose image hover animation.', 'shopbuilder-pro' ),
			'options'     => [
				'zoom_in'  => esc_html__( 'Zoom In', 'shopbuilder-pro' ),
				'zoom_out' => esc_html__( 'Zoom Out', 'shopbuilder-pro' ),
				'none'     => esc_html__( 'None', 'shopbuilder-pro' ),
			],
			'label_block' => true,
			'default'     => 'none',
		];

		$fields[ $prefix . '_show_overlay' ] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Image Overlay?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable image overlay.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
		];

		$fields[ $prefix . '_image_size_note' ] = $obj->el_heading( esc_html__( 'Image Size', 'shopbuilder-pro' ), 'before' );

		$fields[ $prefix . '_image_size' ] = [
			'type'            => 'select2',
			'label'           => esc_html__( 'Select Image Size', 'shopbuilder-pro' ),
			'description'     => esc_html__( 'Please select the image size.', 'shopbuilder-pro' ),
			'options'         => Fns::get_image_sizes(),
			'default'         => 'large',
			'label_block'     => true,
			'content_classes' => 'elementor-descriptor',
		];

		$fields[ $prefix . '_image_custom_dimension' ] = [
			'type'        => 'image-dimensions',
			'label'       => esc_html__( 'Enter Custom Image Size', 'shopbuilder-pro' ),
			'label_block' => true,
			'show_label'  => true,
			'default'     => [
				'width'  => 400,
				'height' => 400,
			],
			'condition'   => [ $prefix . '_image_size' => 'rtsb_custom' ],
		];

		$fields[ $prefix . '_image_crop' ] = [
			'type'        => 'select2',
			'label'       => esc_html__( 'Image Crop', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please click on "Apply" to update the image.', 'shopbuilder-pro' ),
			'options'     => [
				'soft' => esc_html__( 'Soft Crop', 'shopbuilder-pro' ),
				'hard' => esc_html__( 'Hard Crop', 'shopbuilder-pro' ),
			],
			'default'     => 'hard',
			'condition'   => [ $prefix . '_image_size' => 'rtsb_custom' ],
		];

		$fields[ $prefix . '_image_custom_dimension_note' ] = [
			'type'      => 'html',
			'raw'       => sprintf(
				'<span style="display: block; background: #fffbf1; padding: 10px; font-weight: 500; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a;">%s</span>',
				esc_html__( 'Please note that, if you enter image size larger than the actual image itself, the image sizes will fallback to the full image dimension.', 'shopbuilder-pro' )
			),
			'condition' => [ $prefix . '_image_size' => 'rtsb_custom' ],
		];

		$fields[ $prefix . '_image_section_end' ] = $obj->end_section();

		return $fields;
	}

	/**
	 * Pointers section
	 *
	 * @param object $obj Reference object.
	 * @param string $title Title.
	 * @param string $prefix Prefix.
	 * @param string $context Context.
	 *
	 * @return array
	 */
	public static function pointers( $obj, $title, $prefix = 'lookbook', $context = 'product' ) {
		$fields[ $prefix . '_pointers_layout' ] = $obj->start_section(
			esc_html__( 'Pointers', 'shopbuilder-pro' ),
			'content'
		);

		$fields[ $prefix . '_pointer_settings_note' ] = $obj->el_heading( esc_html__( 'Pointer Preset', 'shopbuilder-pro' ) );

		$fields['lookbook_pointer_preset'] = [
			'type'    => 'rtsb-image-selector',
			'options' => apply_filters(
				'rtsb/elements/elementor/product_lookbook_pointer_presets',
				[
					'lookbook-pointer-preset1' => [
						'title' => esc_html__( 'Preset 1', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/pointer-preset-1.png' ) ),
					],
					'lookbook-pointer-preset2' => [
						'title' => esc_html__( 'Preset 2', 'shopbuilder-pro' ),
						'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/pointer-preset-2.png' ) ),
					],
				]
			),
			'default' => 'lookbook-pointer-preset1',
		];

		if ( 'lookbook' !== $prefix ) {
			$fields['lookbook_pointer_preset']['options']['lookbook-pointer-preset3'] = [
				'title' => esc_html__( 'Preset 3', 'shopbuilder-pro' ),
				'url'   => esc_url( rtsbpro()->get_assets_uri( 'images/layout/pointer-preset-3.png' ) ),
			];
		}

		$fields[ $prefix . '_pointer_trigger' ] = [
			'type'        => 'select2',
			'label'       => esc_html__( 'Pointer Trigger Behavior', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please select pointer trigger behavior.', 'shopbuilder-pro' ),
			'options'     => [
				'click'      => esc_html__( 'Click', 'shopbuilder-pro' ),
				'mouseenter' => esc_html__( 'Hover', 'shopbuilder-pro' ),
			],
			'default'     => 'click',
			'label_block' => true,
		];

		$fields['lookbook_pointer_pulse_animation'] = [
			'type'        => 'switch',
			'label'       => esc_html__( 'Enable Pulse Animation?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Switch on to enable pointer pulse animation.', 'shopbuilder-pro' ),
			'label_on'    => esc_html__( 'On', 'shopbuilder-pro' ),
			'label_off'   => esc_html__( 'Off', 'shopbuilder-pro' ),
			'default'     => 'yes',
		];

		$fields[ $prefix . '_pointers_note' ] = $obj->el_heading( $title . esc_html__( ' Pointers', 'shopbuilder-pro' ), 'before' );

		$repeater_fields = [];

		if ( 'product' === $context ) {
			$repeater_fields['pointer_product'] = [
				'label'       => esc_html__( 'Choose Product', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Please choose the product to connect with the pointer.', 'shopbuilder-pro' ),
				'type'        => 'rt-select2',
				'separator'   => 'default',
				'source_name' => 'post_type',
				'source_type' => 'product',
				'multiple'    => false,
			];
		} else {
			$repeater_fields['hotspot_icon'] = [
				'type'        => 'icons',
				'label'       => esc_html__( 'Choose Top Icon', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Please choose the top icon.', 'shopbuilder-pro' ),
				'default'     => [
					'value'   => 'rtsb-icon rtsb-icon-check-alt',
					'library' => 'rtsb-fonts',
				],
			];

			$repeater_fields['hotspot_title'] = [
				'type'        => 'text',
				'label'       => esc_html__( 'Pointer Title', 'shopbuilder-pro' ),
				'default'     => esc_html__( 'Pointer Title', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Please enter pointer title.', 'shopbuilder-pro' ),
				'separator'   => 'before-short',
				'label_block' => true,
			];

			$repeater_fields['hotspot_content'] = [
				'type'        => 'wysiwyg',
				'label'       => esc_html__( 'Pointer Content', 'shopbuilder-pro' ),
				'default'     => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Please enter pointer content.', 'shopbuilder-pro' ),
				'separator'   => 'before-short',
				'label_block' => true,
			];
		}

		$repeater_fields['pos_x'] = [
			'type'        => 'slider',
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Horizontal Position (X)', 'shopbuilder-pro' ),
			'size_units'  => [ '%' ],
			'range'       => [
				'%' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'default'     => [
				'size' => 20,
			],
			'label_block' => true,
			'separator'   => 'before-short',
			'selectors'   => [
				$obj->selectors['pointers']['pos_x'] => 'left: {{SIZE}}%;',
			],
		];

		$repeater_fields['pos_y'] = [
			'type'        => 'slider',
			'mode'        => 'responsive',
			'label'       => esc_html__( 'Vertical Position (Y)', 'shopbuilder-pro' ),
			'size_units'  => [ '%' ],
			'range'       => [
				'%' => [
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				],
			],
			'default'     => [
				'size' => 30,
			],
			'label_block' => true,
			'separator'   => 'before-short',
			'selectors'   => [
				$obj->selectors['pointers']['pos_x'] => 'top: {{SIZE}}%;',
			],
		];

		$fields[ $prefix . '_pointers_fields' ] = [
			'type'        => 'repeater',
			'label'       => sprintf(
				/* translators: Context title */
				esc_html__( 'Add %s pointers.', 'shopbuilder-pro' ),
				$title
			),
			'mode'        => 'repeater',
			'separator'   => 'after',
			'title_field' => 'product' !== $context ? '{{{ hotspot_title }}}' : '{{{ "Pointer" }}}',
			'fields'      => $repeater_fields,
		];

		$fields[ $prefix . '_pointers_layout_end' ] = $obj->end_section();

		return $fields;
	}
}
