<?php
/**
 * DescriptionSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.
use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class DescriptionSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function widget_fields( $widget ) {
		$textStyleSettings                         = TextStyleSettings::widget_fields( $widget );
		$textStyleSettings['section_style']['tab'] = 'style';
		return self::general_section() +
			   $textStyleSettings;

	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function general_section() {
		return [
			'sec_general'         => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'description_text' => [
				'label'       => esc_html__( 'Alternative Text', 'shopbuilder-pro' ),
				'type'        => 'textarea',
				'description' => esc_html__( 'If you want to change woocommerce default description text then you can add custom text from this', 'shopbuilder-pro' ),
				'separator'   => 'default',
			],
			'sec_general_end'     => [
				'mode' => 'section_end',
			],
		];
	}


}
