<?php
/**
 * OrderReceivedSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\OrderReviewTableSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class DownloadableProductSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		$fields = OrderReviewTableSettings::general_settings( $widget ) +
				  TitleSettings::title_settings( $widget ) +
				  self::table_settings( $widget ) +
				  ButtonSettings::style_settings( $widget );

		return $fields;

	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function table_settings( $widget ) {
		$fields = OrderReviewTableSettings::table_settings( $widget );
		unset( $fields['table_heading'] );
		unset( $fields['table_heading_typography'] );
		unset( $fields['table_heading_color'] );
		unset( $fields['table_heading_background_color'] );
		unset( $fields['table_heading_align'] );
		unset( $fields['total_heading_width'] );

		unset( $fields['table_cell'] );
		unset( $fields['table_cell_typography'] );
		unset( $fields['table_cell_color'] );
		unset( $fields['table_cell_background_color'] );
		unset( $fields['table_cell_align'] );
		unset( $fields['total_cell_heading_width'] );
		unset( $fields['table_product_title'] );
		unset( $fields['table_product_total'] );

		$insert_array = [
			'table_header_label'    => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Table Heading', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'table_header_typo'     => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['table_header_typo'],
			],
			'table_header_align'    => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => ControlHelper::alignment(),
				'selectors' => [
					$widget->selectors['table_header_align'] => 'text-align: {{VALUE}}!important;',
				],
			],
			'table_header_color'    => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_header_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'table_header_bg_color' => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_header_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
		];

		$fields = Fns::insert_controls( 'table_heading_cell_padding', $fields, $insert_array, true );

		$insert_array = [
			'table_items_label'   => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Table Items', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'table_item_typo'     => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['table_item_typo'],
			],
			'table_item_align'    => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => ControlHelper::alignment(),
				'selectors' => [
					$widget->selectors['table_item_align'] => 'text-align: {{VALUE}}!important;',
				],
			],
			'table_item_color'    => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_item_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'table_item_bg_color' => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['table_item_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
		];

		$fields = Fns::insert_controls( 'table_header_bg_color', $fields, $insert_array, true );

		$insert_array = [
			'show_table_heading'    => [
				'label'       => esc_html__( 'Show Table Heading?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show table heading.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',
				'selectors'   => [
					$widget->selectors['show_table_heading'] => 'display:table-row',
				],
			],
			'table_heading_padding' => [
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ '%' ],
				'selectors'  => [
					$widget->selectors['table_heading_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
				],
				'condition'  => [
					'show_table_heading' => 'yes',
				],
			],
		];
		$fields       = Fns::insert_controls( 'table_header_label', $fields, $insert_array, true );

		return $fields;
	}


}
