<?php
/**
 * Main FormFieldSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

// Do not allow directly accessing this file.
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Product Description class
 */
class FormFieldSettings {

	/**
	 * Widget Control Selectors
	 *
	 * @var object
	 */
	private static $widget = [];
	/**
	 * Widget Control Selectors
	 *
	 * @var array
	 */
	private static $selectors = [];

	/**
	 * Controls Settings
	 *
	 * @param object $widget widget object.
	 * @return array
	 */
	public static function widget_fields( $widget ) {
		self::$widget    = $widget;
		self::$selectors = self::$widget->selectors;
		return self::fields_settings() + ButtonSettings::style_settings( self::$widget );
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function fields_settings() {
		return [
			'fields_label_style_start'    => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Form Label', 'shopbuilder-pro' ),
			],
			'fields_label_typo'           => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Label Typography', 'shopbuilder-pro' ),
				'selector' => self::$selectors['fields_label_typo'],
			],
			'fields_label_color'          => [
				'label'     => esc_html__( 'Label Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					self::$selectors['fields_label_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'fields_label_reguired_color' => [
				'label'     => esc_html__( 'Label Required Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					self::$selectors['fields_label_reguired_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'fields_label_margin'         => [
				'label'      => esc_html__( 'Label Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					self::$selectors['fields_label_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'fields_label_style_end'      => [
				'mode' => 'section_end',
			],
			'fields_style_start'          => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Form Fields', 'shopbuilder-pro' ),
			],
			'fields_height'               => [
				'label'     => esc_html__( 'Fields Height', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'separator' => 'default',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'selectors' => [
					self::$selectors['fields_height'] => 'height: {{SIZE}}{{UNIT}};',
				],
			],
			'fields_width_100'            => [
				'label'       => esc_html__( 'Full Width Fields?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to set all fields to a 100% width..', 'shopbuilder-pro' ),
				'default'     => '',
			],

			'fields_tabs_start'           => [
				'mode' => 'tabs_start',
			],
			// Tab For normal view.
			'fields_normal'               => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Normal', 'shopbuilder-pro' ),
			],
			'fields_border'               => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => self::$selectors['fields_border'],
				'size_units' => [ 'px' ],
			],
			'fields_border_radius'        => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					self::$selectors['fields_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'fields_text_color'           => [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					self::$selectors['fields_text_color'] => 'color: {{VALUE}};',
				],
			],
			'fields_bg_color'             => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					self::$selectors['fields_bg_color'] => 'background-color: {{VALUE}};',
				],
			],
			'fields_normal_end'           => [
				'mode' => 'tab_end',
			],
			'fields_hover'                => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Hover & Focus', 'shopbuilder-pro' ),
			],

			'fields_hover_border'         => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => self::$selectors['fields_hover_border'],
				'size_units' => [ 'px' ],
			],
			'fields_border_radius_hover'  => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					self::$selectors['fields_border_radius_hover'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'fields_hover_text_color'     => [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					self::$selectors['fields_hover_text_color'] => 'color: {{VALUE}};',
				],
			],
			'fields_hover_bg_color'       => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					self::$selectors['fields_hover_bg_color'] => 'background-color: {{VALUE}};',
				],
			],

			'fields_hover_end'            => [
				'mode' => 'tab_end',
			],
			'fields_tabs_end'             => [
				'mode' => 'tabs_end',
			],
			'form_heading_label'          => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Form Heading', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'form_heading_typo'           => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Form Heading Typography', 'shopbuilder-pro' ),
				'selector' => self::$selectors['form_heading_typo'],
			],
			'form_heading_color'          => [
				'label'     => esc_html__( 'Form Heading Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					self::$selectors['form_heading_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'form_heading_gap'            => [
				'label'     => esc_html__( 'Form Heading Gap', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 100,
					],
				],
				'selectors' => [
					self::$selectors['form_heading_gap'] => 'margin: {{SIZE}}{{UNIT}} !important;',
				],
			],
			'form_row_margin'             => [
				'label'      => esc_html__( 'Form Row Margin (px)', 'shopbuilder-pro' ),
				'mode'       => 'responsive',
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					self::$selectors['form_row_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'fields_padding'              => [
				'label'      => esc_html__( 'Fields Padding (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					self::$selectors['fields_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'fields_style_end'            => [
				'mode' => 'section_end',
			],
		];
	}
}
