<?php
/**
 * Elementor layout Fields Class.
 *
 * This class contains all the pro fields for Style tab.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Elementor\Helper\ControlHelper;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Elementor layout Fields Class.
 */
class LayoutFields {
	/**
	 * Pagination section
	 *
	 * @param array $fields Fields array.
	 * @return array
	 */
	public static function pagination_pro_controls( $fields ) {
		$pro_controls = [];

		$pro_controls['load_more_text'] = [
			'type'        => 'text',
			'label'       => esc_html__( 'Load More Button Text', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please enter \'Load More\' button text.', 'shopbuilder-pro' ),
			'label_block' => true,
			'default'     => esc_html__( 'Load More', 'shopbuilder-pro' ),
			'condition'   => [ 'pagination_type' => [ 'load_more' ] ],
		];

		return Fns::insert_controls( 'pagination_type', $fields, $pro_controls, true );
	}

	/**
	 * Pagination section
	 *
	 * @param array $fields Fields array.
	 * @return array
	 */
	public static function category_pro_controls( $fields, $obj ) {
		$pro_controls = [];

		if ( 'rtsb-product-categories-general' === $obj->rtsb_base ) {
			$pro_controls['rows'] = [
				'type'           => 'select2',
				'label'          => esc_html__( 'Number of Product Rows', 'shopbuilder-pro' ),
				'description'    => rtsb()->has_pro() ? esc_html__( 'Please select the number of slide rows. Slide Rows represents how many rows of slides will be displayed at once.', 'shopbuilder-pro' ) : esc_html__( 'Please select the number of slide rows.', 'shopbuilder-pro' ),
				'options'        => [
					1 => esc_html__( 'Layout Default (1 Row)', 'shopbuilder-pro' ),
					2 => esc_html__( '2 Rows', 'shopbuilder-pro' ),
					3 => esc_html__( '3 Rows', 'shopbuilder-pro' ),
					4 => esc_html__( '4 Rows', 'shopbuilder-pro' ),
					5 => esc_html__( '5 Rows', 'shopbuilder-pro' ),
				],
				'label_block'    => true,
				'default'        => '1',
				'tablet_default' => '1',
				'mobile_default' => '1',
				'required'       => true,
				'classes'        => $obj->pro_class(),
				'condition'      => [ 'active_cat_slider' => 'yes' ],
			];

			$pro_controls['cols_group'] = [
				'type'           => 'select2',
				'mode'           => 'responsive',
				'label'          => esc_html__( 'Number of Slides Per Group', 'shopbuilder-pro' ),
				'description'    => rtsb()->has_pro() ? esc_html__( 'Please select the number of slides to show per group. Slides Per Group indicates how many slides will be transitioned at a time.', 'shopbuilder-pro' ) : esc_html__( 'Please select the number of slides to show per group.', 'shopbuilder-pro' ),
				'options'        => ControlHelper::layout_columns(),
				'label_block'    => true,
				'default'        => '0',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'required'       => true,
				'classes'        => $obj->pro_class(),
				'condition'      => [ 'active_cat_slider' => 'yes' ],
			];
		}

		return Fns::insert_controls( 'cols', $fields, $pro_controls, true );
	}
}
