<?php
/**
 * Elementor Multi Step Checkout Settings Class.
 *
 * This class contains all the pro fields for Settings tab.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\InfoboxSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\OrderReviewTableSettings;
use RadiusTheme\SB\Elementor\Widgets\Controls\TitleSettings;
use RadiusTheme\SB\Helpers\Fns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Elementor Settings Fields Class.
 */
class MultiStepCheckoutSettings {
	/**
	 * Settings section
	 *
	 * @param $widget
	 *
	 * @return array
	 */
	public static function widget_settings( $widget ) {
		return self::general_settings( $widget ) +
			   self::step_style_settings( $widget ) +
			   TitleSettings::title_settings( $widget ) +
			   self::form_label_style_settings( $widget ) +
			   self::form_fields_style_settings( $widget ) +
			   ButtonSettings::style_settings( $widget ) +
			   self::coupon_form_style_settings( $widget ) +
			   self::payment_step_style_settings( $widget ) +
			   self::order_table_style_settings( $widget );
	}

	public static function general_settings( $widget ) {
		return [
			'general_section_start' => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
			],

			'multi_checkout_note'   => $widget->el_heading( esc_html__( 'Layout', 'shopbuilder-pro' ), 'before' ),

			'layout_style'          => [
				'type'      => 'rtsb-image-selector',
				'options'   => ControlHelper::multi_step_checkout_layouts(),
				'default'   => 'layout1',
				'separator' => 'default',
			],

			'show_title'            => [
				'label'       => esc_html__( 'Show Title?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show title.', 'shopbuilder-pro' ),
				'separator'   => 'before',
				'default'     => 'yes',
				'selectors'   => [
					$widget->selectors['show_title'] => 'display:block',
				],
			],
			'general_section_end'   => [
				'mode' => 'section_end',
			],
		];
	}

	public static function step_style_settings( $widget ) {
		return [
			'step_style_section_start' => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Steps Style', 'shopbuilder-pro' ),
			],
			'step_title_typography'    => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Title Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['step_title_typography'],
			],
			'step_icon_size'           => [
				'label'     => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'separator' => 'default',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'selectors' => [
					$widget->selectors['step_icon_size']['icon'] => 'font-size: {{SIZE}}{{UNIT}};',
					$widget->selectors['step_icon_size']['svg'] => 'width: {{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'layout_style' => [ 'layout2' ],
				],
			],
			'step_title_position'      => [
				'label'     => esc_html__( 'Step Title Position', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'separator' => 'default',
				'range'     => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors' => [
					$widget->selectors['step_title_position'] => 'top: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => [ 'layout1' ],
				],
			],
			'multi_checkout_step_note' => $widget->el_heading( esc_html__( 'Colors', 'shopbuilder-pro' ), 'before' ),
			'step_tabs_start'          => [
				'mode' => 'tabs_start',
			],
			'step_disable'             => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Disabled State', 'shopbuilder-pro' ),
			],
			'step_disable_title_color' => [
				'label'     => esc_html__( 'Disabled Title Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['step_disable_title_color'] => 'color: {{VALUE}}',
				],
			],
			'step_disable_fill_color'  => [
				'label'     => esc_html__( 'Disabled Fill Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['step_disable_fill_color'] => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'layout_style' => [ 'layout1' ],
				],
			],
			'step_disable_end'         => [
				'mode' => 'tab_end',
			],
			'step_active'              => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Active State', 'shopbuilder-pro' ),
			],
			'step_active_title_color'  => [
				'label'     => esc_html__( 'Active Title Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['step_active_title_color'] => 'color: {{VALUE}}',
				],
			],
			'step_item_active_border'  => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['step_item_active_border'],
				'size_units' => [ 'px' ],
				'condition'  => [
					'layout_style' => [ 'layout2' ],
				],
			],
			'step_active_fill_color'   => [
				'label'     => esc_html__( 'Active Fill Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'separator' => 'default',
				'selectors' => [
					$widget->selectors['step_active_fill_color'] => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'layout_style' => [ 'layout1' ],
				],
			],
			'step_active_end'          => [
				'mode' => 'tab_end',
			],
			'step_tabs_end'            => [
				'mode' => 'tabs_end',
			],
			'step_margin'              => [
				'label'      => esc_html__( 'Step Wrapper Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['step_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'step_style_section_end'   => [
				'mode' => 'section_end',
			],
		];
	}

	public static function coupon_form_style_settings( $widget ) {
		$fields                           = InfoboxSettings::style_settings( $widget );
		$fields['infobox_style']['label'] = __( 'Coupon Form', 'shopbuilder-pro' );
		unset( $fields['infobox_icon_size'] );
		unset( $fields['infobox_icon_color'] );
		unset( $fields['infobox_border_color'] );

		return $fields;
	}

	public static function form_label_style_settings( $widget ) {
		return [
			'fields_label_style_start'    => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Form Label', 'shopbuilder-pro' ),
			],
			'fields_label_typo'           => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Label Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['fields_label_typo'],
			],
			'fields_label_color'          => [
				'label'     => esc_html__( 'Label Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['fields_label_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'fields_label_reguired_color' => [
				'label'     => esc_html__( 'Label Required Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['fields_label_reguired_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'fields_label_margin'         => [
				'label'      => esc_html__( 'Label Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['fields_label_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'fields_label_style_end'      => [
				'mode' => 'section_end',
			],
		];
	}

	public static function form_fields_style_settings( $widget ) {
		return [
			'fields_style_start'         => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Form Fields', 'shopbuilder-pro' ),
			],
			'fields_height'              => [
				'label'     => esc_html__( 'Fields Height', 'shopbuilder-pro' ),
				'type'      => 'slider',
				'mode'      => 'responsive',
				'separator' => 'default',
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 200,
					],
				],
				'selectors' => [
					$widget->selectors['fields_height'] => 'height: {{SIZE}}{{UNIT}};',
				],
			],

			'fields_tabs_start'          => [
				'mode' => 'tabs_start',
			],
			// Tab For normal view.
			'fields_normal'              => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Normal', 'shopbuilder-pro' ),
			],
			'fields_border'              => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['fields_border'],
				'size_units' => [ 'px' ],
			],
			'fields_border_radius'       => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['fields_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'fields_text_color'          => [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',

				'selectors' => [
					$widget->selectors['fields_text_color'] => 'color: {{VALUE}};',
				],
			],
			'fields_bg_color'            => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['fields_bg_color'] => 'background-color: {{VALUE}};',
				],
			],
			'fields_normal_end'          => [
				'mode' => 'tab_end',
			],
			'fields_hover'               => [
				'mode'  => 'tab_start',
				'label' => esc_html__( 'Hover & Focus', 'shopbuilder-pro' ),
			],

			'fields_hover_border'        => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['fields_hover_border'],
				'size_units' => [ 'px' ],
			],
			'fields_border_radius_hover' => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['fields_border_radius_hover'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'fields_hover_text_color'    => [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['fields_hover_text_color'] => 'color: {{VALUE}};',
				],
			],
			'fields_hover_bg_color'      => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['fields_hover_bg_color'] => 'background-color: {{VALUE}};',
				],
			],

			'fields_hover_end'           => [
				'mode' => 'tab_end',
			],
			'fields_tabs_end'            => [
				'mode' => 'tabs_end',
			],

			'fields_padding'             => [
				'label'      => esc_html__( 'Fields Padding (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['fields_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],

			'form_row_margin'            => [
				'label'      => esc_html__( 'Form Row Margin (px)', 'shopbuilder-pro' ),
				'mode'       => 'responsive',
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['form_row_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],

			'fields_style_end'           => [
				'mode' => 'section_end',
			],
		];
	}

	public static function payment_step_style_settings( $widget ) {
		return [
			'payment_step_style_start'  => [
				'mode'  => 'section_start',
				'tab'   => 'style',
				'label' => esc_html__( 'Payment Step', 'shopbuilder-pro' ),
			],
			'payment_label_typo'        => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Label Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['payment_label_typo'],
			],
			'payment_text_typo'         => [
				'mode'     => 'group',
				'type'     => 'typography',
				'label'    => esc_html__( 'Text Typography', 'shopbuilder-pro' ),
				'selector' => $widget->selectors['payment_text_typo'],
			],
			'payment_box_border'        => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['payment_box_border'],
				'size_units' => [ 'px' ],
			],
			'payment_box_border_radius' => [
				'label'      => esc_html__( 'Border Radius (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['payment_box_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'payment_label_color'       => [
				'label'     => esc_html__( 'Label Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['payment_label_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'payment_text_color'        => [
				'label'     => esc_html__( 'Text Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['payment_text_color'] => 'color: {{VALUE}} !important;',
				],
			],
			'payment_bg_color'          => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['payment_bg_color'] => 'background-color: {{VALUE}} !important;',
				],
			],
			'payment_box_padding'       => [
				'label'      => esc_html__( 'Padding (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['payment_box_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			],
			'payment_step_style_end'    => [
				'mode' => 'section_end',
			],
		];
	}
	public static function order_table_style_settings( $widget ) {
		$fields = OrderReviewTableSettings::table_settings( $widget );
		unset( $fields['total_heading_width'] );
		unset( $fields['total_cell_heading_width'] );
		unset( $fields['table_product_title'] );
		unset( $fields['table_heading_background_color'] );
		unset( $fields['table_heading_align'] );
		unset( $fields['table_product_total'] );
		unset( $fields['table_cell_typography'] );
		unset( $fields['table_cell_color'] );
		unset( $fields['table_cell_background_color'] );
		unset( $fields['table_cell_align'] );
		return $fields;
	}
}
