<?php
/**
 * ProductStockCountSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class ProductStockCountSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		return self::general_settings() +
			   self::stock_count_style_settings( $widget );
	}


	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function general_settings() {
		return [
			'sec_general'          => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'product_stock_layout' => [
				'label'     => esc_html__( 'Layout', 'shopbuilder-pro' ),
				'type'      => 'rtsb-image-selector',
				'options'   => FnsPro::product_stock_count_layouts(),
				'default'   => 'layout1',
				'separator' => 'default',
			],
			'show_stock_text'      => [
				'label'       => esc_html__( 'Show Stock Text?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show stock count text.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',

			],
			'show_stock_progress'  => [
				'label'       => esc_html__( 'Show Stock Progress?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show stock progress bar.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'default'     => 'yes',
			],
			'stock_text_position'  => [
				'type'        => 'select2',
				'label'       => esc_html__( 'Stock Text Position', 'shopbuilder-pro' ),
				'description' => esc_html__( 'Please select the stock text position.', 'shopbuilder-pro' ),
				'options'     => [
					'top'    => esc_html__( 'Top', 'shopbuilder-pro' ),
					'bottom' => esc_html__( 'Bottom', 'shopbuilder-pro' ),
				],
				'default'     => 'top',
				'label_block' => true,
				'condition'       => [
					'show_stock_text' => 'yes',
				],

			],
			'stock_text'           => [
				'label'       => esc_html__( 'Stock Text', 'shopbuilder-pro' ),
				'type'        => 'textarea',
				'label_block' => true,
				'default'     => esc_html__( 'Only {count} item(s) left in stock.', 'shopbuilder-pro' ),
				'description' => __( 'Please use the {count} placeholder to dynamically show the stock count. <br />Example: Available Stock: {count} pcs.', 'shopbuilder-pro' ),
				'separator'   => 'default',
				'condition'   => [
					'show_stock_text' => 'yes',
				],
			],
			'sec_general_end'      => [
				'mode' => 'section_end',
			],
		];
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function stock_count_style_settings( $widget ) {
		return [
			'general_section_start'                 => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
				'tab'   => 'style',
			],
			'count_text_heading'                    => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Count Text', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
				'condition'       => [
					'show_stock_text' => 'yes',
				],
			],
			'product_stock_text_typography'         => [
				'mode'      => 'group',
				'type'      => 'typography',
				'label'     => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['product_stock_text_typography'],
				'condition' => [
					'show_stock_text' => 'yes',
				],
			],
			'stock_text_align'                      => [
				'mode'      => 'responsive',
				'label'     => esc_html__( 'Alignment', 'shopbuilder-pro' ),
				'type'      => 'choose',
				'options'   => ControlHelper::alignment(),
				'selectors' => [
					$widget->selectors['stock_text_align'] => 'text-align: {{VALUE}}!important;',
				],
				'condition'                            => [
					'show_stock_text' => 'yes',
				],
			],
			'product_stock_count_typography'        => [
				'mode'      => 'group',
				'type'      => 'typography',
				'label'     => esc_html__( 'Count Typography', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['product_stock_count_typography'],
				'condition' => [
					'show_stock_text' => 'yes',
				],
			],
			'count_text_color_heading'              => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Stock Text Color', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
				'condition'       => [
					'show_stock_text' => 'yes',
				],
			],
			'product_stock_text_color'              => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['product_stock_text_color'] => 'color: {{VALUE}};',
				],
				'condition' => [
					'show_stock_text' => 'yes',
				],
			],
			'product_stock_count_color'             => [
				'label'     => esc_html__( 'Count Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['product_stock_count_color'] => 'color: {{VALUE}};',
				],
				'condition' => [
					'show_stock_text' => 'yes',
				],
			],
			'product_stock_count_bgcolor'           => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['product_stock_count_bgcolor'] => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'show_stock_text' => 'yes',
				],
			],
			'count_text_color_border'               => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Stock Text Border', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
				'condition'       => [
					'show_stock_text' => 'yes',
				],
			],
			'stock_text_border'                     => [
				'mode'       => 'group',
				'type'       => 'border',
				'selector'   => $widget->selectors['stock_text_border'],
				'size_units' => [ 'px' ],
				'condition'  => [
					'show_stock_text' => 'yes',
				],
			],
			'count_text_color_spacing'              => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Stock Text Spacing', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
				'condition'       => [
					'show_stock_text' => 'yes',
				],
			],
			'product_stock_text_padding'            => [
				'label'      => esc_html__( 'Padding', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					$widget->selectors['product_stock_text_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_stock_text' => 'yes',
				],
			],
			'product_stock_text_margin'             => [
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					$widget->selectors['product_stock_text_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'                            => [
					'show_stock_text' => 'yes',
				],
			],
			'progress_heading'                      => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Progress Bar', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'before',
				'condition'       => [
					'show_stock_progress' => 'yes',
				],
			],
			'product_stock_progress_bg_color'       => [
				'label'     => esc_html__( 'Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['product_stock_progress_bg_color'] => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'show_stock_progress' => 'yes',
				],
			],
			'product_stock_progress_stock_bg_color' => [
				'label'     => esc_html__( 'Fill Background', 'shopbuilder-pro' ),
				'type'      => 'color',
				'alpha'     => true,
				'selectors' => [
					$widget->selectors['product_stock_progress_stock_bg_color'] => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'show_stock_progress' => 'yes',
				],
			],
			'product_stock_progress_height'         => [
				'label'     => esc_html__( 'Progress Height', 'shopbuilder-pro' ),
				'type'      => 'number',
				'selectors' => [
					$widget->selectors['product_stock_progress_height'] => 'height: {{VALUE}}px;',
				],
				'condition' => [
					'show_stock_progress' => 'yes',
				],
			],
			'product_stock_border_radius'           => [
				'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					$widget->selectors['product_stock_border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_stock_progress' => 'yes',
				],
			],
			'product_stock_margin'                  => [
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					$widget->selectors['product_stock_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_stock_progress' => 'yes',
				],
			],
			'general_section_end'                   => [
				'mode' => 'section_end',
			],
		];
	}
}
