<?php
/**
 * SaleCountSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Elementor\Widgets\Controls\TextStyleSettings;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * SaleCountSettings class.
 */
class QRCodeSettings {
	/**
	 * Widget Field
	 *
	 * @param object $widget Reference widget.
	 * @return array
	 */
	public static function settings( $widget ) {
		return self::general_settings() +
			  self::style_fields( $widget );
	}
	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function general_settings() {
		return [
			'sec_general'     => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
			],
			'size'            => [
				'type'    => 'number',
				'label'   => __( 'Size', 'shopbuilder-pro' ),
				'min'     => 50,
				'max'     => 500,
				'step'    => 10,
				'default' => 150,
			],
			'qr_ecc'          => [
				'label'       => __( 'Error Correction Level', 'shopbuilder-pro' ),
				'type'        => 'select',
				'default'     => 'L',
				'label_block' => true,
				'options'     => [
					'L' => __( 'Low (7%)', 'shopbuilder-pro' ),
					'M' => __( 'Medium (15%)', 'shopbuilder-pro' ),
					'Q' => __( 'Quartile (25%)', 'shopbuilder-pro' ),
					'H' => __( 'High (30%)', 'shopbuilder-pro' ),
				],
			],
			'add_to_cart_url' => [
				'label'       => esc_html__( 'Enable Add to Cart URL', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to add add to cart url on qr code.', 'shopbuilder-pro' ),
				'separator'   => 'default',
			],
			'quantity'        => [
				'type'      => 'number',
				'label'     => __( 'Quantity', 'shopbuilder-pro' ),
				'min'       => 1,
				'max'       => 100,
				'step'      => 1,
				'default'   => 1,
				'condition' => [
					'add_to_cart_url' => 'yes',
				],
			],
			'show_title_text' => [
				'label'       => esc_html__( 'Show Title?', 'shopbuilder-pro' ),
				'type'        => 'switch',
				'description' => esc_html__( 'Switch on to show title text.', 'shopbuilder-pro' ),
				'separator'   => 'default',
			],
			'title_text'      => [
				'label'       => esc_html__( 'Title Text', 'shopbuilder-pro' ),
				'type'        => 'text',
				'label_block' => true,
				'description' => esc_html__( 'Enter the title text.', 'shopbuilder-pro' ),
				'condition'   => [
					'show_title_text' => 'yes',
				],
			],
			'sec_general_end' => [
				'mode' => 'section_end',
			],
		];
	}
	/**
	 * Widget Style Field
	 *
	 * @return array
	 */
	public static function style_fields( $widget ) {
		return [
			'general_style_section_start' => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'General', 'shopbuilder-pro' ),
				'tab'   => 'style',
			],
			'title_text_heading'          => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'Title Text', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
				'condition'       => [
					'show_title_text' => 'yes',
				],
			],
			'title_text_typography'       => [
				'mode'      => 'group',
				'type'      => 'typography',
				'label'     => esc_html__( 'Typography', 'shopbuilder-pro' ),
				'selector'  => $widget->selectors['title_text_typography'],
				'condition' => [
					'show_title_text' => 'yes',
				],
			],
			'title_color'                 => [
				'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['title_color'] => 'color: {{VALUE}};',
				],
				'condition' => [
					'show_title_text' => 'yes',
				],
			],
			'title_text_margin'           => [
				'label'      => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					$widget->selectors['title_text_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_title_text' => 'yes',
				],
			],
			'qr_code_heading'             => [
				'type'            => 'html',
				'raw'             => sprintf(
					'<h3 class="rtsb-elementor-group-heading">%s</h3>',
					esc_html__( 'QR Code', 'shopbuilder-pro' )
				),
				'content_classes' => 'elementor-panel-heading-title',
				'separator'       => 'default',
			],
			'qr_code_color'               => [
				'label'       => esc_html__( 'Color', 'shopbuilder-pro' ),
				'render_type' => 'template',
				'type'        => 'color',
			],
			'qr_code_bgcolor'             => [
				'label'       => esc_html__( 'Background', 'shopbuilder-pro' ),
				'render_type' => 'template',
				'type'        => 'color',
			],
			'general_style_section_end'   => [
				'mode' => 'section_end',
			],
		];
	}
}
