<?php
/**
 * AccountAddressSettings class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Elementor\Widgets\Controls\ButtonSettings;
use RadiusTheme\SB\Helpers\Fns;

if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class SizeChartSettings {

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function settings( $widget ) {
		$options = Fns::get_options( 'modules', 'product_size_chart' );
		$button  = [];
		$image   = [];
		if ( 'general' === ( $options['size_chart_button_action'] ?? 'general' ) ) {
			$image = self::image( $widget );
		} else {
			$button = ButtonSettings::style_settings( $widget );
			unset( $button['button_section_start']['tab'] );
		}
		return $button + $image;
	}


	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public static function image( $widget ) {
		return [
			'image_section_start' => [
				'mode'  => 'section_start',
				'label' => esc_html__( 'Image', 'shopbuilder-pro' ),
			],
			'image_width'         => [
				'label'      => esc_html__( 'Image Width', 'shopbuilder-pro' ),
				'type'       => 'slider',
				'size_units' => [ '%', 'px' ],
				'range'      => [
					'%'  => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
					'px' => [
						'min'  => 0,
						'max'  => 2000,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => '%',
				],
				'separator'  => 'default',
				'selectors'  => [
					$widget->selectors['image_width'] => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			],
			//'image_border_radius' => [
			//	'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			//	'type'       => 'slider',
			//	'size_units' => [ 'px', '%' ],
			//	'range'      => [
			//		'px' => [
			//			'min'  => 0,
			//			'max'  => 100,
			//			'step' => 1,
			//		],
			//		'%'  => [
			//			'min'  => 0,
			//			'max'  => 100,
			//			'step' => 1,
			//		],
			//	],
			//	'selectors'  => [
			//		$widget->selectors['image_border_radius'] => 'border-radius: {{SIZE}}{{UNIT}} !important;',
			//	],
			//],
			'image_bg_color'      => [
				'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
				'type'      => 'color',
				'selectors' => [
					$widget->selectors['image_bg_color'] => 'background-color: {{VALUE}};',
				],
			],

			'image_padding'       => [
				'label'      => esc_html__( 'Padding (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['image_padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
				'separator'  => 'before',
			],
			'image_margin'        => [
				'label'      => esc_html__( 'Margin (px)', 'shopbuilder-pro' ),
				'type'       => 'dimensions',
				'mode'       => 'responsive',
				'size_units' => [ 'px' ],
				'selectors'  => [
					$widget->selectors['image_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			],
			'image_section_end'   => [
				'mode' => 'section_end',
			],
		];
	}
}
