<?php
/**
 * Elementor Style Fields Class.
 *
 * This class contains all the pro fields for Style tab.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Controls;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Elementor\Helper\ControlHelper;
use RadiusTheme\SB\Elementor\Widgets\Controls\StyleFields as StyleFieldsFree;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Elementor Style Fields Class.
 */
class StyleFields {
	/**
	 * Ajax Filter section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function ajax_filter_controls( $obj ) {
		$css_selectors = $obj->selectors['ajax_filter_controls'];
		$title         = esc_html__( 'Ajax Tab Filters', 'shopbuilder-pro' );
		$condition     = [
			'tax_filter' => [ 'yes' ],
		];
		$selectors     = [
			'typography'               => $css_selectors['typography'],
			'alignment'                => [ $css_selectors['alignment'] => 'justify-content: {{VALUE}};' ],
			'track_height'             => [ $css_selectors['track_height'] => '--rtsb-filter-track-height: {{SIZE}}{{UNIT}};' ],
			'color'                    => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'count_color'              => [ $css_selectors['count_color'] => 'color: {{VALUE}};' ],
			'track_bg_color'           => [ $css_selectors['track_bg_color'] => 'background-color: {{VALUE}};' ],
			'track_border_color'       => [ $css_selectors['track_border_color'] => 'background-color: {{VALUE}};' ],
			'bg_color'                 => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}};' ],
			'hover_color'              => [ $css_selectors['hover_color'] => 'color: {{VALUE}};' ],
			'track_bg_hover_color'     => [ $css_selectors['track_bg_hover_color'] => 'background-color: {{VALUE}};' ],
			'track_border_hover_color' => [ $css_selectors['track_border_hover_color'] => 'background-color: {{VALUE}};' ],
			'count_hover_color'        => [ $css_selectors['count_hover_color'] => 'color: {{VALUE}};' ],
			'hover_bg_color'           => [ $css_selectors['hover_bg_color'] => 'background-color: {{VALUE}};' ],
			'active_color'             => [ $css_selectors['active_color'] => 'color: {{VALUE}};' ],
			'active_count_color'       => [ $css_selectors['active_count_color'] => 'color: {{VALUE}};' ],
			'active_bg_color'          => [ $css_selectors['active_bg_color'] => 'background-color: {{VALUE}}; border-color: {{VALUE}};' ],
			'border'                   => $css_selectors['border'],
			'border_hover_color'       => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}};' ],
			'border_active_color'      => [ $css_selectors['border_active_color'] => 'border-color: {{VALUE}};' ],
			'border_radius'            => [ $css_selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'padding'                  => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'margin'                   => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'wrapper_margin'           => [ $css_selectors['wrapper_margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields = ControlHelper::general_elementor_style( 'ajax_filters', $title, $obj, $condition, $selectors );

		$extra_controls = [];

		$extra_controls['ajax_filters_track_height'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Track Height', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 200,
				],
			],
			'condition'  => [ 'tax_filter_type' => 'track' ],
			'selectors'  => $selectors['track_height'],
		];

		$fields = Fns::insert_controls( 'ajax_filters_alignment', $fields, $extra_controls, true );

		$extra_controls['ajax_filters_count_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Count Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['count_color'],
			'separator' => 'default',
		];

		$fields = Fns::insert_controls( 'ajax_filters_color', $fields, $extra_controls, true );

		$extra_controls['ajax_filters_track_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Track Background Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['track_bg_color'],
			'separator' => 'default',
			'condition' => [ 'tax_filter_type' => 'track' ],
		];

		$extra_controls['ajax_filters_track_border_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Track Border Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['track_border_color'],
			'separator' => 'default',
			'condition' => [ 'tax_filter_type' => 'track' ],
		];

		$fields = Fns::insert_controls( 'ajax_filters_bg_color', $fields, $extra_controls, true );

		$extra_controls['ajax_filters_hover_count_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Count Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['count_hover_color'],
			'separator' => 'default',
		];

		$fields = Fns::insert_controls( 'ajax_filters_hover_color', $fields, $extra_controls, true );

		$extra_controls['ajax_filters_hover_track_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Track Background Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['track_bg_hover_color'],
			'separator' => 'default',
			'condition' => [ 'tax_filter_type' => 'track' ],
		];

		$extra_controls['ajax_filters_hover_track_border_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Track Border Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['track_border_hover_color'],
			'separator' => 'default',
			'condition' => [ 'tax_filter_type' => 'track' ],
		];

		$fields = Fns::insert_controls( 'ajax_filters_hover_bg_color', $fields, $extra_controls, true );

		$extra_controls['ajax_filters_active_color_tab'] = $obj->start_tab( esc_html__( 'Active', 'shopbuilder-pro' ) );

		$extra_controls['ajax_filters_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['active_color'],
			'separator' => 'default',
		];

		$extra_controls['ajax_filters_active_count_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Count Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['active_count_color'],
			'separator' => 'default',
		];

		$extra_controls['ajax_filters_active_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Background Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['active_bg_color'],
			'separator' => 'default',
		];

		$extra_controls['ajax_filters_active_color_tab_end'] = $obj->end_tab();

		$fields = Fns::insert_controls( 'ajax_filters_hover_color_tab_end', $fields, $extra_controls, true );

		$extra_controls['ajax_filters_border_active_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Active Color', 'shopbuilder-pro' ),
			'condition' => [ 'rtsb_el_ajax_filters_border_border!' => [ '' ] ],
			'selectors' => $selectors['border_active_color'],
		];

		$extra_controls['ajax_filters_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['border_radius'],
		];

		$fields = Fns::insert_controls( 'ajax_filters_border_hover_color', $fields, $extra_controls, true );

		$extra_controls['ajax_filters_wrapper_margin'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Wrapper Margin', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['wrapper_margin'],
		];

		return Fns::insert_controls( 'ajax_filters_margin', $fields, $extra_controls, true );
	}

	/**
	 * Quick checkout style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function quick_checkout_styles( $obj ) {
		$css_selectors = $obj->selectors['quick_checkout_styles'];
		$title         = esc_html__( 'Quick Checkout Button', 'shopbuilder-pro' );
		$condition     = [
			'show_quick_checkout' => [ 'yes' ],
		];
		$selectors     = [
			'typography'            => $css_selectors['typography'],
			'icon_size'             => [
				$css_selectors['icon_size']['font_size'] => 'font-size: {{SIZE}}{{UNIT}};',
				$css_selectors['icon_size']['width']     => 'height: {{SIZE}}{{UNIT}};',
			],
			'checkout_icon_spacing' => [ $css_selectors['checkout_icon_spacing'] => 'margin-left: {{SIZE}}{{UNIT}};' ],
			'checkout_width'        => [ $css_selectors['checkout_width'] => 'width: {{SIZE}}{{UNIT}} !important;' ],
			'checkout_height'       => [ $css_selectors['checkout_height'] => 'height: {{SIZE}}{{UNIT}} !important;' ],
			'color'                 => [ $css_selectors['color'] => 'color: {{VALUE}};' ],
			'bg_color'              => [ $css_selectors['bg_color'] => 'background-color: {{VALUE}};' ],
			'icon_color'            => [ $css_selectors['icon_color'] => 'color: {{VALUE}};' ],
			'hover_color'           => [ $css_selectors['hover_color'] => 'color: {{VALUE}};' ],
			'hover_bg_color'        => [ $css_selectors['hover_bg_color'] => 'background-color: {{VALUE}};' ],
			'hover_icon_color'      => [ $css_selectors['hover_icon_color'] => 'color: {{VALUE}};' ],
			'border'                => $css_selectors['border'],
			'border_hover_color'    => [ $css_selectors['border_hover_color'] => 'border-color: {{VALUE}};' ],
			'border_radius'         => [ $css_selectors['border_radius'] => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'padding'               => [ $css_selectors['padding'] => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			'margin'                => [ $css_selectors['margin'] => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
		];

		$fields = ControlHelper::general_elementor_style( 'quick_checkout_styles', $title, $obj, $condition, $selectors );

		$fields['quick_checkout_styles_alignment'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'condition'  => [
				'show_cart_icon' => [ 'yes' ],
			],
			'selectors'  => $selectors['icon_size'],
		];

		$extra_controls = [];

		$extra_controls['quick_checkout_icon_spacing'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Icon Spacing', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default'    => [
				'unit' => 'px',
				'size' => 8,
			],
			'condition'  => [ 'show_quick_checkout_text' => [ 'yes' ] ],
			'selectors'  => $selectors['checkout_icon_spacing'],
		];

		$extra_controls['quick_checkout_width'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 1000,
				],
			],
			'selectors'  => $selectors['checkout_width'],
		];

		$extra_controls['quick_checkout_height'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'height', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 1000,
				],
			],
			'selectors'  => $selectors['checkout_height'],
		];

		$fields = Fns::insert_controls( 'quick_checkout_styles_alignment', $fields, $extra_controls, true );

		$extra_controls['quick_checkout_styles_icon_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Icon Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['icon_color'],
		];

		$fields = Fns::insert_controls( 'quick_checkout_styles_bg_color', $fields, $extra_controls, true );

		$extra_controls['quick_checkout_styles_hover_icon_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Icon Color', 'shopbuilder-pro' ),
			'selectors' => $selectors['hover_icon_color'],
		];

		$fields = Fns::insert_controls( 'quick_checkout_styles_hover_bg_color', $fields, $extra_controls, true );

		$extra_controls['quick_checkout_styles_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['border_radius'],
		];

		return Fns::insert_controls( 'quick_checkout_styles_border_hover_color', $fields, $extra_controls, true );
	}

	/**
	 * Share Toggle style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function share_toggle( $obj ) {
		$css_selectors = $obj->selectors['share_toggle_styles'];
		$title         = esc_html__( 'Share Toggle Button', 'shopbuilder-pro' );
		$condition     = [
			'share_toggle' => [ 'yes' ],
		];
		$selectors     = StyleFieldsFree::action_btn_selectors( $css_selectors );

		unset( $selectors['icon_size'] );

		$selectors['item_spacing'] = [
			$css_selectors['item_spacing']['vertical']   => 'padding-top: {{SIZE}}{{UNIT}} !important;',
			$css_selectors['item_spacing']['horizontal'] => 'padding-left: {{SIZE}}{{UNIT}} !important;',
			$css_selectors['item_spacing']['rtl']        => 'padding-right: {{SIZE}}{{UNIT}} !important;',
		];
		$selectors['icon_size']    = [
			$css_selectors['icon_size']['font_size'] => 'font-size: {{SIZE}}{{UNIT}};',
			$css_selectors['icon_size']['width']     => 'width: auto; height: {{SIZE}}{{UNIT}} !important;',
		];

		$fields = ControlHelper::general_elementor_style( 'share_toggle_styles', $title, $obj, $condition, $selectors );

		unset( $fields['share_toggle_styles_alignment'] );

		$fields['share_toggle_styles_hover_color_tab']['label'] = esc_html__( 'Hover / Active', 'shopbuilder-pro' );

		$fields['rtsb_el_share_toggle_styles_typography'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Icon Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['icon_size'],
			'separator'  => 'default',
		];

		$extra_controls = [];

		$extra_controls['share_toggle_styles_width'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Width', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['width'],
		];

		$extra_controls['share_toggle_styles_height'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'height', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors'  => $selectors['height'],
		];

		$extra_controls['share_toggle_spacing'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Spacing with Social Items', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 0,
					'max' => 500,
				],
			],
			'selectors'  => $selectors['item_spacing'],
		];

		$fields = Fns::insert_controls( 'share_toggle_styles_color_note', $fields, $extra_controls );

		$extra_controls['share_toggle_styles_radius'] = [
			'mode'       => 'responsive',
			'type'       => 'dimensions',
			'label'      => esc_html__( 'Border Radius', 'shopbuilder-pro' ),
			'size_units' => [ 'px', '%', 'em' ],
			'selectors'  => $selectors['border_radius'],
		];

		return Fns::insert_controls( 'share_toggle_styles_border_hover_color', $fields, $extra_controls, true );
	}

	/**
	 * Pointer style section
	 *
	 * @param object $obj Reference object.
	 *
	 * @return array
	 */
	public static function pointer_styles( $obj ) {
		$css_selectors = $obj->selectors['pointer_styles'];

		$fields['pointer_style_section_start'] = $obj->start_section( esc_html__( 'Pointer Styles', 'shopbuilder-pro' ), 'style' );
		$fields['pointer_dimension_note']      = $obj->el_heading( esc_html__( 'Dimension', 'shopbuilder-pro' ) );

		$fields['pointer_width'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Pointer Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 10,
					'max' => 100,
				],
			],
			'selectors'  => [ $css_selectors['pointer_width'] => '--rtsb-pointer-size: {{SIZE}}{{UNIT}} !important;' ],
		];

		$fields['pointer_icon_size'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Pointer Icon Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 10,
					'max' => 100,
				],
			],
			'selectors'  => [ $css_selectors['pointer_icon_size'] => '--rtsb-pointer-icon-size: {{SIZE}}{{UNIT}} !important;' ],
			'condition'  => [ 'lookbook_pointer_preset!' => [ 'lookbook-pointer-preset1' ] ],
		];

		$fields['pointer_hover_width'] = [
			'type'       => 'slider',
			'mode'       => 'responsive',
			'label'      => esc_html__( 'Pointer Hover Size', 'shopbuilder-pro' ),
			'size_units' => [ 'px' ],
			'range'      => [
				'px' => [
					'min' => 10,
					'max' => 100,
				],
			],
			'selectors'  => [ $css_selectors['pointer_hover_width'] => '--rtsb-pointer-size-hover: {{SIZE}}{{UNIT}} !important;' ],
			'condition'  => [ 'lookbook_pointer_preset' => [ 'lookbook-pointer-preset1' ] ],
		];

		$fields['pointer_scale'] = [
			'type'      => 'slider',
			'mode'      => 'responsive',
			'label'     => esc_html__( 'Pulse Animation Spreading Factor', 'shopbuilder-pro' ),
			'range'     => [
				'min' => 1,
				'max' => 50,
			],
			'selectors' => [ $css_selectors['pointer_scale'] => '--rtsb-scale-factor: {{SIZE}}' ],
			'condition' => [ 'lookbook_pointer_pulse_animation' => [ 'yes' ] ],
		];

		$fields['pointer_color_note'] = $obj->el_heading( esc_html__( 'Colors', 'shopbuilder-pro' ) );
		$fields['pointer_color_tabs'] = $obj->start_tab_group();
		$fields['pointer_color_tab']  = $obj->start_tab( esc_html__( 'Normal', 'shopbuilder-pro' ) );

		$fields['pointer_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['pointer_color'] => '--rtsb-pointer-color: {{VALUE}} !important;' ],
		];

		$fields['pointer_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Background Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['pointer_bg_color'] => '--rtsb-pointer-wrapper-color: {{VALUE}} !important;' ],
			'condition' => [ 'lookbook_pointer_preset!' => [ 'lookbook-pointer-preset1' ] ],
		];

		$fields['pointer_border_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Border Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['pointer_border_color'] => '--rtsb-pointer-border-color: {{VALUE}} !important;' ],
			'condition' => [ 'lookbook_pointer_preset' => [ 'lookbook-pointer-preset1', 'lookbook-pointer-preset3' ] ],
		];

		$fields['pointer_color_tab_end']   = $obj->end_tab();
		$fields['pointer_hover_color_tab'] = $obj->start_tab( esc_html__( 'Hover', 'shopbuilder-pro' ) );

		$fields['pointer_hover_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['pointer_hover_color'] => '--rtsb-pointer-color: {{VALUE}} !important;' ],
		];

		$fields['pointer_hover_bg_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Hover Background Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['pointer_bg_color'] => '--rtsb-pointer-wrapper-hover-color: {{VALUE}} !important;' ],
			'condition' => [ 'lookbook_pointer_preset!' => [ 'lookbook-pointer-preset1' ] ],
		];

		$fields['pointer_hover_border_color'] = [
			'type'      => 'color',
			'label'     => esc_html__( 'Border Color', 'shopbuilder-pro' ),
			'selectors' => [ $css_selectors['pointer_hover_border_color'] => '--rtsb-pointer-border-color: {{VALUE}} !important;' ],
			'condition' => [ 'lookbook_pointer_preset' => [ 'lookbook-pointer-preset1', 'lookbook-pointer-preset3' ] ],
		];

		$fields['pointer_hover_color_tab_end'] = $obj->end_tab();
		$fields['pointer_color_tabs_end']      = $obj->end_tab_group();

		$fields['pointer_style_section_end'] = $obj->end_section();

		return $fields;
	}
}
