<?php
/**
 * Selectors class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\CouponList;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Selectors class.
 *
 * @package RadiusTheme\SBPRO
 */
class Selectors {
	/**
	 * Product Lookbook CSS Selectors.
	 *
	 * @return array
	 */
	public static function get_selectors() {
		return [
			'layout' => [
				'cols' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-row',
			],
			'design' => [
				'discount_typography'     => '{{WRAPPER}} .rtsb-coupon-card .rtsb-coupon-content .coupon-discount',
				'code_typography'         => '{{WRAPPER}} .rtsb-coupon-card .rtsb-coupon-content .coupon-code',
				'validity_typography'     => '{{WRAPPER}} .rtsb-coupon-card .rtsb-coupon-content :where(.coupon-days-left, .coupon-validity) span',
				'text_typography'         => '{{WRAPPER}} .rtsb-coupon-card .rtsb-coupon-side',
				'coupon_bg_color'         => '{{WRAPPER}} .coupon-item',
				'coupon_text_color'       => '{{WRAPPER}} .coupon-item',
				'coupon_dot_color'        => '{{WRAPPER}} .coupon-item',
				'coupon_badge_bg_color'   => '{{WRAPPER}} .coupon-item .rtsb-coupon-card .rtsb-coupon-side',
				'coupon_expired_bg_color' => '{{WRAPPER}} .rtsb-elementor-container :is(.rtsb-coupon-layout1, .rtsb-coupon-layout2, .rtsb-coupon-layout3) .coupon-item.coupon-expired',
				'coupon_badge_text_color' => [
					'color'    => '{{WRAPPER}} .coupon-item .rtsb-coupon-card .rtsb-coupon-side',
					'bg_color' => '{{WRAPPER}} .coupon-item .rtsb-coupon-card .rtsb-coupon-side .coupon-label::before',
				],
				'content_padding'         => '{{WRAPPER}} .coupon-item .rtsb-coupon-card .rtsb-coupon-content',
				'content_height'          => '{{WRAPPER}} .coupon-item .rtsb-coupon-card',
				'badge_x_position'        => '{{WRAPPER}} .coupon-item .rtsb-coupon-card .rtsb-coupon-side',
				'badge_y_position'        => '{{WRAPPER}} .coupon-item .rtsb-coupon-card .rtsb-coupon-side',
				'badge_padding'           => '{{WRAPPER}} .coupon-item .rtsb-coupon-card .rtsb-coupon-side',
				'grid_gap'                => [
					'padding'        => '{{WRAPPER}} .rtsb-elementor-container [class*=rtsb-col-]',
					'margin'         => '{{WRAPPER}} .rtsb-elementor-container .rtsb-row',
					'element_margin' => '{{WRAPPER}} .rtsb-elementor-container .coupon-item',
				],
			],
		];
	}
}
