<?php
/**
 * Selectors class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\HeroSlider;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Selectors class.
 *
 * @package RadiusTheme\SBPRO
 */
class Selectors {
	/**
	 * Image Hotspots CSS Selectors.
	 *
	 * @return array
	 */
	public static function get_selectors() {
		return [
			'slider_item'    => [
				'alignment'        => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-content',
				'justify'          => '{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4 .rtsb-slider-content-wrap.background',
				'height'           => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slide-item',
				'container_width'  => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-container',
				'border_radius'    => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slide-item',
				'padding'          => '{{WRAPPER}} .rtsb-slider-layout:not(.rtsb-hero-slider-layout4) .rtsb-hero-slider-item .rtsb-slider-content-wrap,{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-item  .rtsb-slider-content',
				'bg_overlay_color' => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-hero-slider-item:after',
				'arrow_position1'  => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout.rtsb-hero-slider-layout1,{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout2,{{WRAPPER}} .rtsb-hero-slider,{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4',
				'arrow_position2'  => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout.rtsb-hero-slider-layout1,{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout2,{{WRAPPER}} .rtsb-hero-slider',
				'dot_position1'    => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout.rtsb-hero-slider-layout1 .swiper-pagination.swiper-pagination-fraction,{{WRAPPER}} .rtsb-hero-slider,{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4',
				'dot_position2'    => '{{WRAPPER}} {{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout.rtsb-hero-slider-layout1 .swiper-pagination.swiper-pagination-fraction,{{WRAPPER}} .rtsb-hero-slider,{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4',
			],
			'subtitle_style' => [
				'typography'     => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-subtitle',
				'color'          => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-subtitle',
				'bg_color'       => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-subtitle',
				'border'         => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-subtitle',
				'border_radius'  => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-subtitle',
				'padding'        => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-subtitle',
				'subtitle_width' => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-subtitle',
				'margin'         => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-subtitle',
			],
			'title_style'    => [
				'typography'              => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-title',
				'color'                   => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-title',
				'title_shape_color'       => '{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4 .rtsb-slider-title:after',
				'shape_position'          => '{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4 .rtsb-slider-title:after',
				'shape_vertical_position' => '{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4 .rtsb-slider-title:after',
				'shape_width'             => '{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4 .rtsb-slider-title:after',
				'shape_height'            => '{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4 .rtsb-slider-title:after',
				'margin'                  => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-title',
			],
			'title_style2'   => [
				'typography' => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-title2',
				'color'      => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-title2',
				'margin'     => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-title2',
			],
			'content_style'  => [
				'typography' => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-des',
				'color'      => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-des',
				'margin'     => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-des',
			],
			'button_style'   => [
				'typography'         => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link',
				'color'              => '{{WRAPPER}}  .rtsb-hero-slider  .rtsb-slider-button .button-link',
				'bg_color'           => '{{WRAPPER}}  .rtsb-hero-slider  .rtsb-slider-button .button-link',
				'hover_color'        => '{{WRAPPER}}  .rtsb-hero-slider  .rtsb-slider-button .button-link:hover',
				'hover_bg_color'     => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link:hover,{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4 .button-link:before',
				'border'             => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link',
				'btn_width'          => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link',
				'btn_height'         => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link',
				'box_shadow'         => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link',
				'border_hover_color' => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link:hover',
				'border_radius'      => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link',
				'padding'            => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link',
				'margin'             => '{{WRAPPER}} .rtsb-hero-slider .rtsb-slider-layout .rtsb-slider-button',
				'icon_gap'           => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link',
				'icon_size'          => [
					'font_size' => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link i',
					'svg'       => '{{WRAPPER}} .rtsb-hero-slider  .rtsb-slider-button .button-link svg',
				],
			],
			'slider_buttons' => [
				'arrow_size'             => [
					'icon' => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow i',
					'svg'  => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow svg',
				],
				'arrow_width'            => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow',
				'arrow_height'           => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow',
				'arrow_line_height'      => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow i',
				'dot_width'              => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-pagination-bullet',
				'dot_height'             => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-pagination-bullet',
				'dot_spacing'            => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-pagination-bullet',
				'color'                  => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow,{{WRAPPER}} .rtsb-hero-slider.has-number-dot-pagination  .swiper-pagination .swiper-pagination-bullet',
				'number_separator_color' => '{{WRAPPER}} .rtsb-hero-slider.has-number-dot-pagination  .swiper-pagination .swiper-pagination-bullet .number:after',
				'bg_color'               => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow,{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4 .swiper-pagination',
				'hover_color'            => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow:hover',
				'hover_bg_color'         => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow:hover',
				'dot_color'              => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-pagination-bullet',
				'dot_active_color'       => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-pagination-bullet-active',
				'border'                 => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow,{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-pagination-bullet',
				'border_hover_color'     => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow:hover, {{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-pagination-bullet:hover',
				'active_border_color'    => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-pagination-bullet-active',
				'border_radius'          => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-arrow, {{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-pagination-bullet',
				'wrapper_padding'        => '{{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-nav, {{WRAPPER}} .rtsb-elementor-container .rtsb-hero-carousel-slider .swiper-pagination',
				'number_dot_height'      => '{{WRAPPER}} .rtsb-hero-slider .rtsb-hero-slider-layout4 .swiper-pagination',
			],
		];
	}
}
