<?php
/**
 * Render class for Image Hotspots widget.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\ImageHotspots;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Elementor\Helper\RenderHelpers;
use RadiusTheme\SB\Elementor\Render\GeneralAddons;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Render class.
 *
 * @package RadiusTheme\SBPRO
 */
class Render extends GeneralAddons {
	/**
	 * Main render function for displaying content.
	 *
	 * @param array $data     Data to be passed to the template.
	 * @param array $settings Widget settings.
	 *
	 * @return string
	 */
	public function display_content( $data, $settings ) {
		$this->settings  = $settings;
		$data            = wp_parse_args( $this->get_template_args(), $data );
		$data            = apply_filters( 'rtsb/general/hotspots/args/' . $data['unique_name'], $data );
		$data['content'] = Fns::load_template( $data['template'], $data, true );

		return $this->addon_view( $data, $settings );
	}

	/**
	 * Retrieves template args based on widget settings.
	 *
	 * @return array
	 */
	private function get_template_args() {
		return [
			'pointers'        => RenderHelpers::get_data( $this->settings, 'hotspots_pointers_fields', [] ),
			'wrapper_classes' => $this->get_wrapper_classes(),
			'image_args'      => $this->get_image_args(),
			'render'          => $this,
		];
	}

	/**
	 * Image args.
	 *
	 * @return array
	 */
	private function get_image_args() {
		return [
			'image'             => $this->settings['lookbook_custom_image'],
			'size'              => $this->settings['lookbook_image_size'] ?? 'medium',
			'custom_image_args' => [
				'custom' => RenderHelpers::get_data( $this->settings, 'lookbook_image_custom_dimension', [] ),
				'crop'   => RenderHelpers::get_data( $this->settings, 'lookbook_image_crop', 'hard' ),
			],
		];
	}

	/**
	 * Retrieves wrapper class.
	 *
	 * @return string
	 */
	private function get_wrapper_classes() {
		$classes   = [ 'lookbook-wrapper' ];
		$classes[] = ! empty( $this->settings['lookbook_show_overlay'] ) ? 'show-overlay' : '';
		$classes[] = ! empty( $this->settings['lookbook_pointer_pulse_animation'] ) ? 'show-pulse' : '';
		$classes[] = ! empty( $this->settings['lookbook_pointer_preset'] )
			? $this->settings['lookbook_pointer_preset'] : 'lookbook-pointer-preset1';

		if ( ! empty( $this->settings['lookbook_image_hover_animation'] ) ) {
			$classes[] = 'img-hover-' . $this->settings['lookbook_image_hover_animation'];
		}

		return implode( ' ', array_filter( $classes ) );
	}
}
