<?php
/**
 * ProductLookBook class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\ProductLookBook;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * ProductLookBook class.
 *
 * @package RadiusTheme\SBPRO
 */
class ProductLookBook extends ElementorWidgetBase {
	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Product Lookbook', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-product-lookbook';

		parent::__construct( $data, $args );

		$this->rtsb_category = 'rtsb-shopbuilder-general';
	}

	/**
	 * Whether the element returns dynamic content.
	 *
	 * @return bool
	 */
	protected function is_dynamic_content(): bool {
		return false;
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public function widget_fields() {
		return array_merge(
			Controls::content( $this ),
			Controls::style( $this )
		);
	}

	/**
	 * Style dependencies.
	 *
	 * @return array
	 */
	public function get_style_depends(): array {
		return [
			'rtsb-general-addons',
		];
	}

	/**
	 * Script dependencies.
	 *
	 * @return array
	 */
	public function get_script_depends(): array {
		return [
			'rtsb-tippy',
		];
	}

	/**
	 * Addon Render.
	 *
	 * @return void
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$template = empty( $settings['layout'] ) || 'rtsb-lookbook-layout2' !== $settings['layout'] ? 'layout-1' : 'layout-2';
		$template = apply_filters( 'rtsb/elements/general/template/lookbook/', $template, $settings );
		$data     = [
			'template'    => 'elementor/general/lookbook/' . $template,
			'id'          => $this->get_id(),
			'unique_name' => $this->get_unique_name(),
			'layout'      => $settings['layout'] ?? 'rtsb-lookbook-layout1',
			'settings'    => $settings,
		];

		// Render initialization.
		$this->theme_support();

		// Call the template rendering method.
		Fns::print_html( ( new Render() )->display_content( $data, $settings ), true );

		$this->theme_support( 'render_reset' );
	}
}
