<?php
/**
 * Selectors class.
 *
 * @package RadiusTheme\SBPRO
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\General\ProductLookBook;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Selectors class.
 *
 * @package RadiusTheme\SBPRO
 */
class Selectors {
	/**
	 * Product Lookbook CSS Selectors.
	 *
	 * @return array
	 */
	public static function get_selectors() {
		return [
			'pointers'       => [
				'pos_x' => '{{WRAPPER}} {{CURRENT_ITEM}}',
				'pos_y' => '{{WRAPPER}} {{CURRENT_ITEM}}',
			],
			'color_scheme'   => [
				'primary_color'   => '{{WRAPPER}} .rtsb-product-lookbook, .tippy-box[data-theme=rtsb-lookbook]',
				'secondary_color' => '{{WRAPPER}} .rtsb-product-lookbook, .tippy-box[data-theme=rtsb-lookbook]',
				'loader_color'    => '{{WRAPPER}} .rtsb-product-lookbook',
			],
			'image'          => [
				'overlay'              => '{{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.show-overlay::before',
				'hover_overlay'        => '{{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.show-overlay:hover::before',
				'img_bg_color'         => '{{WRAPPER}} .rtsb-product-lookbook .image-container img',
				'border'               => '{{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper',
				'border_radius'        => '{{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper',
				'margin'               => '{{WRAPPER}} .rtsb-product-lookbook',
				'width'                => '',
				'max_width'            => '',
				'img_wrapper_bg_color' => '',
			],
			'pointer_styles' => [
				'pointer_width'              => '{{WRAPPER}} .rtsb-product-lookbook, {{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.lookbook-pointer-preset2, {{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.lookbook-pointer-preset3 .popup-pointer-buttons .pointer-button',
				'pointer_icon_size'          => '{{WRAPPER}} .rtsb-product-lookbook, {{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.lookbook-pointer-preset3 .popup-pointer-buttons .pointer-button',
				'pointer_hover_width'        => '{{WRAPPER}} .rtsb-product-lookbook',
				'pointer_scale'              => '{{WRAPPER}} .rtsb-product-lookbook, {{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.lookbook-pointer-preset2, {{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.lookbook-pointer-preset3',
				'pointer_color'              => '{{WRAPPER}} .rtsb-product-lookbook .popup-pointer-buttons .pointer-button .product-data',
				'pointer_bg_color'           => '{{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.lookbook-pointer-preset2, {{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.lookbook-pointer-preset3',
				'pointer_border_color'       => '{{WRAPPER}} .rtsb-product-lookbook .popup-pointer-buttons .pointer-button, {{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.lookbook-pointer-preset3',
				'pointer_hover_color'        => '{{WRAPPER}} .rtsb-product-lookbook .popup-pointer-buttons .pointer-button:hover .product-data',
				'pointer_bg_hover_color'     => '{{WRAPPER}} .rtsb-product-lookbook .popup-pointer-buttons .pointer-button:hover .product-data',
				'pointer_hover_border_color' => '{{WRAPPER}} .rtsb-product-lookbook .popup-pointer-buttons .pointer-button:hover, {{WRAPPER}} .rtsb-product-lookbook .lookbook-wrapper.lookbook-pointer-preset3 .popup-pointer-buttons .pointer-button:hover',
			],
			'product_popup'  => [
				'product_popup_width'             => '.tippy-box[data-theme=rtsb-lookbook]',
				'product_popup_image_height'      => '.rtsb-elementor-container .rtsb-lookbook-popup .rtsb-product-img figure img',
				'title_typography'                => '.rtsb-elementor-container .rtsb-lookbook-popup .product-title',
				'price_typography'                => '.rtsb-elementor-container .rtsb-lookbook-popup .product-price',
				'popup_bg_color'                  => '.tippy-box[data-theme=rtsb-lookbook]',
				'popup_title_color'               => '.rtsb-elementor-container .rtsb-lookbook-popup .product-title',
				'popup_price_color'               => '.rtsb-elementor-container .rtsb-lookbook-popup .product-price',
				'popup_badge_color'               => '.rtsb-elementor-container .rtsb-lookbook-popup .rtsb-product-img .rtsb-promotion .rtsb-tag-fill',
				'popup_badge_bg_color'            => '.rtsb-elementor-container .rtsb-lookbook-popup .rtsb-product-img .rtsb-promotion .rtsb-tag-fill',
				'popup_action_button_color'       => '.rtsb-elementor-container .rtsb-lookbook-popup .rtsb-action-buttons.top-part .rtsb-action-button-item > a',
				'popup_button_color'              => '.rtsb-elementor-container .rtsb-lookbook-popup .rtsb-action-buttons:not(.top-part) .rtsb-action-button-list .rtsb-cart .rtsb-action-btn',
				'popup_button_bg_color'           => '.rtsb-elementor-container .rtsb-lookbook-popup .rtsb-action-buttons:not(.top-part) .rtsb-action-button-list .rtsb-cart .rtsb-action-btn',
				'popup_title_hover_color'         => '.rtsb-elementor-container .rtsb-lookbook-popup .product-title:hover',
				'popup_action_button_hover_color' => '.rtsb-elementor-container .rtsb-lookbook-popup .rtsb-action-buttons.top-part .rtsb-action-button-item > a:hover',
				'popup_button_hover_color'        => '.rtsb-elementor-container .rtsb-lookbook-popup .rtsb-action-buttons:not(.top-part) .rtsb-action-button-list .rtsb-cart .rtsb-action-btn:hover',
				'popup_button_bg_hover_color'     => '.rtsb-elementor-container .rtsb-lookbook-popup .rtsb-action-buttons:not(.top-part) .rtsb-action-button-list .rtsb-cart .rtsb-action-btn:hover',
			],
		];
	}
}
