<?php
/**
 * AccountAddressDescription class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\DescriptionSettings;



// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigation class.
 */
class AccountAddressDescription extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Account Address Description', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-account-address-description';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return DescriptionSettings::widget_fields( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();

		$this->theme_support();

		$data = [
			'template'    => 'elementor/myaccount/account-address-description',
			'controllers' => $controllers,
		];

		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );

		$this->theme_support( 'render_reset' );
	}

}
