<?php
/**
 * AccountOrderDetailsNote class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\OrderNoteSettings;
use RadiusTheme\SBPRO\Helpers\BuilderFunPro;
use RadiusTheme\SBPRO\Helpers\FnsPro;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigation class.
 */
class AccountOrderNote extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Account Order Note', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-account-order-note';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return OrderNoteSettings::widget_fields( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();
		$this->theme_support();
		$order = null;
		if ( $this->is_builder_mode() ) {
			$order = BuilderFunPro::get_order();
		} else {
			global $wp;
			if ( ! empty( $wp->query_vars['view-order'] ) ) {
				$order = wc_get_order( $wp->query_vars['view-order'] );
			}
		}
		if ( is_object( $order ) ) {
			$notes      = $order->get_customer_order_notes();
			$show_title = 'yes' === $controllers['show_title'] ? true : null;
			$data       = [
				'template'    => 'elementor/myaccount/account-order-note',
				'controllers' => $controllers,
				'notes'       => $notes,
				'show_title'  => $show_title,
			];
			if ( $this->is_builder_mode() && ! $notes ) {
				$preview_data = [
					'template'   => 'elementor/myaccount/order-note-preview',
					'show_title' => $show_title,
				];
				Fns::load_template( $preview_data['template'], $preview_data, false, '', rtsbpro()->get_plugin_template_path() );
				return;
			}
			Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );

		} else {
			FnsPro::order_message();
			return;
		}

		$this->theme_support( 'render_reset' );
	}

}
