<?php
/**
 * AccountOrderShipping class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\AccountOrderStatusSettings;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\BillingShippingSettings;
use RadiusTheme\SBPRO\Helpers\BuilderFunPro;
use RadiusTheme\SBPRO\Helpers\FnsPro;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigation class.
 */
class AccountOrderShipping extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Account Order Shipping', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-account-order-shipping';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return BillingShippingSettings::settings( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();

		$this->theme_support();
		$order = null;

		if ( $this->is_builder_mode() ) {
			$order = BuilderFunPro::get_order();
		} else {
			global $wp;
			if ( ! empty( $wp->query_vars['view-order'] ) ) {
				$order = wc_get_order( $wp->query_vars['view-order'] );
			}
		}
		if ( ! $order ) {
			FnsPro::order_message();
			return;
		}
		if ( is_object( $order ) ) {
			$show_shipping = ! wc_ship_to_billing_address_only() && $order->needs_shipping_address();
			$data          = [
				'template'      => 'elementor/myaccount/account-order-shipping',
				'controllers'   => $controllers,
				'order'         => $order,
				'show_shipping' => $show_shipping,
			];
			Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );
		}

		$this->theme_support( 'render_reset' );
	}

}
