<?php
/**
 * AccountRegistrationForm class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\AccountRegistrationFormSettings;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * AccountNavigation class.
 */
class AccountRegistrationForm extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Registration Form', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-account-registration-form';
		parent::__construct( $data, $args );
		$this->rtsb_category = 'rtsb-shopbuilder-general';
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		 return AccountRegistrationFormSettings::settings( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();

		$this->theme_support();
		$data = [
			'template'    => 'elementor/myaccount/account-separate-registration-form',
			'controllers' => $controllers,
		];
		if ( $this->is_edit_mode() && ( 'no' === get_option( 'woocommerce_enable_myaccount_registration' ) ) ) {
			?>
			<p class="rtsb-registration-warning">
				<?php
				esc_html_e(
					'
		Register option is turned off from woocommerce settings',
					'shopbuilder-pro'
				);
				?>
			</p>
			<?php
			return;
		}

		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );

		$this->theme_support( 'render_reset' );
	}
}
