<?php
/**
 * EndpointDynamicContent class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\MyAccount;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Modules\CustomizeMyAccount\CustomizeMyAccountFns;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * EndpointDynamicContent class.
 */
class EndpointDynamicContent extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Endpoint Dynamic Content', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-endpoint-dynamic-content';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public function widget_fields() {
		$fields  = [];
		$options = [];

		$endpoints = CustomizeMyAccountFns::custom_endpoints()['endpoints_data'] ?? [];

		foreach ( $endpoints as $endpoint => $endpoint_data ) {
			if ( 'url' === ( $endpoint_data['repeater_type'] ?? 'endpoint' ) ) {
				continue;
			}

			$options[ esc_html( $endpoint_data['slug'] ) ] = esc_html__( 'Endpoint: ', 'shopbuilder-pro' ) . esc_html( $endpoint_data['title'] );
		}

		if ( empty( $options ) ) {
			return [ 'no-data' => esc_html__( 'No Custom Endpoints Found', 'shopbuilder-pro' ) ];
		}

		$fields['custom_endpoint_section'] = $this->start_section(
			esc_html__( 'Endpoint Dynamic Content', 'shopbuilder-pro' ),
			'content'
		);

		$fields['custom_endpoint_heading'] = $this->el_heading( esc_html__( 'Dynamic Content', 'shopbuilder-pro' ) );

		$fields['custom_endpoint_note'] = [
			'type' => 'html',
			'raw'  => sprintf(
				'<span style="display: block; background: #fffbf1; padding: 10px; font-weight: 500; line-height: 1.4; color: #bd3a3a;border: 1px solid #bd3a3a;">%s</span>',
				esc_html__( 'Please note that, you can choose the below custom endpoint to show the dynamic content for the corresponding endpoint.', 'shopbuilder-pro' )
			),
		];

		$fields['select_custom_endpoint'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Which Endpoint Data to Show?', 'shopbuilder-pro' ),
			'description' => esc_html__( 'Please choose the custom endpoint to show the corresponding dynamic content.', 'shopbuilder-pro' ),
			'options'     => $options,
			'label_block' => true,
			'default'     => array_key_first( $options ),
		];

		$fields['custom_endpoint_section_end'] = $this->end_section();

		return $fields;
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'My Account' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();
		$this->theme_support();

		$endpoint       = $controllers['select_custom_endpoint'] ?? '';
		$endpoints_data = CustomizeMyAccountFns::custom_endpoints()['endpoints_data'] ?? [];
		$content        = '';

		if ( isset( $endpoints_data[ $endpoint ]['content'] ) && ! empty( wp_strip_all_tags( $endpoints_data[ $endpoint ]['content'] ) ) ) {
			global $wp_embed;

			$endpoints_content = $endpoints_data[ $endpoint ]['content'];
			$content          .= do_shortcode( $wp_embed->autoembed( $this->is_edit_mode() ? $endpoints_content : apply_filters( 'the_content', $endpoints_content ) ) );
		} else {
			$content .= sprintf(
				/* translators: %s: endpoint name */
				esc_html__(
					'No dynamic data has been found.',
					'shopbuilder-pro'
				),
				esc_html( $endpoint )
			);
		}

		echo '<div class="rtsb-endpoint-dynamic-content">';
		Fns::print_html( $content, true );
		echo '</div';

		$this->theme_support( 'render_reset' );
	}
}
