<?php
/**
 * Main ProductTitle class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Single;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\QRCodeSettings;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

/**
 * Product Title class
 */
class ProductQRCode extends ElementorWidgetBase {
	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'QR Code', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-product-product-qr-code';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return array
	 */
	public function widget_fields() {
		return QRCodeSettings::settings( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'QR Code', 'Product QR Code' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		global $product;
		$_product    = $product;
		$product     = Fns::get_product();
		$controllers = $this->get_settings_for_display();
		$product_id  = $product->get_id();
		$quantity    = ( ! empty( $controllers['quantity'] ) ? $controllers['quantity'] : 1 );

		if ( ! empty( $controllers['add_to_cart_url'] ) && 'yes' == $controllers['add_to_cart_url'] ) {
			$url = get_the_permalink( $product_id ) . sprintf( '?add-to-cart=%s&quantity=%s', $product_id, $quantity );
		} else {
			$url = get_the_permalink( $product_id );
		}

		$product_url = urlencode( $url );

		$size      = ( ! empty( $controllers['size'] ) ? $controllers['size'] : 150 );
		$dimension = esc_attr( $size . 'x' . $size );

		$qr_color    = str_replace( '#', '', $controllers['qr_code_color'] );
		$qr_bg_color = str_replace( '#', '', $controllers['qr_code_bgcolor'] );
		$qr_ecc      = sanitize_text_field( $controllers['qr_ecc'] );

		$controllers['image_src'] = sprintf(
			'https://api.qrserver.com/v1/create-qr-code/?size=%s&ecc=%s&color=%s&bgcolor=%s&data=%s',
			$dimension,
			$qr_ecc,
			$qr_color,
			$qr_bg_color,
			$product_url
		);
		$controllers['size']      = $size;
		$this->theme_support();
		$data = [
			'template'    => 'elementor/single-product/qr-code',
			'controllers' => $controllers,
		];

		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );
		$this->theme_support( 'render_reset' );
		$product = $_product; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
	}
}
