<?php
/**
 * Main ProductStockCounter class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Single;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Helpers\BuilderFns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\AdvancedProductTabSettings;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\ProductStockCountSettings;


// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}


class ProductStockCount extends ElementorWidgetBase {
	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Product Stock Count', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-product-stock-count';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Fields
	 *
	 * @return array
	 */
	public function widget_fields() {
		return ProductStockCountSettings::settings( $this );
	}



	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'Product Stock Counter', 'Stock Counter' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		global $product;
		$_product    = $product;
		$product     = Fns::get_product();
		$controllers = $this->get_settings_for_display();
		$this->theme_support();
		$stock        = $product->get_stock_quantity();
		$stock_manage = $product->managing_stock();
		if ( ( $stock <= 0 || ! $stock_manage ) && $this->is_edit_mode() ) {
			echo '<div class="alert alert-info" role="alert"><i class="fa fa-info-circle"></i>';
			echo esc_html__( ' Please enable stock management or product stock must be greater then 0.', 'shopbuilder-pro' );
			echo '</div>';
			return;
		}
		$show_stock_text     = $controllers['show_stock_text'] ?: 'no';
		$show_stock_progress = $controllers['show_stock_progress'] ?: 'no';
		$stock_text          = $controllers['stock_text'] ?: '';
		$stock_text_position = $controllers['stock_text_position'] === 'bottom' ? 'bottom-position' : 'top-position';
		$shortcode           = '[product_stock_count wrapper_class="' . $stock_text_position . '" stock_text="' . $stock_text . '" show_stock_text="' . $show_stock_text . '" show_stock_progress="' . $show_stock_progress . '"/]';
		?>
		<div class="rtsb-product-stock-count-wrapper">
			<?php
			Fns::print_html( do_shortcode( $shortcode ) );
			?>
		</div>
		<?php
		$this->theme_support( 'render_reset' );
		$product = $_product; // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
	}
}
