<?php
/**
 * OrderShippingAddress class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Thankyou;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\CustomFieldsDataSettings;
use RadiusTheme\SBPRO\Helpers\BuilderFunPro;
use RadiusTheme\SBPRO\Helpers\FnsPro;
use RadiusTheme\SBPRO\Modules\CheckoutEditor\CheckoutEditorCustomData;
use RadiusTheme\SBPRO\Modules\CheckoutEditor\CheckoutManager;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class CustomFieldsData extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Custom Fields Data', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-order-custom-field-data';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		return CustomFieldsDataSettings::settings( $this );
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'Thank you', 'Custom Fields' ] + parent::get_keywords();
	}

	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();

		$order = BuilderFunPro::get_order( ! $this->is_builder_mode() );

		if ( ! $order ) {
			FnsPro::order_message();
			return;
		}
		$CustomField   = new CheckoutEditorCustomData();
		$data          = $CustomField->get_custom_data_for_thankyou_page( $order );
		$wrapper_class = ! empty( $controllers['section_width_100'] ) ? 'rtsb-section-width-100' : '';

		if ( ! FnsPro::is_module_active( 'checkout_fields_editor' ) && $this->is_edit_mode() ) {
			?>
				<p style="color: darkred"> Checkout Fields Editor Is disabled </p>
			<?php
			return;
		}
		?>
		<div class="rtsb-custom-information-wrapper <?php echo esc_attr( $wrapper_class ); ?>">
			<?php
			foreach ( $data as $field ) {
				if ( empty( $field['fields'] ) ) {
					continue;
				}
				Fns::load_template( 'checkout-custom-fields/table', $field, false, '', rtsbpro()->get_plugin_template_path() );
			}
			?>
		</div>
		<?php
	}
}
