<?php
/**
 * OrderDetailsSummary class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Elementor\Widgets\Thankyou;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SB\Abstracts\ElementorWidgetBase;
use RadiusTheme\SBPRO\Elementor\Widgets\Controls\OrderDetailsTableSettings;
use RadiusTheme\SBPRO\Helpers\BuilderFunPro;
use RadiusTheme\SBPRO\Helpers\FnsPro;

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'This script cannot be accessed directly.' );
}

class OrderDetailsTable extends ElementorWidgetBase {

	/**
	 * Construct function
	 *
	 * @param array $data default array.
	 * @param mixed $args default arg.
	 */
	public function __construct( $data = [], $args = null ) {
		$this->rtsb_name = esc_html__( 'Order Details Table', 'shopbuilder-pro' );
		$this->rtsb_base = 'rtsb-order-details-table';
		parent::__construct( $data, $args );
	}

	/**
	 * Widget Field
	 *
	 * @return void|array
	 */
	public function widget_fields() {
		$fields = OrderDetailsTableSettings::settings( $this );
		return self::add_layout_conditions( $fields );
	}

	/**
	 * Add layout conditions to the fields array.
	 *
	 * @param array $fields The array of fields.
	 * @return array The updated array of fields with layout conditions.
	 */
	public static function add_layout_conditions( $fields ) {
		$fields['table_heading_align']['condition']         = [
			'layout!' => [ 'layout2' ],
		];
		$fields['table_header_align']['condition']          = [
			'layout!' => [ 'layout2' ],
		];
		$fields['total_heading_width']['condition']         = [
			'layout!' => [ 'layout2' ],
		];
		$fields['table_cell_align']['condition']            = [
			'layout!' => [ 'layout2' ],
		];
		$fields['total_cell_heading_width']['condition']    = [
			'layout!' => [ 'layout2' ],
		];
		$fields['table_cell_background_color']['condition'] = [
			'layout!' => [ 'layout2' ],
		];
		$fields['table_footer_align']['condition']          = [
			'layout!' => [ 'layout2' ],
		];
		return $fields;
	}

	/**
	 * Set Widget Keyword.
	 *
	 * @return array
	 */
	public function get_keywords() {
		return [ 'Order Details' ] + parent::get_keywords();
	}


	/**
	 * Render Function
	 *
	 * @return void
	 */
	protected function render() {
		$controllers = $this->get_settings_for_display();

		$this->theme_support();
		$order = BuilderFunPro::get_order( ! $this->is_builder_mode() );
		if ( ! $order ) {
			FnsPro::order_message();
			return;
		}
		$show_title = 'yes' === $controllers['show_title'] ? true : null;
		$template   = 'elementor/thankyou/order-details/order-details-table';
		$layout     = ! empty( $controllers['layout'] ) ? $controllers['layout'] : 'layout1';
		$data       = [
			'template'    => $template . '-' . $layout,
			'controllers' => $controllers,
			'order'       => $order,
			'show_title'  => $show_title,
			'layout'      => $layout,
		];

		Fns::load_template( $data['template'], $data, false, '', rtsbpro()->get_plugin_template_path() );

		$this->theme_support( 'render_reset' );
	}
}
