<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\BogoBxGy;

use RadiusTheme\SB\Helpers\Cache;
use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Helpers\FnsPro;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class BogoGiftBxGyFns {
	/**
	 * Free-gift key.
	 *
	 * @var string
	 */
	const DISCOUNTED_CART_KEY = 'rtsb_bogo_free_gift';

	/**
	 * @return array
	 */
	public static function get_options() {
		return Fns::get_options( 'modules', 'bogo_bxgy_free_gift_discounts' );
	}

	/**
	 * @return array
	 */
	public static function settings_field() {
		$fields = [
			'general_settings'                 => [
				'id'    => 'general_settings',
				'type'  => 'title',
				'label' => esc_html__( 'Settings', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'discount_note_in_product_loop'    => [
				'id'    => 'discount_note_in_product_loop',
				'type'  => 'switch',
				'label' => esc_html__( 'Show Discount Availability Note', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Display discount availability message in shop, archive, related, upsell, and cross-sell sections', 'shopbuilder-pro' ),
				'value' => 'on',
				'tab'   => 'general',
			],
			'discount_note_in_product_details' => [
				'id'    => 'discount_note_in_product_details',
				'type'  => 'switch',
				'label' => esc_html__( 'Show Discount Availability Note in Product details page', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Display discount availability message in product details page.', 'shopbuilder-pro' ),
				'value' => 'on',
				'tab'   => 'general',
			],
			'bxgybogo_cart_message'            => [
				'id'    => 'bxgybogo_cart_message',
				'label' => __( 'Cart Message', 'shopbuilder-pro' ),
				'type'  => 'textarea',
				'help'  => __( 'Add a discount message to display in the cart. Use {{bxgy_products}} to show the list of discounted product names.', 'shopbuilder-pro' ),
				'tab'   => 'general',
				'value' => esc_html__( 'Discount Applied On {{bxgy_products}}', 'shopbuilder-pro' ),
			],
			'bxgybogo_disable_coupons'         => [
				'id'    => 'bxgybogo_disable_coupons',
				'type'  => 'switch',
				'label' => esc_html__( 'Disable Coupons', 'shopbuilder-pro' ),
				'help'  => __( 'Disable coupons for discounted product.', 'shopbuilder-pro' ),
				'tab'   => 'general',
			],
			'bxgybogo_rules_field_intro'       => [
				'id'   => 'bxgybogo_rules_field_intro',
				'type' => 'description',
				'text' => esc_html__( 'To add new discount rules, simply click on the \'Add New\' button below.', 'shopbuilder-pro' ),
				'tab'  => 'rules',
			],
			'bxgybogo_rules'                   => [
				'id'     => 'bxgybogo_rules',
				'type'   => 'repeaters',
				'label'  => '',
				'tab'    => 'rules',
				'repeat' => [
					'title'                        => [
						'id'          => 'title',
						'label'       => esc_html__( 'Discount Title', 'shopbuilder-pro' ),
						'type'        => 'text',
						'placeholder' => esc_html__( 'Discount Title', 'shopbuilder-pro' ),
						'value'       => esc_html__( 'Untitled Rule', 'shopbuilder-pro' ),
						'help'        => esc_html__( 'The title of the discount.', 'shopbuilder-pro' ),
					],
					'discount_type'                => [
						'id'      => 'discount_type',
						'type'    => 'select',
						'value'   => 'bogo',
						'isPro'   => ! rtsb()->has_pro(),
						'label'   => esc_html__( 'Offer Type', 'shopbuilder-pro' ),
						'help'    => esc_html__( 'Select the type of offer.', 'shopbuilder-pro' ),
						'options' => [
							'bogo'        => esc_html__( 'BOGO - Buy One Get One | Free Gift', 'shopbuilder-pro' ),
							'buy-x-get-y' => esc_html__( 'Buy X Get Y', 'shopbuilder-pro' ),
						],
					],
					'applicable_product'           => [
						'id'              => 'applicable_product',
						'type'            => 'search_and_multi_select',
						'label'           => esc_html__( 'Main Product', 'shopbuilder-pro' ),
						'help'            => esc_html__( 'This is the product that qualifies for the free or discount offer.', 'shopbuilder-pro' ),
						'placeholder'     => esc_html__( 'Search Products', 'shopbuilder-pro' ),
						'func_with_param' => [ Fns::class, 'get_post_types', [ 'post_type' => 'product' ] ],
						'options'         => Fns::get_post_types( null, [ 'post_type' => 'product' ] ),
						'multiple'        => false,
					],
					'required_quantity'            => [
						'id'          => 'required_quantity',
						'label'       => esc_html__( 'Required Minimum Quantity', 'shopbuilder-pro' ),
						'placeholder' => esc_html__( 'Minimum Quantity', 'shopbuilder-pro' ),
						'help'        => esc_html__( 'Minimum quantity required to qualify. (Buy X).', 'shopbuilder-pro' ),
						'type'        => 'number',
						'value'       => 1,
						'min'         => 1,
						'dependency'  => [
							'rules' => [
								[
									'item'     => 'modules.bogo_bxgy_free_gift_discounts.rules.discount_type',
									'value'    => 'buy-x-get-y',
									'operator' => '==',
								],
							],
						],
					],

					// This Field Only For BOGO.
					 'discount_product'            => [
						 'id'              => 'discount_product',
						 'type'            => 'search_and_multi_select',
						 'label'           => esc_html__( 'Select Discounted product', 'shopbuilder-pro' ),
						 'help'            => esc_html__( 'Select the product that is offered for free or at a discount.', 'shopbuilder-pro' ),
						 'placeholder'     => esc_html__( 'Search Products', 'shopbuilder-pro' ),
						 'func_with_param' => [ Fns::class, 'get_post_types', [ 'post_type' => 'product' ] ],
						 'options'         => Fns::get_post_types( null, [ 'post_type' => 'product' ] ),
						 'multiple'        => false,
					 ],
					// This Field Only For B-X-G-Y.
					'discount_product_quantity'    => [
						'id'          => 'discount_product_quantity',
						'label'       => esc_html__( 'Discounted Product Quantity', 'shopbuilder-pro' ),
						'placeholder' => esc_html__( 'Enter quantity', 'shopbuilder-pro' ),
						'help'        => esc_html__( 'Set the number of free or discounted products a customer can receive.', 'shopbuilder-pro' ),
						'type'        => 'number',
						'min'         => 1,
						'value'       => 1,
						'dependency'  => [
							'rules' => [
								[
									'item'     => 'modules.bogo_bxgy_free_gift_discounts.rules.discount_type',
									'value'    => 'buy-x-get-y',
									'operator' => '==',
								],
							],
						],
					],
					// This Field Only For B-X-G-Y.
					'discount_calculation'         => [
						'id'         => 'discount_calculation',
						'type'       => 'select',
						'value'      => 'full',
						'label'      => esc_html__( 'Discount Type', 'shopbuilder-pro' ),
						'help'       => esc_html__( 'Choose how the discount is applied to the product (Get Y).', 'shopbuilder-pro' ),
						'options'    => [
							'full'       => esc_html__( '100% Discount (Free)', 'shopbuilder-pro' ),
							'percentage' => esc_html__( 'Percentage Discount (%)', 'shopbuilder-pro' ),
							'fixed'      => esc_html__( 'Fixed Amount Discount (Per Item)', 'shopbuilder-pro' ),
						],
						'dependency' => [
							'rules' => [
								[
									'item'     => 'modules.bogo_bxgy_free_gift_discounts.rules.discount_type',
									'value'    => 'buy-x-get-y',
									'operator' => '==',
								],
							],
						],
					],
					// This Field Only For B-X-G-Y.
					'bxgy_amount'                  => [
						'id'          => 'bxgy_amount',
						'label'       => esc_html__( 'Discount Amount', 'shopbuilder-pro' ),
						'type'        => 'number',
						'placeholder' => esc_html__( 'Discount Amount', 'shopbuilder-pro' ),
						'help'        => esc_html__( 'Enter the discount amount based on the selected discount type (fixed amount or percentage).', 'shopbuilder-pro' ),
						'dependency'  => [
							'rules' => [
								[
									'item'     => 'modules.bogo_bxgy_free_gift_discounts.rules.discount_type',
									'value'    => 'buy-x-get-y',
									'operator' => '==',
								],
								[
									'item'     => 'modules.bogo_bxgy_free_gift_discounts.rules.discount_calculation',
									'value'    => 'full',
									'operator' => '!=',
								],
							],
						],
					],

					'bxgy_multiple_apply'          => [
						'id'         => 'bxgy_multiple_apply',
						'type'       => 'switch',
						'label'      => esc_html__( 'Allow Multiple Applies?', 'shopbuilder-pro' ),
						'help'       => __( 'Allow the discount to apply multiple times based on the quantity of qualifying products.', 'shopbuilder-pro' ),
						'tab'        => 'general',
						'dependency' => [
							'rules' => [
								[
									'item'     => 'modules.bogo_bxgy_free_gift_discounts.rules.discount_type',
									'value'    => 'buy-x-get-y',
									'operator' => '==',
								],
							],
						],
					],

					'apply_only_one_gift_item'     => [
						'id'         => 'apply_only_one_gift_item',
						'type'       => 'switch',
						'label'      => esc_html__( 'One Gift Product Allowed?', 'shopbuilder-pro' ),
						'help'       => __( 'Only one gift product can be added to the cart per order, regardless of the quantity of the main product. Even if multiple eligible products are added, only a single gift item will be included.', 'shopbuilder-pro' ),
						'tab'        => 'general',
						'dependency' => [
							'rules' => [
								[
									'item'     => 'modules.bogo_bxgy_free_gift_discounts.rules.discount_type',
									'value'    => 'bogo',
									'operator' => '==',
								],
							],
						],
					],

					// This Field Only For BOGO.
					'user_roles'                   => [
						'id'       => 'user_roles',
						'label'    => esc_html__( 'Select User Roles', 'shopbuilder-pro' ),
						'help'     => esc_html__( 'Select user roles eligible for the discount. Leave blank to apply to all users.', 'shopbuilder-pro' ),
						'type'     => 'select',
						'isPro'    => ! rtsb()->has_pro(),
						'value'    => [],
						'options'  => Fns::get_all_user_roles(),
						'multiple' => true,
					],
					'enable_date_range'            => [
						'id'    => 'enable_date_range',
						'type'  => 'switch',
						'label' => esc_html__( 'Date Range', 'shopbuilder-pro' ),
						'tab'   => 'general',
					],
					'discount_start_date_and_time' => [
						'id'         => 'discount_start_date_and_time',
						'type'       => 'datetime',
						'label'      => esc_html__( 'Discount Start Date', 'shopbuilder-pro' ),
						'help'       => esc_html__( 'Select the start date and time for the discount.', 'shopbuilder-pro' ),
						'format'     => 'YYYY-MM-DD HH:mm',
						'showtime'   => true,
						'dependency' => [
							'rules' => [
								[
									'item'     => 'modules.bogo_bxgy_free_gift_discounts.rules.enable_date_range',
									'value'    => 'on',
									'operator' => '==',
								],
							],
						],
					],
					'discount_end_date_and_time'   => [
						'id'         => 'discount_end_date_and_time',
						'type'       => 'datetime',
						'label'      => esc_html__( 'Discount End Date', 'shopbuilder-pro' ),
						'help'       => esc_html__( 'Select the end date and time for the discount.', 'shopbuilder-pro' ),
						'format'     => 'YYYY-MM-DD HH:mm',
						'showtime'   => true,
						'dependency' => [
							'rules' => [
								[
									'item'     => 'modules.bogo_bxgy_free_gift_discounts.rules.enable_date_range',
									'value'    => 'on',
									'operator' => '==',
								],
							],
						],
					],
				],
			],

			// Styles.
			'style_settings_tooltips'          => [
				'id'    => 'style_settings',
				'type'  => 'title',
				'label' => esc_html__( 'ToolTip Style', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'badge_text_color'                 => [
				'id'    => 'badge_text_color',
				'label' => esc_html__( 'Tooltip Badge Text Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'badge_bg_color'                   => [
				'id'    => 'badge_bg_color',
				'label' => esc_html__( 'Tooltip Badge Background', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'notice_bg_color'                  => [
				'id'    => 'notice_bg_color',
				'label' => esc_html__( 'Tooltip Background', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'notice_border_color'              => [
				'id'    => 'notice_border_color',
				'label' => esc_html__( 'Tooltip Border Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'notice_text_color'                => [
				'id'    => 'notice_text_color',
				'label' => esc_html__( 'Tooltip Text Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],

			'notice_tooltip_arrow_color'       => [
				'id'    => 'notice_tooltip_arrow_color',
				'label' => esc_html__( 'Tooltip Arrow Color (Down Arrow)', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'tooltip_product_name_color'       => [
				'id'    => 'tooltip_product_name_color',
				'label' => esc_html__( 'Tooltip Product Name Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'tooltip_product_name_hover_color' => [
				'id'    => 'tooltip_product_name_hover_color',
				'label' => esc_html__( 'Tooltip Product Name Hover Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],

			'style_settings_product_showcase'  => [
				'id'    => 'style_settings',
				'type'  => 'title',
				'label' => esc_html__( 'Shop / Archive Page', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'showcase_note_font_size'          => [
				'id'    => 'showcase_note_font_size',
				'label' => esc_html__( 'Font Size (px)', 'shopbuilder-pro' ),
				'type'  => 'slider',
				'min'   => 10,
				'max'   => 50,
				'unit'  => 'px',
				'value' => 15,
				'tab'   => 'styles',
			],
			'showcase_note_font_color'         => [
				'id'    => 'showcase_note_font_color',
				'label' => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'showcase_note_margin'             => [
				'id'    => 'showcase_note_margin',
				'type'  => 'text',
				'size'  => 'small',
				'min'   => 0,
				'max'   => 999,
				'label' => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Margin. Example: 0 15px 15px 15px', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],

			'style_settings_product_details'   => [
				'id'    => 'style_settings',
				'type'  => 'title',
				'label' => esc_html__( 'Product Details', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
			'details_page_note_font_size'      => [
				'id'    => 'details_page_note_font_size',
				'label' => esc_html__( 'Font Size (px)', 'shopbuilder-pro' ),
				'type'  => 'slider',
				'min'   => 10,
				'max'   => 50,
				'unit'  => 'px',
				'value' => 15,
				'tab'   => 'styles',
			],
			'details_page_note_font_color'     => [
				'id'    => 'details_page_note_font_color',
				'label' => esc_html__( 'Color', 'shopbuilder-pro' ),
				'type'  => 'color',
				'tab'   => 'styles',
			],
			'details_page_note_margin'         => [
				'id'    => 'showcase_note_margin',
				'type'  => 'text',
				'size'  => 'small',
				'min'   => 0,
				'max'   => 999,
				'label' => esc_html__( 'Margin', 'shopbuilder-pro' ),
				'help'  => esc_html__( 'Margin. Example: 0 15px 15px 15px', 'shopbuilder-pro' ),
				'tab'   => 'styles',
			],
		];
		return $fields;
	}
}
