<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\CurrencySwitcher;

use RadiusTheme\SB\Models\DataModel;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class FetchCurrencyApi extends CurrencyBase {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * @var array|mixed
	 */
	private array $options;
	/**
	 * @var
	 */
	protected $geting_rate = null;
	/**
	 * @var
	 */
	protected $from;

	/**
	 * @var
	 */
	protected $to;
	/**
	 * @var bool
	 */
	private bool $conversionSet = false;

	/**
	 * Set Default Currency.
	 */
	private function __construct() {
		parent::__construct();
		$this->from = trim( CsFns::get_default_currency() );
	}

	/**
	 * @return void
	 */
	private function fetch_currency_rate() {
		if ( ! $this->conversionSet ) {
			throw new \Exception( 'Conversion must be set using convert_to method before fetching the rate.' );
		}

		global $currency_switcher_options; // Define global variable.

		$resource = $currency_switcher_options['exchange_rate_resources'] ?? 'google';
		switch ( $resource ) {
			case 'google':
				// $this->google_rate();
				break;
			case 'yahoo-finance':
				$this->yahoo_finance_rate();
				break;
			case 'cuex':
				$this->cuex_rate();
				break;
			case 'transferWise':
				 $this->transferwise_rate();
				break;
			case 'xe':
				 $this->xe_rate();
				break;
			// case 'fixer':
			// $this->yahoo_finance_convert();
			// break;
			// case 'currency-freaks':
			// $this->yahoo_finance_convert();
			// break;
			// case 'exchange-rates-host':
			// $this->yahoo_finance_convert();
			// break;
			// case 'european-central-bank':
			// $this->yahoo_finance_convert();
			// break;
			// case 'national-bank-of-romania':
			// $this->yahoo_finance_convert();
			// break;
			// case 'bank-of-italy':
			// $this->yahoo_finance_convert();
			// break;
			// case 'currency-freaks':
			// $this->yahoo_finance_convert();
			// break;
			default:
		}
	}

	/**
	 * Google Convert.
	 *
	 * @return void
	 */
	protected function google_rate() {
		// Google Is not provide Currency.
		// This will functional Latter.
		$cache_key = 'google_rate_' . $this->from . '_' . $this->to;
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			$this->geting_rate = $this->cache[ $cache_key ];
			return;
		}
		$url = 'https://www.google.com/async/currency_v2_update?vet=12ahUKEwjfsduxqYXfAhWYOnAKHdr6BnIQ_sIDMAB6BAgFEAE..i&ei=kgAGXN-gDJj1wAPa9ZuQBw&yv=3&async=source_amount:1,source_currency:' . $this->from . ',target_currency:' . $this->to . ',lang:en,country:us,disclaimer_url:https%3A%2F%2Fwww.google.com%2Fintl%2Fen%2Fgooglefinance%2Fdisclaimer%2F,period:5d,interval:1800,_id:knowledge-currency__currency-v2-updatable,_pms:s,_fmt:pc';

		$request = wp_remote_get(
			$url,
			[
				'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36',
				'timeout'    => 10,
			]
		);

		if ( ! is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) === 200 ) {
			preg_match( '/data-exchange-rate=\"(.+?)\"/', $request['body'], $match );
			if ( is_array( $match ) && count( $match ) > 1 ) {
				$this->geting_rate = $match[1];
			}
		}
		$this->cache[ $cache_key ] = $this->geting_rate;
	}

	/**
	 * @return void
	 */
	protected function yahoo_finance_rate() {
		// This will functional Latter.
		$char      = trim( $this->from ) . trim( $this->to );
		$cache_key = 'yahoo_finance_rate_' . $char;
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			$this->geting_rate = $this->cache[ $cache_key ];
			return;
		}
		$rate     = 0;
		$queryStr = sprintf( '%s%s=X', $this->from, $this->to );
		$url      = 'https://query1.finance.yahoo.com/v8/finance/chart/' . $queryStr;
		$response = wp_remote_request( $url, [ 'headers' => [ 'Content-Type' => 'application/json' ] ] );
		$data     = is_wp_error( $response ) ? '' : json_decode( wp_remote_retrieve_body( $response ), true );
		if ( isset( $data['chart'] ) && isset( $data['chart']['result'] ) && isset( $data['chart']['result'][0] ) ) {
			$meta = $data['chart']['result'][0]['meta'] ?? [];
			$rate = $meta['regularMarketPrice'] ?? '';
		}
		if ( empty( $rate ) ) {
			// (https://finance.yahoo.com/quote/USDBTC=X) .
			$queryStr = sprintf( '%s%s=X', $this->from, $this->to );
			$url      = 'https://finance.yahoo.com/quote/' . $queryStr;
			// $html = function_exists('curl_init') ? $this->_fileGetContentsCurl($url) : file_get_contents($url);
			$response = wp_remote_request( $url, [ 'headers' => [ 'Content-Type' => 'application/json' ] ] );
			$html     = is_wp_error( $response ) ? '' : wp_remote_retrieve_body( $response );
			preg_match_all( '/quote-header-info.*?fin-streamer.*?>(.*?)<\/fin-streamer>/s', $html, $matches );
			$rate = isset( $matches[1][0] ) ? floatval( str_replace( ',', '', $matches[1][0] ) ) : 0;
		}
		$this->geting_rate         = $rate;
		$this->cache[ $cache_key ] = $rate;
	}
	/**
	 * @return void
	 */
	protected function cuex_rate() {
		$cache_key = 'cuex_rate_' . $this->from . '_' . $this->to;
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			$this->geting_rate = $this->cache[ $cache_key ];
			return;
		}

		global $currency_switcher_options; // Define global variable.
		$cuex_api_key   = $currency_switcher_options['cuex_api_key'] ?? null;
		$date           = date( 'Y-m-d', current_time( 'timestamp' ) );
		$lower_code     = strtolower( $this->to );
		$original_price = strtolower( $this->from );
		$url            = "https://api.cuex.com/v1/exchanges/{$original_price}?to_currency={$lower_code}&from_date={$date}&l=en";
		$request        = wp_remote_get(
			$url,
			[
				'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36',
				'timeout'    => 10,
				'headers'    => [ 'Authorization' => $cuex_api_key ?: '3b71e5d431b2331acb65f2d484d423e5' ],
			]
		);
		if ( ! is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) === 200 ) {
			$body = json_decode( wp_remote_retrieve_body( $request ) );
			if ( isset( $body->data[0]->rate ) ) {
				$this->geting_rate = $body->data[0]->rate;
			}
		}
		$this->cache[ $cache_key ] = $this->geting_rate;
	}

	/**
	 * @return void
	 */
	protected function transferwise_rate() {
		$cache_key = 'transferwise_rate_' . $this->from . '_' . $this->to;
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			$this->geting_rate = $this->cache[ $cache_key ];
			return;
		}

		global $currency_switcher_options; // Define global variable.
		$transferwise_api_key = $currency_switcher_options['transferwise_api_key'] ?? null;
		$url                  = "https://transferwise.com/api/v1/payment/calculate?amount=1&sourceCurrency={$this->from}&targetCurrency={$this->to}";
		$request              = wp_remote_get(
			$url,
			[
				'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36',
				'timeout'    => 100,
				'headers'    => [
					'x-authorization-key' => $transferwise_api_key ?: 'dad99d7d8e52c2c8aaf9fda788d8acdc',
				],
			]
		);
		if ( ! is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) === 200 ) {
			// TODO:: Need Check Later.
			$body = json_decode( wp_remote_retrieve_body( $request ) );
			if ( isset( $body->transferwiseRate ) ) {
				$this->geting_rate = $body->transferwiseRate;
			}
		}
		$this->cache[ $cache_key ] = $this->geting_rate;
	}

	/**
	 * @return void
	 */
	protected function xe_rate() {
		// This will functional Latter.
		$cache_key = 'set_xe_rate_cache_' . $this->from . '_' . $this->to;
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			$this->geting_rate = $this->cache[ $cache_key ];
			return;
		}
		$url = 'http://www.xe.com/currencyconverter/convert/?Amount=1&From=' . $this->from . '&To=' . $this->to;

		$request = wp_remote_get(
			$url,
			[
				'user-agent' => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36',
				'timeout'    => 10,
			]
		);
		if ( ! is_wp_error( $request ) || wp_remote_retrieve_response_code( $request ) === 200 ) {
			$body = wp_remote_retrieve_body( $request );
			// Define the regular expression pattern.
			$pattern = '/>(\d+\.\d+)<span class="faded-digits">(\d+)<\/span>/';
			// Use preg_match to find the match.
			if ( preg_match( $pattern, $body, $matches ) ) {
				$mainRate                  = $matches[1]; // The first capturing group contains the main rate.
				$fadedDigits               = $matches[2]; // The second capturing group contains the faded digits.
				$rate                      = $mainRate . $fadedDigits;
				$rates                     = floatval( $rate );
				$this->geting_rate         = $rates;
				$this->cache[ $cache_key ] = $rates;
			}
		}
	}

	/**
	 * @param string $to Currency.
	 * @return $this
	 * @throws \Exception
	 */
	public function convert_to( $to ) {
		$this->to            = trim( $to );
		$this->conversionSet = true;
		$this->fetch_currency_rate();
		return $this;
	}
	/**
	 * @return mixed
	 */
	public function get_the_rate() {
		return floatval( $this->geting_rate );
	}

	/**
	 * @return mixed
	 */
	public function get_all_currency_rate_updated_value() {
		$cache_key = 'get_all_currency_rate_updated_value';
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			return $this->cache[ $cache_key ];
		}
		$modules          = DataModel::source()->get_option( 'modules', [], false );
		$switcher_options = $modules['currency_switcher'];
		$currencies       = $this->all_currency_list();
		if ( empty( $currencies ) ) {
			return $modules;
		}
		foreach ( $currencies as $key => $currency ) {
			if ( CsFns::get_default_currency() === $currency['title'] ) {
				continue;
			}
			$rate = $this->convert_to( $key )->get_the_rate();
			if ( ! $rate ) {
				continue;
			}
			$currencies[ $key ]['currency_rate'] = number_format( $rate, 5, '.', '' );
		}

		$switcher_options['currency_options'] = wp_json_encode( array_values( $currencies ) );
		$modules['currency_switcher']         = $switcher_options;
		$this->cache[ $cache_key ]            = $modules;
		return $this->cache[ $cache_key ];
	}

	/**
	 * @return void
	 */
	public function automatically_update_all_currency_rate() {
		global $currency_switcher_options; // Define global variable.
		$exchange_rates = $currency_switcher_options['exchange_rates'] ?? 'manually';
		if ( 'automatically' !== $exchange_rates ) {
			return;
		}
		$cache_key = 'automatically_update_all_currency_rate';
		if ( ! empty( $this->cache[ $cache_key ] ) ) {
			return;
		}
		$modules = $this->get_all_currency_rate_updated_value();
		DataModel::source()->set_option( 'modules', $modules );
		$this->cache[ $cache_key ] = 'updated';
	}
}
