<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\CurrencySwitcher;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;

defined( 'ABSPATH' ) || exit();


/**
 * Class WOOMULTI_CURRENCY_Frontend_Price
 */
class FrontendPrice extends CurrencyBase {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * Class Constructor
	 */
	private function __construct() {
		parent::__construct();
		$this->exchange_shopping_cost();
	}

	/**
	 * @return void
	 */
	public function exchange_shopping_cost() {
		if ( ! $this->is_available_currency() ) {
			return;
		}

		if ( $this->get_default_currency() === $this->get_current_currency() ) {
			return;
		}

		// *Variable price*/
		 add_filter( 'woocommerce_product_variation_get_price', [ $this, 'exchange_product_price' ], 30, 2 );
		 add_filter( 'woocommerce_product_variation_get_regular_price', [ $this, 'exchange_product_price' ], 30, 2 );
		 add_filter( 'woocommerce_product_variation_get_sale_price', [ $this, 'exchange_product_price' ], 30, 2 );
		 add_filter( 'rtsb/module/product_add_ons/price', [ $this, 'exchange_product_price' ], 10, 2 );
		// *Variable Parent min max price*/
		// Hook to modify variation product prices.
		add_filter( 'woocommerce_variation_prices', [ $this, 'woocommerce_variation_prices_array' ], 15, 2 );
		// Not Working add_filter( 'woocommerce_variation_prices_price', [ $this, 'exchange_product_price' ], 35, 2 ) For Internal Caching.

		/* Simple product */
		add_filter( 'woocommerce_product_get_regular_price', [ $this, 'exchange_product_price' ], 30, 2 );
		add_filter( 'woocommerce_product_get_sale_price', [ $this, 'exchange_product_price' ], 30, 2 );
		add_filter( 'woocommerce_product_get_price', [ $this, 'exchange_product_price' ], 30, 2 );

		// Hook into WooCommerce shipping calculator.
		add_filter( 'woocommerce_package_rates', [ $this, 'calculate_shipping_costs' ], 35, 2 );
		add_filter( 'woocommerce_shipping_rate_taxes', [ $this, 'shipping_rate_taxes' ], 35, 2 );
	}

	/**
	 * @param array  $prices_array prices array.
	 * @param object $product product object.
	 * @return mixed
	 */
	public function woocommerce_variation_prices_array( $prices_array, $product ) {
		if ( is_array( $prices_array['price'] ) ) {
			foreach ( $prices_array['price'] as $key => $value ) {
				$prices_array['price'][ $key ] = $value * $this->get_current_rate();
			}
		}
		/*
		 * If need will apply.
		if ( is_array( $prices_array['regular_price'] ) ) {
			foreach ( $prices_array['regular_price'] as $key => $value ) {
				$prices_array['regular_price'][ $key ] = $value * $this->get_current_rate();
			}
		}
		if ( is_array( $prices_array['sale_price'] ) ) {
			foreach ( $prices_array['sale_price'] as $key => $value ) {
				$prices_array['sale_price'][ $key ] = $value * $this->get_current_rate();
			}
		}
		*/
		return $prices_array;
	}


	/**
	 * @param float  $price Product price.
	 * @param object $product product object.
	 * @return mixed
	 */
	public function exchange_product_price( $price, $product ) {
		if ( ! $price ) {
			return $price;
		}
		return $price * $this->get_current_rate();
	}

	/**
	 * @param array $rates Shipping Cost Rate.
	 * @param array $package shipping package.
	 * @return array
	 */
	public function calculate_shipping_costs( $rates, $package ) {
		foreach ( $rates as $rate_key => $rate ) {
			$rates[ $rate_key ]->cost = $rate->cost * $this->get_current_rate();
		}
		return $rates;
	}

	/**
	 * @param float  $taxes applied Texes.
	 * @param object $obj shipping object.
	 * @return array
	 */
	public function shipping_rate_taxes( $taxes, $obj ) {
		$cost  = $obj->get_cost();
		$taxes = \WC_Tax::calc_shipping_tax( $cost, \WC_Tax::get_shipping_tax_rates() );
		return $taxes;
	}
}
