<?php
/**
 * Main FilterHooks class.
 *
 * @package RadiusTheme\SB
 */

namespace RadiusTheme\SBPRO\Modules\FlashSaleCountdown;

use RadiusTheme\SB\Helpers\Fns;
use RadiusTheme\SBPRO\Traits\SingletonTrait;
use WC_Product;

defined( 'ABSPATH' ) || exit();

/**
 * Main FilterHooks class.
 */
class CountdownFrontEnd {
	/**
	 * Singleton Trait.
	 */
	use SingletonTrait;

	/**
	 * @var array|mixed
	 */
	private array $options;

	/**
	 *
	 */
	private function __construct() {

		$this->options = Fns::get_options( 'modules', 'flash_sale_countdown' );

		add_action( 'rtsb/modules/flash_sale_countdown/frontend/display', [ $this, 'frontend_display' ] );
		// Add do_action( 'rtsb/modules/flash_sale_countdown/frontend/display' ); for display anywhere inside product query.
		add_action( 'rtsb/modules/flash_sale_countdown/print_counter', [ $this, 'print_counter' ] );
		// ShortCode.
		add_shortcode( 'rtsb_flash_sale_countdown', [ $this, 'counter_shortcode' ] );

		// Template.
		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_public_scripts' ], 99 );

		$this->attach_button();
	}

	/**
	 * @return void
	 */
	public function enqueue_public_scripts() {

		if ( ! apply_filters( 'rtsb/module/flash_sale_countdown/show_counter', true ) ) {
			return;
		}

		$loop_counter_layout = $this->options['loop_counter_layout'] ?? '';
		$dynamic_css         = '';
		$pre                 = '.rtsb-countdown-campaign';

		if ( 'vertical' === $loop_counter_layout ) {
			$top_distance      = $this->options['loop_counter_vertical_top_distance'] ?? ''; // Fns::get_option( 'modules', 'flash_sale_countdown', 'loop_counter_vertical_top_distance' );
			$vertical_distance = $this->options['loop_counter_vertical_vertical_distance'] ?? ''; // Fns::get_option( 'modules', 'flash_sale_countdown', 'loop_counter_vertical_vertical_distance' );

			$dynamic_css .= $pre . '.rtsb-countdown-vertical{';
			$dynamic_css .= 'top:' . ( $top_distance ?? '30%' );
			$dynamic_css .= '}';

			$dynamic_css .= $pre . '.rtsb-vertical-position-top-right{';
			$dynamic_css .= 'right:' . ( $vertical_distance ?? '20px' );
			$dynamic_css .= '}';

			$dynamic_css .= $pre . '.rtsb-vertical-position-top-left{';
			$dynamic_css .= 'left:' . ( $vertical_distance ?? '20px' );
			$dynamic_css .= '}';

		}

		if ( ! empty( $this->options['counter_text_color'] ) ) {
			$dynamic_css .= $pre . ' .rtsb-countdown-section{';
			$dynamic_css .= 'color:' . $this->options['counter_text_color'];
			$dynamic_css .= '}';
		}

		if ( ! empty( $this->options['counter_background_color'] ) ) {
			$dynamic_css .= $pre . ' .rtsb-countdown-section{';
			$dynamic_css .= 'background-color:' . $this->options['counter_background_color'];
			$dynamic_css .= '}';
		}

		if ( ! empty( $this->options['counter_button_margin'] ) ) {
			$dynamic_css .= 'body .products:not(.rtsb-elementor-container) ' . $pre . ' {';
			$dynamic_css .= 'margin:' . $this->options['counter_button_margin'] . ' !important';
			$dynamic_css .= '}';
		}

		if ( ! empty( $dynamic_css ) ) {
			wp_add_inline_style( 'rtsb-frontend', $dynamic_css );
		}

	}

	/**
	 * Add the "Add to Wishlist" button. Needed to use in wp_head hook.
	 *
	 * @return void
	 * @since 1.0.0
	 */
	public function attach_button() {
		if ( ! apply_filters( 'rtsb/module/flash_sale_countdown/show_counter', true ) ) {
			return;
		}

		$product_hook_priority = $this->options['product_hook_priority'] ?? null;// Fns::get_option( 'modules', 'flash_sale_countdown', 'product_hook_priority', null );
		$product_hook_priority = is_int( $product_hook_priority ) ? $product_hook_priority : null;

		$positions = apply_filters(
			'rtsb/module/flash_sale_countdown/counter_positions',
			[
				'before_add_to_cart' => [
					'hook'     => 'woocommerce_before_add_to_cart_button',
					'priority' => $product_hook_priority ?? 20,
				],
				'after_add_to_cart'  => [
					'hook'     => 'woocommerce_single_product_summary',
					'priority' => $product_hook_priority ?? 31,
				],
				'after_thumbnail'    => [
					'hook'     => 'woocommerce_before_single_product_summary',
					'priority' => $product_hook_priority ?? 21,
				],
				'after_summary'      => [
					'hook'     => 'woocommerce_after_single_product_summary',
					'priority' => $product_hook_priority ?? 11,
				],
				'after_short_desc'   => [
					'hook'     => 'woocommerce_single_product_summary',
					'priority' => $product_hook_priority ?? 21,
				],

				'custom'             => [
					'hook'     => $this->options['product_custom_hook_name'] ?? '',
					'priority' => $product_hook_priority,
				],
			]
		);

		// Add the link "Add to wishlist".

		$product_counter_enable   = boolval( $this->options['show_counter_product_page'] ?? null );
		$product_counter_position = $this->options['product_counter_position'] ?? 'after_add_to_cart';

		if ( $product_counter_enable && 'shortcode' !== $product_counter_position && isset( $positions[ $product_counter_position ]['hook'] ) ) {
			add_action( $positions[ $product_counter_position ]['hook'], [ $this, 'frontend_display' ], isset( $positions[ $product_counter_position ]['priority'] ) ? absint( $positions[ $product_counter_position ]['priority'] ) : '' );
		}

		// check if Add to wishlist button is enabled for loop.
		$loop_btn_enable = boolval( $this->options['show_counter_on_loop'] ?? null );

		if ( ! $loop_btn_enable ) {
			return;
		}

		$loop_hook_priority = $this->options['loop_hook_priority'] ?? null;
		$loop_hook_priority = is_int( $loop_hook_priority ) ? $loop_hook_priority : null;

		$positions = apply_filters(
			'rtsb/module/flash_sale_countdown/loop_counter_positions',
			[
				'before_add_to_cart' => [
					'hooks'    => [
						'woocommerce_after_shop_loop_item',
					],
					'priority' => $loop_hook_priority ?? 7,
				],
				'after_add_to_cart'  => [
					'hooks'    => [
						'woocommerce_after_shop_loop_item',
					],
					'priority' => $loop_hook_priority ?? 15,
				],
				'custom'             => [
					'hooks'    => explode( ',', $this->options['loop_custom_hook_name'] ?? '' ),
					'priority' => $loop_hook_priority ?? 10,
				],
			]
		);

		// Add the link "Add to wishlist" in the loop.
		$loop_counter_position = $this->options['loop_counter_position'] ?? 'after_add_to_cart';

		if ( 'shortcode' !== $loop_counter_position && ! empty( $positions[ $loop_counter_position ]['hooks'] ) ) {
			foreach ( $positions[ $loop_counter_position ]['hooks'] as $hook ) {
				add_action( trim( $hook ), [ $this, 'frontend_display' ], isset( $positions[ $loop_counter_position ]['priority'] ) ? $positions[ $loop_counter_position ]['priority'] : '' );
			}
		}

	}

	/**
	 * Print "Add to compare" button
	 *
	 * @return void
	 */
	public function frontend_display() {

		if ( ! apply_filters( 'rtsb/module/flash_sale_countdown/show_counter', true ) ) {
			return;
		}

		global $product;

		if ( $product instanceof WC_Product ) {
			do_action( 'rtsb/modules/flash_sale_countdown/print_counter', $product->get_id() );
		}
	}


	/**
	 * Wishlist button Shortcode callable function
	 *
	 * @param array  $atts
	 * @param string $content
	 *
	 * @return string [HTML]
	 */

	public function counter_shortcode( $atts, $content = '' ) {
		global $product;
		if ( ! $product instanceof WC_Product ) {
			return '';
		}
		ob_start();

		do_action( 'rtsb/modules/flash_sale_countdown/frontend/display' );

		return ob_get_clean();
	}

	/**
	 * @return void
	 */
	public function print_counter( $product_id = 0 ) {
		global $product, $woocommerce_loop;

		if ( ! $product instanceof WC_Product && $product_id ) {
			$product = wc_get_product( $product_id );
		}

		$campaign = CountdownFns::get_campaign_for_current_product();

		if ( empty( $campaign ) ) {
			return;
		}

		if ( ! $product->is_on_sale() || ! $product->is_in_stock() ) {
			return;
		}

		$date_time   = $campaign['end_date'] ?? '';
		$expire_time = strtotime( date( 'Y-m-d H:m', strtotime( $date_time ) ) );
		$now         = strtotime( 'now' );
		if ( $now > $expire_time ) {
			return;
		}

		$classes        = [];
		$counter_layout = 'horizontal';

		if ( is_product() && in_array( ( $woocommerce_loop['name'] ?? '' ), [ 'related', 'up-sells', 'cross-sells' ], true ) ) {
			$vertical_position = $this->options['loop_counter_vertical_position'] ?? 'top-left';
			$classes[]         = 'rtsb-vertical-position-' . esc_attr( $vertical_position );
			$counter_layout    = $this->options['loop_counter_layout'] ?? 'horizontal';
		}

		if ( ! is_product() ) {
			$vertical_position = $this->options['loop_counter_vertical_position'] ?? 'top-left';
			$classes[]         = 'rtsb-vertical-position-' . esc_attr( $vertical_position );
			$counter_layout    = $this->options['loop_counter_layout'] ?? 'horizontal';
		}
		$classes[] = 'rtsb-countdown-' . esc_attr( $counter_layout );

		$classes = apply_filters( 'rtsb/countdown/campaign/parent/class', $classes, $product, $woocommerce_loop );
		do_action( 'rtdb/before/countdown/campaign' );
		echo '<div class="rtsb-countdown-campaign ' . esc_attr( implode( ' ', $classes ) ) . ' " data-date="' . esc_attr( $date_time ) . '"></div>';
		do_action( 'rtdb/after/countdown/campaign' );
	}
}
